/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.client;

import java.io.Serializable;

public class BackupSchedule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DayOfWeek dayOfWeek;
    private int hour;
    private int minute;
    private boolean reorganizeRepositories;

    public BackupSchedule() {
        this.dayOfWeek = DayOfWeek.SUNDAY;
        this.hour = 1;
        this.minute = 0;
        this.reorganizeRepositories = false;
    }

    public BackupSchedule(DayOfWeek dayOfWeek, int hour, int minute, boolean reorganizeRepositories) {
        this.dayOfWeek = dayOfWeek;
        this.setHour(hour);
        this.setMinute(minute);
        this.reorganizeRepositories = reorganizeRepositories;
    }

    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public DayOfWeek getDayOfweek() {
        return this.dayOfWeek;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException();
        }
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException();
        }
        this.minute = minute;
    }

    public boolean isReorganizeRepositories() {
        return this.reorganizeRepositories;
    }

    public void setReorganizeRepositories(boolean reorganizeRepositories) {
        this.reorganizeRepositories = reorganizeRepositories;
    }

    public static enum DayOfWeek {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY;

    }
}

