/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav.tools;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.tools.DAVTree;
import com.sas.services.webdav.tools.RB;
import com.sas.services.webdav.tools.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

@SASScope
public class VHDialog
extends JDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 7793046230325837132L;
    private JButton okButton = new JButton(RB.getStringResource("DAVTree.ok.txt"));
    private JButton cancelButton = new JButton(RB.getStringResource("DAVTree.cancel.txt"));
    DAVTree.PropertyPanel pPanel;
    JTextArea txt = new JTextArea();

    public VHDialog(Frame owner, final List propsList, boolean modal) {
        super(owner, RB.getStringResource("DAVTree.vhtable.title.txt"), modal);
        Object[] colNames = new String[]{RB.getStringResource("DAVTree.vhtable.column.name.txt"), RB.getStringResource("DAVTree.vhtable.column.creator.txt"), RB.getStringResource("DAVTree.vhtable.column.date.txt"), RB.getStringResource("DAVTree.vhtable.column.size.txt"), RB.getStringResource("DAVTree.vhtable.column.comment.txt")};
        final String[] colIndx = new String[]{"version-name", "creator-displayname", "creationdate", "getcontentlength", "comment", "owning-URL"};
        DefaultTableModel model = new DefaultTableModel(colNames, propsList.size()){
            private static final long serialVersionUID = -4818921576457901248L;

            @Override
            public Object getValueAt(int row, int col) {
                if ("creationdate".equals(colIndx[col])) {
                    String crdate = (String)((Map)propsList.get(row)).get(colIndx[col]);
                    Date creationDate = Utils.parseISO8601(crdate);
                    return DateFormat.getDateTimeInstance().format(creationDate);
                }
                return ((Map)propsList.get(row)).get(colIndx[col]);
            }
        };
        JTable table = new JTable(model);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JTable source;
                int nrows;
                if (e.isPopupTrigger() && (nrows = (source = (JTable)e.getSource()).getSelectedRowCount()) == 2) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new JMenuItem("Compare with each other"));
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        table.getSelectionModel().addListSelectionListener(this);
        JScrollPane sp = new JScrollPane(table);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)sp, "Center");
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VHDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VHDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                VHDialog.this.okButton.requestFocus();
            }
        });
        this.pack();
        int centredX = owner.getX() + (owner.getWidth() - this.getWidth()) / 2;
        int centredY = owner.getY() + (owner.getHeight() - this.getHeight()) / 2;
        this.setLocation(centredX, centredY);
    }

    public Map getSetUpdates() {
        return this.pPanel.getSetUpdates();
    }

    public Vector getDelUpdates() {
        return this.pPanel.getDelUpdates();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        System.out.println(e.getSource().getClass().getName());
        System.out.println(e.getFirstIndex() + ", " + e.getLastIndex() + ", " + e.getValueIsAdjusting());
        if (!e.getValueIsAdjusting()) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            System.out.println(lsm.toString());
        }
    }
}

