/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav.tools;

import com.sas.services.webdav.tools.DAVTree;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;

public class DAVTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 0x3838343433383338L;
    protected String resName;
    private transient TreeMap<String, Element> DAVprops;
    protected boolean isCollection;
    protected boolean isCheckedOut;
    protected boolean isLocked;
    protected String name;
    protected String newName;
    protected String fullName;
    protected boolean populated;
    protected boolean interim;
    protected static final BitSet pchar;

    public DAVTreeNode(String url, boolean isCollection, boolean isCheckedOut, boolean isLocked) {
        super(url);
        String relpath;
        this.isCollection = isCollection;
        this.isCheckedOut = isCheckedOut;
        this.isLocked = isLocked;
        this.fullName = url;
        String _url = this.fullName.trim();
        int ptr = _url.lastIndexOf(47);
        if (_url.charAt(_url.length() - 1) != '/') {
            if (isCollection) {
                _url = _url + "/";
            }
        } else {
            ptr = _url.lastIndexOf(47, ptr - 1);
        }
        if ((relpath = _url.substring(ptr + 1)).length() == 0) {
            relpath = _url;
        }
        this.resName = relpath;
    }

    public boolean isCheckedOut() {
        return this.isCheckedOut;
    }

    public void setCheckedOut(boolean isCheckedOut) {
        this.isCheckedOut = isCheckedOut;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    @Override
    public boolean isLeaf() {
        return !this.isCollection;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isCollection;
    }

    public void setProperties(TreeMap<String, Element> props) {
        this.DAVprops = props;
    }

    public TreeMap<String, Element> getProperties() {
        return this.DAVprops;
    }

    @Override
    public String toString() {
        return this.resName;
    }

    public boolean populateCollections(DAVTree tree, boolean descend) {
        boolean addedNodes = false;
        if (!this.populated) {
            if (this.interim) {
                this.removeAllChildren();
                this.interim = false;
            }
            if (!this.isCollection) {
                return addedNodes;
            }
            for (Map.Entry child : tree.getChildrenList(this.fullName).entrySet()) {
                boolean isLocked;
                boolean isCheckedOut;
                Map m;
                boolean isCollection;
                String _name = (String)child.getKey();
                DAVTreeNode node = new DAVTreeNode(_name, isCollection = (m = (Map)child.getValue()).containsKey("resourcetype") && "COLLECTION".equals(m.get("resourcetype")), isCheckedOut = m.containsKey("checked-out") && "true".equals(m.get("checked-out")), isLocked = m.containsKey("locked") && "true".equals(m.get("locked")));
                if (!this.equals(node)) {
                    this.add(node);
                    addedNodes = true;
                }
                if (descend) continue;
                break;
            }
            if (descend || !addedNodes) {
                this.populated = true;
            } else {
                this.interim = true;
            }
        }
        return addedNodes;
    }

    @Override
    public void setUserObject(Object userObject) {
        System.out.println("setUserObject called: " + userObject + "(" + userObject.getClass().getName() + ")");
        super.setUserObject(userObject);
    }

    public void setNewName(String name) {
        this.newName = name;
        if (!this.isCollection && this.newName.endsWith("/")) {
            this.newName = this.newName.substring(0, this.newName.length() - 1);
        }
        if (!this.isSegmentNameValid(this.newName)) {
            this.newName = null;
            return;
        }
    }

    private boolean isSegmentNameValid(String name) {
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (pchar.get(chars[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
        result = 31 * result + (this.interim ? 1231 : 1237);
        result = 31 * result + (this.isCheckedOut ? 1231 : 1237);
        result = 31 * result + (this.isCollection ? 1231 : 1237);
        result = 31 * result + (this.isLocked ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.newName == null ? 0 : this.newName.hashCode());
        result = 31 * result + (this.populated ? 1231 : 1237);
        result = 31 * result + (this.resName == null ? 0 : this.resName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DAVTreeNode other = (DAVTreeNode)obj;
        if (this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName)) {
            return false;
        }
        if (this.interim != other.interim) {
            return false;
        }
        if (this.isCheckedOut != other.isCheckedOut) {
            return false;
        }
        if (this.isCollection != other.isCollection) {
            return false;
        }
        if (this.isLocked != other.isLocked) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.newName == null ? other.newName != null : !this.newName.equals(other.newName)) {
            return false;
        }
        if (this.populated != other.populated) {
            return false;
        }
        return !(this.resName == null ? other.resName != null : !this.resName.equals(other.resName));
    }

    static {
        int i;
        pchar = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            pchar.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            pchar.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            pchar.set(i);
        }
        pchar.set(37);
        pchar.set(58);
        pchar.set(64);
        pchar.set(38);
        pchar.set(61);
        pchar.set(43);
        pchar.set(36);
        pchar.set(44);
        pchar.set(45);
        pchar.set(95);
        pchar.set(46);
        pchar.set(33);
        pchar.set(126);
        pchar.set(42);
        pchar.set(39);
        pchar.set(40);
        pchar.set(41);
    }
}

