/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.ResourceFilter;
import com.sas.services.webdav.Utils;
import com.sas.services.webdav.XMLUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

@SASScope
public class ResourceFinder {
    static List propNamesList = null;
    static boolean allProperties;
    static PropertyName[] propNames;

    public static void getDavResources(DAVResource r, ResourceFilter filter, List results, boolean stopWhenFound) throws ParserConfigurationException {
        if (propNamesList == null) {
            propNamesList = filter.getPropertyList();
            if (propNamesList == null) {
                return;
            }
            if (propNamesList.isEmpty()) {
                allProperties = true;
            } else {
                allProperties = false;
                if (!propNamesList.contains("{DAV:}resourcetype")) {
                    propNamesList.add("{DAV:}resourcetype");
                }
                propNames = new PropertyName[propNamesList.size()];
                for (int i = 0; i < propNames.length; ++i) {
                    ResourceFinder.propNames[i] = new PropertyName((String)propNamesList.get(i));
                }
            }
        }
        try {
            List<DavPropertyItem> davPropertyItems = allProperties ? r.getDavProperties(1).getDavProperties() : r.getDavProperties(propNames, 1).getDavProperties();
            Map rMap = Utils.transformDavProperties(r.getURL().toString(), davPropertyItems, 1);
            for (Map.Entry me : rMap.entrySet()) {
                String path = (String)me.getKey();
                if (Utils.isSameUrl(path, r.getPath())) continue;
                Map pMap = (Map)me.getValue();
                if (filter.accept(pMap)) {
                    HashMap<String, Map> m = new HashMap<String, Map>();
                    m.put(path, pMap);
                    results.add(m);
                    if (stopWhenFound || !"COLLECTION".equals(pMap.get("{DAV:}resourcetype"))) continue;
                    r.setPath(path);
                    ResourceFinder.getDavResources(r, filter, results, stopWhenFound);
                    continue;
                }
                if (!"COLLECTION".equals(pMap.get("{DAV:}resourcetype"))) continue;
                r.setPath(path);
                ResourceFinder.getDavResources(r, filter, results, stopWhenFound);
            }
        }
        catch (DAVException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static String extractPath(String url) {
        int p2;
        int p1 = url.indexOf("://");
        String path = p1 != -1 ? ((p2 = url.indexOf("/", p1 + 3)) != -1 ? url.substring(p2) : "/") : url;
        return path;
    }

    public static List getDavChildrenList(DAVResource r, String path) throws ParserConfigurationException {
        ArrayList<Object> members = new ArrayList<Object>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            r.setPath(path);
            String currUrl = r.getURL().toString();
            List<DavPropertyItem> davPropertyItems = r.getDavProperties(new PropertyName[]{new PropertyName("<D:resourcetype/>")}, 1).getDavProperties();
            for (DavPropertyItem davPropertyItem : davPropertyItems) {
                List mems;
                String newurl = Utils.transformURL(r.getURL().toString(), davPropertyItem.getDavResourceHref());
                if (Utils.isSameUrl(newurl, currUrl)) continue;
                members.add(newurl);
                if (!"COLLECTION".equals(XMLUtil.getPropertyAsString(davPropertyItem)) || (mems = ResourceFinder.getDavChildrenList(r, ResourceFinder.extractPath(newurl))).size() <= 0) continue;
                members.add(mems);
            }
        }
        catch (DAVException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return members;
    }
}

