/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DAVResourceInterface;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.RB;
import com.sas.services.webdav.ResourceInterface;
import com.sas.services.webdav.SharedResourceInterface;
import com.sas.services.webdav.Utils;
import com.sas.text.Message;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;

@SASScope
public class Resource
implements ResourceInterface {
    protected DAVResource _resource;
    protected PropertyMap _properties;
    private String _urlString;
    protected String _path;
    private String _name;
    protected SharedResourceInterface sharedResource;
    protected boolean isSharedResource;

    public Resource(String url) throws DAVException {
        this._resource = new DAVResource(new ConnectionInfo(url));
        this._urlString = url;
        this._path = this.getPath(url);
        File f = new File(this._urlString);
        this._name = f.getName();
    }

    public Resource(String url, String userid, String pw) throws DAVException {
        this._resource = new DAVResource(new ConnectionInfo(url, userid, pw));
        this._urlString = url;
        this._path = this.getPath(url);
        File f = new File(this._urlString);
        this._name = f.getName();
    }

    public Resource(DAVResource r) throws DAVException, RemoteException {
        this._resource = r;
        this._urlString = this._resource.getURL().toString();
        this._path = this.getPath(this._urlString);
        File f = new File(this._urlString);
        this._name = f.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource(SharedResourceInterface sr) throws DAVException, RemoteException {
        this.sharedResource = sr;
        String urlStr = null;
        DAVResourceInterface r = null;
        try {
            r = this.sharedResource.getConnection();
            urlStr = r.getURL().toString();
        }
        finally {
            this.sharedResource.releaseConnection(r);
            r = null;
        }
        this.isSharedResource = true;
        this.sharedResource = sr;
        this._urlString = urlStr;
        this._path = this.getPath(urlStr);
        this._name = new File(urlStr).getName();
    }

    public Resource(SharedResourceInterface sr, String urlStr) {
        this.isSharedResource = true;
        this.sharedResource = sr;
        this._urlString = urlStr;
        this._path = this.getPath(urlStr);
        this._name = new File(urlStr).getName();
    }

    @Override
    public String getURL() throws DAVException, RemoteException {
        return this._urlString;
    }

    @Override
    public String getName() throws DAVException, RemoteException {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws DAVException, RemoteException {
        if (this.isSharedResource) {
            DAVResourceInterface r = null;
            try {
                r = this.sharedResource.getConnection();
                r.setPath(this._path);
                r.delete();
            }
            finally {
                this.sharedResource.releaseConnection(r);
                r = null;
            }
        } else {
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                this._resource.delete();
                if (!this._resource.SUCCEEDED()) {
                    throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.delres.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() throws DAVException, RemoteException {
        if (this.isSharedResource) {
            DAVResourceInterface r = null;
            try {
                r = this.sharedResource.getConnection();
                r.lock();
            }
            finally {
                this.sharedResource.releaseConnection(r);
                r = null;
            }
        } else {
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                this._resource.lock();
                if (!this._resource.SUCCEEDED()) {
                    throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.lockres.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() throws DAVException, RemoteException {
        if (this.isSharedResource) {
            DAVResourceInterface r = null;
            try {
                r = this.sharedResource.getConnection();
                r.unlock();
            }
            finally {
                this.sharedResource.releaseConnection(r);
                r = null;
            }
        } else {
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                this._resource.unlock();
                if (!this._resource.SUCCEEDED()) {
                    throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.unlockres.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceInterface copy(String destination) throws DAVException, RemoteException {
        if (this.isSharedResource) {
            DAVResourceInterface r = null;
            try {
                r = this.sharedResource.getConnection();
                r.copy(destination);
                Resource resource = new Resource(this.sharedResource, destination);
                return resource;
            }
            finally {
                this.sharedResource.releaseConnection(r);
                r = null;
            }
        }
        DAVResource dAVResource = this._resource;
        synchronized (dAVResource) {
            if (!this._path.equals(this._resource.getPath())) {
                this._resource.setPath(this._path);
            }
            DAVResource copied = this._resource.copy(destination);
            if (!this._resource.SUCCEEDED()) {
                throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.copyres.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
            }
            return new Resource(copied);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceInterface move(String destination) throws DAVException, RemoteException {
        if (this.isSharedResource) {
            DAVResourceInterface r = null;
            try {
                r = this.sharedResource.getConnection();
                r.move(destination);
                Resource resource = new Resource(this.sharedResource, destination);
                return resource;
            }
            finally {
                this.sharedResource.releaseConnection(r);
                r = null;
            }
        }
        DAVResource dAVResource = this._resource;
        synchronized (dAVResource) {
            if (!this._path.equals(this._resource.getPath())) {
                this._resource.setPath(this._path);
            }
            DAVResource moved = this._resource.move(destination);
            if (!this._resource.SUCCEEDED()) {
                throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.moveres.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
            }
            return new Resource(moved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ResourceInterface r) throws DAVException, RemoteException {
        if (!this.isSharedResource) {
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                return this._resource.getURL().toString().equals(r.getURL().toString());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProperties(PropertyMap pMap) throws DAVException, RemoteException {
        block14: {
            int nsCounter = 0;
            ArrayList<PropertyName> pNames = new ArrayList<PropertyName>();
            Iterator entries = pMap.entrySet().iterator();
            HashMap<String, String> usedPrefixes = new HashMap<String, String>();
            while (entries.hasNext()) {
                String pName;
                String namespace;
                Map.Entry pm = entries.next();
                String name = ((String)pm.getKey()).trim();
                int sep = name.indexOf(125);
                if (name.charAt(0) == '{' && sep > 0) {
                    namespace = name.substring(1, sep);
                    pName = name.substring(sep + 1);
                } else {
                    namespace = "";
                    pName = name;
                }
                String prefix = (String)usedPrefixes.get(namespace);
                if (prefix == null) {
                    prefix = "ns" + nsCounter;
                    ++nsCounter;
                    usedPrefixes.put(namespace, prefix);
                }
                pNames.add(new PropertyName(pName, prefix, namespace));
            }
            PropertyName[] pNameArray = pNames.toArray(new PropertyName[0]);
            if (this.isSharedResource) {
                DAVResourceInterface r = null;
                try {
                    r = this.sharedResource.getConnection();
                    r.removeProperties(pNameArray);
                    if (!r.SUCCEEDED()) {
                        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.remprop.ex.fmt.txt", (Object)r.getStatusMessage()));
                    }
                    break block14;
                }
                finally {
                    this.sharedResource.releaseConnection(r);
                    r = null;
                }
            }
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                this._resource.removeProperties(pNameArray);
                if (!this._resource.SUCCEEDED()) {
                    throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.remprop.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(PropertyMap pMap) throws DAVException, RemoteException {
        block14: {
            int nsCounter = 0;
            ArrayList<PropertyName> pNames = new ArrayList<PropertyName>();
            ArrayList pVals = new ArrayList();
            Iterator entries = pMap.entrySet().iterator();
            HashMap<String, String> usedPrefixes = new HashMap<String, String>();
            while (entries.hasNext()) {
                String pName;
                String namespace;
                Map.Entry pm = entries.next();
                String name = (String)pm.getKey();
                if (name == null || name.length() == 0) continue;
                name = name.trim();
                int sep = name.indexOf(125);
                if (name.charAt(0) == '{' && sep > 0) {
                    namespace = name.substring(1, sep);
                    pName = name.substring(sep + 1);
                } else {
                    namespace = "";
                    pName = name;
                }
                String prefix = (String)usedPrefixes.get(namespace);
                if (prefix == null && !namespace.equals("")) {
                    prefix = "ns" + nsCounter;
                    ++nsCounter;
                    usedPrefixes.put(namespace, prefix);
                }
                pNames.add(new PropertyName(pName, prefix, namespace));
                pVals.add(pm.getValue());
            }
            PropertyName[] pNameArray = pNames.toArray(new PropertyName[0]);
            String[] pValArray = pVals.toArray(new String[0]);
            if (this.isSharedResource) {
                DAVResourceInterface r = null;
                try {
                    r = this.sharedResource.getConnection();
                    r.setProperties(pNameArray, pValArray);
                    if (!r.SUCCEEDED()) {
                        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.setprop.ex.fmt.txt", (Object)r.getStatusMessage()));
                    }
                    break block14;
                }
                finally {
                    this.sharedResource.releaseConnection(r);
                    r = null;
                }
            }
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                this._resource.setProperties(pNameArray, pValArray);
                if (!this._resource.SUCCEEDED()) {
                    throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.setprop.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PropertyMap getProperties() throws DAVException, RemoteException {
        if (this.isSharedResource) {
            DAVResourceInterface r = null;
            try {
                r = this.sharedResource.getConnection();
                r.setPath(this._path);
                if (this._properties != null) return this._properties;
                this._properties = new PropertyMap();
                DavPropertyResult davPropertyResult = r.getDavProperties();
                if (!r.SUCCEEDED()) {
                    throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.getprop.ex.fmt.txt", (Object)r.getStatusMessage()));
                }
                this._properties = Utils.convertDavPropertyArray(davPropertyResult.getDavProperties());
                return this._properties;
            }
            catch (ParserConfigurationException e) {
                throw new DAVException(e.getMessage(), e, 500);
            }
            finally {
                this.sharedResource.releaseConnection(r);
                r = null;
            }
        }
        DAVResource dAVResource = this._resource;
        synchronized (dAVResource) {
            if (!this._path.equals(this._resource.getPath())) {
                this._resource.setPath(this._path);
            }
            if (this._properties != null) return this._properties;
            this._properties = new PropertyMap();
            DavPropertyResult davPropertyResult = this._resource.getDavProperties();
            if (!this._resource.SUCCEEDED()) {
                throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.getprop.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
            }
            try {
                this._properties = Utils.convertDavPropertyArray(davPropertyResult.getDavProperties());
            }
            catch (ParserConfigurationException e) {
                throw new DAVException(e.getMessage(), e, 500);
            }
            return this._properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(byte[] input) throws DAVException, RemoteException {
        block13: {
            if (this.isSharedResource) {
                DAVResourceInterface r = null;
                try {
                    r = this.sharedResource.getConnection();
                    r.setPath(this._path);
                    if (r.isCollection()) {
                        return;
                    }
                    r.setContents(input);
                    if (!r.SUCCEEDED()) {
                        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.setcontent.ex.fmt.txt", (Object)r.getStatusMessage()));
                    }
                    break block13;
                }
                finally {
                    this.sharedResource.releaseConnection(r);
                    r = null;
                }
            }
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                if (this._resource.isCollection()) {
                    return;
                }
                this._resource.setContents(input);
                if (!this._resource.SUCCEEDED()) {
                    throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.setcontent.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(InputStream is) throws DAVException, RemoteException {
        block13: {
            if (this.isSharedResource) {
                DAVResourceInterface r = null;
                try {
                    r = this.sharedResource.getConnection();
                    r.setPath(this._path);
                    if (r.isCollection()) {
                        return;
                    }
                    r.setContents(is);
                    if (!r.SUCCEEDED()) {
                        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.setcontent.ex.fmt.txt", (Object)r.getStatusMessage()));
                    }
                    break block13;
                }
                finally {
                    this.sharedResource.releaseConnection(r);
                    r = null;
                }
            }
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                if (this._resource.isCollection()) {
                    return;
                }
                this._resource.setContents(is);
                if (!this._resource.SUCCEEDED()) {
                    throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.setcontent.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(URL url) throws DAVException, RemoteException {
        block13: {
            if (this.isSharedResource) {
                DAVResourceInterface r = null;
                try {
                    r = this.sharedResource.getConnection();
                    r.setPath(this._path);
                    if (r.isCollection()) {
                        return;
                    }
                    r.setContents(url);
                    if (!r.SUCCEEDED()) {
                        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.setcontent.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
                    }
                    break block13;
                }
                finally {
                    this.sharedResource.releaseConnection(r);
                    r = null;
                }
            }
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                if (this._resource.isCollection()) {
                    return;
                }
                this._resource.setContents(url);
                if (!this._resource.SUCCEEDED()) {
                    throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.setcontent.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getContents() throws DAVException, RemoteException {
        InputStream _result;
        block10: {
            _result = null;
            if (this.isSharedResource) {
                DAVResourceInterface r = null;
                try {
                    r = this.sharedResource.getConnection();
                    r.setPath(this._path);
                    _result = r.getContentsInputStream();
                    if (!r.SUCCEEDED()) {
                        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.getcontent.ex.fmt.txt", (Object)r.getStatusMessage()));
                    }
                    break block10;
                }
                finally {
                    this.sharedResource.releaseConnection(r);
                    r = null;
                }
            }
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                _result = this._resource.getContentsInputStream();
                if (!this._resource.SUCCEEDED()) {
                    throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.getcontent.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
                }
            }
        }
        return _result;
    }

    protected void setDebug(int level) {
        if (!this.isSharedResource) {
            this._resource.setDebug(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DAVResource getDAVResource() {
        if (!this.isSharedResource) {
            DAVResource dAVResource = this._resource;
            synchronized (dAVResource) {
                if (!this._path.equals(this._resource.getPath())) {
                    this._resource.setPath(this._path);
                }
                return this._resource;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws DAVException, RemoteException {
        if (this.isSharedResource) {
            DAVResourceInterface r = null;
            try {
                r = this.sharedResource.getConnection();
                r.setPath(this._path);
                boolean bl = r.exists();
                return bl;
            }
            finally {
                this.sharedResource.releaseConnection(r);
                r = null;
            }
        }
        if (this._resource == null) {
            return false;
        }
        DAVResource dAVResource = this._resource;
        synchronized (dAVResource) {
            if (!this._path.equals(this._resource.getPath())) {
                this._resource.setPath(this._path);
            }
            return this._resource.exists();
        }
    }

    private String getPath(String url) {
        String path = null;
        int p = url.indexOf("://");
        path = p > 0 ? ((p = url.indexOf("/", p + 3)) > 0 ? url.substring(p) : "") : url;
        return path;
    }

    @Override
    public void close() throws DAVException, RemoteException {
        if (!this.isSharedResource && this._resource != null) {
            this._resource.close();
        }
    }

    @Override
    public boolean isSharedResource() {
        return this.isSharedResource;
    }

    @Override
    public SharedResourceInterface getSharedResource() {
        if (this.isSharedResource) {
            return this.sharedResource;
        }
        return null;
    }
}

