/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.Collection;
import com.sas.services.webdav.CollectionInterface;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.RemoteResource;
import com.sas.services.webdav.Resource;
import com.sas.services.webdav.ResourceInterface;
import com.sas.services.webdav.SharedResourceInterface;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;

@SASScope
public class RemoteCollection
extends RemoteResource
implements CollectionInterface {
    private static final long serialVersionUID = -7878276295229878766L;
    private Collection collection;

    public static CollectionInterface createCollection(RemoteCollection model, String name) throws DAVException, RemoteException {
        Collection c = (Collection)Collection.createCollection(model.collection, name);
        return new RemoteCollection(c);
    }

    public static ResourceInterface createResource(RemoteCollection model, String name) throws DAVException, RemoteException {
        Resource r = (Resource)Collection.createResource(model.collection, name);
        return new RemoteResource(r);
    }

    public RemoteCollection(SharedResourceInterface sr) throws DAVException, RemoteException {
        super(sr);
        this.collection = new Collection(sr);
    }

    public RemoteCollection(SharedResourceInterface sr, String urlStr) throws DAVException, RemoteException {
        super(sr, urlStr);
        this.collection = new Collection(sr, urlStr);
    }

    public RemoteCollection(Collection c) throws DAVException, RemoteException {
        super(c);
        this.collection = c;
    }

    @Override
    public CollectionInterface createCollection(String collName) throws DAVException, RemoteException {
        return this.createCollection(collName, null, null);
    }

    @Override
    public CollectionInterface createCollection(String collName, String userName, String pwd) throws DAVException, RemoteException {
        Collection c = (Collection)this.collection.createCollection(collName, userName, pwd);
        return new RemoteCollection(c);
    }

    @Override
    public ResourceInterface createResource(String resName) throws DAVException, RemoteException {
        return this.createResource(resName, null, null);
    }

    @Override
    public ResourceInterface createResource(String resName, String userName, String pwd) throws DAVException, RemoteException {
        return this.createResource(resName, userName, pwd);
    }

    @Override
    public List getChildren() throws DAVException, RemoteException {
        return this.collection.getChildren();
    }

    @Override
    public Map<String, PropertyMap> getDavChildrenProperties() throws DAVException, RemoteException, ParserConfigurationException {
        return this.collection.getDavChildrenProperties();
    }

    @Override
    public InputStream getContents() throws DAVException, RemoteException {
        return null;
    }

    Collection getCollection() {
        return this.collection;
    }
}

