/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PropertyName {
    private String localName;
    private String prefix;
    private String namespaceURI;
    public static final PropertyName DAV_RESOURCETYPE_PN = new PropertyName("{DAV:}resourcetype");
    public static final PropertyName DAV_ACL_PN = new PropertyName("{DAV:}acl");

    public PropertyName(DavProperty<?> davProperty) {
        String propertyName;
        int n;
        DavPropertyName davPropertyName = davProperty.getName();
        if (null == davPropertyName) {
            throw new IllegalArgumentException("The DAVProperty's name is null");
        }
        Namespace namespace = davPropertyName.getNamespace();
        if (null != namespace) {
            this.namespaceURI = namespace.getURI();
        }
        if (0 < (n = (propertyName = davPropertyName.getName()).indexOf(58))) {
            this.prefix = propertyName.substring(0, n++);
            this.localName = n < propertyName.length() ? propertyName.substring(n) : "";
        } else {
            this.localName = propertyName;
        }
    }

    public PropertyName(String localName, String prefix, String namespaceURI) {
        this.localName = localName;
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
    }

    public PropertyName(Element propElement) {
        this.localName = propElement.getLocalName();
        this.namespaceURI = propElement.getNamespaceURI();
        this.prefix = propElement.getPrefix();
    }

    public PropertyName(String name) {
        String prefix;
        String pName;
        String namespace;
        name = name.trim();
        int sep = name.indexOf(125);
        if (name.charAt(0) == '{' && sep > 0) {
            namespace = name.substring(1, sep);
            pName = name.substring(sep + 1);
        } else {
            namespace = "";
            pName = name;
        }
        String string = prefix = !namespace.equals("") ? "ns0" : null;
        if ("DAV:".equals(namespace)) {
            prefix = "D";
        }
        this.localName = pName;
        this.prefix = prefix;
        this.namespaceURI = namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String toString() {
        if (this.prefix != null && this.prefix.length() > 0) {
            return "<" + this.prefix + ':' + this.localName + " xmlns:" + this.prefix + "=\"" + this.namespaceURI + "\"/>";
        }
        return "<" + this.localName + "/>";
    }

    public String toPropertyNameString() {
        StringBuilder sb = new StringBuilder().append('{');
        if (null != this.namespaceURI) {
            sb.append(this.namespaceURI);
        }
        sb.append('}').append(this.localName);
        return sb.toString();
    }
}

