/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.validate;

import com.sas.ssn.DialogData;
import com.sas.ssn.DlgBusyMsg;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.utils.GroovyClassLoadingException;
import com.sas.ssn.utils.GroovyLauncher;
import com.sas.ssn.utils.PropertyJarFile;
import com.sas.ssn.validate.ValidationResult;
import com.sas.ssn.validate.Validator;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class ValidatorRunner
extends Validator {
    public static final String BUSY_MESSAGE_SUFFIX = "validator.busymsg";
    private static final SSNResource bundle = new SSNResource("com.sas.ssn.PropertyBundle");
    private GroovyLauncher groovyLauncher = GroovyLauncher.getDefaultGroovyLauncher();
    private Validator validator = null;
    private ValidationResult result = null;

    public ValidatorRunner(DialogData.Property validatorProperty, String validatorClassName, List<PropertyJarFile> dependendJars, int dialogType) throws IOException, GroovyClassLoadingException, ClassNotFoundException {
        if (dependendJars != null) {
            for (PropertyJarFile propertyJarFile : dependendJars) {
                this.groovyLauncher.addClasspath(propertyJarFile.getName());
            }
        }
        this.validator = (Validator)this.groovyLauncher.constructGroovyInstance(validatorClassName);
        this.validator.init(dialogType, validatorProperty.getName());
    }

    private void createZosValidator(String className) throws IOException {
        String validatorFileName = className.replace('.', '/').concat(".groovy");
        String validatorFileNameZos = validatorFileName.concat(".ebcdic");
        String validator = Utils.joinPath(Globals.g_deploymentData.getProductDataDir(Globals.g_order, "deploywiz", false, false), "groovy/src/", validatorFileName);
        String validatorZos = Utils.joinPath(Globals.g_deploymentData.getProductDataDir(Globals.g_order, "deploywiz", false, false), "groovy/src/", validatorFileNameZos);
        File validatorFile = new File(validator);
        File validatorZosFile = new File(validatorZos);
        if (validatorZosFile.exists()) {
            return;
        }
        String groovyScript = Utils.readFile(validatorFile, "UTF-8");
        Utils.writeFile(validatorZosFile, groovyScript, "IBM-1047");
        int rc = Utils.copyFile(validatorZosFile, validatorFile);
        if (rc != 0) {
            Utils.removeFile(validatorZosFile);
            String msg = String.format("Failure copying EBCDIC file '%s' to '%s'", validatorZosFile.getName(), validatorFile.getName());
            throw new IOException(msg);
        }
    }

    @Override
    public void init(int dialogType, String validatorPropertyName) {
    }

    @Override
    public void init(int dialogType, String validatorPropertyName, Properties data, Properties msgPropertiesOverride) {
    }

    @Override
    public ValidationResult validateData() {
        String busyMessage = this.validator.getMessageEndsWith(BUSY_MESSAGE_SUFFIX);
        if (busyMessage == null || Globals.g_quietMode || Globals.g_consoleMode) {
            this.result = this.validator.validateData();
        } else {
            DlgBusyMsg busyDialog = new DlgBusyMsg(Globals.g_wizard.getFrame(), bundle.getString("GroovyValidator.BusyTitleHeader.txt"), busyMessage);
            busyDialog.execute(new ValidateDataRunnable());
        }
        return this.result;
    }

    @Override
    public String getMessageEndsWith(String endsWith) {
        return this.validator.getMessageEndsWith(endsWith);
    }

    @Override
    public String getMessage(String msgKey) {
        return this.validator.getMessage(msgKey);
    }

    @Override
    public String getMessage(String msgKey, Object[] msgValues) {
        return this.validator.getMessage(msgKey, msgValues);
    }

    @Override
    public String getDialogDataEndsWith(String endsWith) {
        return this.validator.getDialogDataEndsWith(endsWith);
    }

    @Override
    public String getDialogData(String propertyName) {
        return this.validator.getDialogData(propertyName);
    }

    private class ValidateDataRunnable
    implements Runnable {
        private ValidateDataRunnable() {
        }

        @Override
        public void run() {
            ValidatorRunner.this.result = ValidatorRunner.this.validator.validateData();
        }
    }
}

