/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.validate;

import com.sas.ssn.DialogData;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.validate.ValidationResult;
import java.text.MessageFormat;
import java.util.Properties;

public abstract class Validator {
    protected int dialogType = -1;
    protected String propertyNamespacePrefix = null;
    protected String validatorPropertyName = null;
    protected Properties data = null;
    protected Properties msgPropertiesOverride = null;

    public void init(int dialogType, String validatorPropertyName) {
        Properties data = null;
        data = dialogType == 1 ? Globals.g_installData.getProperties() : Globals.g_configData.getProperties();
        this.init(dialogType, validatorPropertyName, data, null);
    }

    public void init(int dialogType, String validatorPropertyName, Properties data, Properties msgPropertiesOverride) {
        this.dialogType = dialogType;
        this.validatorPropertyName = validatorPropertyName;
        this.data = data;
        this.propertyNamespacePrefix = DialogData.Property.parseNamespacePrefix(validatorPropertyName);
        this.msgPropertiesOverride = msgPropertiesOverride;
    }

    public String getMessageEndsWith(String endsWith) {
        String propertyName = this.propertyNamespacePrefix + "." + endsWith;
        return this.getMessage(propertyName);
    }

    public String getMessage(String msgKey) {
        String message = null;
        message = this.msgPropertiesOverride != null ? this.msgPropertiesOverride.getProperty(msgKey) : (this.dialogType == 1 ? DynamicDialogs.getInstallDialogProperty(msgKey) : DynamicDialogs.getConfigDialogProperty(msgKey));
        if (message != null && message.equals(msgKey)) {
            message = null;
        }
        return message;
    }

    public String getMessage(String msgKey, Object[] msgValues) {
        return MessageFormat.format(this.getMessage(msgKey), msgValues);
    }

    public String getDialogDataEndsWith(String endsWith) {
        String propertyName = this.propertyNamespacePrefix + "." + endsWith;
        return this.getDialogData(propertyName);
    }

    public String getDialogData(String propertyName) {
        return this.data.getProperty(propertyName);
    }

    public String getMetadataProperty(String fqid, String propertyName, String defaultValue) {
        String ret = defaultValue;
        String host = null;
        String port = null;
        String repository = null;
        String user = null;
        String password = null;
        if (Globals.g_mode == 2 || Globals.g_mode == 5) {
            host = Globals.g_cmtConnectHost;
            port = Globals.g_cmtConnectPort;
            repository = Globals.g_cmtConnectRepos;
            user = Globals.g_cmtConnectUser;
            password = Globals.g_cmtConnectPassword;
        } else {
            host = Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null);
            port = Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null);
            repository = Globals.g_configData.getProperty("oma.repository.foundation.name", null);
            user = Globals.g_configData.getProperty("oma.person.admin.login.userid", null);
            password = Globals.g_configData.getProperty("oma.person.admin.login.passwd", null);
        }
        if (host != null && port != null && repository != null && user != null && password != null) {
            ret = MetadataAccess.propQuery(host, port, repository, user, password, fqid, propertyName, defaultValue);
        }
        return ret;
    }

    public abstract ValidationResult validateData();
}

