/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.validate;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.validate.ValidationResult;
import com.sas.ssn.validate.Validator;
import java.awt.Component;

public class ValidationResultPrompt {
    private static final long serialVersionUID = 1520241682686543317L;
    private static final SSNResource bundle = new SSNResource("com.sas.ssn.PropertyBundle");
    public static final int ANSWER_PROCEED = 0;
    public static final int ANSWER_GO_BACK = 1;
    public static final int ANSWER_EXIT = 2;
    private Validator validator = null;
    private ValidationResult result = null;

    public ValidationResultPrompt(Validator validator, ValidationResult result) {
        this.validator = validator;
        this.result = result;
    }

    public int showPromptReturnAnswer() {
        int ret = 0;
        String msgKey = null;
        if (this.result != null && (msgKey = this.result.getMessageKey()) != null) {
            String message = this.result.getMessageValues() != null ? this.validator.getMessage(msgKey, this.result.getMessageValues()) : this.validator.getMessage(msgKey);
            switch (this.result.getResultType()) {
                case 0: {
                    Logging.log.info(message);
                    if (Globals.g_quietMode) break;
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), message, bundle.getString("Common.Info.txt"), 1);
                    break;
                }
                case 1: {
                    String warningCofirmation = bundle.messageString("GroovyValidator.WarningConfirmation.txt");
                    Logging.log.warning(message);
                    if (Globals.g_quietMode) {
                        ret = 0;
                        break;
                    }
                    int response = CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), message + "\n\n" + warningCofirmation, bundle.getString("Common.Warning.txt"), 0, 2);
                    if (response != 1) break;
                    ret = 1;
                    break;
                }
                case 2: {
                    Logging.log.severe(message);
                    if (Globals.g_quietMode) {
                        ret = 1;
                        break;
                    }
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), message, bundle.getString("Common.Error.txt"), 0);
                    ret = 1;
                    break;
                }
            }
        }
        return ret;
    }
}

