/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.utils;

import com.sas.ssn.Globals;
import com.sas.ssn.ProductData;
import com.sas.ssn.Utils;
import java.io.File;

public class ProductDirUtils {
    private static String cfgwizardProductDataDir = null;
    private static String cfgwizardMaintenanceDir = null;

    public static String getCfgWizardProductDataDir() {
        if (cfgwizardProductDataDir == null) {
            cfgwizardProductDataDir = ProductDirUtils.getProductDataDir("cfgwizard");
        }
        return cfgwizardProductDataDir;
    }

    public static String getCfgWizardMaintenanceDir() {
        if (cfgwizardMaintenanceDir == null) {
            cfgwizardMaintenanceDir = ProductDirUtils.getMaintenanceDir("cfgwizard");
        }
        return cfgwizardMaintenanceDir;
    }

    public static String getProductDataDir(String owningProduct) {
        return Globals.g_deploymentData.getProductDataDir(Globals.g_order, owningProduct, true, true);
    }

    public static String getMaintenanceDir(String owningProduct) {
        String maintDataDir = null;
        ProductData maintData = Globals.g_deploymentData.getMaintenance(Globals.g_order, owningProduct, Utils.getOS_Suffix(), "xx", true);
        if (maintData != null) {
            maintDataDir = Globals.g_deploymentData.getSpsSkuDataDir(Globals.g_order, maintData.getSpsSku(), true);
        }
        return maintDataDir;
    }

    public static File getProductDataFile(String owningProduct, String fileName) {
        File file;
        File ret = null;
        String productDataDir = ProductDirUtils.getProductDataDir(owningProduct);
        String maintenanceDir = ProductDirUtils.getMaintenanceDir(owningProduct);
        if (maintenanceDir != null && (file = new File(Utils.joinPath(maintenanceDir, fileName))).exists()) {
            ret = file;
        }
        if (ret == null && productDataDir != null && (file = new File(Utils.joinPath(productDataDir, fileName))).exists()) {
            ret = file;
        }
        return ret;
    }
}

