/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.utils;

import com.sas.ssn.Configure;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.Utils;
import com.sas.ssn.utils.ClassLoaderUtils;
import com.sas.ssn.utils.GroovyClassLoadingException;
import com.sas.ssn.utils.ProductDirUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;

public class GroovyLauncher {
    private static GroovyLauncher defaultLauncher = null;
    private URLClassLoader myGroovyClassLoader = null;
    private Method addClasspathMethod = null;
    private Method parseClassMethod = null;
    private Method loadClassMethod = null;

    public static GroovyLauncher getDefaultGroovyLauncher() throws IOException {
        if (defaultLauncher == null) {
            defaultLauncher = new GroovyLauncher();
            defaultLauncher.addClasspath(GroovyLauncher.getDefaultOrderedClasspath());
        }
        return defaultLauncher;
    }

    public static List<String> getDefaultOrderedClasspath() {
        ProductData[] allProdData;
        ArrayList<String> orderedClasspath = new ArrayList<String>();
        String srcDir = GroovyLauncher.getGroovySrcDirectory("cfgwizard");
        if (srcDir != null && !orderedClasspath.contains(srcDir)) {
            orderedClasspath.add(srcDir);
        }
        if ((allProdData = Globals.g_deploymentData.getAllProducts(Globals.g_order, true)) != null) {
            String prodCode = null;
            for (int i = 0; i < allProdData.length; ++i) {
                prodCode = allProdData[i].getProdCode();
                srcDir = GroovyLauncher.getGroovySrcDirectory(prodCode);
                if (srcDir == null || orderedClasspath.contains(srcDir)) continue;
                orderedClasspath.add(srcDir);
            }
        }
        return orderedClasspath;
    }

    private static String getGroovySrcDirectory(String prodCode) {
        String path = ProductDirUtils.getMaintenanceDir(prodCode);
        String string = path = path != null ? Utils.joinPath(path, DynamicDialogs.GROOVY_SRC_SUBDIR) : null;
        if (path == null || !new File(path).isDirectory()) {
            path = ProductDirUtils.getProductDataDir(prodCode);
            String string2 = path = path != null ? Utils.joinPath(path, DynamicDialogs.GROOVY_SRC_SUBDIR) : null;
            if (path == null || !new File(path).isDirectory()) {
                path = null;
            }
        }
        return path;
    }

    public static GroovyLauncher getCustomGroovyLauncher(List<JarFile> jarFileList, boolean includeDefaultGroovy) throws IOException {
        return new GroovyLauncher(jarFileList, includeDefaultGroovy);
    }

    public static GroovyLauncher getCustomGroovyLauncher(String path, boolean includeDefaultGroovy) throws IOException {
        return new GroovyLauncher(path, includeDefaultGroovy);
    }

    private static ClassLoader getClassLoaderWithGroovy() throws IOException {
        ClassLoader classLoaderWithGroovy = ClassLoaderUtils.getClassLoaderWithJarsFromPath(Configure.getDefaultGroovyFilePath());
        try {
            classLoaderWithGroovy.loadClass("groovy.lang.GroovyClassLoader");
        }
        catch (Exception e) {
            throw new IOException("GroovyLauncher:getClassLoaderWithGroovy() Groovy could not be found in the classpath!");
        }
        return classLoaderWithGroovy;
    }

    private GroovyLauncher() throws IOException {
        this.init(GroovyLauncher.getClassLoaderWithGroovy());
    }

    private GroovyLauncher(ClassLoader classLoader) throws IOException {
        this.init(classLoader);
    }

    private void init(ClassLoader classLoader) throws IOException {
        try {
            Class<?> groovyClassLoaderClass = classLoader.loadClass("groovy.lang.GroovyClassLoader");
            Constructor<?> groovyClassLoaderConstructor = groovyClassLoaderClass.getConstructor(ClassLoader.class);
            this.myGroovyClassLoader = (URLClassLoader)groovyClassLoaderConstructor.newInstance(classLoader);
            this.addClasspathMethod = groovyClassLoaderClass.getMethod("addClasspath", String.class);
            this.parseClassMethod = groovyClassLoaderClass.getMethod("parseClass", File.class);
            this.loadClassMethod = groovyClassLoaderClass.getMethod("loadClass", String.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("GroovyLauncher<init>(ClassLoader parentClassLoader) Problem loading groovy.lang.GroovyClassLoader class or methods: " + e.getMessage());
        }
    }

    private GroovyLauncher(List<JarFile> jarFileList, boolean includeDefaultGroovy) throws IOException {
        ClassLoader parentClassLoader = includeDefaultGroovy ? GroovyLauncher.getClassLoaderWithGroovy() : GroovyLauncher.class.getClassLoader();
        this.init(ClassLoaderUtils.getClassLoaderWithJars(jarFileList, parentClassLoader));
    }

    private GroovyLauncher(String path, boolean includeDefaultGroovy) throws IOException {
        ClassLoader parentClassLoader = includeDefaultGroovy ? GroovyLauncher.getClassLoaderWithGroovy() : GroovyLauncher.class.getClassLoader();
        this.init(ClassLoaderUtils.getClassLoaderWithJarsFromPath(path, parentClassLoader));
    }

    public ClassLoader getGroovyClassLoader() {
        return this.myGroovyClassLoader;
    }

    public boolean addClasspath(List<String> orderedClasspath) {
        boolean ret = true;
        if (orderedClasspath != null) {
            for (String path : orderedClasspath) {
                if (this.addClasspath(path)) continue;
                ret = false;
            }
        }
        return ret;
    }

    public boolean addClasspath(String path) {
        boolean ret = false;
        if (path != null) {
            try {
                Logging.log.finer("Adding to default groovy launcher classpath: " + path);
                this.addClasspathMethod.invoke((Object)this.myGroovyClassLoader, path);
                ret = true;
            }
            catch (IllegalAccessException iae) {
                Logging.logStackTrace(iae);
            }
            catch (InvocationTargetException ite) {
                Logging.logStackTrace(ite);
            }
        }
        return ret;
    }

    public Class loadClass(String className) throws ClassNotFoundException, GroovyClassLoadingException {
        Class groovyClass = null;
        if (className != null) {
            try {
                groovyClass = (Class)this.loadClassMethod.invoke((Object)this.myGroovyClassLoader, className, Boolean.TRUE, Boolean.TRUE);
            }
            catch (IllegalAccessException iae) {
                throw new GroovyClassLoadingException(iae);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)cause;
                }
                throw new GroovyClassLoadingException(cause);
            }
        }
        return groovyClass;
    }

    public Class parseClass(File groovyFile) throws GroovyClassLoadingException {
        Class groovyClass = null;
        if (groovyFile != null) {
            try {
                groovyClass = (Class)this.parseClassMethod.invoke((Object)this.myGroovyClassLoader, groovyFile);
            }
            catch (IllegalAccessException iae) {
                throw new GroovyClassLoadingException(iae);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                throw new GroovyClassLoadingException(cause);
            }
        }
        return groovyClass;
    }

    public Object constructGroovyInstance(File groovyFile) throws GroovyClassLoadingException {
        Object instance = null;
        Class groovyClass = this.parseClass(groovyFile);
        if (groovyClass != null) {
            try {
                instance = groovyClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new GroovyClassLoadingException(e);
            }
            catch (IllegalAccessException e) {
                throw new GroovyClassLoadingException(e);
            }
        }
        return instance;
    }

    public Object constructGroovyInstance(String className) throws ClassNotFoundException, GroovyClassLoadingException {
        Object instance = null;
        Class groovyClass = this.loadClass(className);
        if (groovyClass != null) {
            try {
                instance = groovyClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new GroovyClassLoadingException(e);
            }
            catch (IllegalAccessException e) {
                throw new GroovyClassLoadingException(e);
            }
        }
        return instance;
    }
}

