/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.utils;

import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import com.sas.ssn.utils.ProductDirUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GroovyFile
extends File {
    private String owningProduct = null;
    private String groovyClassname = null;
    private List<String> orderedClasspath = null;

    private static String getClasspath(String dataDir, String relativePath) {
        return relativePath == null || relativePath.trim().length() == 0 ? dataDir : Utils.joinPath(dataDir, relativePath);
    }

    public static GroovyFile findGroovyFileInProductData(String owningProduct, String relativePath, String classname) {
        GroovyFile groovyFile = null;
        Object classpath = null;
        ArrayList<String> orderedClasspath = new ArrayList<String>();
        groovyFile = GroovyFile.findGroovyFileInProductData(owningProduct, relativePath, classname, orderedClasspath);
        if (!owningProduct.equalsIgnoreCase("cfgwizard")) {
            GroovyFile groovyFileFromCfgWizard = GroovyFile.findGroovyFileInProductData("cfgwizard", relativePath, classname, orderedClasspath);
            if (groovyFile == null) {
                groovyFile = groovyFileFromCfgWizard;
            }
        }
        return groovyFile;
    }

    private static GroovyFile findGroovyFileInProductData(String owningProduct, String relativePath, String classname, ArrayList<String> orderedClasspath) {
        File groovyFile = null;
        String classpath = null;
        if (owningProduct != null && classname != null) {
            String classFileName = classname.replaceAll("\\.", "/") + ".groovy";
            String productDataDir = ProductDirUtils.getProductDataDir(owningProduct);
            if (productDataDir != null) {
                File classpathFile;
                String maintDataDir = ProductDirUtils.getMaintenanceDir(owningProduct);
                if (maintDataDir != null) {
                    classpath = GroovyFile.getClasspath(maintDataDir, relativePath);
                    classpathFile = new File(classpath);
                    if (classpathFile.isDirectory()) {
                        orderedClasspath.add(classpath);
                    }
                    groovyFile = new GroovyFile(classpath, classFileName);
                    Logging.log.finer("GroovyFile::Searching for Groovy file in maintenance directory: " + groovyFile.getPath());
                }
                if ((classpathFile = new File(classpath = GroovyFile.getClasspath(productDataDir, relativePath))).isDirectory()) {
                    orderedClasspath.add(classpath);
                }
                if (groovyFile == null || !groovyFile.isFile()) {
                    groovyFile = new GroovyFile(classpath, classFileName);
                    Logging.log.finer("GroovyFile::Searching for Groovy file in base product_data directory: " + groovyFile.getPath());
                    if (!groovyFile.isFile()) {
                        groovyFile = null;
                    }
                }
            }
        }
        if (groovyFile != null) {
            Logging.log.finer("GroovyFile::Found matching Groovy file: " + groovyFile.getPath());
            ((GroovyFile)groovyFile).owningProduct = owningProduct;
            ((GroovyFile)groovyFile).groovyClassname = classname;
            ((GroovyFile)groovyFile).orderedClasspath = orderedClasspath;
        }
        return groovyFile;
    }

    private GroovyFile(String parent, String child) {
        super(parent, child);
    }

    private GroovyFile(String pathname) {
        super(pathname);
    }

    public String getOwningProduct() {
        return this.owningProduct;
    }

    public String getGroovyClassname() {
        return this.groovyClassname;
    }

    public List<String> getOrderedClasspath() {
        return this.orderedClasspath;
    }
}

