/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.utils;

import com.sas.ssn.Logging;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public class DynamicJDBCDriver
implements Driver {
    private static HashMap<String, Driver> registeredDrivers = new HashMap();
    private Driver driver = null;

    public static boolean registerDriver(ClassLoader classLoader, String driver) {
        boolean ret = false;
        if (classLoader != null && driver != null) {
            try {
                Class<?> driverClass = classLoader.loadClass(driver);
                Driver newDriver = (Driver)driverClass.newInstance();
                DynamicJDBCDriver dynamicDriver = new DynamicJDBCDriver(newDriver);
                DriverManager.registerDriver(dynamicDriver);
                registeredDrivers.put(driver, dynamicDriver);
                ret = true;
            }
            catch (Exception e) {
                Logging.log.severe("DynamicDriver:registerDriver() Could not register driver class '" + driver + "'");
                Logging.logStackTrace(e);
            }
        }
        return ret;
    }

    public static boolean deregisterDriver(String driver) {
        boolean ret = false;
        if (driver != null) {
            try {
                Driver foundDriver = registeredDrivers.remove(driver);
                DriverManager.deregisterDriver(foundDriver);
                ret = true;
            }
            catch (Exception e) {
                Logging.log.warning("DynamicDriver:deregisterDriver() Could not deregister driver class '" + driver + "'");
            }
        }
        return ret;
    }

    private DynamicJDBCDriver(Driver driver) {
        this.driver = driver;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.driver.connect(url, info);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.driver.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.driver.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this.driver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.driver.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this.driver.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

