/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.utils;

import com.sas.ssn.Chaining;
import com.sas.ssn.Globals;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class DocPartUtils {
    public static final String DEFAULT_CONFIG_INSTRUCTIONS_FILE_NAME = "Instructions.html";
    public static final String DEFAULT_CONFIG_ERRORLOG_FILE_NAME = "ConfigurationErrors.html";
    public static final String[] REPLACE_INSTRUCTIONS_TOKENS_LIST = new String[]{"instructions.head", "instructions.warnings.head", "instructions.warnings.singleuser", "instructions.warnings.item", "instructions.warnings.tail", "instructions.head.intro", "instructions.contents.head", "instructions.contents.warnings", "instructions.contents.item", "instructions.contents.installing.jmp", "instructions.contents.completing.manual.deployment", "instructions.contents.additional.info", "instructions.contents.tail", "instructions.notices.head", "instructions.notices.singleuser", "instructions.notices.item", "instructions.notices.tail", "instructions.additionalinfo.head", "instructions.additionalinfo.item", "instructions.additionalinfo.tail", "instructions.tail.outro"};
    private static HashSet<File> createdDocPartFiles = new HashSet();

    public static String getCurrentInstructionsFile() {
        return Globals.g_cmtTaskInstructionsFile;
    }

    public static String getCurrentInstructionsFileName() {
        int lastSeparator;
        String filename = "";
        String filepath = DocPartUtils.getCurrentInstructionsFile();
        if (filepath != null && filepath.length() > 0 && (lastSeparator = filepath.lastIndexOf(File.separatorChar)) != -1) {
            filename = filepath.substring(lastSeparator + 1);
        }
        return filename;
    }

    private static Map<String, String> getReplacementTokensForDocParts(Properties textProperties, String taskName, String[] instructTokenList) {
        HashMap<String, String> replacementTokens = new HashMap<String, String>();
        if (textProperties != null && taskName != null && instructTokenList != null) {
            String lowerCaseTaskName = taskName.toLowerCase();
            for (int i = 0; instructTokenList.length > i; ++i) {
                String instructToken = instructTokenList[i];
                if (!instructToken.startsWith("instructions.")) continue;
                String suffix = instructToken.substring(13);
                suffix = "_" + suffix.replace('.', '_') + ".txt";
                String value = textProperties.getProperty(lowerCaseTaskName + suffix);
                if (value == null) {
                    value = textProperties.getProperty("generaltarget" + suffix);
                }
                if (value == null) continue;
                replacementTokens.put(instructToken, value);
            }
        }
        return replacementTokens;
    }

    public static File createInstructionsDocPartsForTask(String taskName) throws IOException {
        String lcTaskName;
        Properties taskTxt;
        String installLocation;
        File newFile = null;
        if (Globals.g_cmtRunConfigure && (installLocation = Utils.joinPath(Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", "")), Globals.g_deploymentData.getProductDir(Globals.g_order, "cfgwizard", true, false), "Config")) != null && !(taskTxt = DocPartUtils.loadPropertiesForLocale(installLocation, Language.gs_SelectedLanguage, (lcTaskName = taskName.toLowerCase()) + "_task.txt")).isEmpty()) {
            Properties configTargetsTxt = DocPartUtils.loadPropertiesForLocale(installLocation, Language.gs_SelectedLanguage, "configuration_targets.txt");
            taskTxt.putAll((Map<?, ?>)configTargetsTxt);
            Map<String, String> replacementTokens = DocPartUtils.getReplacementTokensForDocParts(taskTxt, taskName, REPLACE_INSTRUCTIONS_TOKENS_LIST);
            if (replacementTokens != null && replacementTokens.size() > 0) {
                String backupFileName;
                String backupPath;
                File backupFile;
                File backupDir;
                String htmlFileName = Globals.g_configData.getProperty("config.instructions.file.name", DEFAULT_CONFIG_INSTRUCTIONS_FILE_NAME);
                String newFileName = Globals.g_configDefaults.getDefault("config." + lcTaskName + ".file.name", taskName + ".html");
                File templateFile = new File(Utils.joinPath(installLocation, "documents", htmlFileName + ".orig"));
                String docPath = Utils.joinPath(Globals.g_cmtConfigDir, "Documents");
                String newFilePath = Utils.joinPath(docPath, newFileName);
                newFile = new File(newFilePath);
                if (newFile.exists() && (backupDir = (backupFile = new File(backupPath = Utils.joinPath(docPath, "Backup", backupFileName = newFile.getName() + "_" + Chaining.getStartTimestamp() + ".bak"))).getParentFile()) != null) {
                    if (!backupDir.exists()) {
                        backupDir.mkdir();
                    }
                    Utils.copyFile(newFile, backupFile);
                }
                DocPartUtils.createDocParts(templateFile, newFile, replacementTokens);
                createdDocPartFiles.add(newFile);
                Globals.g_cmtTaskInstructionsFile = newFilePath;
            }
        }
        return newFile;
    }

    public static File createConfigErrorDocParts() throws IOException {
        String installLocation;
        File newFile = null;
        if (Globals.g_cmtRunConfigure && (installLocation = Utils.joinPath(Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", "")), Globals.g_deploymentData.getProductDir(Globals.g_order, "cfgwizard", true, false), "Config")) != null) {
            HashMap<String, String> replacementTokens = new HashMap<String, String>();
            Properties cfgwizardTxt = DocPartUtils.loadPropertiesForLocale(installLocation, Language.gs_SelectedLanguage, "cfgwizard.txt");
            String errorsHead = cfgwizardTxt.getProperty("errors_head.txt");
            String errorsIntro = cfgwizardTxt.getProperty("errors_intro.txt");
            String errorsOutro = cfgwizardTxt.getProperty("errors_instructions_html_link.txt");
            String errorsTail = cfgwizardTxt.getProperty("errors_tail.txt");
            replacementTokens.put("errors.head", errorsHead);
            replacementTokens.put("errors.intro", errorsIntro);
            replacementTokens.put("errors.outro", errorsOutro);
            replacementTokens.put("errors.tail", errorsTail);
            String htmlFileName = Globals.g_configData.getProperty("config.errorlog.file.name", DEFAULT_CONFIG_ERRORLOG_FILE_NAME);
            File templateFile = new File(Utils.joinPath(installLocation, "documents", htmlFileName + ".orig"));
            newFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "Documents", htmlFileName));
            DocPartUtils.createDocParts(templateFile, newFile, replacementTokens);
            createdDocPartFiles.add(newFile);
        }
        return newFile;
    }

    private static void createDocParts(File templateFile, File newFile, Map<String, String> replacementTokens) {
        File docDir;
        Object backupFile = null;
        if (templateFile.exists() && (docDir = newFile.getParentFile()) != null) {
            if (!docDir.exists()) {
                docDir.mkdir();
            }
            try {
                String content = Utils.readFile(templateFile, "UTF-8");
                for (Map.Entry<String, String> entry : replacementTokens.entrySet()) {
                    String key = "${" + entry.getKey() + "}";
                    String value = entry.getValue();
                    content = content.replace(key, value);
                }
                Utils.writeFile(newFile, content, "UTF-8");
            }
            catch (IOException ioe) {
                Logging.logStackTrace(ioe);
            }
        }
    }

    public static void finalizeAllDocPartFiles() {
        for (File file : createdDocPartFiles) {
            DocPartUtils.finalizeDocParts(file);
        }
        createdDocPartFiles.clear();
    }

    private static void finalizeDocParts(File file) {
        if (file != null && file.isFile()) {
            try {
                String content = Utils.readFile(file, "UTF-8");
                for (Map.Entry<Object, Object> entry : Globals.g_configData.getProperties().entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (key == null || value == null) continue;
                    content = content.replace("${" + key.toString() + "}", value.toString());
                }
                content = content.replaceAll("\\$\\{line.separator\\}[\\n\\r\\s]*", System.getProperty("line.separator"));
                content = content.replaceAll("\\$\\{[\\w\\.]*\\}[\\n\\r\\s]*", "");
                Utils.writeFile(file, content, "UTF-8");
            }
            catch (IOException ioe) {
                Logging.logStackTrace(ioe);
            }
        }
    }

    private static Properties loadPropertiesForLocale(String parentDirectory, String locale, String fileName) throws IOException {
        String localeFilePath;
        File localeFile;
        Properties properties = new Properties();
        String enFilePath = Utils.joinPath(parentDirectory, "en", fileName);
        File enLocaleFile = new File(enFilePath);
        if (enLocaleFile.exists()) {
            properties.load(new FileInputStream(enLocaleFile));
        }
        if (!locale.equalsIgnoreCase("en") && (localeFile = new File(localeFilePath = Utils.joinPath(parentDirectory, locale, fileName))).exists()) {
            Properties localeProperties = new Properties();
            localeProperties.load(new FileInputStream(localeFile));
            properties.putAll((Map<?, ?>)localeProperties);
        }
        return properties;
    }
}

