/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;

public class ClassLoaderUtils {
    public static ClassLoader getClassLoaderWithJars(List<JarFile> jarFileList, ClassLoader parent) throws IOException {
        ClassLoader classLoader = null;
        if (jarFileList == null || jarFileList.size() == 0) {
            classLoader = parent;
        } else {
            URL[] jarFileURLs = new URL[jarFileList.size()];
            for (int i = 0; i < jarFileList.size(); ++i) {
                File myFile = new File(jarFileList.get(i).getName());
                jarFileURLs[i] = myFile.toURI().toURL();
            }
            classLoader = new URLClassLoader(jarFileURLs, parent);
        }
        return classLoader;
    }

    public static ClassLoader getClassLoaderWithJars(List<JarFile> jarFileList) throws IOException {
        return ClassLoaderUtils.getClassLoaderWithJars(jarFileList, ClassLoaderUtils.class.getClassLoader());
    }

    public static ClassLoader getClassLoaderWithJarsFromPath(String path, ClassLoader parent) throws IOException {
        ArrayList<JarFile> jarFileList = new ArrayList<JarFile>();
        File pathFile = new File(path);
        if (pathFile.isFile()) {
            jarFileList.add(new JarFile(pathFile));
        } else if (pathFile.isDirectory()) {
            File[] jarFiles;
            FilenameFilter jarFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".jar");
                }
            };
            for (File jarFile : jarFiles = pathFile.listFiles(jarFilter)) {
                jarFileList.add(new JarFile(jarFile.getCanonicalFile()));
            }
        }
        return ClassLoaderUtils.getClassLoaderWithJars(jarFileList, parent);
    }

    public static ClassLoader getClassLoaderWithJarsFromPath(String path) throws IOException {
        return ClassLoaderUtils.getClassLoaderWithJarsFromPath(path, ClassLoaderUtils.class.getClassLoader());
    }
}

