/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.ssl;

import com.sas.ssn.PanelSASHome;
import com.sas.ssn.PanelSDMStart;
import com.sas.ssn.SSNResource;
import com.sas.ssn.WizardCallbackIface;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class CertFileBrowseButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 6466958524192383339L;
    public static final String BUNDLE_KEY_FilE_CHOOSER_FILTER_NAME = "PanelCertificateRemove.FileChooserFilterName.txt";
    protected static SSNResource bundle = new SSNResource(PanelSASHome.class);
    private JTextComponent m_companion = null;
    private JComboBox m_comboBox = null;
    private String m_defdir = null;
    private String m_deffile = null;
    private WizardCallbackIface m_callbackPanel = null;
    private JFileChooser m_chooser;
    private Boolean m_chooserReadOnlyValOrig;

    public CertFileBrowseButton(String title, String defdir, JTextComponent companion) {
        super(title);
        this.m_defdir = defdir;
        this.m_companion = companion;
        this.addActionListener(this);
    }

    public void initChooser() {
        this.m_chooserReadOnlyValOrig = UIManager.getBoolean("FileChooser.readOnly");
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        CertificateRemoveFilter removeFilter = new CertificateRemoveFilter();
        removeFilter.setValidCertDirectory(this.m_defdir);
        String title = null;
        title = bundle.getString("Common.Open.txt");
        JFileChooser chooser = new JFileChooser(new File(this.m_defdir));
        chooser.setDialogTitle(title);
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(removeFilter);
        this.m_chooser = chooser;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String selectedFileStr = null;
        int returnVal = 0;
        if (this.m_chooser == null) {
            this.initChooser();
        }
        returnVal = this.m_chooser.showOpenDialog(this.getParentComponent(this));
        UIManager.put("FileChooser.readOnly", this.m_chooserReadOnlyValOrig);
        if (returnVal == 0) {
            File file = this.m_chooser.getSelectedFile();
            selectedFileStr = file.getPath();
        }
        if (selectedFileStr != null) {
            selectedFileStr = selectedFileStr.replaceAll(Pattern.compile("^/(\\.\\.?/)+").toString(), "/");
        }
        if (selectedFileStr != null) {
            if (this.m_companion != null) {
                this.m_companion.setText(selectedFileStr);
            } else if (this.m_comboBox != null) {
                ((JTextField)this.m_comboBox.getEditor().getEditorComponent()).setText(selectedFileStr);
            }
            if (this.m_callbackPanel != null) {
                this.m_callbackPanel.updateTextArea();
            }
        }
    }

    public Frame getParentFrame(Component comp) {
        Frame parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame) {
                parentFrame = (Frame)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public Component getParentComponent(Component comp) {
        Component parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame || parent instanceof Dialog) {
                parentFrame = parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public void setCallbackPanel(WizardCallbackIface panel) {
        this.m_callbackPanel = panel;
    }

    public void setDefaultFile(String df) {
        this.m_deffile = df;
    }

    public void setFileName(String fileName) {
        this.m_chooser.setSelectedFile(new File(fileName));
    }

    private String getComboText() {
        return ((JTextField)this.m_comboBox.getEditor().getEditorComponent()).getText();
    }

    private class CertificateRemoveFilter
    extends FileFilter {
        protected StringBuffer strBuf1;
        protected StringBuffer strBuf2;
        protected StringBuffer strBuf3;
        protected StringBuffer strBuf4;
        protected String skipFileStr1;
        protected String skipFileStr2;
        protected String skipFileStr3;
        protected String skipFileStr4;
        private SSNResource bundle = new SSNResource(PanelSDMStart.class);
        String validTrustStoreDirStr = null;
        String messageStr = null;

        public CertificateRemoveFilter() {
            this.strBuf1 = new StringBuffer("cacerts.pem");
            this.strBuf2 = new StringBuffer("cacerts.jks");
            this.strBuf3 = new StringBuffer("trustedcerts.pem");
            this.strBuf4 = new StringBuffer("trustedcerts.jks");
            this.skipFileStr1 = new String(this.strBuf1);
            this.skipFileStr2 = new String(this.strBuf2);
            this.skipFileStr3 = new String(this.strBuf3);
            this.skipFileStr4 = new String(this.strBuf4);
        }

        public void setValidCertDirectory(String validDir) {
            this.validTrustStoreDirStr = validDir;
        }

        public String getValidCertDirectory() {
            return this.validTrustStoreDirStr;
        }

        public String getMessage() {
            return this.validTrustStoreDirStr;
        }

        @Override
        public boolean accept(File file) {
            boolean retVal = true;
            String filename = file.getName();
            if (filename.equals(this.skipFileStr1) || filename.equals(this.skipFileStr2) || filename.equals(this.skipFileStr3) || filename.equals(this.skipFileStr4)) {
                this.messageStr = "cannot remove " + filename;
                retVal = false;
            }
            return retVal;
        }

        @Override
        public String getDescription() {
            return this.bundle.getString(CertFileBrowseButton.BUNDLE_KEY_FilE_CHOOSER_FILTER_NAME);
        }
    }
}

