/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.lsm.impl;

import com.sas.ssn.lsm.ConfigInterface;
import com.sas.ssn.lsm.ProductInterface;
import com.sas.ssn.lsm.impl.JavaIniFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;

public class SASJavaProduct
implements ProductInterface {
    private String productName;
    private String installLocation;
    private String exeFileName;
    private ConfigInterface configFile;
    private String version;
    private String clsid;

    public SASJavaProduct(String productName, String installLoc, String exe, ConfigInterface configfile, String version, String clsid) throws FileNotFoundException, IOException {
        this.productName = productName;
        this.installLocation = installLoc;
        this.configFile = configfile;
        this.exeFileName = exe;
        this.version = version;
        this.clsid = clsid;
        if (this.configFile.getContents() == null) {
            this.configFile.load();
        }
    }

    public SASJavaProduct(String productName, String installLoc, String configfile, String exe, String version, String clsid) throws FileNotFoundException, IOException {
        JavaIniFile cfgInterface = new JavaIniFile(configfile);
        cfgInterface.load();
        this.productName = productName;
        this.installLocation = installLoc;
        this.configFile = cfgInterface;
        this.exeFileName = exe;
        this.version = version;
        this.clsid = clsid;
    }

    @Override
    public void storeConfig(String outFile) throws IOException {
        this.configFile.store(outFile);
    }

    @Override
    public void updateConfig() throws IOException {
        this.configFile.update();
    }

    @Override
    public Locale getLocale() {
        return this.configFile.getLocale();
    }

    @Override
    public void setLocale(Locale locale) {
        this.configFile.setLocale(locale);
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getInstallLocation() {
        return this.installLocation;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ConfigInterface getConfigfile() {
        return this.configFile;
    }

    @Override
    public void setConfigfile(ConfigInterface configfile) {
        this.configFile = configfile;
    }

    @Override
    public String getExecutable() {
        return this.exeFileName;
    }

    @Override
    public String getCLSID() {
        return this.clsid;
    }

    @Override
    public boolean isInstalled() {
        return this.configFile.isInstalled();
    }

    @Override
    public Object clone() {
        SASJavaProduct product = null;
        try {
            product = (SASJavaProduct)super.clone();
            product.setConfigfile((ConfigInterface)this.configFile.clone());
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return product;
    }

    @Override
    public boolean isSameProductInfomation(ProductInterface product) {
        return this.getProductName().equals(product.getProductName()) && this.getInstallLocation().equals(product.getInstallLocation()) && this.getExecutable().equals(product.getExecutable()) && this.getConfigfile().getConfigurationFile().equals(product.getConfigfile().getConfigurationFile()) && this.getVersion().equals(product.getVersion()) && this.getCLSID().equals(product.getCLSID());
    }

    @Override
    public int validate() {
        return this.configFile.validate();
    }

    @Override
    public void printDebug() {
        System.out.println(this.getProductName());
        System.out.println(this.getVersion());
        System.out.println(this.getCLSID());
        System.out.println(this.getExecutable());
        System.out.println(this.getInstallLocation());
        System.out.println(this.getLocale());
        System.out.println(this.isInstalled());
    }
}

