/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.lsm;

import com.sas.ssn.Globals;
import com.sas.ssn.Kit;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelLocaleSetupManagerFinish;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.Utils;
import com.sas.ssn.lsm.BaseConfigFile;
import com.sas.ssn.lsm.JavaProductsWithLauncherFiles;
import com.sas.ssn.lsm.LauncherINIFiles;
import com.sas.ssn.lsm.impl.JavaIniFile;
import com.sas.tools.installs.schema.ittasks.LocaleType;
import com.sas.tools.installs.schema.ittasks.LocalesForHostType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LocaleSetupManager {
    private RegistryAccess registryAccess = null;
    private List<String> productCodes = new ArrayList<String>();
    private String sasHome = null;
    private boolean baseIsInstalled = false;
    private String baseSASVersion = null;
    private static final String[] dbcsLangs = new String[]{"1d", "dbcs", "u8", "ja", "ko", "zh", "zt"};
    private JavaProductsWithLauncherFiles javaProducts = new JavaProductsWithLauncherFiles();

    public LocaleSetupManager(String sasHome) {
        this.sasHome = sasHome;
        this.javaProducts.clear();
        PanelLocaleSetupManagerFinish.getProductList().clear();
        if (Globals.g_order != null) {
            try {
                RegistryData.setRegistry(sasHome);
                this.registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                if (this.registryAccess.open()) {
                    this.loadHosts();
                }
            }
            catch (FileNotFoundException e) {
                Logging.log.severe("Deployment registry jar not found: " + RegistryData.getDeployRegJar());
                Logging.logStackTrace(e);
            }
            catch (Exception e) {
                Logging.log.severe("Failed to load deployment registry jar: " + RegistryData.getDeployRegJar());
                Logging.logStackTrace(e);
            }
            finally {
                if (this.registryAccess != null) {
                    this.registryAccess.close();
                }
            }
        }
    }

    public JavaProductsWithLauncherFiles getJavaProducts() {
        return this.javaProducts;
    }

    private LocaleType getLocaleTypeForLocale(String mvaPosixLocaleName) {
        String host = "unx";
        if (Utils.getOS() == 1) {
            host = "win";
        }
        LocaleType selectedLocaleType = null;
        List<LocaleType> localeTypes = Kit.getDeploymentXMLReader().getLocalesForHost(host, "").getLocale();
        for (LocaleType localeType : localeTypes) {
            if (!localeType.getName().equals(mvaPosixLocaleName)) continue;
            selectedLocaleType = localeType;
            break;
        }
        if (host.equals("unx")) {
            host = Utils.getOS_Suffix();
            LocalesForHostType localesForHostType = Kit.getDeploymentXMLReader().getLocalesForHost(host, "");
            if (localesForHostType != null) {
                localeTypes = Kit.getDeploymentXMLReader().getLocalesForHost(host, "").getLocale();
                for (LocaleType localeType : localeTypes) {
                    if (!localeType.getName().equals(mvaPosixLocaleName)) continue;
                    selectedLocaleType = localeType;
                    break;
                }
            }
        }
        return selectedLocaleType;
    }

    private void loadHosts() {
        String[] hosts = this.registryAccess.getInstallHosts();
        for (int i = 0; i < hosts.length; ++i) {
            this.loadProducts(hosts[i]);
        }
    }

    private void loadProducts(String host) {
        String[] codes = this.registryAccess.getInstallCodes(host);
        for (int i = 0; i < codes.length; ++i) {
            if (codes[i].equalsIgnoreCase("base")) {
                this.baseIsInstalled = true;
                String[] versions = this.registryAccess.getInstallVersions("base", host);
                this.baseSASVersion = versions[0];
            }
            this.locateProductsWithJavaLaunchers(host, codes[i]);
        }
    }

    private void locateProductsWithJavaLaunchers(String platform, String code) {
        String launcherExtension = "";
        if (Utils.getOS() == 1) {
            launcherExtension = ".exe";
        }
        class FileFilter
        implements FilenameFilter {
            String ext;

            public FileFilter(String ext) {
                this.ext = ext;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(this.ext);
            }
        }
        FileFilter filter = new FileFilter(".ini");
        String[] versions = this.registryAccess.getInstallVersions(code, platform);
        for (int i = 0; i < versions.length; ++i) {
            File files;
            String[] iniFiles;
            String version = versions[i];
            String installLoc = this.registryAccess.getInstallLoc(code, version, platform);
            String displayName = this.registryAccess.getInstallDisplayName(code, version, platform);
            if (installLoc == null || installLoc.equals("") || (iniFiles = (files = new File(installLoc)).list(filter)) == null) continue;
            for (int j = 0; j < iniFiles.length; ++j) {
                File iniFile = new File(iniFiles[j]);
                String iniFileName = iniFile.getName();
                String launcher = iniFileName.replace(".ini", launcherExtension);
                File launcherFile = new File(installLoc, launcher);
                ArrayList<JavaIniFile> javaIniFiles = new ArrayList<JavaIniFile>();
                if (launcherFile.exists()) {
                    JavaIniFile javaIniFile = new JavaIniFile(installLoc + File.separator + iniFiles[j]);
                    javaIniFiles.add(javaIniFile);
                }
                if (javaIniFiles.isEmpty()) continue;
                this.javaProducts.addProduct(code, version, platform, displayName, javaIniFiles);
            }
        }
    }

    public List<String> getJavaProductCodesWithLaunchers() {
        return this.productCodes;
    }

    public boolean isBaseSASInstalled() {
        return this.baseIsInstalled;
    }

    public String getBaseSASVersion() {
        return this.baseSASVersion;
    }

    public boolean setLocaleForSelectedJavaProducts(String mvaPosixLocaleName, List<String> productKeys) {
        List<JavaIniFile> javaIniFiles = this.javaProducts.getSelectedJavaIniFiles(productKeys);
        LanguageAndCountry langAndCountry = new LanguageAndCountry(mvaPosixLocaleName);
        String language = langAndCountry.getLanguage();
        String country = langAndCountry.getCountry();
        if (language != null && country != null) {
            if (javaIniFiles.size() > 0) {
                Locale locale = new Locale(language, country);
                LauncherINIFiles launcherINIFiles = new LauncherINIFiles(javaIniFiles);
                launcherINIFiles.setLocale(locale);
            }
        } else {
            Logging.log.warning("MVA posix locale name missing a language or country code: " + mvaPosixLocaleName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLocaleForBase(String mvaPosixLocaleName) {
        LocaleType localeType = this.getLocaleTypeForLocale(mvaPosixLocaleName);
        if (localeType == null) {
            Logging.log.severe("Can not determine locale type for locale value: " + mvaPosixLocaleName);
            return false;
        }
        LanguageAndCountry langAndCountry = new LanguageAndCountry(mvaPosixLocaleName);
        String language = langAndCountry.getLanguage();
        if (language == null) {
            Logging.log.severe("Cannot determine language for locale value: " + mvaPosixLocaleName);
            return false;
        }
        String sasEncoding = localeType.getSasEncoding();
        BaseConfigFile baseConfigFile = new BaseConfigFile(this.sasHome, mvaPosixLocaleName, sasEncoding, LocaleSetupManager.isDBCSLocale(language));
        baseConfigFile.setDefaultLocale();
        String encoding = null;
        try {
            RegistryData.setRegistry(this.sasHome);
            this.registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            if (this.registryAccess.open()) {
                encoding = this.registryAccess.getSashomeEncodingName();
            }
        }
        catch (FileNotFoundException e) {
            Logging.log.severe("Deployment registry jar not found: " + RegistryData.getDeployRegJar());
            Logging.logStackTrace(e);
        }
        catch (Exception e) {
            Logging.log.severe("Failed to load deployment registry jar: " + RegistryData.getDeployRegJar());
            Logging.logStackTrace(e);
        }
        finally {
            if (this.registryAccess != null) {
                this.registryAccess.close();
            }
        }
        if (encoding.compareToIgnoreCase("UTF-8") != 0) {
            baseConfigFile.setDefaultStartupLanguage();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDeploymentRegistry(String mvaPosixLocaleName) {
        LocaleType localeType = this.getLocaleTypeForLocale(mvaPosixLocaleName);
        if (localeType == null) {
            Logging.log.severe("Can not determine locale type for locale value: " + mvaPosixLocaleName);
            return false;
        }
        String sasEncoding = localeType.getSasEncoding();
        String javaEncoding = localeType.getJavaEncoding();
        try {
            RegistryData.setRegistry(this.sasHome);
            this.registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            if (this.registryAccess.open()) {
                this.registryAccess.setSashomeLocaleName(mvaPosixLocaleName);
                if (this.registryAccess.getSashomeEncodingName().compareToIgnoreCase("UTF-8") != 0) {
                    this.registryAccess.setSashomeEncodingName(sasEncoding);
                    this.registryAccess.setSashomeEncodingJavaName(javaEncoding);
                }
            }
        }
        catch (FileNotFoundException e) {
            Logging.log.severe("Deployment registry jar not found: " + RegistryData.getDeployRegJar());
            Logging.logStackTrace(e);
        }
        catch (Exception e) {
            Logging.log.severe("Failed to load deployment registry jar: " + RegistryData.getDeployRegJar());
            Logging.logStackTrace(e);
        }
        finally {
            if (this.registryAccess != null) {
                this.registryAccess.close();
            }
        }
        return true;
    }

    public static boolean isDBCSLocale(String lang) {
        boolean isdbcs = false;
        for (String dbcslang : dbcsLangs) {
            if (!lang.equalsIgnoreCase(dbcslang)) continue;
            return true;
        }
        return isdbcs;
    }

    class LanguageAndCountry {
        String language = null;
        String country = null;

        public LanguageAndCountry(String mvaPosixLocaleName) {
            String[] languageAndCountry = mvaPosixLocaleName.split("_");
            if (languageAndCountry.length == 2) {
                this.language = languageAndCountry[0];
                this.country = languageAndCountry[1];
            }
        }

        public String getLanguage() {
            return this.language;
        }

        public String getCountry() {
            return this.country;
        }
    }
}

