/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.lsm;

import com.sas.ssn.Logging;
import com.sas.ssn.lsm.impl.JavaIniFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LauncherINIFiles {
    private List<JavaIniFile> javaIniFiles = new ArrayList<JavaIniFile>();

    public LauncherINIFiles(List<JavaIniFile> javaIniFiles) {
        this.javaIniFiles = javaIniFiles;
    }

    public void setLocale(Locale locale) {
        for (JavaIniFile javaIniFile : this.javaIniFiles) {
            try {
                javaIniFile.load();
            }
            catch (FileNotFoundException e) {
                Logging.log.severe("File not found error while loading java product launcher ini file: " + javaIniFile.getConfigurationFile());
                Logging.logStackTrace(e);
            }
            catch (IOException e) {
                Logging.log.severe("File I/O error while loading java product launcher ini file: " + javaIniFile.getConfigurationFile());
                Logging.logStackTrace(e);
            }
            javaIniFile.setLocale(locale);
            try {
                javaIniFile.store(javaIniFile.getConfigurationFile());
            }
            catch (IOException e) {
                Logging.log.severe("File I/O error while updating java product launcher ini file: " + javaIniFile.getConfigurationFile());
                Logging.logStackTrace(e);
            }
        }
    }
}

