/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.lsm;

import com.sas.ssn.ProductData;
import com.sas.ssn.lsm.impl.JavaIniFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaProductsWithLauncherFiles {
    Map<String, JavaProduct> products = new HashMap<String, JavaProduct>();

    public void addProduct(String productCode, String version, String platform, String displayName, List<JavaIniFile> javaIniFiles) {
        this.products.put(this.constructKey(productCode, version, platform), new JavaProduct(productCode, version, platform, displayName, javaIniFiles));
    }

    private String constructKey(String productCode, String version, String platform) {
        return productCode + "_" + version + "_" + platform;
    }

    public Collection<String> getProductKeys() {
        return this.products.keySet();
    }

    public ProductData getProductData(String productKeys) {
        JavaProduct javaProduct = this.products.get(productKeys);
        if (javaProduct != null) {
            return javaProduct.getProductData();
        }
        return null;
    }

    public List<JavaIniFile> getSelectedJavaIniFiles(List<String> keys) {
        ArrayList<JavaIniFile> javaIniFiles = new ArrayList<JavaIniFile>();
        for (String key : keys) {
            if (this.products.get(key).getJavaIniFiles() == null) continue;
            javaIniFiles.addAll(this.products.get(key).getJavaIniFiles());
        }
        return javaIniFiles;
    }

    public void clear() {
        this.products.clear();
    }

    class JavaProduct {
        ProductData productData = null;
        private List<JavaIniFile> javaIniFiles = null;

        public JavaProduct(String productCode, String version, String platform, String displayName, List<JavaIniFile> javaIniFiles) {
            this.productData = new ProductData(productCode, "", platform, "", version, "0", "", "", displayName, 0, 0, 0, false, "", "", "", "", "", false, false, false, false, false, "", "", 0L);
            this.javaIniFiles = javaIniFiles;
        }

        public ProductData getProductData() {
            return this.productData;
        }

        public Collection<JavaIniFile> getJavaIniFiles() {
            return this.javaIniFiles;
        }
    }
}

