/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.lsm;

import com.sas.ssn.Kit;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelLocaleSetupManagerFinish;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class BaseConfigFile {
    private RegistryAccess registryAccess = null;
    private String mvaPosixLocaleName = null;
    private String sasEncoding = null;
    private String sasHome = null;
    private String mvaRootConfigDir = null;
    private String newDefaultLanguage = null;
    private File newDefaultConfigFileLangDir = null;
    private boolean isDBCSLang = false;
    private String dbcsDir = "dbcs";

    public BaseConfigFile(String sasHome, String mvaPosixLocaleName, String sasEncoding, boolean isDBCSLang) {
        this.sasHome = sasHome;
        this.mvaPosixLocaleName = mvaPosixLocaleName;
        this.sasEncoding = sasEncoding;
        this.isDBCSLang = isDBCSLang;
        if (Utils.getOS() == 1) {
            this.dbcsDir = "1d";
        }
    }

    public void setDefaultLocale() {
        File configFile;
        File newDefaultConfigFileLangDir = this.getNewDefaultConfigFileLangDir();
        String configLangDir = "";
        if (newDefaultConfigFileLangDir != null && (configLangDir = this.getNewDefaultConfigFileLangDir().getAbsolutePath()) != null) {
            boolean setEncoding = false;
            if (this.newDefaultLanguage.compareToIgnoreCase("ja") != 0 && this.newDefaultLanguage.compareToIgnoreCase("zh") != 0 && this.newDefaultLanguage.compareToIgnoreCase("zt") != 0 && this.newDefaultLanguage.compareToIgnoreCase("ko") != 0) {
                setEncoding = true;
            }
            configFile = new File(configLangDir, "sasv9.cfg");
            this.editConfigFile(configFile, setEncoding);
        }
        String mvaRootConfigDir = this.getMVARootConfigDir();
        if (this.isDBCSLang) {
            configLangDir = mvaRootConfigDir + File.separator + this.dbcsDir;
            configFile = new File(configLangDir, "sasv9.cfg");
            this.editConfigFile(configFile, false);
        } else {
            configLangDir = mvaRootConfigDir + File.separator + "en";
            configFile = new File(configLangDir, "sasv9.cfg");
            this.editConfigFile(configFile, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void editConfigFile(File configFile, boolean setEncoding) {
        if (configFile.exists()) {
            File bkupConfigFile = this.backupConfigFile(configFile.getAbsolutePath());
            if (bkupConfigFile == null) return;
            BufferedReader inputBR = null;
            PrintWriter outputPR = null;
            try {
                FileReader inputConfigFile = new FileReader(bkupConfigFile);
                inputBR = new BufferedReader(inputConfigFile);
                String line = inputBR.readLine();
                outputPR = new PrintWriter(new FileWriter(configFile));
                boolean localeSettingFound = false;
                boolean encodingSettingFound = false;
                while (line != null) {
                    String upperCaseLine = line.toUpperCase();
                    if (upperCaseLine.contains("-LOCALE")) {
                        line = "-LOCALE " + this.mvaPosixLocaleName;
                        localeSettingFound = true;
                    } else if (upperCaseLine.contains("-ENCODING") && setEncoding) {
                        line = "-ENCODING " + this.sasEncoding;
                        encodingSettingFound = true;
                    }
                    outputPR.println(line);
                    line = inputBR.readLine();
                }
                if (!localeSettingFound) {
                    line = "-LOCALE " + this.mvaPosixLocaleName;
                    outputPR.println(line);
                }
                if (encodingSettingFound || !setEncoding) return;
                line = "-ENCODING " + this.sasEncoding;
                outputPR.println(line);
                return;
            }
            catch (FileNotFoundException e) {
                Logging.log.severe("File not found error occurred while updating: " + configFile.getAbsolutePath());
                Logging.logStackTrace(e);
                return;
            }
            catch (IOException e) {
                Logging.log.severe("File I/O error occurred while updating: " + configFile.getAbsolutePath());
                Logging.logStackTrace(e);
                return;
            }
            finally {
                try {
                    if (inputBR != null) {
                        inputBR.close();
                    }
                }
                catch (IOException e) {
                    Logging.log.warning("File I/O error while closing the file: " + bkupConfigFile.getAbsolutePath());
                    Logging.logStackTrace(e);
                }
                if (outputPR != null) {
                    outputPR.close();
                }
            }
        }
        Logging.log.severe("Config file to modify does not exist: " + configFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultStartupLanguage() {
        String mvaRootConfigDir = this.getMVARootConfigDir();
        File mvaRootDir = new File(mvaRootConfigDir);
        String newDefaultLanguage = this.getNewDefaultLanguage();
        if (Utils.getOS() == 1) {
            File configFile;
            if (mvaRootConfigDir != null && (configFile = new File(mvaRootDir.getParent(), "sasv9.cfg")).exists()) {
                this.backupConfigFile(configFile.getAbsolutePath());
                File newDefaultConfigFileLangDir = this.getNewDefaultConfigFileLangDir();
                if (newDefaultConfigFileLangDir == null) {
                    if (this.isDBCSLang) {
                        newDefaultLanguage = "1d";
                        newDefaultConfigFileLangDir = new File(mvaRootConfigDir, newDefaultLanguage);
                    } else {
                        newDefaultLanguage = "en";
                        newDefaultConfigFileLangDir = new File(mvaRootConfigDir, newDefaultLanguage);
                    }
                }
                try (PrintWriter outputPR = null;){
                    outputPR = new PrintWriter(new FileWriter(configFile));
                    outputPR.println("-config \"" + newDefaultConfigFileLangDir.getAbsolutePath() + File.separator + "sasv9.cfg\"");
                }
            }
        } else {
            String linkDestination = null;
            try {
                if (newDefaultLanguage == null) {
                    newDefaultLanguage = this.isDBCSLang ? "dbcs" : "en";
                }
                linkDestination = "bin" + File.separator + "sas_" + newDefaultLanguage;
                String link = mvaRootDir.getParent() + File.separator + "sas";
                String[] cmd = new String[]{"rm", link};
                Process prm = Runtime.getRuntime().exec(cmd);
                prm.waitFor();
                cmd = new String[]{"ln", "-s", linkDestination, link};
                Process pln = Runtime.getRuntime().exec(cmd);
                pln.waitFor();
            }
            catch (Exception e) {
                Logging.log.severe("Error occurred while creating <sasroot>/sas symbolic link for: " + linkDestination);
                Logging.logStackTrace(e);
            }
        }
        PanelLocaleSetupManagerFinish.setDefaultMVALanguage(newDefaultLanguage);
    }

    public String getNewDefaultLanguage() {
        if (this.newDefaultLanguage == null) {
            String mvaRootConfigDir = this.getMVARootConfigDir();
            if (mvaRootConfigDir != null) {
                List<String> supportedLanguages = Kit.getDeploymentXMLReader().getLocalizationLanguages(this.mvaPosixLocaleName);
                File configLangDir = null;
                for (String lang : supportedLanguages) {
                    configLangDir = new File(mvaRootConfigDir, lang);
                    if (!configLangDir.exists() || !configLangDir.isDirectory()) continue;
                    this.newDefaultLanguage = lang;
                    break;
                }
            }
            if (this.newDefaultLanguage == null) {
                Logging.log.info("A localization is not installed for the selected locale " + this.mvaPosixLocaleName);
            }
        }
        return this.newDefaultLanguage;
    }

    public File getNewDefaultConfigFileLangDir() {
        if (this.newDefaultConfigFileLangDir == null) {
            String mvaRootConfigDir = this.getMVARootConfigDir();
            String newDefaultLanguage = this.getNewDefaultLanguage();
            if (mvaRootConfigDir != null && newDefaultLanguage != null) {
                this.newDefaultConfigFileLangDir = new File(mvaRootConfigDir, newDefaultLanguage);
            }
        }
        return this.newDefaultConfigFileLangDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMVARootConfigDir() {
        if (this.mvaRootConfigDir == null) {
            String host = Utils.getOS_Suffix();
            try {
                RegistryData.setRegistry(this.sasHome);
                this.registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                if (this.registryAccess.open()) {
                    String[] versions = this.registryAccess.getInstallVersions("base", host);
                    for (int i = 0; i < versions.length; ++i) {
                        String installLoc = this.registryAccess.getInstallLoc("base", versions[i], host);
                        if (installLoc == null || installLoc.equals("")) continue;
                        this.mvaRootConfigDir = installLoc + File.separator + "nls";
                    }
                }
            }
            catch (FileNotFoundException e) {
                Logging.log.info("Deployment registry jar not found: " + RegistryData.getDeployRegJar());
                Logging.logStackTrace(e);
            }
            catch (Exception e) {
                Logging.log.info("Failed to load deployment registry jar: " + RegistryData.getDeployRegJar());
                Logging.logStackTrace(e);
            }
            finally {
                if (this.registryAccess != null) {
                    this.registryAccess.close();
                }
            }
        }
        return this.mvaRootConfigDir;
    }

    private File backupConfigFile(String srcCfgFile) {
        File cfgFile = new File(srcCfgFile);
        String cfgPath = cfgFile.getParent();
        String cfgFileNameExt = cfgFile.getName();
        File backupFilePath = new File(cfgPath);
        File backupFile = null;
        if (!cfgFileNameExt.endsWith(".cfg")) {
            Logging.log.warning("Config file name not recognized");
        }
        String cfgFileName = cfgFileNameExt.substring(0, cfgFileNameExt.length() - 4);
        Integer extNum = 0;
        if (!cfgFile.exists()) {
            return null;
        }
        while (extNum < 1000) {
            backupFile = extNum < 10 ? new File(backupFilePath, cfgFileName + ".00" + extNum.toString()) : (extNum < 100 ? new File(backupFilePath, cfgFileName + ".0" + extNum.toString()) : new File(backupFilePath, cfgFileName + "." + extNum.toString()));
            if (backupFile.exists()) {
                Integer n = extNum;
                Integer n2 = extNum = Integer.valueOf(extNum + 1);
                continue;
            }
            extNum = 1001;
            Utils.moveFile(cfgFile, backupFile);
        }
        return backupFile;
    }
}

