/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.install;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.util.GlobalConfiguration;
import com.sas.ssn.Globals;
import com.sas.ssn.install.GroovyInstallTask;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.tools.ant.Project;

public class ConfigAgentCredentials
extends GroovyInstallTask {
    public static final String DEPLOYAGT_CONFIG_SECURITY_REGENERATE = "deployagt.config.security.regenerate";
    public static final String DEPLOYAGENT_INSTALL_DIR = "deployagent.install.dir";
    public static final String DEPLOYCLIENT_INSTALL_DIR = "deployagtclt.install.dir";
    public static final String KEYSTORE_PASSWORD = "solstice.security.keystore.password";
    public static final String KEYSTORE_FILE = "solstice.security.keystore";
    public static final String TRUSTSTORE_PASSWORD = "solstice.security.truststore.password";
    public static final String TRUSTSTORE_FILE = "solstice.security.truststore";
    public static final String SELF_SIGNED = "solstice.security.selfsignedcerts";
    public static final HashMap<String, String> agentFiles = new HashMap();
    public static final HashMap<String, String> agentGlobalKeys = new HashMap();
    public static final HashMap<String, String> clientFiles = new HashMap();
    public static final HashMap<String, String> clientGlobalKeys = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Project project) {
        int ret = 0;
        this.setAntProject(project);
        String metahost = project.getProperty("iomsrv.metadatasrv.host");
        String metaport = project.getProperty("iomsrv.metadatasrv.port");
        String metauser = project.getProperty("oma.person.admin.login.userid");
        String metapassword = project.getProperty("oma.person.admin.login.passwd");
        String myhostname = project.getProperty("os.localhost.fqdn.host.name");
        String agentInstallDir = project.getProperty(DEPLOYAGENT_INSTALL_DIR);
        String clientInstallDir = project.getProperty(DEPLOYCLIENT_INSTALL_DIR);
        if (agentInstallDir == null) {
            this.log(Level.WARNING, "ConfigAgentCredentials", "execute()", "agentInstallDir is null!");
        }
        if (clientInstallDir == null) {
            this.log(Level.WARNING, "ConfigAgentCredentials", "execute()", "clientInstallDir is null!");
        }
        if (agentInstallDir != null || clientInstallDir != null) {
            MdObjectStore store = null;
            try {
                store = this.getMetadataConnection(metahost, metaport, metauser, metapassword);
                if (store != null) {
                    GlobalConfiguration global = GlobalConfiguration.getGlobalConfiguration(store);
                    if (myhostname.equalsIgnoreCase(metahost)) {
                        if (agentInstallDir != null) {
                            ret = this.uploadCerts(global, agentInstallDir, agentFiles, agentGlobalKeys);
                        }
                        if (clientInstallDir != null) {
                            ret = this.uploadCerts(global, clientInstallDir, clientFiles, clientGlobalKeys);
                        }
                    } else {
                        if (agentInstallDir != null) {
                            ret = this.downloadCerts(global, agentInstallDir, agentFiles, agentGlobalKeys);
                        }
                        if (clientInstallDir != null) {
                            ret = this.downloadCerts(global, clientInstallDir, clientFiles, clientGlobalKeys);
                        }
                    }
                    store.updatedMetadataAll();
                }
            }
            catch (IOException ioe) {
                this.logStackTrace(ioe);
                ret = -1;
            }
            catch (MdException me) {
                this.logStackTrace(me);
                ret = -1;
            }
            finally {
                if (store != null) {
                    try {
                        MdFactory factory = store.getFactory();
                        store.dispose();
                        if (factory != null) {
                            factory.dispose();
                        }
                    }
                    catch (IOException ioe) {
                        this.logStackTrace(ioe);
                    }
                }
            }
        }
        ret = this.restartAgent(agentInstallDir);
        return ret;
    }

    private int restartAgent(String agentInstallDir) {
        int ret = 0;
        if (agentInstallDir != null) {
            String extension = ".sh";
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                extension = ".bat";
            } else if (osName.equalsIgnoreCase("z/OS")) {
                extension = "_zos.sh";
            }
            File agentFile = new File(agentInstallDir + "/agent" + extension);
            if (agentFile.exists()) {
                try {
                    String cmd = agentFile.getCanonicalPath();
                    String[] stopArray = new String[]{cmd, "stop"};
                    this.log(Level.FINER, "ConfigAgentCredentials", "execute()", "Running command: " + stopArray[0] + " " + stopArray[1]);
                    Process stopProcess = Runtime.getRuntime().exec(stopArray);
                    int stopResult = stopProcess.waitFor();
                    if (stopResult == -1) {
                        this.log(Level.WARNING, "ConfigAgentCredentials", "execute()", "Agent already stopped or could not be stopped");
                    }
                    int attempts = 0;
                    int startResult = -1;
                    String[] startArray = new String[]{cmd, "start"};
                    while (startResult == -1 && attempts < 3) {
                        Thread.sleep(attempts++ * 2000);
                        this.log(Level.FINER, "ConfigAgentCredentials", "execute()", "Running command: " + startArray[0] + " " + startArray[1]);
                        Process startProcess = Runtime.getRuntime().exec(startArray);
                        startResult = startProcess.waitFor();
                    }
                    ret = startResult;
                    if (ret == -1) {
                        this.log(Level.SEVERE, "ConfigAgentCredentials", "execute()", "Agent could not be started!");
                    }
                }
                catch (IOException ioe) {
                    this.logStackTrace(ioe);
                    ret = -1;
                }
                catch (InterruptedException ie) {
                    this.logStackTrace(ie);
                    ret = -1;
                }
            } else {
                this.log(Level.SEVERE, "ConfigAgentCredentials", "execute()", "The agent script does not exist: " + agentFile);
                ret = -1;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String target) {
        int ret = 0;
        String regenerate = Globals.g_installData.getProperty(DEPLOYAGT_CONFIG_SECURITY_REGENERATE, null);
        String host = Globals.g_installData.getProperty("metadata.connection.host", null);
        String port = Globals.g_installData.getProperty("metadata.connection.port", null);
        String user = Globals.g_installData.getProperty("metadata.connection.userid", null);
        String password = Globals.g_installData.getProperty("metadata.connection.passwd", null);
        String agentInstallDir = Globals.g_installData.getProperty(DEPLOYAGENT_INSTALL_DIR, null);
        String clientInstallDir = Globals.g_installData.getProperty(DEPLOYCLIENT_INSTALL_DIR, null);
        if (agentInstallDir == null) {
            this.log(Level.WARNING, "ConfigAgentCredentials", "execute()", "agentInstallDir is null!");
        }
        if (clientInstallDir == null) {
            this.log(Level.WARNING, "ConfigAgentCredentials", "execute()", "clientInstallDir is null!");
        }
        if (agentInstallDir != null || clientInstallDir != null) {
            MdObjectStore store = null;
            try {
                store = this.getMetadataConnection(host, port, user, password);
                if (store != null) {
                    GlobalConfiguration global = GlobalConfiguration.getGlobalConfiguration(store);
                    this.log(Level.FINER, "ConfigAgentCredentials", "execute()", "deployagt.config.security.regenerate=" + regenerate);
                    if (regenerate != null && regenerate.equalsIgnoreCase("true") || target.equalsIgnoreCase("agentpushcred")) {
                        if (agentInstallDir != null) {
                            ret = this.uploadCerts(global, agentInstallDir, agentFiles, agentGlobalKeys);
                        }
                        if (clientInstallDir != null) {
                            ret = this.uploadCerts(global, clientInstallDir, clientFiles, clientGlobalKeys);
                        }
                    } else {
                        if (agentInstallDir != null) {
                            ret = this.downloadCerts(global, agentInstallDir, agentFiles, agentGlobalKeys);
                        }
                        if (clientInstallDir != null) {
                            ret = this.downloadCerts(global, clientInstallDir, clientFiles, clientGlobalKeys);
                        }
                    }
                    store.updatedMetadataAll();
                }
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "ConfigAgentCredentials", "execute()", "Caught error trying to update GLOBALROOT", e);
                ret = -1;
            }
            finally {
                if (store != null) {
                    try {
                        MdFactory factory = store.getFactory();
                        store.dispose();
                        if (factory != null) {
                            factory.dispose();
                        }
                    }
                    catch (IOException ioe) {
                        this.logStackTrace(ioe);
                    }
                }
            }
        }
        return ret;
    }

    protected MdObjectStore getMetadataConnection(String host, String port, String user, String password) throws MdException, RemoteException {
        MdObjectStore mdObjectStore = null;
        if (host == null) {
            this.log(Level.SEVERE, "ConfigAgentCredentials", "getMetadataConnection()", "host is null!");
        }
        if (port == null) {
            this.log(Level.SEVERE, "ConfigAgentCredentials", "getMetadataConnection()", "port is null!");
        }
        if (user == null) {
            this.log(Level.SEVERE, "ConfigAgentCredentials", "getMetadataConnection()", "user is null!");
        }
        if (password == null) {
            this.log(Level.SEVERE, "ConfigAgentCredentials", "getMetadataConnection()", "password is null!");
        }
        if (host != null && port != null && user != null && password != null) {
            MdFactoryImpl mdFactory = new MdFactoryImpl(false);
            mdFactory.setDebug(false);
            mdFactory.getUtil().setOutputStream(System.out);
            mdFactory.setLoggingEnabled(false);
            mdFactory.getUtil().setLogStream(System.out);
            MdOMRConnection connection = mdFactory.getConnection();
            connection.makeOMRConnection(host, port, user, password);
            mdObjectStore = mdFactory.createObjectStore(null, "SDW: ConfigurationStore");
        }
        return mdObjectStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveProperties(Properties properties, String propsFilePath) throws FileNotFoundException, IOException {
        if (properties == null) {
            this.log(Level.SEVERE, "ConfigAgentCredentials", "saveProperties()", "properties is null!");
        }
        if (propsFilePath == null) {
            this.log(Level.SEVERE, "ConfigAgentCredentials", "saveProperties()", "propsFilePath is null!");
        }
        try (FileOutputStream fos = new FileOutputStream(propsFilePath);){
            properties.store(fos, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(String propsFilePath) throws FileNotFoundException, IOException {
        File file;
        Properties properties = new Properties();
        if (propsFilePath == null) {
            this.log(Level.SEVERE, "ConfigAgentCredentials", "loadProperties()", "propsFilePath is null!");
        }
        if (!(file = new File(propsFilePath)).exists()) {
            this.log(Level.SEVERE, "ConfigAgentCredentials", "loadProperties()", "The properties file does not exist: " + propsFilePath);
        } else {
            try (FileInputStream fis = new FileInputStream(propsFilePath);){
                properties.load(fis);
            }
        }
        return properties;
    }

    protected int uploadCerts(GlobalConfiguration global, String installdir, Map<String, String> filemap, Map<String, String> keymap) {
        int ret = 0;
        if (global == null) {
            this.log(Level.SEVERE, "ConfigAgentCredentials", "uploadCerts()", "global is null!");
            ret = -1;
        }
        if (installdir == null) {
            this.log(Level.WARNING, "ConfigAgentCredentials", "uploadCerts()", "installdir is null!");
        }
        if (global != null && installdir != null) {
            try {
                String propsFilePath = new File(installdir + "/config/" + filemap.get("propsfile")).getCanonicalPath();
                this.log(Level.FINER, "ConfigAgentCredentials", "uploadCerts()", "Reading " + propsFilePath);
                Properties props = this.loadProperties(propsFilePath);
                SoftwareComponent globalRoot = global.getSoftwareComponent();
                if (props != null) {
                    String selfSigned = props.getProperty(SELF_SIGNED);
                    if (selfSigned != null && selfSigned.equalsIgnoreCase("true")) {
                        String keystorepwd = props.getProperty(KEYSTORE_PASSWORD);
                        String keystorePath = props.getProperty(KEYSTORE_FILE);
                        this.log(Level.INFO, "ConfigAgentCredentials", "uploadCerts()", "Attempting to upload " + keystorePath);
                        byte[] keystore = this.readBinaryFile(keystorePath);
                        if (keystore == null) {
                            this.log(Level.WARNING, "ConfigAgentCredentials", "uploadCerts()", "keystore is null!");
                        }
                        if (keystorepwd == null) {
                            this.log(Level.WARNING, "ConfigAgentCredentials", "uploadCerts()", "keystorepwd is null!");
                        }
                        if (keystore != null && keystorepwd != null) {
                            global.setCertificateStore(keymap.get("keystore"), keystore);
                            global.setPassword(keymap.get("keystorepwd"), keystorepwd);
                            this.log(Level.INFO, "ConfigAgentCredentials", "uploadCerts()", "Successfully updated keystore in GLOBALROOT " + globalRoot.getId() + "(" + globalRoot.getName() + ")");
                        }
                        String truststorepwd = props.getProperty(TRUSTSTORE_PASSWORD);
                        String truststorePath = props.getProperty(TRUSTSTORE_FILE);
                        this.log(Level.INFO, "ConfigAgentCredentials", "uploadCerts()", "Attempting to upload " + truststorePath);
                        byte[] truststore = this.readBinaryFile(truststorePath);
                        if (truststore == null) {
                            this.log(Level.WARNING, "ConfigAgentCredentials", "uploadCerts()", "truststore is null!");
                        }
                        if (truststorepwd == null) {
                            this.log(Level.WARNING, "ConfigAgentCredentials", "uploadCerts()", "truststorepwd is null!");
                        }
                        if (truststore != null && truststorepwd != null) {
                            global.setCertificateStore(keymap.get("truststore"), truststore);
                            global.setPassword(keymap.get("truststorepwd"), truststorepwd);
                            this.log(Level.INFO, "ConfigAgentCredentials", "uploadCerts()", "Successfully updated truststore in GLOBALROOT " + globalRoot.getId() + "(" + globalRoot.getName() + ")");
                        }
                    } else {
                        this.log(Level.INFO, "ConfigAgentCredentials", "uploadCerts()", "solstice.security.selfsignedcerts false or not defined in " + propsFilePath);
                    }
                }
            }
            catch (MdException mde) {
                this.logStackTrace(mde);
                ret = -1;
            }
            catch (IOException ioe) {
                this.logStackTrace(ioe);
                ret = -1;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBinaryFile(String filePath) throws FileNotFoundException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(filePath));
        try {
            while (bis.available() > 0) {
                baos.write((byte)bis.read());
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBinaryFile(String filePath, byte[] data) throws FileNotFoundException, IOException {
        try (BufferedOutputStream buffer = new BufferedOutputStream(new FileOutputStream(filePath));){
            buffer.write(data);
        }
        File file = new File(filePath);
        file.setReadable(false, false);
        file.setWritable(false, false);
        file.setExecutable(false, false);
        file.setReadable(true, true);
        file.setWritable(true, true);
        file.setExecutable(true, true);
    }

    protected int downloadCerts(GlobalConfiguration global, String installdir, Map<String, String> filemap, Map<String, String> keymap) {
        int ret = 0;
        if (global == null) {
            this.log(Level.SEVERE, "ConfigAgentCredentials", "downloadCerts()", "global is null!");
            ret = -1;
        }
        if (installdir == null) {
            this.log(Level.WARNING, "ConfigAgentCredentials", "downloadCerts()", "installdir is null!");
        }
        if (global != null && installdir != null) {
            try {
                String propsFilePath = new File(installdir + "/config/" + filemap.get("propsfile")).getCanonicalPath();
                String keystorePath = new File(installdir + "/config/" + filemap.get("keystore")).getCanonicalPath();
                String truststorePath = new File(installdir + "/config/" + filemap.get("truststore")).getCanonicalPath();
                this.log(Level.FINER, "ConfigAgentCredentials", "downloadCerts()", "Reading " + propsFilePath);
                Properties props = this.loadProperties(propsFilePath);
                if (props != null) {
                    String selfSigned = props.getProperty(SELF_SIGNED);
                    if (selfSigned != null && selfSigned.equalsIgnoreCase("true")) {
                        this.log(Level.INFO, "ConfigAgentCredentials", "downloadCerts()", "Attempting download to " + keystorePath);
                        byte[] keystore = global.getCertificateStore(keymap.get("keystore"));
                        String keystorepwd = global.getPassword(keymap.get("keystorepwd"));
                        if (keystore == null) {
                            this.log(Level.WARNING, "ConfigAgentCredentials", "downloadCerts()", "keystore is null!");
                        }
                        if (keystorepwd == null) {
                            this.log(Level.WARNING, "ConfigAgentCredentials", "downloadCerts()", "keystorepwd is null!");
                        }
                        if (keystore != null && keystorepwd != null) {
                            this.writeBinaryFile(keystorePath, keystore);
                            props.setProperty(KEYSTORE_FILE, keystorePath);
                            props.setProperty(KEYSTORE_PASSWORD, keystorepwd);
                        }
                        this.log(Level.INFO, "ConfigAgentCredentials", "downloadCerts()", "Attempting download to " + truststorePath);
                        byte[] truststore = global.getCertificateStore(keymap.get("truststore"));
                        String truststorepwd = global.getPassword(keymap.get("truststorepwd"));
                        if (truststore == null) {
                            this.log(Level.WARNING, "ConfigAgentCredentials", "downloadCerts()", "truststore is null!");
                        }
                        if (truststorepwd == null) {
                            this.log(Level.WARNING, "ConfigAgentCredentials", "downloadCerts()", "truststorepwd is null!");
                        }
                        if (truststore != null && truststorepwd != null) {
                            this.writeBinaryFile(truststorePath, truststore);
                            props.setProperty(TRUSTSTORE_FILE, truststorePath);
                            props.setProperty(TRUSTSTORE_PASSWORD, truststorepwd);
                        }
                        this.saveProperties(props, propsFilePath);
                    } else {
                        this.log(Level.INFO, "ConfigAgentCredentials", "downloadCerts()", "solstice.security.selfsignedcerts false or not defined in " + propsFilePath);
                    }
                }
            }
            catch (MdException mde) {
                this.logStackTrace(mde);
                ret = -1;
            }
            catch (IOException ioe) {
                this.logStackTrace(ioe);
                ret = -1;
            }
        }
        return ret;
    }

    static {
        agentFiles.put("propsfile", "agent.properties");
        agentFiles.put("keystore", "agentKeyStore.jks");
        agentFiles.put("truststore", "agentTrustStore.jks");
        agentGlobalKeys.put("keystore", "Deployment Agent Key Store");
        agentGlobalKeys.put("keystorepwd", "Deployment Agent Key Store Password");
        agentGlobalKeys.put("truststore", "Deployment Agent Trust Store");
        agentGlobalKeys.put("truststorepwd", "Deployment Agent Trust Store Password");
        clientFiles.put("propsfile", "deployagtclt.properties");
        clientFiles.put("keystore", "clientKeyStore.jks");
        clientFiles.put("truststore", "clientTrustStore.jks");
        clientGlobalKeys.put("keystore", "Deployment Agent Client Key Store");
        clientGlobalKeys.put("keystorepwd", "Deployment Agent Client Key Store Password");
        clientGlobalKeys.put("truststore", "Deployment Agent Client Trust Store");
        clientGlobalKeys.put("truststorepwd", "Deployment Agent Client Trust Store Password");
    }
}

