/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class WizardData {
    public static final String SAVEPDFVIEWER = "SavePDFViewer";
    public static final String SAVEBROWSER = "SaveBrowser";
    public static final String WEBBROWSER = "WebBrowser";
    public static final String PDFVIEWER = "PDFViewer";
    public static final String SASHOME = "SASHome";
    public static final String SASROOT = "SASFoundation";
    public static final String ARCHIVESAVEDEFAULT = "ArchiveSaveDefault";
    public static final String LASTPROJECTDIR = "LastProjDir";
    public static final String LASTSIDFILE = "LastSidFile";
    public static final String LASTJMPSIDFILE = "LastJMPSidFile";
    public static final String LASTSPDSSIDFILE = "LastSPDSSidFile";
    public static final String LASTSIMSTUDIOSIDFILE = "LastSIMSTUDIOSidFile";
    public static final String LASTMOMINSTALLSIDFILE = "LastMOMINSTALLSidFile";
    public static final String SELECTEDSAMPLEPLAN = "SampleSelectedPlan";
    public static final String CUSTOMPLAN = "CustomPlan";
    public static final String MACHINENAME = "MachineName";
    public static final String USEPROXYSERVER = "UseProxyServer";
    public static final String PROXYSERVER = "ProxyServer";
    public static final String PROXYPORT = "ProxyPort";
    public static final String LOGINPROXYSERVER = "LoginProxyServer";
    public static final String PROXYUSER = "ProxyUser";
    public static final String ORDERNUMBER = "OrderNumber";
    public static final String INSTALLATIONKEY = "InstallationKey";
    public static final String ACTIVEDOWNLOADFOLDER = "ActiveDownloadFolder";
    public static final String PERSONALTYPE = "PersonalType";
    public static final String SELECTEDORDER = "SelectedOrder";
    public static final String LASTSSDDIR = "LastSSDDir";
    public static final String PLANNEDINSTALL = "PlannedInstall";
    public static final String INSTALL = "Install";
    public static final String CONFIGURE = "Configure";
    public static final String SENDLOG = "SendLog";
    public static final String LOGPROMPTED = "LogPrompted";
    public static final String DEPOTOPTION = "DepotOption";
    public static final String SASVERSION = "SASVersion";
    public static final String HOTFIX_INSTALL = "HotFixInstall";
    public static final String HOTFIX_CONFIGURE = "HotFixConfigure";
    public static final String HOTFIX_PACKAGE_DIR = "HotFixPackageDir";
    public static final String LASTSIDDIR = "LastSidDir";
    public static final String RESUMEDORDER = "ResumedOrder";
    public static final String INCOMPLETECONFIGURATION = "IncompleteConfiguration";
    public static final String CONFIGDIRECTORY = "ConfigDirectory";
    private Vector sharedKeys = new Vector<String>(Arrays.asList("SASHome"));
    private Properties m_wizardUserProps = new Properties();
    private Properties m_wizardSharedProps = new Properties();
    private File m_userPropsFile = new File(Utils.getSDWDataPath(true), "sdwpreferences.txt");
    private File m_sharedPropsFile = null;
    private boolean m_userPropsChanged = false;
    private boolean m_sharedPropsChanged = false;

    public WizardData() {
        String sharedPath = Utils.getSharedDataPath(true);
        if (sharedPath != null) {
            this.m_sharedPropsFile = new File(Utils.getSharedDataPath(true), "sdwpreferences.txt");
        }
    }

    public boolean load() {
        FileInputStream fis;
        boolean valid = false;
        try {
            if (this.m_userPropsFile.isFile()) {
                fis = new FileInputStream(this.m_userPropsFile);
                this.m_wizardUserProps.load(fis);
                fis.close();
                this.m_userPropsChanged = false;
                valid = true;
            } else {
                Logging.log.info("Preference file does not exist: " + this.m_userPropsFile.toString());
            }
        }
        catch (Exception e) {
            Logging.log.warning("Error loading preference file: " + this.m_userPropsFile.toString());
        }
        if (this.m_sharedPropsFile != null) {
            try {
                if (this.m_sharedPropsFile.isFile()) {
                    fis = new FileInputStream(this.m_sharedPropsFile);
                    this.m_wizardSharedProps.load(fis);
                    fis.close();
                    this.m_sharedPropsChanged = false;
                    valid &= true;
                } else {
                    Logging.log.info("Preference file does not exist: " + this.m_sharedPropsFile.toString());
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error loading preference file: " + this.m_sharedPropsFile.toString());
            }
        }
        for (String key : this.sharedKeys) {
            String userValue = this.m_wizardUserProps.getProperty(key);
            String sharedValue = this.m_wizardSharedProps.getProperty(key);
            if (sharedValue != null) {
                this.m_userPropsChanged = true;
                this.m_wizardUserProps.setProperty(key, sharedValue);
            } else if (userValue != null) {
                this.m_sharedPropsChanged = true;
                this.m_wizardSharedProps.setProperty(key, userValue);
            }
            if (!SASHOME.equals(key)) continue;
            for (int i = 1; i > 0; ++i) {
                userValue = this.m_wizardUserProps.getProperty(key + i);
                sharedValue = this.m_wizardSharedProps.getProperty(key + i);
                if (sharedValue != null) {
                    this.m_userPropsChanged = true;
                    this.m_wizardUserProps.setProperty(key + i, sharedValue);
                    continue;
                }
                if (userValue != null) {
                    this.m_sharedPropsChanged = true;
                    this.m_wizardSharedProps.setProperty(key + i, userValue);
                    continue;
                }
                i = -1;
            }
        }
        return valid;
    }

    public boolean save() {
        FileOutputStream fos;
        if (Globals.g_srwOnly) {
            return true;
        }
        boolean valid = true;
        if (this.m_userPropsChanged) {
            Set<String> keysStartWith = this.getSharedAndUserPreferenceKeysStartsWith(SASHOME);
            if (keysStartWith.contains(SASHOME) && !keysStartWith.contains("SASHome1")) {
                this.m_wizardUserProps.setProperty("SASHome1", this.m_wizardUserProps.getProperty(SASHOME));
            }
            try {
                fos = new FileOutputStream(this.m_userPropsFile);
                this.m_wizardUserProps.store(fos, null);
                fos.close();
                this.m_userPropsChanged = false;
            }
            catch (Exception e) {
                Logging.log.warning("Error saving preference file: " + this.m_userPropsFile.toString());
                valid = false;
            }
        }
        if (this.m_sharedPropsFile != null && this.m_sharedPropsChanged) {
            Set<String> keysStartsWith = this.getSharedAndUserPreferenceKeysStartsWith(SASHOME);
            if (keysStartsWith.contains(SASHOME) && !keysStartsWith.contains("SASHome1")) {
                this.m_wizardSharedProps.setProperty("SASHome1", this.m_wizardSharedProps.getProperty(SASHOME));
            }
            try {
                fos = new FileOutputStream(this.m_sharedPropsFile);
                this.m_wizardSharedProps.store(fos, null);
                fos.close();
                this.m_sharedPropsChanged = false;
            }
            catch (Exception e) {
                Logging.log.warning("Error saving preference file: " + this.m_sharedPropsFile.toString());
                valid = false;
            }
        }
        return valid;
    }

    public void removePreference(String key) {
        if (this.m_wizardUserProps.containsKey(key)) {
            this.m_userPropsChanged = true;
            this.m_wizardUserProps.remove(key);
        }
        if (this.m_wizardSharedProps.containsKey(key)) {
            this.m_sharedPropsChanged = true;
            this.m_wizardSharedProps.remove(key);
        }
    }

    public void setPreference(String key, boolean value) {
        if (value) {
            this.setPreference(key, "1");
        } else {
            this.setPreference(key, "0");
        }
    }

    public void setPreference(String key, int value) {
        this.setPreference(key, Integer.toString(value));
    }

    public void setPreference(String key, long value) {
        this.setPreference(key, Long.toString(value));
    }

    public void setPreference(String key, float value) {
        this.setPreference(key, Float.toString(value));
    }

    public void setPreference(String key, double value) {
        this.setPreference(key, Double.toString(value));
    }

    public void setPreference(String key, String value) {
        if (this.sharedKeys.contains(key)) {
            this.setSharedPreference(key, value);
        } else {
            this.m_userPropsChanged = true;
            this.m_wizardUserProps.setProperty(key, value);
        }
    }

    public void setSharedPreference(String key, String value) {
        this.m_userPropsChanged = true;
        this.m_wizardUserProps.setProperty(key, value);
        this.m_sharedPropsChanged = true;
        this.m_wizardSharedProps.setProperty(key, value);
    }

    public boolean getPreference(String key, boolean defaultValue) {
        String defaultVal = null;
        defaultVal = defaultValue ? "1" : "0";
        boolean value = !this.getPreference(key, defaultVal).equals("0");
        return value;
    }

    public int getPreference(String key, int defaultValue) {
        return Integer.parseInt(this.getPreference(key, Integer.toString(defaultValue)));
    }

    public long getPreference(String key, long defaultValue) {
        return Long.parseLong(this.getPreference(key, Long.toString(defaultValue)));
    }

    public float getPreference(String key, float defaultValue) {
        return Float.parseFloat(this.getPreference(key, Float.toString(defaultValue)));
    }

    public double getPreference(String key, double defaultValue) {
        return Double.parseDouble(this.getPreference(key, Double.toString(defaultValue)));
    }

    public String getPreference(String key, String defaultValue) {
        String value = null;
        value = this.sharedKeys.contains(key) ? this.getSharedPreference(key, defaultValue) : this.m_wizardUserProps.getProperty(key, defaultValue);
        return value;
    }

    public String getSharedPreference(String key, String defaultValue) {
        String value = this.m_wizardSharedProps.getProperty(key, null);
        if (value == null) {
            value = this.m_wizardUserProps.getProperty(key, defaultValue);
        }
        return value;
    }

    public Set<String> getPreferencesStartsWith(String prefix) {
        HashSet<String> values = new HashSet<String>();
        Set<String> keys = this.getPreferenceKeysStartsWith(prefix);
        for (String key : keys) {
            String value = this.getPreference(key, null);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public Set<String> getPreferenceKeys() {
        return this.getPreferenceKeysStartsWith(null);
    }

    public Set<String> getPreferenceKeysStartsWith(String prefix) {
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.sharedKeys) {
            if (prefix != null && !key.startsWith(prefix)) continue;
            keys.add(key);
        }
        Enumeration<Object> e = this.m_wizardUserProps.keys();
        while (e.hasMoreElements()) {
            String key;
            key = (String)e.nextElement();
            if (prefix != null && !key.startsWith(prefix)) continue;
            keys.add(key);
        }
        return keys;
    }

    public Set<String> getSharedAndUserPreferenceKeysStartsWith(String prefix) {
        String key;
        HashSet<String> keys = new HashSet<String>();
        Enumeration<Object> e = this.m_wizardSharedProps.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (prefix != null && !key.startsWith(prefix)) continue;
            keys.add(key);
        }
        e = this.m_wizardUserProps.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (prefix != null && !key.startsWith(prefix)) continue;
            keys.add(key);
        }
        return keys;
    }
}

