/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitHelp;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.ResponseData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.apache.commons.lang.StringEscapeUtils;

public class Wizard
implements ActionListener {
    private static final long serialVersionUID = -1552508274681083934L;
    private final int INITIAL_WIDTH = 650;
    private final int INITIAL_HEIGHT = 500;
    private final int MIN_WIDTH = 550;
    private final int MIN_HEIGHT = 400;
    private final int INITIAL_SIZE = 11;
    private final double BASE_RATIO = 0.9;
    private static SSNResource bundle = new SSNResource(Wizard.class);
    private JFrame m_frame = null;
    private KitHelp m_helpDlg = null;
    private WizardPanelIface m_currentPanel = null;
    private JPanel m_contentPane = new JPanel(new GridBagLayout());
    private JPanel m_headerPanel = new JPanel(new GridBagLayout());
    private JPanel m_gutsPanel = new JPanel(new GridBagLayout());
    private JPanel m_fillerPanel = new JPanel();
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JLabel m_header = null;
    private JTextArea m_headerDesc = null;
    private ImageIcon m_bannerRight = null;
    private JLabel m_bannerLabelRight = null;
    private JSeparator m_separator = new JSeparator();
    private JSeparator m_buttonSeparator = new JSeparator();
    private JButton m_cancelButton = null;
    private JButton m_nextButton = null;
    private JButton m_backButton = null;
    private JButton m_helpButton = null;
    private Hashtable m_panelsHash = null;
    private LinkedList m_wizardChain = new LinkedList();
    private PrintWriter m_responseFile = null;
    private PrintWriter m_chainResponseFile = null;
    private PrintWriter m_responseRecord = null;
    private String m_currentPanelID = null;
    private boolean m_wizardActive = true;
    private int m_returnCode = 0;
    private cKeyHandler m_keyHandler;

    public Wizard(Hashtable panels, String startingPanel) {
        try {
            this.m_frame = new JFrame();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_helpDlg = new KitHelp(this.getFrame());
        this.m_panelsHash = panels;
        this.m_currentPanelID = startingPanel;
        this.m_currentPanel = (WizardPanelIface)this.m_panelsHash.get(this.m_currentPanelID);
        if (!this.m_currentPanel.displayPanel()) {
            this.m_currentPanelID = this.getNextPanelID(true);
            if (this.m_currentPanelID != null) {
                this.m_currentPanel = (WizardPanelIface)this.m_panelsHash.get(this.m_currentPanelID);
            }
        }
        if (Globals.g_consoleMode) {
            this.initialize();
        } else if (!Globals.g_quietMode && this.m_currentPanelID != null) {
            this.getFrame().setDefaultCloseOperation(0);
            this.getFrame().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Wizard.this.onCancel();
                }
            });
            this.m_keyHandler = new cKeyHandler();
            Object[][] rows = new String[][]{{bundle.getString("Common.LangCodeEN.txt")}};
            Object[] headers = new String[]{bundle.getString("Common.LangCodeEN.txt")};
            JTable table = new JTable(rows, headers);
            Globals.g_rowheight = Utils.getPreferredRowHeight(table);
            this.initialize();
            this.layoutWidgets();
            this.getFrame().pack();
            this.resizeButtons();
            double ratio = Math.max(this.getDefaultFontSize(), 11) / 11;
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            size.height = Math.min((int)((double)size.height * 0.9), (int)(500.0 * ratio));
            size.width = Math.min((int)((double)size.width * 0.9), (int)(650.0 * ratio));
            this.getFrame().setSize(size);
            this.getFrame().setLocationRelativeTo(null);
            ImageIcon wizardIcon = bundle.getImageIcon("Common.icon.image");
            if (wizardIcon != null) {
                this.getFrame().setIconImage(wizardIcon.getImage());
            }
            this.getFrame().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int width = Wizard.this.getFrame().getWidth();
                    int height = Wizard.this.getFrame().getHeight();
                    if (width < 550) {
                        width = 550;
                    }
                    if (height < 400) {
                        height = 400;
                    }
                    Wizard.this.getFrame().setSize(width, height);
                }
            });
            this.m_currentPanel.preShowUpdates(this);
        }
    }

    public JFrame getFrame() {
        return this.m_frame;
    }

    public void createSDWChainRFile(boolean forceNewChainResponse) {
        if (!(Globals.g_reboot || this.m_currentPanelID.equals("incompletedeployment") && !forceNewChainResponse)) {
            try {
                this.m_chainResponseFile = new PrintWriter(new BufferedWriter(new FileWriter(Globals.g_chainData.getResponseFile())));
                this.m_chainResponseFile.println("# Response file for resuming the SAS Deployment Wizard");
                this.m_chainResponseFile.println("# Created: " + this.getCurrentDateTime());
            }
            catch (Exception e) {
                Logging.log.severe("Error creating chain response file: " + Globals.g_chainData.getResponseFile());
            }
        }
        try {
            this.m_responseRecord = new PrintWriter(new BufferedWriter(new FileWriter(ResponseData.getInstance().getCurResponsefileName())));
            this.m_responseRecord.println("# Response file for resuming the SAS Deployment Wizard");
            this.m_responseRecord.println("# Created: " + this.getCurrentDateTime());
        }
        catch (Exception e) {
            Logging.log.severe("Error creating response record file: " + ResponseData.getInstance().getCurResponsefileName());
        }
        if ((Globals.g_quietMode || Globals.g_partialPrompt) && Globals.g_quietMode && !Globals.g_uninstallAll && !Globals.g_silentHotFix) {
            String inLine;
            BufferedReader inputStream;
            if (this.m_chainResponseFile != null) {
                this.m_chainResponseFile.println();
                this.m_chainResponseFile.println("# The following is a copy of the original response file:");
                this.m_chainResponseFile.println();
                try {
                    inputStream = new BufferedReader(new FileReader(Globals.g_responseFile));
                    while ((inLine = inputStream.readLine()) != null) {
                        if (inLine.contains("{sas002}")) continue;
                        this.m_chainResponseFile.println(inLine);
                    }
                    inputStream.close();
                }
                catch (IOException ioe) {
                    Logging.log.severe("Error copying data to chaining response file: " + ioe.getLocalizedMessage());
                }
            }
            if (this.m_responseRecord != null) {
                this.m_responseRecord.println();
                this.m_responseRecord.println("# The following is a copy of the original response file:");
                this.m_responseRecord.println();
                try {
                    inputStream = new BufferedReader(new FileReader(Globals.g_responseFile));
                    while ((inLine = inputStream.readLine()) != null) {
                        if (inLine.contains("{sas002}")) continue;
                        this.m_responseRecord.println(inLine);
                    }
                    inputStream.close();
                }
                catch (IOException ioe) {
                    Logging.log.severe("Error copying data to response record file: " + ioe.getLocalizedMessage());
                }
            }
        }
    }

    public void show() {
        block15: {
            if (Globals.g_recordMode) {
                try {
                    File responseFile = new File(Globals.g_responseFile);
                    File responseDir = responseFile.getParentFile();
                    if (!responseDir.exists()) {
                        responseDir.mkdirs();
                    }
                    this.m_responseFile = new PrintWriter(Globals.g_responseFile, "UTF-8");
                    this.m_responseFile.println("# " + bundle.getString("Wizard.response1.txt"));
                    this.m_responseFile.println("# " + bundle.getString("Wizard.response2.txt") + " " + this.getCurrentDateTime());
                    this.m_responseFile.println("#");
                    this.m_responseFile.println("# " + bundle.getString("Wizard.response3.txt"));
                    if (Globals.g_quietMode) {
                        WizardPanelIface panel = null;
                        String[] responseData = null;
                        Enumeration e = this.m_panelsHash.elements();
                        while (e.hasMoreElements()) {
                            panel = (WizardPanelIface)e.nextElement();
                            panel.initializePanel();
                            responseData = panel.responseData();
                            if (responseData == null) continue;
                            this.m_responseFile.println();
                            this.m_responseFile.println("# " + panel.getHeader());
                            this.m_responseFile.println("# " + panel.getHeaderDesc());
                            for (int i = 0; i < responseData.length; ++i) {
                                this.m_responseFile.println(responseData[i]);
                            }
                        }
                        this.exitWizard(0);
                    }
                }
                catch (Exception e) {
                    Logging.log.severe("Error creating response file: " + Globals.g_responseFile);
                    if (!Globals.g_quietMode) break block15;
                    this.exitWizard(-1);
                }
            }
        }
        this.createSDWChainRFile(false);
        if (Globals.g_quietMode || Globals.g_partialPrompt) {
            this.silentDialogs();
            if (Globals.g_partialPrompt && Globals.g_consoleMode) {
                this.consoleDialogs();
            }
        } else if (Globals.g_consoleMode) {
            this.consoleDialogs();
        }
        if (this.m_currentPanelID != null && !Globals.g_quietMode && !Globals.g_consoleMode) {
            if (Globals.g_partialPrompt) {
                this.loadPanel(false);
            }
            this.getFrame().show();
            if (this.m_currentPanel.initialFocus() != null) {
                this.m_currentPanel.initialFocus().requestFocus();
            }
        } else {
            this.exitWizard(0);
        }
    }

    public String getCurrentDateTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy h:mm:ss a", Locale.getDefault());
        return dateFormat.format(calendar.getTime());
    }

    private void silentDialogs() {
        boolean morePanels = true;
        while (morePanels) {
            this.m_currentPanel.initializePanel();
            if (this.m_currentPanel.silentEvent()) {
                this.m_currentPanelID = this.getNextPanelID(true);
                if (this.m_currentPanelID != null) {
                    this.m_currentPanel = (WizardPanelIface)this.m_panelsHash.get(this.m_currentPanelID);
                    continue;
                }
                morePanels = false;
                continue;
            }
            morePanels = false;
            if (this.m_currentPanelID.equals("finish") && Globals.g_skipStatusPanels && Globals.g_partialPrompt || Globals.g_partialPrompt) continue;
            if (Globals.g_mode == 1) {
                Logging.log.severe("Download is incomplete due to failures noted above.");
            } else {
                Logging.log.severe("Deployment is incomplete due to failures noted above.");
            }
            this.exitWizard(-1);
        }
        if (!Globals.g_partialPrompt) {
            if (Globals.g_mode == 1) {
                Logging.log.info("Download completed successfully.");
            } else {
                Logging.log.info("Deployment completed successfully.");
            }
        }
    }

    private void consoleDialogs() {
        boolean morePanels = true;
        while (morePanels) {
            int returnCode = this.driveConsoleDialog();
            if (returnCode > -1) {
                this.m_wizardChain.add(this.m_currentPanelID);
                this.m_currentPanelID = this.getNextPanelID(true);
                if (this.m_currentPanelID != null) {
                    this.m_currentPanel = (WizardPanelIface)this.m_panelsHash.get(this.m_currentPanelID);
                    if (!Globals.g_partialPrompt) continue;
                    this.silentDialogs();
                    if (this.m_currentPanelID != null) continue;
                    morePanels = false;
                    continue;
                }
                morePanels = false;
                continue;
            }
            if (returnCode == -3) {
                this.m_currentPanelID = (String)this.m_wizardChain.removeLast();
                this.m_currentPanel.backEvent(this.m_currentPanelID);
                this.m_currentPanel = (WizardPanelIface)this.m_panelsHash.get(this.m_currentPanelID);
                continue;
            }
            if (returnCode != -2) continue;
            morePanels = false;
            ConsoleMode.println(bundle.getString("Wizard.DeploymentAborted.txt"));
        }
        try {
            if (Globals.g_consoleStdIn != null) {
                Globals.g_consoleStdIn.close();
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
    }

    private int driveConsoleDialog() {
        int returnCode = -1;
        while (returnCode == -1 || returnCode == -4) {
            ConsoleMode.println();
            ConsoleMode.printDivider();
            ConsoleMode.println();
            if (this.m_currentPanel.getHeader().length() > 0) {
                ConsoleMode.println(this.m_currentPanel.getHeader());
            }
            if (this.m_currentPanel.getHeaderDesc().length() > 0) {
                ConsoleMode.printlongln(null, this.m_currentPanel.getHeaderDesc());
            }
            this.m_currentPanel.preShowUpdates(this);
            returnCode = this.m_currentPanel.consoleEvent();
            if (returnCode > -1 && !this.m_currentPanel.validateData()) {
                returnCode = -1;
            }
            if (returnCode != -4) continue;
            this.displayConsoleHelp();
        }
        return returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayConsoleHelp() {
        String helpID = this.m_currentPanel.getHelpTopic();
        if (helpID != null) {
            ConsoleMode.println();
            BufferedReader in = null;
            File helpFile = new File(helpID);
            if (helpFile.isFile()) {
                try {
                    FileInputStream stream = new FileInputStream(helpFile);
                    in = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
                }
                catch (Exception e) {
                    in = null;
                }
            } else {
                int i = 0;
                String lang = Language.gs_SelectedLanguage;
                String page = "/doc/" + lang + "/deploywiz/html/" + helpID + ".html";
                URL url = null;
                block20: while (page != null) {
                    try {
                        url = this.getClass().getResource(page);
                        InputStream stream = url.openStream();
                        in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                        page = null;
                    }
                    catch (IOException e) {
                        switch (++i) {
                            case 1: {
                                page = "/doc/en/deploywiz/html/" + helpID + ".html";
                                continue block20;
                            }
                            case 2: {
                                page = "/doc/" + lang + "/deploywiz/html/Overview.html";
                                continue block20;
                            }
                            case 3: {
                                page = "/doc/en/deploywiz/html/Overview.html";
                                continue block20;
                            }
                        }
                        page = null;
                        Logging.log.info("Help Not Found: " + helpID);
                    }
                }
            }
            if (in != null) {
                try {
                    String line = in.readLine();
                    String prevLine = "";
                    while (line != null) {
                        if ((line = Utils.removeHTMLTags(line.trim())).length() > 0 && !(line = StringEscapeUtils.unescapeHtml(line)).equalsIgnoreCase(prevLine)) {
                            ConsoleMode.println(line);
                            prevLine = line;
                        }
                        line = in.readLine();
                    }
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                }
            }
            ConsoleMode.promptPause(true);
        }
    }

    private void initialize() {
        this.m_header = new JLabel();
        this.m_header.setOpaque(true);
        this.m_header.setBackground(Color.WHITE);
        Font headerFont = this.m_header.getFont();
        this.m_header.setFont(headerFont.deriveFont(1));
        this.m_headerDesc = new JTextArea();
        this.m_headerDesc.setEditable(false);
        this.m_headerDesc.setFocusable(false);
        this.m_headerDesc.setLineWrap(true);
        this.m_headerDesc.setWrapStyleWord(true);
        this.m_headerDesc.setOpaque(true);
        this.m_headerDesc.setBackground(Color.WHITE);
        this.m_bannerRight = bundle.getImageIcon("Wizard.banner_right.image");
        this.m_bannerLabelRight = new JLabel(this.m_bannerRight, 0);
        this.m_bannerLabelRight.setOpaque(true);
        this.m_bannerLabelRight.setBackground(Color.WHITE);
        String mtxt = bundle.getString("Wizard.Help.txt");
        this.m_helpButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_helpButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_helpButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = bundle.getString("Wizard.Next.txt");
        this.m_nextButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_nextButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_nextButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = bundle.getString("Wizard.Back.txt");
        this.m_backButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_backButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_backButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_cancelButton = new JButton(bundle.getString("Common.Cancel.txt"));
        this.m_cancelButton.addActionListener(this);
        this.m_nextButton.addActionListener(this);
        this.m_backButton.addActionListener(this);
        this.m_helpButton.addActionListener(this);
        if (this.getFrame() != null) {
            this.getFrame().setTitle(this.getTitleText());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_cancelButton) {
            this.onCancel();
        } else if (src == this.m_nextButton) {
            this.onNext();
        } else if (src == this.m_backButton) {
            this.onBack();
        } else if (src == this.m_helpButton) {
            this.onHelp();
        }
    }

    public void setReturnCode(int returnCode) {
        this.m_returnCode = returnCode;
    }

    public void exitWizard(int exitCode) {
        if (!Globals.g_quietMode) {
            this.saveWizardResponses();
        }
        if (this.m_responseFile != null) {
            this.m_responseFile.close();
        }
        if (this.m_chainResponseFile != null) {
            this.m_chainResponseFile.close();
        }
        if (this.m_responseRecord != null) {
            this.m_responseRecord.close();
        }
        if (Globals.g_configData != null) {
            Globals.g_configData.delete();
        }
        if (Globals.g_installData != null && Globals.g_installData.isTemporary()) {
            Globals.g_installData.delete();
        }
        if (this.getFrame() != null) {
            this.getFrame().dispose();
        }
        Globals.g_kit.exitKit(exitCode);
    }

    private void onCancel() {
        boolean valid = false;
        String closeMsg = this.m_currentPanel.getCancelMsg();
        if (closeMsg == null) {
            closeMsg = this.m_wizardActive ? (Globals.g_mode == 1 ? bundle.messageString("Wizard.CloseESDMsg.txt", bundle.getString("Common.ESDTitle.txt")) : (Globals.g_mode == 2 ? bundle.messageString("Wizard.CloseCMTMsg.txt", bundle.getString("Common.CMTTitle.txt")) : bundle.messageString("Wizard.CloseMsg.txt", bundle.getString("Common.Title.txt")))) : (Globals.g_mode == 1 ? bundle.messageString("Wizard.CloseEndESDMsg.txt", bundle.getString("Common.ESDTitle.txt")) : (Globals.g_mode == 2 ? bundle.messageString("Wizard.CloseEndCMTMsg.txt", bundle.getString("Common.CMTTitle.txt")) : bundle.messageString("Wizard.CloseEndMsg.txt", bundle.getString("Common.Title.txt"))));
        }
        if (CustMsgBox.showConfirmDialog((Component)this.getFrame(), closeMsg, this.getWizardTitle(), 0, 3, 1) == 0) {
            valid = true;
        }
        if (valid) {
            this.m_helpDlg.getFrame().dispose();
            if (this.m_currentPanelID.equals("incompletedeployment")) {
                Globals.g_deleteChainData = false;
            }
            if (Globals.g_mode == 2) {
                if (this.m_wizardActive) {
                    if (this.m_currentPanelID.equals("execute")) {
                        this.exitWizard(-2);
                    } else {
                        this.exitWizard(-9998);
                    }
                } else {
                    this.exitWizard(0);
                }
            } else {
                this.exitWizard(-9999);
            }
        }
    }

    private void onNext() {
        if (this.getFrame() != null) {
            this.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        }
        if (this.m_currentPanel.validateData()) {
            String nextPanel = this.getNextPanelID(true);
            if (nextPanel != null) {
                WizardPanelIface panel = (WizardPanelIface)this.m_panelsHash.get(nextPanel);
                if (panel != null) {
                    this.m_wizardChain.add(this.m_currentPanelID);
                    this.m_currentPanelID = nextPanel;
                    this.m_currentPanel = panel;
                    if (Globals.g_partialPrompt) {
                        this.silentDialogs();
                    }
                    if (this.m_currentPanelID != null) {
                        this.loadPanel(false);
                    } else {
                        this.exitWizard(this.m_returnCode);
                    }
                } else {
                    Logging.log.severe("An invalid dialog ID was referenced: " + nextPanel);
                    this.exitWizard(this.m_returnCode);
                }
            } else {
                this.exitWizard(this.m_returnCode);
            }
        }
        if (this.getFrame() != null) {
            this.getFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    public int getReturnCode() {
        return this.m_returnCode;
    }

    private void onBack() {
        if (this.getFrame() != null) {
            this.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        }
        this.m_currentPanelID = (String)this.m_wizardChain.removeLast();
        this.m_currentPanel.backEvent(this.m_currentPanelID);
        this.m_currentPanel = (WizardPanelIface)this.m_panelsHash.get(this.m_currentPanelID);
        this.loadPanel(false);
        if (this.getFrame() != null) {
            this.getFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void loadPanel(boolean initializing) {
        this.m_header.setText(this.m_currentPanel.getHeader());
        this.m_headerDesc.setText(this.m_currentPanel.getHeaderDesc());
        if (this.getFrame() != null && this.getFrame().isVisible()) {
            this.removeKeyListeners(this.m_gutsPanel, this.m_keyHandler);
        }
        this.m_gutsPanel.removeAll();
        this.layoutGuts();
        this.adjustConstraints();
        this.enableButtons();
        if (!initializing) {
            this.m_currentPanel.preShowUpdates(this);
        }
        if (this.getFrame() != null && this.getFrame().isVisible()) {
            this.addKeyListeners(this.m_gutsPanel, this.m_keyHandler);
        }
        if (this.getFrame() != null) {
            this.getFrame().validate();
            this.getFrame().repaint();
        }
        if (this.m_currentPanel.initialFocus() == null) {
            this.m_currentPanel.getPanel().requestFocus();
            this.m_currentPanel.getPanel().transferFocus();
        } else {
            this.m_currentPanel.initialFocus().requestFocus();
        }
        this.m_helpDlg.setHelp(this.m_currentPanel.getHelpTopic());
    }

    private void adjustConstraints() {
        this.m_contentPane.remove(this.m_gutsPanel);
        this.m_contentPane.remove(this.m_fillerPanel);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.gridy = 2;
        if (this.m_currentPanel.staticHeight()) {
            c.weighty = 0.0;
            c.fill = 2;
        } else {
            c.weighty = 1.0;
            c.fill = 1;
        }
        c.anchor = 11;
        c.insets = new Insets(10, 10, 10, 10);
        this.m_contentPane.add((Component)this.m_gutsPanel, c);
        c.gridy = 3;
        if (this.m_currentPanel.staticHeight()) {
            c.weighty = 1.0;
            c.fill = 1;
        } else {
            c.weighty = 0.0;
            c.fill = 2;
        }
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_contentPane.add((Component)this.m_fillerPanel, c);
    }

    private void onHelp() {
        this.m_helpDlg.show();
    }

    public boolean firstDialog() {
        return this.m_wizardChain.size() == 0;
    }

    public void enableButtons() {
        this.m_helpButton.setEnabled(this.m_currentPanel.getHelpTopic() != null);
        this.m_backButton.setEnabled(this.isBackButtonEnabled());
        if (this.getNextPanelID(false) == null) {
            String mtxt = bundle.getString("Wizard.Finish.txt");
            this.m_nextButton.setText(Util.getLabelWithoutMnemonic(mtxt));
            this.m_nextButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_nextButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            this.m_cancelButton.setEnabled(this.m_wizardActive);
        } else {
            String mtxt = bundle.getString("Wizard.Next.txt");
            this.m_nextButton.setText(Util.getLabelWithoutMnemonic(mtxt));
            this.m_nextButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_nextButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            this.m_cancelButton.setEnabled(true);
        }
        if (this.getFrame() != null) {
            this.getFrame().getRootPane().setDefaultButton(this.m_nextButton);
        }
    }

    private boolean isBackButtonEnabled() {
        boolean isEnabled = false;
        if (this.m_wizardChain.size() > 0 && !this.m_currentPanelID.equals("start") && !this.m_currentPanelID.equals("sdmstart")) {
            isEnabled = true;
        }
        return isEnabled;
    }

    public int getDefaultFontSize() {
        return this.m_helpButton.getFont().getSize();
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        this.layoutHeader();
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_contentPane.add((Component)this.m_headerPanel, c);
        c.gridy = 1;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 11;
        c.insets = new Insets(0, 1, 0, 1);
        this.m_contentPane.add((Component)this.m_separator, c);
        this.loadPanel(true);
        c.gridy = 4;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        c.insets = new Insets(0, 1, 0, 1);
        this.m_contentPane.add((Component)this.m_buttonSeparator, c);
        this.layoutButtons();
        c.gridy = 5;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_contentPane.add((Component)this.m_buttonPanel, c);
        this.m_contentPane.setOpaque(true);
        this.getFrame().setContentPane(this.m_contentPane);
        this.addKeyListeners(this.getFrame(), this.m_keyHandler);
    }

    private void layoutHeader() {
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 15, 0, 0);
        this.m_headerPanel.add((Component)this.m_header, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(3, 30, 5, 0);
        this.m_headerPanel.add((Component)this.m_headerDesc, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_headerPanel.add((Component)this.m_bannerLabelRight, c);
        this.m_headerPanel.setOpaque(true);
        this.m_headerPanel.setBackground(Color.WHITE);
    }

    private void layoutGuts() {
        if (this.m_currentPanel != null) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.anchor = 18;
            c.insets = new Insets(0, 0, 0, 0);
            this.m_gutsPanel.add((Component)this.m_currentPanel.getPanel(), c);
        }
    }

    private void layoutButtons() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        c.insets = new Insets(15, 15, 15, 0);
        this.m_buttonPanel.add((Component)this.m_helpButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(15, 0, 15, 0);
        this.m_buttonPanel.add((Component)this.m_backButton, c);
        c.gridx = 2;
        c.weightx = 0.0;
        c.anchor = 13;
        c.insets = new Insets(15, 0, 15, 10);
        this.m_buttonPanel.add((Component)this.m_nextButton, c);
        c.gridx = 3;
        c.weightx = 0.0;
        c.anchor = 13;
        c.insets = new Insets(15, 0, 15, 15);
        this.m_buttonPanel.add((Component)this.m_cancelButton, c);
    }

    public void resizeButtons() {
        Dimension buttonSize = this.m_cancelButton.getSize();
        double maxWidth = buttonSize.getWidth();
        double maxHeight = buttonSize.getHeight();
        if ((buttonSize = this.m_nextButton.getSize(buttonSize)).getWidth() > maxWidth) {
            maxWidth = buttonSize.getWidth();
        }
        if (buttonSize.getHeight() > maxHeight) {
            maxHeight = buttonSize.getHeight();
        }
        if ((buttonSize = this.m_backButton.getSize(buttonSize)).getWidth() > maxWidth) {
            maxWidth = buttonSize.getWidth();
        }
        if (buttonSize.getHeight() > maxHeight) {
            maxHeight = buttonSize.getHeight();
        }
        if ((buttonSize = this.m_helpButton.getSize(buttonSize)).getWidth() > maxWidth) {
            maxWidth = buttonSize.getWidth();
        }
        if (buttonSize.getHeight() > maxHeight) {
            maxHeight = buttonSize.getHeight();
        }
        if (maxWidth < 75.0) {
            maxWidth = 75.0;
        }
        if (maxHeight < 23.0) {
            maxHeight = 23.0;
        }
        buttonSize.setSize(maxWidth, maxHeight);
        this.m_cancelButton.setPreferredSize(buttonSize);
        this.m_nextButton.setPreferredSize(buttonSize);
        this.m_backButton.setPreferredSize(buttonSize);
        this.m_helpButton.setPreferredSize(buttonSize);
    }

    public JButton getCancelButton() {
        return this.m_cancelButton;
    }

    public JButton getNextButton() {
        return this.m_nextButton;
    }

    public JButton getBackButton() {
        return this.m_backButton;
    }

    public JButton getHelpButton() {
        return this.m_helpButton;
    }

    public JLabel getHeader() {
        return this.m_header;
    }

    public JTextArea getHeaderDesc() {
        return this.m_headerDesc;
    }

    public String getWizardTitle() {
        if (this.getFrame() == null) {
            return this.getTitleText();
        }
        return this.getFrame().getTitle();
    }

    private String getTitleText() {
        String title = null;
        title = Globals.g_mode == 5 ? bundle.getString("Common.SDATitle.txt") : (Globals.g_mode == 1 ? bundle.getString("Common.ESDTitle.txt") : (Globals.g_mode == 6 ? bundle.getString("Common.DCUTitle.txt") : (Globals.g_mode == 2 ? (Globals.g_cmtConfigDirSet ? bundle.getString("Common.CMTTitle.txt") + " - " + Globals.g_cmtConfigDir : bundle.getString("Common.CMTTitle.txt")) : bundle.getString("Common.Title.txt"))));
        return title;
    }

    public void setWizardActive(boolean active) {
        this.m_wizardActive = active;
    }

    public boolean getWizardActive() {
        return this.m_wizardActive;
    }

    public void addPanel(String panelID, Object panel) {
        this.m_panelsHash.remove(panelID);
        this.m_panelsHash.put(panelID, panel);
    }

    public void removePanel(String panelID) {
        this.m_panelsHash.remove(panelID);
    }

    public void clearWizardChain(boolean saveResponses) {
        if (saveResponses) {
            this.saveWizardResponses();
        }
        this.m_wizardChain.clear();
    }

    public Object getPanel(String panelID) {
        return this.m_panelsHash.get(panelID);
    }

    public void saveWizardResponses() {
        if (Globals.g_recordMode && this.m_responseFile != null || !Globals.g_resumeChain) {
            String panelID = null;
            WizardPanelIface panel = null;
            String[] responseData = null;
            while (this.m_wizardChain.size() > 0) {
                int i;
                panelID = (String)this.m_wizardChain.removeFirst();
                panel = (WizardPanelIface)this.m_panelsHash.get(panelID);
                responseData = panel.responseData();
                if (responseData == null) continue;
                if (this.m_responseFile != null) {
                    this.m_responseFile.println();
                    this.m_responseFile.println("# " + panel.getHeader());
                    this.m_responseFile.println("# " + panel.getHeaderDesc());
                    for (i = 0; i < responseData.length; ++i) {
                        this.m_responseFile.println(responseData[i]);
                    }
                }
                if (this.m_chainResponseFile != null) {
                    this.m_chainResponseFile.println();
                    this.m_chainResponseFile.println("# " + panel.getHeader());
                    this.m_chainResponseFile.println("# " + panel.getHeaderDesc());
                    for (i = 0; i < responseData.length; ++i) {
                        if (responseData[i].contains("{sas002}")) continue;
                        this.m_chainResponseFile.println(responseData[i]);
                    }
                }
                if (this.m_responseRecord == null) continue;
                this.m_responseRecord.println();
                this.m_responseRecord.println("# " + panel.getHeader());
                this.m_responseRecord.println("# " + panel.getHeaderDesc());
                for (i = 0; i < responseData.length; ++i) {
                    if (responseData[i].contains("{sas002}")) continue;
                    this.m_responseRecord.println(responseData[i]);
                }
            }
            if (this.m_responseFile != null) {
                this.m_responseFile.flush();
            }
            if (this.m_chainResponseFile != null) {
                this.m_chainResponseFile.flush();
            }
            if (this.m_responseRecord != null) {
                this.m_responseRecord.flush();
            }
        }
    }

    public void deleteChainRFile() {
        if (this.m_chainResponseFile != null) {
            this.m_chainResponseFile.close();
        }
        if (!Globals.g_chainData.deleteChainRFile()) {
            Logging.log.warning("Unable to delete " + Globals.g_chainData.getResponseFile() + " file during UIP.");
        }
    }

    public static String getResponse(String key, String defaultValue) {
        String response = defaultValue;
        if (Globals.g_resumeChain && Globals.g_chainData != null) {
            response = Globals.g_chainData.getResponse(key, defaultValue);
        } else if (ResponseData.getInstance() != null) {
            response = ResponseData.getInstance().getProperty(key, defaultValue);
        }
        return response;
    }

    public static void logResponseMissing(String panel, String field) {
        Logging.log.severe("Response data missing for:\n   Panel: " + panel + "\n   Field: " + field);
    }

    public static void logResponseInvalid(String panel, String field, String value, String notes) {
        String logEntry = "Response data invalid for:\n   Panel: " + panel + "\n   Field: " + field + "\n   Value: " + value;
        if (notes != null) {
            logEntry = logEntry + "\n   Notes: " + notes;
        }
        Logging.log.severe(logEntry);
    }

    private String getNextPanelID(boolean loadPanels) {
        String nextPanelID = this.m_currentPanel.getNextPanelID();
        if (nextPanelID != null) {
            WizardPanelIface panel = (WizardPanelIface)this.m_panelsHash.get(nextPanelID);
            boolean found = panel.displayPanel();
            while (!found) {
                if (loadPanels) {
                    if (Globals.g_wizard == null && "jre".equals(nextPanelID)) {
                        Globals.g_wizard = this;
                    }
                    panel.initializePanel();
                }
                nextPanelID = panel.getNextPanelID();
                panel = (WizardPanelIface)this.m_panelsHash.get(nextPanelID);
                found = panel.displayPanel();
            }
            if (!found) {
                nextPanelID = null;
            }
        }
        return nextPanelID;
    }

    private void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] componentArray = container.getComponents();
        int nComps = componentArray.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            componentArray[iComp].addKeyListener(keyHandler);
            if (!(componentArray[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)componentArray[iComp], keyHandler);
        }
    }

    private void removeKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] componentArray = container.getComponents();
        int nComps = componentArray.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            componentArray[iComp].removeKeyListener(keyHandler);
            if (!(componentArray[iComp] instanceof Container)) continue;
            this.removeKeyListeners((Container)componentArray[iComp], keyHandler);
        }
    }

    private class cKeyHandler
    extends KeyAdapter {
        private cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int eKeyCode = e.getKeyCode();
            switch (eKeyCode) {
                case 27: {
                    Wizard.this.onCancel();
                    break;
                }
                case 112: 
                case 156: {
                    Wizard.this.onHelp();
                }
            }
        }
    }
}

