/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.DeploymentData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.UnicodeInputStream;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VolserData
implements Cloneable {
    private File file;
    private Document doc;
    private Element root;
    private DeploymentData deploymentData;
    private String volser;
    private String type;
    private String volnum;
    private Vector spsSkus = new Vector();
    private Vector orders = new Vector();
    private Hashtable products = new Hashtable();
    private Hashtable name = new Hashtable();
    private Hashtable misc = new Hashtable();
    private Hashtable payloadHistory = new Hashtable();
    private File origfile;

    public VolserData(String file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(file, null);
    }

    public VolserData(File file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(file, null);
    }

    public VolserData(String file, DeploymentData deploymentData) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(new File(file), deploymentData);
    }

    public VolserData(File file, DeploymentData deploymentData) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        int i;
        this.file = file;
        this.deploymentData = deploymentData;
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file));
        this.root = this.doc.getDocumentElement();
        this.volser = this.root.getAttribute("volser");
        this.type = this.root.getAttribute("type").toLowerCase(Locale.ENGLISH);
        this.volnum = this.root.getAttribute("volnum").toLowerCase(Locale.ENGLISH);
        NodeList data = this.root.getChildNodes();
        if (data != null) {
            for (i = 0; i < data.getLength(); ++i) {
                if (data.item(i).getNodeType() != 1) continue;
                Element element = (Element)data.item(i);
                if ("name".equals(element.getTagName())) {
                    this.name.put(element.getAttribute("loc").toLowerCase(Locale.ENGLISH), element.getAttribute("v"));
                    continue;
                }
                if ("product".equals(element.getTagName())) {
                    this.addProduct(element);
                    continue;
                }
                this.misc.put(element.getTagName(), element.getAttribute("v"));
            }
        }
        String[] errors = this.getErrors();
        for (i = 0; i < errors.length; ++i) {
            Logging.log.info(errors[i] + ": " + file.getCanonicalPath());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VolserData clone = (VolserData)super.clone();
        clone.file = new File(this.file.toString());
        clone.doc = (Document)this.doc.cloneNode(true);
        clone.root = clone.doc.getDocumentElement();
        clone.deploymentData = this.deploymentData;
        clone.spsSkus = (Vector)this.spsSkus.clone();
        clone.orders = (Vector)this.orders.clone();
        NodeList data = clone.root.getChildNodes();
        if (data != null) {
            for (int i = 0; i < data.getLength(); ++i) {
                Element element;
                if (data.item(i).getNodeType() != 1 || !"product".equals((element = (Element)data.item(i)).getTagName())) continue;
                clone.products.put(element.getAttribute("alt_sku"), element);
            }
        }
        clone.name = (Hashtable)this.name.clone();
        clone.misc = (Hashtable)this.misc.clone();
        return clone;
    }

    public VolserData clone(String newVolser) {
        VolserData clone = null;
        try {
            clone = (VolserData)this.clone();
            clone.volser = newVolser;
            clone.root.setAttribute("volser", clone.volser);
            clone.file = new File(clone.deploymentData.getMediaDir() + File.separator + clone.volser + ".xml");
            clone.write();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clone;
    }

    public VolserData clone(String newVolser, String destDir) {
        VolserData clone = null;
        try {
            clone = (VolserData)this.clone();
            clone.volser = newVolser;
            clone.root.setAttribute("volser", clone.volser);
            clone.origfile = new File(clone.deploymentData.getMediaDir() + File.separator + clone.volser + ".xml");
            clone.file = new File(clone.deploymentData.getMediaDir(destDir) + File.separator + clone.volser + ".xml");
            clone.write();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clone;
    }

    private String[] getErrors() {
        Vector<String> errors = new Vector<String>();
        if (this.volser.length() == 0) {
            errors.add("No VOLSER Value in VOLSER Data");
        }
        if (this.name.isEmpty()) {
            errors.add("No Media Names in VOLSER Data");
        }
        return errors.toArray(new String[0]);
    }

    public void setOrder(String order) {
        this.orders.add(order);
    }

    public boolean setDataPath(String spsSku, String datPath) {
        Element product;
        boolean retVal = false;
        if (spsSku != null && datPath != null && (product = (Element)this.products.get(spsSku)) != null) {
            if (datPath.equals("product_data/" + spsSku)) {
                product.removeAttribute("skudat_path");
            } else {
                product.setAttribute("skudat_path", datPath);
            }
            retVal = true;
        }
        return retVal;
    }

    public boolean setProductPath(String spsSku, String pkgPath) {
        Element product;
        boolean retVal = false;
        if (spsSku != null && pkgPath != null && (product = (Element)this.products.get(spsSku)) != null) {
            product.setAttribute("skupkg_path", pkgPath);
            retVal = true;
        }
        return retVal;
    }

    public String[] getOrders() {
        return this.orders.toArray(new String[0]);
    }

    public boolean inOrder(String order) {
        return this.orders.contains(order);
    }

    public String getType() {
        return this.type;
    }

    public String getVolser() {
        return this.volser;
    }

    public String getVolnum() {
        return this.volnum;
    }

    public long getVolnumAsLong() {
        long volnum = 0L;
        try {
            volnum = Long.parseLong(this.getVolnum());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return volnum;
    }

    public String[] getSpsSkus() {
        return this.spsSkus.toArray(new String[0]);
    }

    public String getFormat(String spsSku) {
        String format = null;
        Element product = (Element)this.products.get(spsSku);
        if (product != null && (format = product.getAttribute("format")).length() == 0) {
            format = "media";
        }
        return format;
    }

    public String getProductPath(String spsSku) {
        String path = null;
        Element product = (Element)this.products.get(spsSku);
        if (product != null) {
            path = product.getAttribute("skupkg_path");
        }
        return path;
    }

    public String getDataPath(String spsSku) {
        String path = null;
        Element product = (Element)this.products.get(spsSku);
        if (product != null && (path = product.getAttribute("skudat_path")).length() == 0) {
            path = "product_data/" + spsSku;
        }
        return path;
    }

    public boolean isPayloadIncluded(String spsSku) {
        boolean containsPayload = false;
        Element product = (Element)this.products.get(spsSku);
        if (product != null) {
            containsPayload = product.getAttribute("skupkg_path").length() > 0;
        }
        return containsPayload;
    }

    public String getName(String loc) {
        return (String)this.name.get(loc.toLowerCase(Locale.ENGLISH));
    }

    public String getMiscValue(String key) {
        return (String)this.misc.get(key);
    }

    public boolean addProduct(String spsSku, String pkgPath, String datPath) {
        Element product;
        boolean retVal = false;
        if (spsSku != null && pkgPath != null && datPath != null && (product = (Element)this.products.get(spsSku)) == null) {
            product = this.doc.createElement("product");
            product.setAttribute("alt_sku", spsSku);
            product.setAttribute("skupkg_path", pkgPath);
            if (!datPath.equals("product_data/" + spsSku)) {
                product.setAttribute("skudat_path", datPath);
            }
            this.root.appendChild(product);
            this.addProduct(product);
            retVal = true;
        }
        return retVal;
    }

    private void addProduct(Element element) {
        String spsSku = element.getAttribute("alt_sku");
        this.products.put(spsSku, element);
        String skuPkgPath = element.getAttribute("skupkg_path");
        String skuDatPath = element.getAttribute("skudat_path");
        if (skuDatPath.length() == 0) {
            skuDatPath = "product_data/" + spsSku;
        }
        SpsSkuData spsSkuData = null;
        if (this.deploymentData != null) {
            spsSkuData = this.deploymentData.getSpsSku(spsSku);
            if (spsSkuData != null) {
                spsSkuData.setVolser(this.getVolser());
            } else {
                String file = this.deploymentData.getMediaRoot() + File.separator + skuDatPath + File.separator + "product.xml";
                try {
                    spsSkuData = new SpsSkuData(file, this.deploymentData);
                    if (spsSku.equals(spsSkuData.getSpsSku())) {
                        this.deploymentData.spsSkuList.add(spsSkuData);
                        spsSkuData.setVolser(this.getVolser());
                        if (!spsSkuData.isFileListFound()) {
                            Logging.log.info("Generating a File List for: " + spsSku);
                            spsSkuData.genDataFileList(new File(this.deploymentData.getMediaRoot(), skuDatPath));
                            spsSkuData.genProductFileList(new File(this.deploymentData.getMediaRoot(), skuPkgPath));
                        }
                    } else {
                        spsSkuData = null;
                        Logging.log.info("Mismatched ALT_SKU Value in Product XML File: " + file);
                    }
                }
                catch (FileNotFoundException e) {
                    if (Globals.g_genFileLists || Globals.g_mode == 2) {
                        Logging.log.fine("Product XML File Not Found: " + file);
                        Logging.log.fine(e.getMessage());
                        if (Globals.g_badOrderDataFiles != null) {
                            Globals.g_badOrderDataFiles.add(file);
                        }
                    } else {
                        Logging.log.info("Product XML File Not Found: " + file);
                        Logging.log.info(e.getMessage());
                        if (Globals.g_badOrderDataFiles != null) {
                            Globals.g_badOrderDataFiles.add(file);
                        }
                    }
                }
                catch (IOException e) {
                    Logging.log.info("Error Reading Product XML File: " + file);
                    Logging.log.info(e.getMessage());
                    if (Globals.g_badOrderDataFiles != null) {
                        Globals.g_badOrderDataFiles.add(file);
                    }
                }
                catch (Exception e) {
                    Logging.log.info("Error Parsing Product XML File: " + file);
                    Logging.log.info(e.getMessage());
                }
            }
        }
        if (this.deploymentData == null || spsSkuData != null) {
            this.spsSkus.add(spsSku);
        }
    }

    public boolean removeProduct(String spsSku) {
        Element product;
        boolean retVal = false;
        if (spsSku != null && (product = (Element)this.products.get(spsSku)) != null) {
            this.root.removeChild(product);
            this.products.remove(spsSku);
            if (this.deploymentData == null) {
                retVal = true;
            } else {
                SpsSkuData spsSkuData = this.deploymentData.getSpsSku(spsSku);
                if (spsSkuData != null) {
                    spsSkuData.removeVolser(this.getVolser());
                    this.spsSkus.remove(spsSku);
                    if (spsSkuData.getVolsers().length == 0) {
                        this.deploymentData.mediaCodeList.remove(spsSku);
                    }
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    public boolean setPayloadIncluded(String spsSku, boolean include) {
        Element product;
        boolean retVal = false;
        if (spsSku != null && (product = (Element)this.products.get(spsSku)) != null) {
            if (include) {
                String value = (String)this.payloadHistory.remove(spsSku);
                if (value != null) {
                    product.setAttribute("skupkg_path", value);
                    retVal = true;
                }
            } else {
                String value = product.getAttribute("skupkg_path");
                if (value.length() > 0) {
                    this.payloadHistory.put(spsSku, value);
                    product.removeAttribute("skupkg_path");
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() {
        boolean retVal = false;
        if ((this.file.getParentFile().isDirectory() || this.file.getParentFile().mkdirs()) && !this.file.isFile()) {
            try {
                this.file.createNewFile();
            }
            catch (Exception e) {
                Logging.log.info(e.getMessage());
            }
        }
        if (this.file.isFile()) {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(this.file);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(new DOMSource(this.doc), new StreamResult(stream));
                retVal = true;
            }
            catch (Exception e) {
                Logging.log.info(e.getMessage());
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        retVal = false;
                    }
                }
            }
            Utils.removeBlankLines(this.file);
        }
        return retVal;
    }
}

