/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigStatus;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelConfigMaint;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.ValidationFileList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VJR_Pruner {
    protected static SSNResource bundle = new SSNResource(VJR_Pruner.class);
    static List<String> picklistJars = new ArrayList<String>();
    static List<String> inVJRnotInPicklists = new ArrayList<String>();
    static List<String> picklistDirs = new ArrayList<String>();
    private static String WILD_CARD = "_.*";
    private static String PERIOD = ".";
    private static String ESCAPED_PERIOD = "\\.";
    private static String pruneVJRFile = "InstallMisc/utilities/installqual/9.4/VJRPluginsToPrune.txt";
    private static String sasHomeDir;
    private static String sasDMHome;
    private static String clusterNodeConfigDir;

    public static void prune(String sashome) {
        sasHomeDir = sashome;
        String fs = File.separator;
        String jarLocation = sashome + fs + "SASVersionedJarRepository" + fs + "eclipse" + fs + "plugins";
        sasDMHome = sasHomeDir + fs + "SASDeploymentManager" + fs + "9.4";
        Logging.log.info("Checking VJR...");
        File jarLocationFile = new File(jarLocation);
        if (!jarLocationFile.exists()) {
            Logging.log.info("The jar location " + jarLocation + " does not exist. Skipping.");
            return;
        }
        Logging.log.info("Adding SAS home directory '" + sashome + "' to list of directories to search.");
        picklistDirs.add(sashome);
        boolean done = false;
        RegistryAccess registry = null;
        try {
            File deployRegJar = new File(com.sas.tools.installs.it.Utils.joinPath(sashome, "deploymntreg"), "sas.tools.deploymntreg.jar");
            if (deployRegJar != null) {
                registry = new RegistryAccess(deployRegJar);
            }
        }
        catch (Exception e) {
            Logging.log.severe(e.getMessage());
            Logging.logStackTrace(e);
        }
        if (registry != null && registry.open()) {
            if (VJR_Pruner.SASVersionedJarRepositoryRequired(registry)) {
                Logging.log.info("SASVersionedJarRepository will not be altered because AppDev Studio is currently installed");
                done = true;
            }
            registry.close();
            if (done) {
                return;
            }
            VJR_Pruner.findConfigDirs();
        }
        if (Globals.g_analyze) {
            System.out.println("Processing the following picklists to determine which jars in the SASVersionedJarRepository are in use by SAS software that was not uninstalled.");
        }
        if (picklistDirs != null && picklistDirs.size() > 0) {
            for (int j = 0; j < picklistDirs.size(); ++j) {
                VJR_Pruner.process_pickfiles(picklistDirs.get(j));
            }
            Collections.sort(picklistJars);
            ArrayList<String> vjrJars = new ArrayList();
            vjrJars = VJR_Pruner.processVJRs(jarLocation);
            Collections.sort(vjrJars);
            VJR_Pruner.listDifference(vjrJars, picklistJars, inVJRnotInPicklists);
            if (Globals.g_analyze) {
                System.out.println("\n" + bundle.messageString("VJR_Prunner.Analyze.txt"));
                Logging.log.info("\nThe following VJR jar files are missing from the picklists and should be removed.");
                System.out.println("---------------------------------------------------------------------------------");
                Logging.log.info("---------------------------------------------------------------------------------");
                for (int i = 0; i < inVJRnotInPicklists.size(); ++i) {
                    System.out.println(jarLocation + File.separator + inVJRnotInPicklists.get(i));
                    Logging.log.info(jarLocation + File.separator + inVJRnotInPicklists.get(i));
                }
                if (inVJRnotInPicklists.size() == 0) {
                    Logging.log.info("\nAll VJR jars files are in use. Therefore there are no VJR jar files to remove.");
                }
            } else {
                if (!inVJRnotInPicklists.isEmpty()) {
                    Logging.log.info("Pruning VJR...");
                    ValidationFileList validationFileList = new ValidationFileList(sashome);
                    if (!validationFileList.unmarshalData()) {
                        Logging.log.severe("Unable to load validation file list, VJR pruning aborted.");
                        return;
                    }
                    for (int i = 0; i < inVJRnotInPicklists.size(); ++i) {
                        String jarName = jarLocation + File.separator + inVJRnotInPicklists.get(i);
                        File jarFile = new File(jarName);
                        try {
                            List<String> fileNames = VJR_Pruner.getFileNames(jarName);
                            if (com.sas.tools.installs.it.Utils.deleteFolder(jarFile)) {
                                Logging.log.info("Deleted plugin " + jarFile);
                                for (String fileName : fileNames) {
                                    String fn = fileName.replace(sashome, "");
                                    validationFileList.removeFile(fn);
                                }
                                continue;
                            }
                            Logging.log.severe("Unable to delete plugin " + jarFile);
                            continue;
                        }
                        catch (SecurityException e) {
                            Logging.log.severe("Unable to delete plugin " + jarFile + "(" + e.getMessage() + ")");
                            Logging.logStackTrace(e);
                        }
                    }
                    validationFileList.marshalData();
                    Logging.log.info("VJR pruning complete.");
                } else {
                    Logging.log.info("No VJR pruning required.");
                }
                File[] files = jarLocationFile.listFiles();
                if (files.equals(null) || files.length == 0) {
                    File vjrHome = new File(sashome, "SASVersionedJarRepository");
                    com.sas.tools.installs.it.Utils.deleteFolder(vjrHome);
                    Logging.log.info("Deleted VJR folder " + vjrHome);
                }
            }
        } else {
            Logging.log.warning("Unable to open the picklist directory.");
        }
    }

    public static void process_pickfiles(String pDir) {
        File sasdmIniFile;
        String installs = File.separator.concat("installs");
        if (pDir.endsWith(installs) && !pDir.equalsIgnoreCase(sasHomeDir)) {
            Logging.log.fine("Skipping directory '" + pDir + "'");
            return;
        }
        String pDirLowercase = pDir.toLowerCase();
        if (pDirLowercase.endsWith("sasdeploymentmanager" + File.separator + "9.4") && !pDir.equalsIgnoreCase(sasHomeDir) && (sasdmIniFile = new File(pDir, "sasdm.ini")).exists()) {
            Logging.log.fine("Skipping SASDeploymentManager directory '" + pDir + "'");
            return;
        }
        if (pDirLowercase.contains("saswebinfrastructureplatformdataserver" + File.separator + "9.4_previous") && !pDir.equalsIgnoreCase(sasHomeDir)) {
            Logging.log.fine("Skipping SASWebInfrastructurePlatformDataServer/9.4_PREVIOUS* directories '" + pDir + "'");
            return;
        }
        if (clusterNodeConfigDir != null && pDir.startsWith(clusterNodeConfigDir) && VJR_Pruner.isBackupDir(pDir)) {
            Logging.log.fine("Skipping backup directory on cluster node '" + pDir + "'");
            return;
        }
        try {
            File[] dir = new File(pDir).listFiles();
            String MVAPicklistRootDir = "SASVersionedJarRepository" + File.separator + "picklist";
            for (int i = 0; i < dir.length; ++i) {
                if (dir[i].isFile()) {
                    if ((!dir[i].getPath().contains(MVAPicklistRootDir) || !dir[i].getName().toLowerCase().endsWith(".txt")) && !dir[i].getName().matches("picklist") && !dir[i].getName().matches(".*.picklist")) continue;
                    VJR_Pruner.parsePicklist(dir[i].getCanonicalPath());
                    if (!Globals.g_analyze) continue;
                    System.out.println(dir[i].getCanonicalPath());
                    Logging.log.info(dir[i].getCanonicalPath());
                    continue;
                }
                if (!dir[i].canRead() || !dir[i].isDirectory()) continue;
                VJR_Pruner.process_pickfiles(dir[i].getCanonicalPath());
            }
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
    }

    public static List<String> processVJRs(String jar_location) {
        File jarLoc = new File(jar_location);
        ArrayList<String> vjrJars = new ArrayList<String>();
        ArrayList<String> vjrData = VJR_Pruner.getVjrDataForRemoval();
        if (vjrData.isEmpty()) {
            return vjrJars;
        }
        if (jarLoc != null) {
            File[] dir = jarLoc.listFiles();
            String all = "all_unused_plugins";
            boolean hasAll = false;
            if (vjrData.contains(all)) {
                hasAll = true;
            }
            for (int i = 0; i < dir.length; ++i) {
                if (vjrJars.contains(dir[i]) || !dir[i].isDirectory()) continue;
                String lastSubDir = dir[i].getName();
                if (hasAll) {
                    vjrJars.add(lastSubDir);
                    continue;
                }
                for (int j = 0; j < vjrData.size(); ++j) {
                    String name = (String)vjrData.get(j);
                    if (!lastSubDir.startsWith(name)) continue;
                    vjrJars.add(lastSubDir);
                }
            }
        }
        return vjrJars;
    }

    private static ArrayList<String> getVjrDataForRemoval() {
        ArrayList<String> list = new ArrayList<String>();
        String fileName = com.sas.tools.installs.it.Utils.joinPath(sasHomeDir, pruneVJRFile);
        File vjrDataToRemove = new File(fileName);
        BufferedReader in = null;
        if (!vjrDataToRemove.isFile()) {
            return list;
        }
        try {
            String line;
            in = new BufferedReader(new FileReader(vjrDataToRemove));
            while ((line = in.readLine()) != null && !line.isEmpty()) {
                line = line.trim();
                list.add(line);
            }
            in.close();
        }
        catch (Exception e) {
            Logging.log.info("Problem processing file " + pruneVJRFile + ". Continuing without removing obsolete files. See stack trace below.");
            Logging.logStackTrace(e);
        }
        return list;
    }

    public static void parsePicklist(String picklist) {
        try {
            String jar;
            String line;
            BufferedReader in = new BufferedReader(new FileReader(picklist));
            String name = "";
            boolean nameFound = false;
            while ((line = in.readLine()) != null) {
                int i;
                if (line.matches(".*name=.*")) {
                    if (nameFound) {
                        jar = name.replace(PERIOD, ESCAPED_PERIOD) + WILD_CARD;
                        if (Globals.g_analyze || Globals.g_logLevel == 2) {
                            Logging.log.info(jar + " referenced in " + picklist);
                        }
                        VJR_Pruner.addToPicklistJars(jar);
                    } else {
                        nameFound = true;
                    }
                    i = line.indexOf("name=");
                    name = line.substring(i + 5);
                }
                if (!line.matches(".*version=.*") || !nameFound) continue;
                i = line.indexOf("version=");
                String version = line.substring(i + 8);
                nameFound = false;
                jar = name + "_" + version;
                if (Globals.g_analyze || Globals.g_logLevel == 2) {
                    Logging.log.info(jar + " referenced in " + picklist);
                }
                VJR_Pruner.addToPicklistJars(jar);
            }
            if (nameFound) {
                jar = name.replace(PERIOD, ESCAPED_PERIOD) + WILD_CARD;
                if (Globals.g_analyze || Globals.g_logLevel == 2) {
                    Logging.log.info(jar + " referenced in " + picklist);
                }
                VJR_Pruner.addToPicklistJars(jar);
            }
            in.close();
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
    }

    private static void addToPicklistJars(String jar) {
        if (!picklistJars.contains(jar)) {
            picklistJars.add(jar);
        }
    }

    public static void findConfigDirs() {
        RegistryData regData = new RegistryData();
        if (regData != null && RegistryData.setRegistry(sasHomeDir)) {
            ArrayList<String> configDirs = VJR_Pruner.loadConfigDirs();
            for (String configDir : configDirs) {
                File configDirFile = new File(configDir);
                if (configDirFile == null || !configDirFile.exists() || !VJR_Pruner.checkStatusFileForCode(configDir, "tcsclusterc")) continue;
                clusterNodeConfigDir = configDir;
                Logging.log.info("Adding config directory '" + configDir + "' to list of directories to search due to cluster node detected.");
                picklistDirs.add(configDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> loadConfigDirs() {
        ArrayList<String> listData = new ArrayList<String>(10);
        if (Utils.getOS() != 8 || !Globals.g_z64 && Globals.g_zosJobSubmit) {
            String[] configDirs = null;
            RegistryAccess registryAccess = null;
            try {
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                if (registryAccess != null && registryAccess.open()) {
                    configDirs = registryAccess.getConfigLocs();
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (registryAccess != null) {
                    registryAccess.close();
                    registryAccess = null;
                }
            }
            if (configDirs != null && sasHomeDir != null) {
                for (int i = 0; i < configDirs.length; ++i) {
                    for (int j = 0; j < Globals.g_configLevels.length; ++j) {
                        if (!PanelConfigMaint.isConfigDirEligible(configDirs[i], Globals.g_configLevels[j], sasHomeDir)) continue;
                        listData.add(com.sas.tools.installs.it.Utils.joinPath(configDirs[i], Globals.g_configLevels[j]));
                    }
                }
            }
        }
        return listData;
    }

    private static boolean checkStatusFileForCode(String cfgDir, String prodcode) {
        boolean found = false;
        File statusFile = new File(com.sas.tools.installs.it.Utils.joinPath(cfgDir, "ConfigData", "status.xml"));
        try {
            ConfigStatus status = new ConfigStatus(statusFile);
            if (status.checkStatusFileForProductCode(prodcode)) {
                found = true;
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        return found;
    }

    public static boolean SASVersionedJarRepositoryRequired(RegistryAccess registry) {
        String[] hosts = null;
        String[] codes = null;
        hosts = registry.getInstallHosts();
        for (int i = 0; i < hosts.length; ++i) {
            codes = registry.getInstallCodes(hosts[i]);
            for (int j = 0; j < codes.length; ++j) {
                if (!"appdevstudio".equals(codes[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static void listDifference(List<String> vjrJars, List<String> picklistJars, List<String> inVjrNotInPicklist) {
        for (String vjrJar : vjrJars) {
            if (VJR_Pruner.listContains(picklistJars, vjrJar)) continue;
            inVjrNotInPicklist.add(vjrJar);
        }
    }

    private static boolean listContains(List<String> list, String value) {
        for (String item : list) {
            if (!(item.endsWith(WILD_CARD) ? value.matches(item) : value.equals(item))) continue;
            return true;
        }
        return false;
    }

    private static List<String> getFileNames(String dirName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File directory = new File(dirName);
        try {
            String[] files = directory.list();
            if (files != null) {
                for (String fileName : files) {
                    String filePath = dirName.concat(File.separator).concat(fileName);
                    Logging.log.fine("Processing path '" + filePath + "'");
                    File file = new File(filePath);
                    if (file.isDirectory()) {
                        Logging.log.fine("Path '" + filePath + "' is a directory");
                        fileNames.addAll(VJR_Pruner.getFileNames(filePath));
                        continue;
                    }
                    filePath = com.sas.tools.installs.it.Utils.canonicalizePath(filePath);
                    Logging.log.fine("Adding path '" + filePath + "'");
                    fileNames.add(filePath);
                }
            }
        }
        catch (Exception e) {
            Logging.log.info("Error listing folder (" + dirName + ") - " + e.getMessage());
            System.err.println("Error listing folder (" + dirName + ") - " + e.getLocalizedMessage());
        }
        return fileNames;
    }

    private static boolean isBackupDir(String dir) {
        File dirFile = new File(dir);
        if (dirFile.isDirectory()) {
            String separator = System.getProperty("file.separator");
            if (dir.contains("Web" + separator + "Backup_")) {
                Logging.log.fine("Skipping path with Web" + separator + "Backup_ : " + dir);
                return true;
            }
            if (dir.contains("AppData" + separator + "Backup_")) {
                Logging.log.fine("Skipping path with Web" + separator + "Backup_ : " + dir);
                return true;
            }
            String appSvrDir = "Web" + separator + "Scripts" + separator + "AppServer";
            if (dir.contains(appSvrDir + separator + "jdbc.")) {
                Logging.log.fine("Skipping path with Web" + appSvrDir + separator + "jdbc. : " + dir);
                return true;
            }
            if (dir.contains(appSvrDir + separator + "lib.")) {
                Logging.log.fine("Skipping path with Web" + appSvrDir + separator + "lib. : " + dir);
                return true;
            }
            if (dir.contains(appSvrDir + separator + "src.")) {
                Logging.log.fine("Skipping path with Web" + appSvrDir + separator + "src. : " + dir);
                return true;
            }
        }
        return false;
    }

    static {
        clusterNodeConfigDir = null;
    }
}

