/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.JREData;
import com.sas.ssn.Logging;
import com.sas.ssn.OsLevelCheck;
import com.sas.ssn.PanelExecute;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.Utils;
import com.sas.ssn.WizardPromptedIface;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class SystemInfo {
    private final String separator = System.getProperty("line.separator");

    SystemInfo() {
    }

    public String collectInfo(String home_loc, String temp_loc) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date my_time = new Date();
        String logName = "SDW_sysinfo_" + formatter.format(my_time) + ".dat";
        String buffer = "SAS Sysinfo Log: " + formatter.format(my_time) + this.separator;
        buffer = buffer + "SDW version: " + Utils.GetSDWVersion() + this.separator;
        buffer = buffer + this.separator;
        String temp = this.getRegistryInfo();
        if (temp != null) {
            buffer = buffer + temp + this.separator;
        }
        if ((temp = this.getSystemInfo()) != null) {
            buffer = buffer + temp + this.separator;
        }
        buffer = buffer + this.getOsInfo() + this.separator;
        String filename = Utils.joinPath(temp_loc, logName);
        try {
            FileWriter fout = new FileWriter(filename);
            fout.write(buffer);
            fout.close();
        }
        catch (IOException e) {
            Logging.log.severe("Error writing file: " + filename);
            return null;
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRegistryInfo() {
        String buffer = "";
        String host = Utils.getOS_Suffix();
        try (RegistryAccess m_registryAccess = null;){
            String deployJar = RegistryData.getDeployRegJar();
            if (deployJar == null) {
                String string = null;
                return string;
            }
            File deployreg = new File(deployJar);
            if (!deployreg.exists() || !deployreg.isFile()) {
                String string = null;
                return string;
            }
            m_registryAccess = new RegistryAccess(deployJar);
            if (m_registryAccess != null && m_registryAccess.open()) {
                WizardPromptedIface jrePanel;
                String[] promptedProducts;
                String version;
                String product;
                PanelExecute panelExecute = (PanelExecute)Globals.g_wizard.getPanel("execute");
                ArrayList<ProductData> installProducts = null;
                installProducts = panelExecute.getInstallProducts(false);
                if (installProducts != null) {
                    for (int i = 0; i < installProducts.size(); ++i) {
                        ProductData installData = installProducts.get(i);
                        String sku = installData.getSpsSku();
                        boolean isStandardLanguage = false;
                        isStandardLanguage = installData.getType() == 4 ? ((HotFix)installData).getSpsSkuData().isStandardLanguage() : Globals.g_deploymentData.getSpsSku(sku).isStandardLanguage();
                        if (installData.getType() == 0 || !isStandardLanguage) continue;
                        product = installData.getProdCode();
                        version = installData.getProdVersion();
                        buffer = product.equalsIgnoreCase("sasinstall") && Globals.g_sasinstallPlat != null ? buffer + this.getProductDetails(m_registryAccess, product, version, Globals.g_sasinstallPlat) : (product.equalsIgnoreCase("jmp") && Globals.g_jmpPlat != null ? buffer + this.getProductDetails(m_registryAccess, product, version, Globals.g_jmpPlat) : (product.equalsIgnoreCase("pcfilesrv") && Globals.g_pcfilesrvPlat != null ? buffer + this.getProductDetails(m_registryAccess, product, version, Globals.g_pcfilesrvPlat) : (product.equalsIgnoreCase("eguide") && Globals.g_eguidePlat != null ? buffer + this.getProductDetails(m_registryAccess, product, version, Globals.g_eguidePlat) : (product.equalsIgnoreCase("msofficeint") && Globals.g_msofficeintPlat != null ? buffer + this.getProductDetails(m_registryAccess, product, version, Globals.g_msofficeintPlat) : (product.equalsIgnoreCase("msoffintva") && Globals.g_msoffintvaPlat != null ? buffer + this.getProductDetails(m_registryAccess, product, version, Globals.g_msoffintvaPlat) : buffer + this.getProductDetails(m_registryAccess, product, version, installData.getPlatform()))))));
                    }
                }
                if ((promptedProducts = Globals.g_promptedInstalls) != null) {
                    for (int i = 0; i < promptedProducts.length; ++i) {
                        WizardPromptedIface promptedPanel = (WizardPromptedIface)Globals.g_wizard.getPanel(Globals.g_promptedInstalls[i]);
                        product = promptedPanel.getProductCode();
                        version = Globals.g_majorReleaseVersion;
                        buffer = buffer + this.getProductDetails(m_registryAccess, product, version, host);
                    }
                }
                if (JREData.g_jrePrompted && (jrePanel = (WizardPromptedIface)Globals.g_wizard.getPanel("jre")) != null) {
                    product = jrePanel.getProductCode();
                    version = Globals.g_majorReleaseVersion;
                    buffer = buffer + this.getProductDetails(m_registryAccess, product, version, host);
                }
            }
        }
        return buffer;
    }

    private String getProductDetails(RegistryAccess m_registryAccess, String product, String version, String host) {
        String buffer = "Product_Name=" + product + this.separator;
        buffer = buffer + "Version=" + version + this.separator;
        buffer = buffer + "Host=" + host + this.separator;
        buffer = buffer + "InstallTime=" + m_registryAccess.getInstallTime(product, version, host) + this.separator;
        buffer = buffer + "OrderNum=" + m_registryAccess.getInstallOrderNum(product, version, host) + this.separator;
        buffer = buffer + "Setnumid=" + m_registryAccess.getInstallSetnumid(product, version, host) + this.separator;
        buffer = buffer + "DisplayName=" + m_registryAccess.getInstallDisplayName(product, version, host) + this.separator;
        buffer = buffer + "InstallLoc=" + m_registryAccess.getInstallLoc(product, version, host) + this.separator;
        buffer = buffer + "InstallGUID=" + m_registryAccess.getInstallGUID(product, version, host) + this.separator;
        buffer = buffer + "InstallStatus=" + m_registryAccess.getInstallStatus(product, version, host) + this.separator;
        buffer = buffer + "ServicePack=" + m_registryAccess.getInstallServicePack(product, version, host) + this.separator;
        buffer = buffer + this.separator;
        return buffer;
    }

    String getSystemInfo() {
        String buffer = null;
        int osInfo = Utils.getOS();
        if (osInfo == 1) {
            buffer = "CPU=" + SASWinAPI.GetProcessorName() + System.getProperty("line.separator");
            buffer = buffer + "\tCPU_Architecture=" + SASWinAPI.GetArchitectureWin() + System.getProperty("line.separator");
            buffer = buffer + "\tCPU_Family=" + SASWinAPI.GetCPULevelWin() + System.getProperty("line.separator");
            buffer = buffer + "\tCPU_Model=" + SASWinAPI.GetCPUModelWin() + System.getProperty("line.separator");
            buffer = buffer + "\tCPU_Stepping=" + SASWinAPI.GetCPUSteppingWin() + System.getProperty("line.separator");
        } else if (osInfo == 2 || osInfo == 3 || osInfo == 4 || osInfo == 5 || osInfo == 7) {
            String[][] command = new String[][]{{"uname", "-m"}, {"uname", "-p"}, {"uname", "-i"}};
            String[] envp = new String[]{"LANG=C", "LC_ALL=C"};
            String temp = Utils.ExecuteCommand(command[0], envp);
            if (temp.length() != 0 && !temp.equalsIgnoreCase(null)) {
                buffer = "Machine_Hardware=" + temp;
            }
            if ((temp = Utils.ExecuteCommand(command[1], envp)).length() != 0 && !temp.equalsIgnoreCase(null)) {
                buffer = buffer + "Processor_Type=" + temp;
            }
            if ((temp = Utils.ExecuteCommand(command[2], envp)).length() != 0 && !temp.equalsIgnoreCase(null)) {
                buffer = buffer + "Platform=" + temp;
            }
        } else if (osInfo == 8) {
            String[][] command = new String[][]{{"uname", "-m"}};
            String[] envp = new String[]{"LANG=C", "LC_ALL=C"};
            buffer = "Machine_Hardware=" + System.getProperty("os.arch");
            String mode = System.getProperty("sun.arch.data.model");
            if (mode.length() != 0) {
                buffer = mode.equals("32") ? buffer + "-31" : buffer + "-" + mode;
            }
            buffer = buffer + System.getProperty("line.separator");
            String temp = Utils.ExecuteCommand(command[0], envp);
            if (temp.length() != 0 && !temp.equalsIgnoreCase(null)) {
                buffer = buffer + "Processor_Type=" + temp;
            }
        }
        return buffer;
    }

    String getOsInfo() {
        String buffer = null;
        int osInfo = Utils.getOS();
        if (osInfo == 1) {
            buffer = OsLevelCheck.getOsVersionDescription();
        } else if (osInfo == 2 || osInfo == 3 || osInfo == 4 || osInfo == 5 || osInfo == 7) {
            String[][] command = new String[][]{{"uname", "-s"}, {"uname", "-r"}, {"uname", "-v"}};
            String[] envp = new String[]{"LANG=C", "LC_ALL=C"};
            buffer = "OSName=" + Utils.ExecuteCommand(command[0], envp);
            buffer = buffer + "OSLevel=" + Utils.ExecuteCommand(command[1], envp);
            buffer = buffer + "OSVersion=" + Utils.ExecuteCommand(command[2], envp);
        } else if (osInfo == 8) {
            buffer = "OSName=" + System.getProperty("os.name") + System.getProperty("line.separator");
            buffer = buffer + "OSVersion=" + System.getProperty("os.version") + System.getProperty("line.separator");
        }
        return buffer;
    }
}

