/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import java.sql.Timestamp;
import java.util.Date;

public class StandardDeploymentPlan
implements Comparable<StandardDeploymentPlan> {
    private String name;
    private Integer machineCount;
    private String type;
    private String pathOnDisk;
    private String sortByName;
    private String uniqueKey;

    public StandardDeploymentPlan(String planName) {
        this.setName(planName);
        Date date = new Date();
        this.uniqueKey = new Timestamp(date.getTime()).toString();
    }

    public StandardDeploymentPlan(String planName, String planType, String planPathOnDisk) {
        this(planName);
        this.setType(planType);
        this.setPathOnDisk(planPathOnDisk);
    }

    public StandardDeploymentPlan(String planName, String planSortByName, int planMachCount, String planType, String planPathOnDisk, String uniqueKey) {
        this(planName, planType, planPathOnDisk);
        this.setSortByName(planSortByName);
        this.setMachineCount(planMachCount);
        this.uniqueKey = uniqueKey;
    }

    public final String getUniqueKey() {
        return this.uniqueKey;
    }

    public final String getSortByName() {
        return this.sortByName;
    }

    public final String getName() {
        return this.name;
    }

    public final Integer getMachineCount() {
        return this.machineCount;
    }

    public final String getType() {
        return this.type;
    }

    public final String getPathOnDisk() {
        return this.pathOnDisk;
    }

    public final void setSortByName(String planSortByName) {
        this.sortByName = planSortByName;
    }

    public final void setType(String planType) {
        this.type = planType;
    }

    public final void setName(String planName) {
        this.name = planName;
    }

    public final void setMachineCount(Integer planMachineCount) {
        this.machineCount = planMachineCount;
    }

    public final void setMachineCount(int planMachineCount) {
        this.machineCount = planMachineCount;
    }

    public final void setPathOnDisk(String planPathOnDisk) {
        this.pathOnDisk = planPathOnDisk;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public final int compareTo(StandardDeploymentPlan stdDepPlan) {
        int result = this.getSortByName().compareTo(stdDepPlan.getSortByName());
        if (0 != result) {
            return result;
        }
        return this.getMachineCount().compareTo(stdDepPlan.getMachineCount());
    }

    public final boolean equals(Object o) {
        if (o instanceof StandardDeploymentPlan) {
            return 0 == this.compareTo((StandardDeploymentPlan)o);
        }
        return false;
    }
}

