/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.PropsParser;
import com.sas.ssn.StagedSDMException;
import com.sas.ssn.Utils;
import com.sas.tools.deploy.util.SASRuntimeWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.io.FileUtils;

public class StagedSDM {
    private static String sdmRestartCommandLineOption = "-sdmrestartedfromaltlocation";
    private static boolean sdmRestartedFromAltLocation = false;
    private static String[] originalCmdLineOptions = null;
    private String sdmRootDir;
    private String stagingDir;
    private File sourceJREDir = null;
    private File altJREDir = null;
    private File sourceSDMDir = null;
    private File altSDMDir = null;
    private String launchercmd;
    private String launcherargs;
    private static String xmxValueFromCmdOptions = "";
    private static String xmxValueFromSasdmIni = "";
    private static String xmxValue = "";

    public StagedSDM(String sdmRootDir, String stagingDir) throws StagedSDMException {
        this.sdmRootDir = sdmRootDir;
        this.stagingDir = stagingDir;
        try {
            this.loadCurrentSasdmIni();
        }
        catch (StagedSDMException e) {
            throw new StagedSDMException("Error loading sasdm.ini", e);
        }
    }

    public void copyJREToAltLocation() throws StagedSDMException {
        File source = null;
        try {
            source = this.getSourceJREDir();
        }
        catch (StagedSDMException e) {
            throw new StagedSDMException("Unable to determine the source jre.", e);
        }
        File destination = this.getAltJREDir();
        if (source != null && destination != null) {
            String linkSource = this.buildJrePathByOS(source.getPath());
            String linkDestination = destination.getAbsolutePath() + "/bin/java";
            Logging.log.info("Copying the jre to an alternate location for staging SAS Deployment Manager: source: " + source.getAbsolutePath() + " destination: " + destination.getAbsolutePath());
            try {
                FileUtils.copyDirectory(source, destination, true);
                if (Utils.getOS() != 1) {
                    Utils.setFileModeOnDirectoryTree(destination);
                }
                if (this.isOsSolaris()) {
                    FileUtils.deleteQuietly(new File(linkDestination));
                    Process p = SASRuntimeWrapper.getRuntime().exec(new String[]{"ln", "-s", linkSource, linkDestination});
                    p.waitFor();
                }
            }
            catch (IOException e) {
                throw new StagedSDMException("An error occurred copying the jre to the alternate location: source: " + source.getAbsolutePath() + " destination: " + destination.getAbsolutePath(), e);
            }
            catch (InterruptedException ie) {
                throw new StagedSDMException(String.format("An error occurred linking the jre from the original location: %s to the temporary location: %s", linkSource, linkDestination));
            }
        }
    }

    private String buildJrePathByOS(String sourcePath) {
        if (this.isOsSax()) {
            return sourcePath + "/bin/amd64/java";
        }
        if (this.isOsS64()) {
            return sourcePath + "/bin/sparcv9/java";
        }
        return sourcePath;
    }

    private boolean isOsSolaris() {
        return Utils.getOS() == 3;
    }

    private boolean isOsSax() {
        return Utils.getOS_Suffix() == "sax";
    }

    private boolean isOsS64() {
        return Utils.getOS_Suffix() == "s64";
    }

    public void copySDMToAltLocation() throws StagedSDMException {
        File source = null;
        try {
            source = this.getSourceSDMDir();
        }
        catch (StagedSDMException e) {
            throw new StagedSDMException("Unable to determine the source location of SAS Deployment Manager.", e);
        }
        File destination = this.getAltSDMDir();
        if (source != null && destination != null) {
            Logging.log.info("Copying the SAS Deployment Manager for staging: source: " + source.getAbsolutePath() + " destination: " + destination.getAbsolutePath());
            try {
                FileUtils.copyDirectory(source, destination, true);
                if (Utils.getOS() != 1) {
                    Utils.setFileModeOnDirectoryTree(destination);
                }
            }
            catch (IOException e) {
                throw new StagedSDMException("An error occurred copying the SAS Deployment Manager to the alternate location: source: " + source.getAbsolutePath() + " destination: " + destination.getAbsolutePath(), e);
            }
        }
    }

    private void loadCurrentSasdmIni() throws StagedSDMException {
        PropsParser sdmProps = new PropsParser(true);
        File sasdminiFile = new File(this.sdmRootDir, "sasdm.ini");
        Logging.log.info("Reading sasdm.ini for staging the SAS Deployment Manager: " + sasdminiFile.getAbsolutePath());
        try {
            String[] tempargs;
            sdmProps.load(sasdminiFile, null);
            this.launchercmd = sdmProps.getINIValue("default", "launchercmd", null);
            this.launcherargs = sdmProps.getINIValue("default", "launcherargs", null);
            for (String arg : tempargs = this.launcherargs.split(" ")) {
                if (!arg.startsWith("-Xmx")) continue;
                xmxValueFromSasdmIni = arg;
            }
        }
        catch (Exception e) {
            throw new StagedSDMException("Unable to load: " + sasdminiFile.getAbsolutePath());
        }
        if (this.launchercmd == null) {
            throw new StagedSDMException("No launchercmd defined in: " + sasdminiFile.getAbsolutePath());
        }
        if (this.launcherargs == null) {
            throw new StagedSDMException("No launcherargs defined in: " + sasdminiFile.getAbsolutePath());
        }
    }

    public void constructNewSasdmINI(File sourceFile, String additionalCmdLineOptions) throws StagedSDMException {
        BufferedReader reader = null;
        PrintStream stream = null;
        try {
            reader = new BufferedReader(new FileReader(sourceFile));
            File altSasdmINI = new File(this.stagingDir, "sasdm.ini");
            stream = new PrintStream((OutputStream)new FileOutputStream(altSasdmINI), false, "UTF-8");
            String lineIn = null;
            Logging.log.info("Construction new sasdm.ini for staging SAS Deployment Manager: " + altSasdmINI.getAbsolutePath());
            while ((lineIn = reader.readLine()) != null) {
                if (lineIn.contains("launchercmd")) {
                    String cmd = this.getLauncherCmd();
                    Logging.log.info("Launcher command for staged SAS Deployment Manager: " + cmd);
                    stream.println(cmd);
                    continue;
                }
                if (lineIn.contains("launcherargs")) {
                    String args = this.getLauncherArgs(additionalCmdLineOptions);
                    Logging.log.info("Launcher args for staged SAS Deployment Maanger: " + args);
                    stream.println(args);
                    continue;
                }
                stream.println(lineIn);
            }
        }
        catch (FileNotFoundException e) {
            throw new StagedSDMException("Source file does not exist: " + sourceFile.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new StagedSDMException("Error reading/writing sasdm.ini", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Logging.logStackTrace(e);
                }
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected String getLauncherCmd() {
        String launcherCmd = "";
        launcherCmd = "launchercmd=" + this.getAltJREDir() + File.separator + "bin" + File.separator + "java";
        return launcherCmd;
    }

    protected String getLauncherArgs(String additionalCmdLineOptions) {
        String originalOptions = this.getOriginalCmdLineOptions();
        String launcherArgs = "";
        if (xmxValueFromSasdmIni != null && xmxValueFromSasdmIni.length() > 0) {
            this.setXmxValue(xmxValueFromSasdmIni);
        }
        if (xmxValueFromCmdOptions != null && xmxValueFromCmdOptions.length() > 0) {
            this.setXmxValue(xmxValueFromCmdOptions);
        }
        launcherArgs = "launcherargs=" + StagedSDM.getXmxValue() + " -jar \"" + this.getAltSDMClassPath() + "\" " + originalOptions + " " + sdmRestartCommandLineOption + " -lang " + Language.gs_SelectedLanguage + " " + additionalCmdLineOptions;
        return launcherArgs;
    }

    public void copySasdm(File sourceFile) throws StagedSDMException {
        String destFilename = sourceFile.getName();
        File destFile = new File(this.stagingDir, destFilename);
        Logging.log.info("Copying sasdm launcher for staged SAS Deployment Manager: source: " + sourceFile.getAbsolutePath() + " destination: " + destFile.getAbsolutePath());
        if (Utils.copyFile(sourceFile, destFile) != 0) {
            throw new StagedSDMException("Error copying " + sourceFile.getAbsolutePath() + " to " + destFile.getAbsolutePath());
        }
    }

    public File getSourceJREDir() throws StagedSDMException {
        if (this.sourceJREDir == null) {
            try {
                this.sourceJREDir = new File(System.getProperty("java.home"));
            }
            catch (Exception e) {
                throw new StagedSDMException("Cannot determine the system property java.home.");
            }
            if (this.sourceJREDir == null || !this.sourceJREDir.exists() || !this.sourceJREDir.isDirectory()) {
                throw new StagedSDMException("Source jre directory does not exist: " + this.sourceJREDir.getAbsolutePath());
            }
        }
        return this.sourceJREDir;
    }

    public File getAltJREDir() {
        if (this.altJREDir == null) {
            this.altJREDir = new File(this.stagingDir, "jre");
        }
        return this.altJREDir;
    }

    public File getSourceSDMDir() throws StagedSDMException {
        File setupJar = null;
        try {
            setupJar = new File(System.getProperty("java.class.path"));
        }
        catch (Exception e) {
            throw new StagedSDMException("Cannot determine the class pass for the SAS Deployment Manager: " + System.getProperty("java.class.path"));
        }
        File checkSourceSDMDir = setupJar.getParentFile();
        if (checkSourceSDMDir == null) {
            throw new StagedSDMException("Cannot determine the source directory for the SAS Deployment Manager.");
        }
        if (!checkSourceSDMDir.exists() || !checkSourceSDMDir.isDirectory()) {
            throw new StagedSDMException("Cannot find the SAS Deployment Manager directory: " + checkSourceSDMDir);
        }
        this.sourceSDMDir = checkSourceSDMDir;
        return this.sourceSDMDir;
    }

    public File getAltSDMDir() {
        if (this.altSDMDir == null) {
            this.altSDMDir = new File(this.stagingDir, "deploywiz");
        }
        return this.altSDMDir;
    }

    private String getAltSDMClassPath() {
        File setupJar = new File(this.getAltSDMDir(), "setup.jar");
        if (setupJar.exists()) {
            return setupJar.getAbsolutePath();
        }
        throw new StagedSDMException("Setup.jar not found in alternate SAS Deployment Manager: " + setupJar.getAbsolutePath());
    }

    public File createPartialPromptResponseFile() {
        File responseFile = null;
        try (PrintStream stream = null;){
            responseFile = new File(this.stagingDir, "sasdm.response.txt");
            stream = new PrintStream((OutputStream)new FileOutputStream(responseFile), false, "UTF-8");
            String manageTaskResponse = "MANAGE_TASK=applyhotfix";
            stream.println(manageTaskResponse);
        }
        return responseFile;
    }

    public static String getSDMRestartCMDLineOption() {
        return sdmRestartCommandLineOption;
    }

    public static void setSDMRestatedFromAltLocation(boolean restarted) {
        sdmRestartedFromAltLocation = restarted;
    }

    public static boolean isSDMRestartedFromAltLocation() {
        return sdmRestartedFromAltLocation;
    }

    public static void setOriginalCmdLineOptions(String[] cmdLineOptions) {
        originalCmdLineOptions = cmdLineOptions;
    }

    private String getOriginalCmdLineOptions() {
        String cmdLineOptions = "";
        if (originalCmdLineOptions != null) {
            for (int count = 0; count < originalCmdLineOptions.length; ++count) {
                if (originalCmdLineOptions[count].equalsIgnoreCase("-startuplocation")) {
                    cmdLineOptions = cmdLineOptions + "-startuplocation ";
                    cmdLineOptions = cmdLineOptions + "\"" + originalCmdLineOptions[++count] + "\" ";
                    continue;
                }
                if (originalCmdLineOptions[count].equalsIgnoreCase("-hotfixdir")) {
                    ++count;
                    continue;
                }
                if (originalCmdLineOptions[count].equalsIgnoreCase("-datalocation")) {
                    cmdLineOptions = cmdLineOptions + "-datalocation ";
                    cmdLineOptions = cmdLineOptions + "\"" + originalCmdLineOptions[++count] + "\" ";
                    continue;
                }
                if (originalCmdLineOptions[count].equalsIgnoreCase("-responsefile")) {
                    cmdLineOptions = cmdLineOptions + "-responsefile ";
                    cmdLineOptions = cmdLineOptions + "\"" + originalCmdLineOptions[++count] + "\" ";
                    continue;
                }
                if (originalCmdLineOptions[count].equalsIgnoreCase("-templocation")) {
                    cmdLineOptions = cmdLineOptions + "-templocation ";
                    cmdLineOptions = cmdLineOptions + "\"" + originalCmdLineOptions[++count] + "\" ";
                    continue;
                }
                if (originalCmdLineOptions[count].equalsIgnoreCase("-javaoptions")) {
                    if (!originalCmdLineOptions[++count].startsWith("-Xmx")) continue;
                    xmxValueFromCmdOptions = originalCmdLineOptions[count];
                    continue;
                }
                cmdLineOptions = cmdLineOptions + originalCmdLineOptions[count] + " ";
            }
        }
        return cmdLineOptions;
    }

    public static String getXmxValue() {
        return xmxValue;
    }

    private void setXmxValue(String xmxParameter) {
        String defaultValue = "-Xmx1024M";
        if (xmxParameter != null && xmxParameter.length() > 0) {
            xmxValue = xmxParameter;
        } else if (xmxValue.length() < 1) {
            xmxValue = defaultValue;
        }
    }
}

