/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.DeploymentData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.SkuData;
import com.sas.ssn.UnicodeInputStream;
import com.sas.ssn.Utils;
import com.sas.tools.installs.it.DeploymentXMLReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SpsSkuData {
    private String spsSku;
    private String prodCode;
    private String language;
    private String version;
    private String sasRelease;
    private String maintLevel;
    private String sequenceNum;
    private String status;
    private String lastPortDate;
    private String platform;
    private String indbString;
    private String docString;
    private String altSkuType;
    public static final String FULL_SKU_TYPE = "full";
    public static final String DELTA_SKU_TYPE = "maint";
    private boolean indb = false;
    private boolean doc = false;
    private boolean targetByBaseHost = false;
    private boolean sysReq = false;
    private String description;
    private String time;
    private String totalSize;
    private String dataSize;
    private String productSize;
    private boolean fileListFound = true;
    private boolean requiresWebServer = false;
    private boolean advancedInstall = false;
    private SkuList skuList = new SkuList();
    private Vector volsers = new Vector();
    private Vector selectGroups = new Vector();
    private Vector dataFiles = new Vector();
    private Vector productFiles = new Vector();
    private Hashtable platformLanguages = new Hashtable();
    private Hashtable installedSize = new Hashtable();
    private Hashtable platformLevels = new Hashtable();
    private Hashtable platformRequirements = new Hashtable();
    private Hashtable displayName = new Hashtable();
    private Hashtable displayVersion = new Hashtable();
    private Hashtable customerVersion = new Hashtable();
    private Hashtable miscData = new Hashtable();
    private HashMap<String, FileAttrData> dataFilesDC = new HashMap();
    private HashMap<String, FileAttrData> productFilesDC = new HashMap();

    public SpsSkuData() {
    }

    public SpsSkuData(String file, DeploymentData deploymentData) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(new File(file), deploymentData);
    }

    public SpsSkuData(File file, DeploymentData deploymentData) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(new UnicodeInputStream(file), deploymentData, file);
    }

    public SpsSkuData(File file) throws IOException, ParserConfigurationException, SAXException {
        this(new UnicodeInputStream(file), null, null);
    }

    public SpsSkuData(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        this(new UnicodeInputStream(inputStream), null, null);
    }

    public SpsSkuData(UnicodeInputStream uniInputStream, DeploymentData deploymentData, File file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        int i;
        NodeList data;
        Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(uniInputStream).getDocumentElement();
        this.spsSku = root.getAttribute("alt_sku");
        this.prodCode = root.getAttribute("software_code").toLowerCase(Locale.ENGLISH);
        this.language = root.getAttribute("lang").toLowerCase(Locale.ENGLISH);
        this.version = root.getAttribute("ver").toLowerCase(Locale.ENGLISH);
        this.sasRelease = root.getAttribute("sas_release");
        this.maintLevel = root.getAttribute("maint_level");
        this.sequenceNum = root.getAttribute("sequence_num").toLowerCase(Locale.ENGLISH);
        this.status = root.getAttribute("status_code").toLowerCase(Locale.ENGLISH);
        this.lastPortDate = root.getAttribute("last_port_date");
        this.platform = root.getAttribute("platform").toLowerCase(Locale.ENGLISH);
        this.indbString = root.getAttribute("indb").toLowerCase(Locale.ENGLISH);
        this.docString = root.getAttribute("doc").toLowerCase(Locale.ENGLISH);
        this.altSkuType = root.getAttribute("alt_sku_type").toLowerCase(Locale.ENGLISH);
        if (this.indbString != null && this.indbString.equalsIgnoreCase("true")) {
            this.indb = true;
        }
        if (this.docString != null && this.docString.equalsIgnoreCase("true")) {
            this.doc = true;
        }
        if ((data = root.getChildNodes()) != null) {
            for (i = 0; i < data.getLength(); ++i) {
                if (data.item(i).getNodeType() != 1) continue;
                Element element = (Element)data.item(i);
                if ("prodName".equals(element.getTagName())) {
                    this.displayName.put(element.getAttribute("loc").toLowerCase(Locale.ENGLISH), element.getAttribute("v"));
                    continue;
                }
                if ("prodVer".equals(element.getTagName())) {
                    this.displayVersion.put(element.getAttribute("loc").toLowerCase(Locale.ENGLISH), element.getAttribute("v"));
                    continue;
                }
                if ("custVer".equals(element.getTagName())) {
                    this.customerVersion.put(element.getAttribute("loc").toLowerCase(Locale.ENGLISH), element.getAttribute("v"));
                    continue;
                }
                if ("prodDefn".equals(element.getTagName())) {
                    this.skuList.add(new SkuData(element));
                    continue;
                }
                this.miscData.put(element.getTagName(), element.getAttribute("v"));
            }
        }
        if (file != null) {
            if (Globals.g_mode != 1 && Globals.g_mode != 6) {
                this.loadDeploymentXMLData(file.getParent() + File.separator + "deployment.xml");
                this.loadLanguages(file.getParent() + File.separator + "langlist.xml");
                this.loadSizeData(file.getParent() + File.separator + "size.xml");
                this.loadSelectData(file.getParent() + File.separator + "select.xml");
                this.loadLevelCheckData(file.getParent() + File.separator + "levcheck.xml");
            }
            if (Globals.g_mode != 6) {
                this.loadRequirementData(file.getParent() + File.separator + "requirements.xml");
            }
        }
        if (deploymentData != null) {
            this.loadFileListData(file.getParent() + File.separator + "filelist.xml", deploymentData.getLoadFileLists());
        }
        String[] errors = this.getErrors();
        for (i = 0; i < errors.length; ++i) {
            Logging.log.info(errors[i] + ": " + file.getCanonicalPath());
        }
    }

    private void loadSizeData(String file) {
        try {
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file)).getDocumentElement();
            NodeList data = root.getChildNodes();
            if (data != null) {
                for (int i = 0; i < data.getLength(); ++i) {
                    Element element;
                    if (data.item(i).getNodeType() != 1 || !"size".equals((element = (Element)data.item(i)).getTagName())) continue;
                    String platform = element.getAttribute("plat").toLowerCase(Locale.ENGLISH);
                    String language = element.getAttribute("lang").toLowerCase(Locale.ENGLISH);
                    String bytes = element.getAttribute("bytes").toLowerCase(Locale.ENGLISH);
                    if (platform == null || language == null || bytes == null) continue;
                    this.installedSize.put(platform + "-" + language, bytes);
                }
            }
        }
        catch (FileNotFoundException root) {
        }
        catch (IOException e) {
            Logging.log.info("Error Reading Size XML File: " + file);
            Logging.log.info(e.getMessage());
        }
        catch (Exception e) {
            Logging.log.info("Error Parsing Size XML File: " + file);
            Logging.log.info(e.getMessage());
        }
    }

    private void loadSelectData(String file) {
        try {
            NodeList data;
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file)).getDocumentElement();
            if ("true".equalsIgnoreCase(root.getAttribute("requiresWebServer"))) {
                this.requiresWebServer = true;
            }
            if ("true".equalsIgnoreCase(root.getAttribute("advancedInstall"))) {
                this.advancedInstall = true;
            }
            if ((data = root.getChildNodes()) != null) {
                for (int i = 0; i < data.getLength(); ++i) {
                    Element element;
                    if (data.item(i).getNodeType() != 1 || !"selectGroup".equals((element = (Element)data.item(i)).getTagName())) continue;
                    this.selectGroups.add(element.getAttribute("name"));
                }
            }
        }
        catch (FileNotFoundException root) {
        }
        catch (IOException e) {
            Logging.log.info("Error Reading Select XML File: " + file);
            Logging.log.info(e.getMessage());
        }
        catch (Exception e) {
            Logging.log.info("Error Parsing Select XML File: " + file);
            Logging.log.info(e.getMessage());
        }
    }

    private void loadLevelCheckData(String file) {
        try {
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file)).getDocumentElement();
            NodeList nodes = root.getChildNodes();
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element;
                    if (nodes.item(i).getNodeType() != 1 || !"platform".equals((element = (Element)nodes.item(i)).getTagName())) continue;
                    LevelData levelData = new LevelData(element);
                    this.platformLevels.put(levelData.getPlatform(), levelData);
                }
            }
        }
        catch (FileNotFoundException root) {
        }
        catch (IOException e) {
            Logging.log.info("Error Reading Level Check XML File: " + file);
            Logging.log.info(e.getMessage());
        }
        catch (Exception e) {
            Logging.log.info("Error Parsing Level Check XML File: " + file);
            Logging.log.info(e.getMessage());
        }
    }

    private void loadRequirementData(String file) {
        try {
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file)).getDocumentElement();
            NodeList nodes = root.getChildNodes();
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element;
                    if (nodes.item(i).getNodeType() != 1 || !"platform".equals((element = (Element)nodes.item(i)).getTagName())) continue;
                    RequirementData requirementData = new RequirementData(element);
                    this.platformRequirements.put(requirementData.getPlatform(), requirementData);
                }
            }
        }
        catch (FileNotFoundException root) {
        }
        catch (IOException e) {
            Logging.log.info("Error Reading Required XML File: " + file);
            Logging.log.info(e.getMessage());
        }
        catch (Exception e) {
            Logging.log.info("Error Parsing Required XML File: " + file);
            Logging.log.info(e.getMessage());
        }
    }

    private void loadFileListData(String file, boolean loadFiles) {
        block13: {
            try {
                NodeList data;
                Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file)).getDocumentElement();
                if (!this.spsSku.equals(root.getAttribute("alt_sku"))) {
                    Logging.log.info("Mismatched ALT_SKU Value in FileList XML File: " + file);
                    break block13;
                }
                this.time = root.getAttribute("time");
                this.totalSize = root.getAttribute("size").toLowerCase(Locale.ENGLISH);
                if (!loadFiles || (data = root.getChildNodes()) == null) break block13;
                for (int i = 0; i < data.getLength(); ++i) {
                    Element fileElement;
                    int j;
                    NodeList files;
                    if (data.item(i).getNodeType() != 1) continue;
                    Element element = (Element)data.item(i);
                    if ("skupkg".equals(element.getTagName())) {
                        this.productSize = element.getAttribute("size").toLowerCase(Locale.ENGLISH);
                        files = element.getElementsByTagName("file");
                        if (files == null) continue;
                        for (j = 0; j < files.getLength(); ++j) {
                            fileElement = (Element)files.item(j);
                            if (Globals.g_mode != 6) {
                                this.productFiles.add(fileElement.getAttribute("name"));
                                continue;
                            }
                            if (fileElement.getAttribute("name").endsWith("/")) continue;
                            this.productFilesDC.put(fileElement.getAttribute("name"), new FileAttrData(fileElement.getAttribute("size"), fileElement.getAttribute("checksum")));
                        }
                        continue;
                    }
                    if (!"skudat".equals(element.getTagName())) continue;
                    this.dataSize = element.getAttribute("size").toLowerCase(Locale.ENGLISH);
                    files = element.getElementsByTagName("file");
                    if (files == null) continue;
                    for (j = 0; j < files.getLength(); ++j) {
                        fileElement = (Element)files.item(j);
                        if (Globals.g_mode != 6) {
                            this.dataFiles.add(fileElement.getAttribute("name"));
                            continue;
                        }
                        if (fileElement.getAttribute("name").endsWith("/")) continue;
                        this.dataFilesDC.put(fileElement.getAttribute("name"), new FileAttrData(fileElement.getAttribute("size"), fileElement.getAttribute("checksum")));
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.fileListFound = false;
                Logging.log.info("FileList XML File Not Found: " + file);
                Logging.log.info(e.getMessage());
                if (Globals.g_badOrderDataFiles != null) {
                    Globals.g_badOrderDataFiles.add(file);
                }
            }
            catch (IOException e) {
                Logging.log.info("Error Reading FileList XML File: " + file);
                Logging.log.info(e.getMessage());
                if (Globals.g_badOrderDataFiles != null) {
                    Globals.g_badOrderDataFiles.add(file);
                }
            }
            catch (Exception e) {
                Logging.log.info("Error Parsing FileList XML File: " + file);
                Logging.log.info(e.getMessage());
                if (Globals.g_badOrderDataFiles == null) break block13;
                Globals.g_badOrderDataFiles.add(file);
            }
        }
    }

    public void genDataFileList(File file) {
        this.time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(new File(file, "product.xml").lastModified()));
        long size = this.generateFileListData("DATA", file, file.getAbsolutePath().length() + 1, true);
        this.dataSize = "" + size;
        try {
            size += Long.parseLong(this.productSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.totalSize = "" + size;
    }

    public void genProductFileList(File file) {
        long size = this.generateFileListData("PROD", file, file.getAbsolutePath().length() + 1, !"sdwstartup".equals(this.prodCode));
        this.productSize = "" + size;
        try {
            size += Long.parseLong(this.dataSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.totalSize = "" + size;
    }

    private long generateFileListData(String section, File file, int chop, boolean recurse) {
        File[] files;
        long size = 0L;
        Vector vector = null;
        if ("DATA".equals(section)) {
            vector = this.dataFiles;
        } else if ("PROD".equals(section)) {
            vector = this.productFiles;
        }
        if (vector != null && (files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                String path = files[i].getAbsolutePath().substring(chop);
                if (Utils.getOS() == 1) {
                    path = Utils.stringReplaceAll(path, "\\", "/");
                }
                if (files[i].isDirectory()) {
                    if (!recurse) continue;
                    vector.add(path + "/");
                    size += this.generateFileListData(section, files[i], chop, recurse);
                    continue;
                }
                vector.add(path);
                size += files[i].length();
            }
        }
        return size;
    }

    public boolean writeFileList(String dir) {
        boolean valid = false;
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element current = doc.createElement("filelist");
            current.setAttribute("alt_sku", this.spsSku);
            current.setAttribute("size", this.totalSize);
            current.setAttribute("time", this.time);
            Element parent = (Element)doc.appendChild(current);
            current = doc.createElement("skupkg");
            current.setAttribute("size", this.productSize);
            parent = (Element)parent.appendChild(current);
            Enumeration e = this.productFiles.elements();
            while (e.hasMoreElements()) {
                current = doc.createElement("file");
                current.setAttribute("name", (String)e.nextElement());
                parent.appendChild(current);
            }
            parent = (Element)parent.getParentNode();
            current = doc.createElement("skudat");
            current.setAttribute("size", this.dataSize);
            parent = (Element)parent.appendChild(current);
            current = doc.createElement("file");
            current.setAttribute("name", "filelist.xml");
            parent.appendChild(current);
            e = this.dataFiles.elements();
            while (e.hasMoreElements()) {
                current = doc.createElement("file");
                current.setAttribute("name", (String)e.nextElement());
                parent.appendChild(current);
            }
            File file = new File(dir, "filelist.xml");
            if (file.getParentFile().isDirectory()) {
                file.createNewFile();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(file)));
                valid = true;
                Utils.removeBlankLines(file);
            }
        }
        catch (Exception e) {
            Logging.log.severe(e.getMessage());
        }
        return valid;
    }

    private void loadDeploymentXMLData(String file) {
        try {
            File deployXMLFile = new File(file);
            if (deployXMLFile.isFile()) {
                DeploymentXMLReader reader = new DeploymentXMLReader(deployXMLFile);
                this.targetByBaseHost = reader.isTargetByBaseHost();
                this.sysReq = reader.isSysReq();
                this.description = reader.getDescription();
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
    }

    private void loadLanguages(String file) {
        try {
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file)).getDocumentElement();
            NodeList data = root.getChildNodes();
            if (data != null) {
                for (int i = 0; i < data.getLength(); ++i) {
                    Element element;
                    if (data.item(i).getNodeType() != 1 || !"platform".equals((element = (Element)data.item(i)).getTagName())) continue;
                    String platform = element.getAttribute("id").toLowerCase(Locale.ENGLISH);
                    NodeList langData = element.getElementsByTagName("lang");
                    if (langData == null) continue;
                    for (int j = 0; j < langData.getLength(); ++j) {
                        String language = ((Element)langData.item(j)).getAttribute("code").toLowerCase(Locale.ENGLISH);
                        if (language.length() <= 0) continue;
                        Hashtable<String, Boolean> langHash = (Hashtable<String, Boolean>)this.platformLanguages.get(platform);
                        if (langHash == null) {
                            langHash = new Hashtable<String, Boolean>();
                            this.platformLanguages.put(platform, langHash);
                        }
                        boolean selectable = !"false".equals(((Element)langData.item(j)).getAttribute("selectable").toLowerCase(Locale.ENGLISH));
                        langHash.put(language, selectable);
                    }
                }
            }
        }
        catch (FileNotFoundException root) {
        }
        catch (IOException e) {
            Logging.log.info("Error Reading Languages XML File: " + file);
            Logging.log.info(e.getMessage());
        }
        catch (Exception e) {
            Logging.log.info("Error Parsing Languages XML File: " + file);
            Logging.log.info(e.getMessage());
        }
    }

    private String[] getErrors() {
        Vector<String> errors = new Vector<String>();
        if (this.spsSku.length() == 0) {
            errors.add("No ALT_SKU Value in PRODUCT Data");
        }
        if (this.prodCode.length() == 0) {
            errors.add("No 12_BYTE_CODE Value in PRODUCT Data");
        }
        if (this.version.length() == 0) {
            errors.add("No VERSION Value in PRODUCT Data");
        }
        if (this.displayName.isEmpty()) {
            errors.add("No Display Names in PRODUCT Data");
        }
        if (this.displayVersion.isEmpty()) {
            errors.add("No Display Versions in PRODUCT Data");
        }
        return errors.toArray(new String[0]);
    }

    public void setVolser(String volser) {
        this.volsers.add(volser);
    }

    public void removeVolser(String volser) {
        this.volsers.remove(volser);
    }

    public boolean isFileListFound() {
        return !Globals.g_genFileLists || this.fileListFound;
    }

    public String platformToDeploy(String platform) {
        String retVal = null;
        SkuData sku = this.skuList.get(platform);
        if (sku == null) {
            if ("wx6".equals(platform)) {
                sku = this.skuList.get("win");
            } else if ("lax".equals(platform) && (Globals.g_mode == 2 || Globals.g_sasinstallPlat != null)) {
                sku = this.skuList.get("lnx");
            } else if ("mvs".equals(platform) && Globals.g_z64) {
                sku = this.skuList.get("z64");
            }
        }
        if (sku != null) {
            retVal = sku.getPlatform();
        }
        return retVal;
    }

    public boolean isTargetByBaseHost() {
        return this.targetByBaseHost;
    }

    public boolean isSysReq() {
        return this.sysReq;
    }

    public String loadProdDescription() {
        return this.description;
    }

    public boolean isInstallable() {
        boolean retVal = false;
        SkuData[] skus = this.skuList.getAll();
        for (int i = 0; !retVal && i < skus.length; ++i) {
            retVal = skus[i].isInstallable();
        }
        return retVal;
    }

    public boolean isSelectable() {
        boolean retVal = false;
        SkuData[] skus = this.skuList.getAll();
        for (int i = 0; !retVal && i < skus.length; ++i) {
            retVal = skus[i].isSelectable();
        }
        return retVal;
    }

    public boolean requiresWebServer() {
        return this.requiresWebServer;
    }

    public boolean advancedInstall() {
        return this.advancedInstall;
    }

    public String getSpsSku() {
        return this.spsSku;
    }

    public String getProdCode() {
        return this.prodCode;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSASRelease() {
        return this.sasRelease;
    }

    public String getMaintLevel() {
        return this.maintLevel;
    }

    public boolean isDeltaRelease() {
        return this.altSkuType.equals(DELTA_SKU_TYPE);
    }

    public boolean isMaintLevelGreaterThanZero() {
        boolean isMaint = false;
        try {
            isMaint = this.maintLevel.length() > 0 && Integer.parseInt(this.maintLevel) > 0;
        }
        catch (NumberFormatException nfe) {
            Logging.log.severe("The maintLevel variable: \"" + this.maintLevel + "\" is not an integer value. Unable to determine the sku data maintenance level. Probable cause: incorrect maintenance data in product.xml for altsku:" + this.spsSku);
            Logging.logStackTrace(nfe);
        }
        return this.maintLevel.length() > 0 && Integer.parseInt(this.maintLevel) > 0;
    }

    public String getSequenceNum() {
        return this.sequenceNum;
    }

    public String getStatus() {
        return this.status;
    }

    public String getLastPortDate() {
        return this.lastPortDate;
    }

    public long getLastPortDateAsLong() {
        long time = 0L;
        try {
            if (this.lastPortDate.length() == 9) {
                time = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(this.lastPortDate, new ParsePosition(0)).getTime();
            }
        }
        catch (NullPointerException ex) {
            Logging.log.warning("Invalid last_port_date for package " + this.spsSku + ": " + this.lastPortDate);
        }
        return time;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean getIndb() {
        return this.indb;
    }

    public boolean getDoc() {
        return this.doc;
    }

    public String[] getVolsers() {
        return this.volsers.toArray(new String[0]);
    }

    public String[] getSelectGroups() {
        return this.selectGroups.toArray(new String[0]);
    }

    public SkuData[] getSkus() {
        return this.skuList.getAll();
    }

    public SkuData getSku(String platform) {
        return this.skuList.get(platform.toLowerCase(Locale.ENGLISH));
    }

    public String getDisplayName(String loc) {
        return (String)this.displayName.get(loc.toLowerCase(Locale.ENGLISH));
    }

    public String getDisplayVer(String loc) {
        return (String)this.displayVersion.get(loc.toLowerCase(Locale.ENGLISH));
    }

    public String getCustomerVer(String loc) {
        return (String)this.customerVersion.get(loc.toLowerCase(Locale.ENGLISH));
    }

    public String getTime() {
        return this.time;
    }

    public long getTimeAsLong() {
        long time = 0L;
        try {
            time = Long.parseLong(this.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return time;
    }

    public String[] getLanguages(String platform) {
        String[] langs = new String[]{};
        Hashtable langHash = (Hashtable)this.platformLanguages.get(platform.toLowerCase(Locale.ENGLISH));
        if (langHash == null && !"prt".equals(platform.toLowerCase(Locale.ENGLISH))) {
            langHash = (Hashtable)this.platformLanguages.get("prt");
        }
        if (langHash != null) {
            langs = langHash.keySet().toArray(new String[0]);
        }
        return langs;
    }

    public boolean isLanguageSelectable(String platform, String language) {
        boolean selectable = true;
        Hashtable langHash = (Hashtable)this.platformLanguages.get(platform.toLowerCase(Locale.ENGLISH));
        if (langHash == null && !"prt".equals(platform.toLowerCase(Locale.ENGLISH))) {
            langHash = (Hashtable)this.platformLanguages.get("prt");
        }
        if (langHash != null && langHash.get(language.toLowerCase(Locale.ENGLISH)) == Boolean.FALSE) {
            selectable = false;
        }
        return selectable;
    }

    public long getInstalledSize(String plat, String[] loc) {
        long size = 0L;
        if (plat != null) {
            String lcPlat = plat.toLowerCase(Locale.ENGLISH);
            String stringSize = (String)this.installedSize.get(lcPlat + "-xx");
            if (stringSize == null && !"prt".equals(lcPlat)) {
                stringSize = (String)this.installedSize.get("prt-xx");
            }
            if (stringSize == null) {
                stringSize = "0";
            }
            try {
                size += Long.parseLong(stringSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < loc.length; ++i) {
                String lcLoc;
                if (loc[i] == null || (lcLoc = loc[i].toLowerCase(Locale.ENGLISH)).equals("xx")) continue;
                stringSize = (String)this.installedSize.get(lcPlat + "-" + lcLoc);
                if (stringSize == null && !"prt".equals(lcPlat)) {
                    stringSize = (String)this.installedSize.get("prt-" + lcLoc);
                }
                if (stringSize == null) {
                    stringSize = "0";
                }
                try {
                    size += Long.parseLong(stringSize);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return size;
    }

    public String getTotalSize() {
        return this.totalSize;
    }

    public String getDataSize() {
        return this.dataSize;
    }

    public String getProductSize() {
        return this.productSize;
    }

    public String getRecommendedVersion(String platform) {
        String version = "";
        LevelData levelData = (LevelData)this.platformLevels.get(platform.toLowerCase(Locale.ENGLISH));
        if (levelData != null) {
            version = levelData.getRecommendedVersion();
        }
        return version;
    }

    public String[] getQueries(String platform) {
        String[] queries = new String[]{};
        LevelData levelData = (LevelData)this.platformLevels.get(platform.toLowerCase(Locale.ENGLISH));
        if (levelData != null) {
            queries = levelData.getQueries();
        }
        return queries;
    }

    public String getLevel(String version, String platform) {
        String level = null;
        LevelData levelData = (LevelData)this.platformLevels.get(platform.toLowerCase(Locale.ENGLISH));
        if (levelData != null) {
            level = levelData.getLevel(version);
        }
        return level;
    }

    public int getLevelAsInt(String version, String platform) {
        return Integer.parseInt(this.getLevel(version, platform));
    }

    public String[] getTypes(String platform) {
        String[] types = new String[]{};
        RequirementData requirementData = (RequirementData)this.platformRequirements.get(platform.toLowerCase(Locale.ENGLISH));
        if (requirementData != null) {
            types = requirementData.getTypes();
        }
        return types;
    }

    public String[] getRequires(String type, String platform) {
        String[] requirements = new String[]{};
        RequirementData requirementData = (RequirementData)this.platformRequirements.get(platform.toLowerCase(Locale.ENGLISH));
        if (requirementData != null) {
            requirements = requirementData.getRequiresData(type);
        }
        return requirements;
    }

    public String[] getRequiredBy(String type, String platform) {
        String[] requirements = new String[]{};
        RequirementData requirementData = (RequirementData)this.platformRequirements.get(platform.toLowerCase(Locale.ENGLISH));
        if (requirementData != null) {
            requirements = requirementData.getRequiredByData(type);
        }
        return requirements;
    }

    public String[] getDataFiles() {
        return this.dataFiles.toArray(new String[0]);
    }

    public String[] getProductFiles() {
        return this.productFiles.toArray(new String[0]);
    }

    public Set<String> getProductFilesDC() {
        return this.productFilesDC.keySet();
    }

    public Set<String> getDataFilesDC() {
        return this.dataFilesDC.keySet();
    }

    public Long getProductFilesDCsize(String file) {
        return this.productFilesDC.get(file).getSize();
    }

    public Long getDataFilesDCsize(String file) {
        return this.dataFilesDC.get(file).getSize();
    }

    public String getProductFilesDCchecksum(String file) {
        return this.productFilesDC.get(file).getChecksum();
    }

    public String getDataFilesDCchecksum(String file) {
        return this.dataFilesDC.get(file).getChecksum();
    }

    public String getMiscValue(String key) {
        return (String)this.miscData.get(key);
    }

    public boolean isStandardLanguage() {
        return "xx".equals(this.language) || "en".equals(this.language) || "ne".equals(this.language);
    }

    private class FileAttrData {
        String size = null;
        String checksum = null;

        private FileAttrData(String size, String checksum) {
            this.size = size;
            this.checksum = checksum;
        }

        private long getSize() {
            if ("".equals(this.size)) {
                return -1L;
            }
            return Long.parseLong(this.size);
        }

        private String getChecksum() {
            return this.checksum;
        }
    }

    private class RequirementData {
        private String platform;
        private Vector types = new Vector();
        private Hashtable requires = new Hashtable();
        private Hashtable requiredBy = new Hashtable();

        private RequirementData(Element root) {
            this.platform = root.getAttribute("id").toLowerCase(Locale.ENGLISH);
            NodeList nodes = root.getChildNodes();
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    if (nodes.item(i).getNodeType() != 1) continue;
                    Element element = (Element)nodes.item(i);
                    if ("requires".equals(element.getTagName())) {
                        this.loadRequirements(element, this.requires);
                        continue;
                    }
                    if (!"requiredBy".equals(element.getTagName())) continue;
                    this.loadRequirements(element, this.requiredBy);
                }
            }
        }

        private void loadRequirements(Element root, Hashtable hashtable) {
            List<String> processTypes;
            String xmlType = root.getAttribute("type").toLowerCase(Locale.ENGLISH);
            if ("".equals(xmlType)) {
                processTypes = OrderData.DEFAULT_REQ_TYPES;
            } else {
                processTypes = new ArrayList<String>(1);
                processTypes.add(xmlType);
            }
            for (String type : processTypes) {
                NodeList nodes;
                Vector<String> vector = (Vector<String>)hashtable.get(type);
                if (vector == null) {
                    vector = new Vector<String>();
                    hashtable.put(type, vector);
                    this.types.add(type);
                }
                if ((nodes = root.getChildNodes()) == null) continue;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String code;
                    Element element;
                    if (nodes.item(i).getNodeType() != 1 || !"target".equals((element = (Element)nodes.item(i)).getTagName()) || (code = element.getAttribute("code")) == null) continue;
                    vector.add(code);
                }
            }
        }

        public String getPlatform() {
            return this.platform;
        }

        public String[] getTypes() {
            return this.types.toArray(new String[0]);
        }

        public String[] getRequiresData(String type) {
            String[] data = new String[]{};
            Vector vector = (Vector)this.requires.get(type);
            if (vector != null) {
                data = vector.toArray(new String[0]);
            }
            return data;
        }

        public String[] getRequiredByData(String type) {
            String[] data = new String[]{};
            Vector vector = (Vector)this.requiredBy.get(type);
            if (vector != null) {
                data = vector.toArray(new String[0]);
            }
            return data;
        }
    }

    private class LevelData {
        private String platform;
        private String undefined;
        private String recommended;
        private String[] levelOrder = new String[0];
        private Vector queries = new Vector();
        private Hashtable levelHash = new Hashtable();

        private LevelData(Element root) {
            this.platform = root.getAttribute("id").toLowerCase(Locale.ENGLISH);
            this.undefined = root.getAttribute("default");
            this.recommended = root.getAttribute("recommended");
            StringTokenizer st = new StringTokenizer(root.getAttribute("order"), ",");
            this.levelOrder = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                this.levelOrder[i] = st.nextToken().trim();
                ++i;
            }
            NodeList nodes = root.getChildNodes();
            if (nodes != null) {
                for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                    if (nodes.item(i2).getNodeType() != 1) continue;
                    Element element = (Element)nodes.item(i2);
                    if ("queries".equals(element.getTagName())) {
                        this.loadQueries(element);
                        continue;
                    }
                    if (!"level".equals(element.getTagName())) continue;
                    this.loadLevel(element);
                }
            }
        }

        private void loadQueries(Element root) {
            NodeList nodes = root.getChildNodes();
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element;
                    if (nodes.item(i).getNodeType() != 1 || !"query".equals((element = (Element)nodes.item(i)).getTagName())) continue;
                    this.queries.add(element.getAttribute("ver"));
                }
            }
        }

        private void loadLevel(Element root) {
            NodeList nodes;
            String level = root.getAttribute("id").trim();
            Vector<String> checks = (Vector<String>)this.levelHash.get(level);
            if (checks == null) {
                checks = new Vector<String>();
                this.levelHash.put(level, checks);
            }
            if ((nodes = root.getChildNodes()) != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element;
                    if (nodes.item(i).getNodeType() != 1 || !"check".equals((element = (Element)nodes.item(i)).getTagName())) continue;
                    checks.add(element.getAttribute("pattern"));
                }
            }
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getRecommendedVersion() {
            return this.recommended;
        }

        public String[] getQueries() {
            return this.queries.toArray(new String[0]);
        }

        public String getLevel(String version) {
            String level = null;
            if (version != null) {
                for (int i = 0; level == null && i < this.levelOrder.length; ++i) {
                    String currentLevel = this.levelOrder[i];
                    Vector checks = (Vector)this.levelHash.get(currentLevel);
                    if (checks == null) continue;
                    Iterator checkIter = checks.iterator();
                    while (level == null && checkIter.hasNext()) {
                        if (!Pattern.compile((String)checkIter.next()).matcher(version).find()) continue;
                        level = currentLevel;
                    }
                }
            }
            if (level == null) {
                level = this.undefined;
            }
            return level;
        }
    }

    private class SkuList {
        private Hashtable skuHash = new Hashtable();

        public boolean add(SkuData product) {
            String platform;
            boolean added = false;
            if (product != null && (platform = product.getPlatform()) != null && !this.skuHash.containsKey(platform)) {
                this.skuHash.put(platform, product);
                added = true;
            }
            return added;
        }

        public SkuData get(String platform) {
            try {
                return (SkuData)this.skuHash.get(platform.toLowerCase(Locale.ENGLISH));
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        public SkuData[] getAll() {
            return this.skuHash.values().toArray(new SkuData[0]);
        }
    }
}

