/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.OrderData;
import com.sas.ssn.SkuFilterIface;
import com.sas.ssn.SpsSkuData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SkuRequirementsForOrder {
    private static final int FIND_REQUIREMENTS = 0;
    private static final int FIND_REQUIRED_BYS = 1;
    public static final String ALL_PLATFORMS = "default";
    public static final String TRIGGERS_INSTALL = "triggers_install";
    public static final String BLOCKS_UNINSTALL = "blocks_uninstall";
    private static final String TRIGGERS_INSTALL_ELMT_NAME = "triggersInstall";
    private static final String TRIGGERS_AND_BLOCKS_ELMT_NAME = "req";
    private static final Map<String, List<String>> reqTypeToElementMap = new HashMap<String, List<String>>(2);
    private static SkuFilterIface includeEverythingSkuFilter;
    private OrderData order;
    private String requirementType;
    private Hashtable<String, PlatformRequirements> requirements = new Hashtable();

    public SkuRequirementsForOrder(OrderData order) {
        this.order = order;
        this.requirementType = TRIGGERS_INSTALL;
    }

    public SkuRequirementsForOrder(OrderData order, String type) {
        this.order = order;
        this.requirementType = type;
    }

    public void loadSkuReqElement(String platform, Element root, String reqType) {
        NodeList data;
        String oneSku = root.getAttribute("id");
        List<String> desiredElmtNames = reqTypeToElementMap.get(reqType);
        if (oneSku != null && (data = root.getChildNodes()) != null) {
            for (int i = 0; i < data.getLength(); ++i) {
                Element element;
                String elmtTagName;
                if (data.item(i).getNodeType() != 1 || !desiredElmtNames.contains(elmtTagName = (element = (Element)data.item(i)).getTagName())) continue;
                this.addRequirement(platform, oneSku, element.getAttribute("id"));
            }
        }
    }

    public void addRequirement(String platform, String requiringSku, String requiredSku) {
        if (platform == null) {
            platform = ALL_PLATFORMS;
        }
        if (requiringSku != null && requiredSku != null) {
            PlatformRequirements platformRequirements = this.requirements.get(platform);
            if (platformRequirements == null) {
                platformRequirements = new PlatformRequirements();
                this.requirements.put(platform, platformRequirements);
            }
            platformRequirements.addRequirement(requiringSku, requiredSku);
        }
    }

    public void addRequirement(String requiringSku, String requiredSku) {
        this.addRequirement(null, requiringSku, requiredSku);
    }

    public void loadSkuReqElement(Element root, String reqType) {
        this.loadSkuReqElement(null, root, reqType);
    }

    public void loadSpsSkuDataReqs(String platform, SpsSkuData spsSkuData, SkuFilterIface filter) {
        String[] prodCodeRequirements = spsSkuData.getRequires(this.requirementType, platform);
        String[] prodCodeRequiredBys = spsSkuData.getRequiredBy(this.requirementType, platform);
        if (prodCodeRequirements.length > 0 || prodCodeRequiredBys.length > 0) {
            SpsSkuData tryNonMaint;
            if (spsSkuData.isDeltaRelease() && (tryNonMaint = this.order.getSpsSkuDataForFullSkuTypes(spsSkuData.getProdCode(), platform, filter)) != null) {
                spsSkuData = tryNonMaint;
            }
            for (String oneRequirement : prodCodeRequirements) {
                SpsSkuData oneReqSkuData = this.order.getSpsSkuDataForFullSkuTypes(oneRequirement, platform, filter);
                if (oneReqSkuData == null) continue;
                this.addRequirement(platform, spsSkuData.getSpsSku(), oneReqSkuData.getSpsSku());
            }
            for (String oneRequiredBy : prodCodeRequiredBys) {
                SpsSkuData oneReqBySkuData = this.order.getSpsSkuDataForFullSkuTypes(oneRequiredBy, platform, filter);
                if (oneReqBySkuData == null) continue;
                this.addRequirement(platform, oneReqBySkuData.getSpsSku(), spsSkuData.getSpsSku());
            }
        }
    }

    public OrderData getOrder() {
        return this.order;
    }

    public String getType() {
        return this.requirementType;
    }

    public HashSet<String> getImmediateSkuRequirements(String platform, String sku, SkuFilterIface filter) {
        return this.getImmediateSkuReqDriver(platform, sku, filter, 0);
    }

    public HashSet<String> getImmediateSkuRequiredBys(String platform, String sku, SkuFilterIface filter) {
        return this.getImmediateSkuReqDriver(platform, sku, filter, 1);
    }

    private HashSet<String> getImmediateSkuReqDriver(String platform, String sku, SkuFilterIface filter, int whatToFind) {
        if (filter == null) {
            filter = SkuRequirementsForOrder.getIncludeEverythingSkuFilter();
        }
        return this.getImmediateSkuRequirementSet(platform, sku, filter, whatToFind);
    }

    public static SkuFilterIface getIncludeEverythingSkuFilter() {
        if (includeEverythingSkuFilter == null) {
            includeEverythingSkuFilter = new SkuFilterIface(){

                @Override
                public String getFilteredSku(String sku, OrderData order, String platform) {
                    return sku;
                }

                @Override
                public String getFilteredSku(SpsSkuData spsSkuData, OrderData order, String platform) {
                    String sku = null;
                    if (spsSkuData != null) {
                        sku = spsSkuData.getSpsSku();
                    }
                    return sku;
                }
            };
        }
        return includeEverythingSkuFilter;
    }

    private HashSet<String> getCheckPlatforms(String platform) {
        HashSet<String> checkPlatforms = new HashSet<String>();
        checkPlatforms.add(ALL_PLATFORMS);
        if (platform != null) {
            checkPlatforms.add(platform);
        }
        return checkPlatforms;
    }

    private HashSet<String> getImmediateSkuRequirementSet(String platform, String sku, SkuFilterIface filter, int whatToFind) {
        HashSet<String> immediateSkus = new HashSet<String>();
        HashSet<String> checkPlatforms = this.getCheckPlatforms(platform);
        for (String checkPlatform : checkPlatforms) {
            PlatformRequirements platformRequirements = this.requirements.get(checkPlatform);
            if (platformRequirements == null) continue;
            if (whatToFind == 1) {
                immediateSkus.addAll(platformRequirements.getImmediateSkuRequiredBys(sku, filter, this.order, platform));
                continue;
            }
            immediateSkus.addAll(platformRequirements.getImmediateSkuRequires(sku, filter, this.order, platform));
        }
        return immediateSkus;
    }

    public HashSet<String> getFullSkuRequirements(String platform, String sku, SkuFilterIface filter) {
        return this.getFullSkuReqDriver(platform, sku, filter, 0);
    }

    public HashSet<String> getFullSkuRequiredBys(String platform, String sku, SkuFilterIface filter) {
        return this.getFullSkuReqDriver(platform, sku, filter, 1);
    }

    private HashSet<String> getFullSkuReqDriver(String platform, String sku, SkuFilterIface filter, int whatToFind) {
        HashSet<String> seenSkus = new HashSet<String>();
        if (filter == null) {
            filter = SkuRequirementsForOrder.getIncludeEverythingSkuFilter();
        }
        seenSkus.add(sku);
        this.buildFullSkuRequirementSet(platform, sku, seenSkus, filter, whatToFind);
        seenSkus.remove(sku);
        return seenSkus;
    }

    private void buildFullSkuRequirementSet(String platform, String sku, HashSet<String> seenSkus, SkuFilterIface filter, int whatToFind) {
        HashSet<String> immediateSkus = this.getImmediateSkuRequirementSet(platform, sku, filter, whatToFind);
        for (String nextSku : immediateSkus) {
            if (seenSkus.contains(nextSku)) continue;
            seenSkus.add(nextSku);
            this.buildFullSkuRequirementSet(platform, nextSku, seenSkus, filter, whatToFind);
        }
    }

    static {
        reqTypeToElementMap.put(TRIGGERS_INSTALL, Arrays.asList(TRIGGERS_AND_BLOCKS_ELMT_NAME, TRIGGERS_INSTALL_ELMT_NAME));
        reqTypeToElementMap.put(BLOCKS_UNINSTALL, Arrays.asList(TRIGGERS_AND_BLOCKS_ELMT_NAME));
    }

    private class PlatformRequirements {
        private Hashtable<String, HashSet<String>> requirements = new Hashtable();

        private PlatformRequirements() {
        }

        private void addRequirement(String requiringSku, String requiredSku) {
            if (requiringSku != null && requiredSku != null) {
                HashSet<String> knownReqs = this.requirements.get(requiringSku);
                if (knownReqs == null) {
                    knownReqs = new HashSet();
                    this.requirements.put(requiringSku, knownReqs);
                }
                knownReqs.add(requiredSku);
            }
        }

        private HashSet<String> getImmediateSkuRequires(String sku, SkuFilterIface filter, OrderData order, String platform) {
            HashSet<String> returnSet = new HashSet<String>();
            HashSet<String> currSkuReqs = this.requirements.get(sku);
            if (currSkuReqs != null) {
                for (String required : currSkuReqs) {
                    String filteredSku = filter.getFilteredSku(required, order, platform);
                    if (filteredSku == null) continue;
                    returnSet.add(filteredSku);
                }
            }
            return returnSet;
        }

        private HashSet<String> getImmediateSkuRequiredBys(String sku, SkuFilterIface filter, OrderData order, String platform) {
            HashSet<String> returnSet = new HashSet<String>();
            if (sku != null) {
                for (String requirer : this.requirements.keySet()) {
                    HashSet<String> requireds;
                    String filteredRequirer = filter.getFilteredSku(requirer, order, platform);
                    if (filteredRequirer == null || !filteredRequirer.equals(requirer) || (requireds = this.requirements.get(requirer)) == null) continue;
                    Iterator<String> requiredsIt = requireds.iterator();
                    boolean stillSearching = true;
                    while (requiredsIt.hasNext() && stillSearching) {
                        String required = requiredsIt.next();
                        String filteredRequired = filter.getFilteredSku(required, order, platform);
                        if (!sku.equals(filteredRequired)) continue;
                        returnSet.add(filteredRequirer);
                        stillSearching = false;
                    }
                }
            }
            return returnSet;
        }
    }
}

