/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SkuData {
    private String sku;
    private String platform;
    private Hashtable installTypes = new Hashtable();
    private Hashtable misc = new Hashtable();

    public SkuData(Element root) {
        this.sku = root.getAttribute("sku");
        this.platform = root.getAttribute("plat").toLowerCase(Locale.ENGLISH);
        NodeList data = root.getChildNodes();
        if (data != null) {
            for (int i = 1; i < data.getLength(); ++i) {
                if (data.item(i).getNodeType() != 1) continue;
                Element element = (Element)data.item(i);
                if ("install".equals(element.getTagName())) {
                    InstallTypeData installData = new InstallTypeData(element);
                    this.installTypes.put(installData.getType(), installData);
                    continue;
                }
                this.misc.put(element.getTagName(), element.getAttribute("v"));
            }
        }
        String[] errors = this.getErrors();
        for (int i = 0; i < errors.length; ++i) {
            Logging.log.fine(errors[i] + ": " + this.sku);
        }
    }

    private String[] getErrors() {
        Vector<String> errors = new Vector<String>();
        String selectable = this.getMiscValue("selectable");
        if (selectable == null) {
            errors.add("No SELECTABLE Value is Defined");
        } else if (!"true".equals(selectable = selectable.toLowerCase(Locale.ENGLISH)) && !"false".equals(selectable)) {
            errors.add("Invalid SELECTABLE Value Defined");
        }
        if (this.installTypes.get("silent") != null && this.installTypes.get("interactive") == null) {
            errors.add("No Interactive Install Type in PRODUCT Data");
        }
        return errors.toArray(new String[0]);
    }

    public String getSku() {
        return this.sku;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getMiscValue(String key) {
        String retVal = Globals.g_allSelectable && "selectable".equals(key) ? (this.sku.startsWith("privatejre") ? "false" : "true") : (String)this.misc.get(key);
        return retVal;
    }

    public InstallTypeData getInstallType(String type) {
        return (InstallTypeData)this.installTypes.get(type);
    }

    public boolean isInstallable(String type) {
        boolean retVal = false;
        InstallTypeData installType = this.getInstallType(type);
        if (installType != null) {
            retVal = installType.isInstallable();
        }
        return retVal;
    }

    public boolean isInstallable() {
        boolean retVal = false;
        Enumeration e = this.installTypes.keys();
        while (!retVal && e.hasMoreElements()) {
            retVal = this.isInstallable((String)e.nextElement());
        }
        return retVal;
    }

    public boolean isSelectable() {
        return "true".equalsIgnoreCase(this.getMiscValue("selectable"));
    }

    public class InstallTypeData
    extends Hashtable {
        private String type;
        private Vector keyFileDataList;
        private Vector regLocDataList;
        private Vector defaultLocDataList;

        public InstallTypeData(Element root) {
            NodeList data;
            this.type = root.getAttribute("type").toLowerCase(Locale.ENGLISH);
            if ("prompt".equals(this.type)) {
                this.keyFileDataList = new Vector();
                this.regLocDataList = new Vector();
                this.defaultLocDataList = new Vector();
            }
            if ((data = root.getChildNodes()) != null) {
                for (int i = 1; i < data.getLength(); ++i) {
                    if (data.item(i).getNodeType() != 1) continue;
                    Element element = (Element)data.item(i);
                    if (this.keyFileDataList != null && "keyFile".equals(element.getTagName())) {
                        this.keyFileDataList.add(new KeyFileData(element));
                        continue;
                    }
                    if (this.regLocDataList != null && "regLoc".equals(element.getTagName())) {
                        this.regLocDataList.add(new RegLocData(element));
                        continue;
                    }
                    if (this.defaultLocDataList != null && "defaultLoc".equals(element.getTagName())) {
                        this.defaultLocDataList.add(new DefaultLocData(element));
                        continue;
                    }
                    element = (Element)data.item(i);
                    this.put(element.getTagName(), element.getAttribute("v"));
                }
            }
        }

        public String getType() {
            return this.type;
        }

        public String getMiscValue(String key) {
            return (String)this.get(key);
        }

        public boolean isInstallable() {
            boolean retVal = false;
            String cmd = (String)this.get("cmd");
            if (cmd != null) {
                retVal = cmd.length() > 0;
            }
            return retVal;
        }

        public class DefaultLocData {
            private String path;

            public DefaultLocData(Element root) {
                this.path = root.getAttribute("path");
            }
        }

        public class RegLocData {
            private String section;
            private String key;
            private String name;

            public RegLocData(Element root) {
                this.section = root.getAttribute("section");
                this.key = root.getAttribute("key");
                this.name = root.getAttribute("name");
            }
        }

        public class KeyFileData {
            private String file;
            private String version;

            public KeyFileData(Element root) {
                this.file = root.getAttribute("file");
                this.version = root.getAttribute("ver");
            }
        }
    }
}

