/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.HotFixManager;
import com.sas.ssn.HotFixPackages;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class SecurityUpdates {
    private String sasHome = "";
    private String[] securityUpdatePackagesInSASHome = new String[0];
    private String newestSecurityUpdateID = "";
    private boolean securiyUpdatesInSASHomeCheckedFor = false;
    private final String securityUpdateProdCode = "instqualtool";
    private final String instqualToolHotFixSkuFormat = "instqualtool__%s__prt__xx__sp0__1";
    private final String instqualToolHotFixNameFormat = "%spt.zip";
    private final String relSecurityUpdatesDir = "InstallMisc/HotFixes/SecurityUpdates";

    public SecurityUpdates(String sasHome) {
        this.sasHome = sasHome;
    }

    private List<Integer> findIndexesForSecurityUpdatesInHotFixChain(List<HotFix> hotFixesToInstall) {
        ArrayList<Integer> securityUpdateIndexes = new ArrayList<Integer>();
        int hotFixListIndex = 0;
        ListIterator<HotFix> it = hotFixesToInstall.listIterator();
        while (it.hasNext()) {
            hotFixListIndex = it.nextIndex();
            HotFix hotFix = it.next();
            String prodCode = hotFix.getProdCode();
            Boolean isSecurityFix = hotFix.isSecurityFix();
            if (!prodCode.equalsIgnoreCase(this.securityUpdateProdCode) || !isSecurityFix.booleanValue()) continue;
            securityUpdateIndexes.add(hotFixListIndex);
        }
        return securityUpdateIndexes;
    }

    private boolean applyNewestToHotFixChain(List<HotFix> hotFixesToInstall, List<Integer> indexes) {
        HotFix newerSecurityUpdate = this.getNewestSecurityUpdate();
        if (newerSecurityUpdate == null) {
            Logging.log.info("There are no applicable securty updates in SASHome's SecurityUpdates directory.");
            return false;
        }
        String msg = String.format("A newer security update was found, %s, in ", newerSecurityUpdate.getHotFixID(), this.getSecurityUpdatesDir().getAbsolutePath());
        Logging.log.info(msg);
        Logging.log.info("Updating the install chain with the newer security update.");
        if (indexes == null || indexes.isEmpty()) {
            hotFixesToInstall.add(newerSecurityUpdate);
            return true;
        }
        if (indexes.size() == 1) {
            this.replaceHotFixChainWithNewerSecurityUpdate(hotFixesToInstall, indexes.get(0), newerSecurityUpdate);
            return true;
        }
        Logging.log.warning("There are multiple security hot fixes in the hot fix chain. There should only be one. Unable to apply newer security hot fix.");
        return false;
    }

    private HotFix getNewestSecurityUpdate() {
        List<Object> securityHotFixCandidates = new ArrayList(10);
        String order = "postInstallHotFixes";
        this.newestSecurityUpdateID = "";
        String[] securityUpdateCandidates = this.getSecurityUpdatePackagesFromSASHome();
        if (securityUpdateCandidates == null || securityUpdateCandidates.length == 0) {
            return null;
        }
        ProductData instqualtoolProdData = Globals.g_deploymentData.getProduct(Globals.g_order, "instqualtool", false);
        if (instqualtoolProdData == null) {
            return null;
        }
        String instqualtoolMaint = instqualtoolProdData.getProdMaint();
        String instqualtoolVersion = instqualtoolProdData.getProdVersion();
        File securityUpdatesDir = this.getSecurityUpdatesDir();
        HotFixManager securityHotFixManager = new HotFixManager(order, securityUpdatesDir.getPath(), "hot_fix_post_install_index.xml");
        if (securityHotFixManager.createIndexFromHotFixPackageDirectory()) {
            HotFixPackages hotFixPackages = new HotFixPackages();
            hotFixPackages.setIndex(securityHotFixManager.getHotFixIndex());
            hotFixPackages.setHotFixPackagesDirectory(securityUpdatesDir.getPath());
            if (hotFixPackages.loadPackages(order, false, Utils.GetSDWVersion())) {
                securityHotFixCandidates = hotFixPackages.getPostInstallHotFixesToInstall(true);
            }
        }
        ArrayList<HotFix> passedMaintVersionCheckCandidates = new ArrayList<HotFix>(securityHotFixCandidates.size());
        for (HotFix securityFix : securityHotFixCandidates) {
            String securityMax;
            String securityMin;
            String securityVersion;
            if (!securityFix.isSecurityFix() || !this.hasRequiredMaintenanceFor(securityVersion = securityFix.getProdVersion(), securityMin = securityFix.getHotFixMinMaintVersion(), securityMax = securityFix.getHotFixMaxMaintVersion(), instqualtoolMaint, instqualtoolVersion)) continue;
            passedMaintVersionCheckCandidates.add(securityFix);
        }
        int newestIndex = -1;
        if (passedMaintVersionCheckCandidates.size() == 1) {
            this.newestSecurityUpdateID = ((HotFix)passedMaintVersionCheckCandidates.get(0)).getHotFixName();
            newestIndex = 0;
        } else {
            String newest = "";
            int maxIndex = passedMaintVersionCheckCandidates.size() - 1;
            for (int i = 0; i <= maxIndex; ++i) {
                if (i == 0) {
                    newest = ((HotFix)passedMaintVersionCheckCandidates.get(i)).getHotFixName();
                    newestIndex = 0;
                    continue;
                }
                String next = ((HotFix)passedMaintVersionCheckCandidates.get(i)).getHotFixName();
                if (next.compareToIgnoreCase(newest) <= 0) continue;
                newest = next;
                newestIndex = i;
            }
            this.setNewestSecurityUpdateID(newest);
        }
        if (newestIndex == -1) {
            return null;
        }
        return (HotFix)passedMaintVersionCheckCandidates.get(newestIndex);
    }

    public String getNewestSecurityUpdateID() {
        return this.newestSecurityUpdateID;
    }

    private String[] getSecurityUpdatePackagesFromSASHome() {
        String[] securityUpdatePackages = this.getSecurityUpdatesDir().list(new FilenameFilter(){

            @Override
            public boolean accept(File securityUpdatesDir, String name) {
                return name.toLowerCase().endsWith(".zip");
            }
        });
        return securityUpdatePackages;
    }

    private String[] getSecurityUpdatePackagesFromSASHome(boolean forceRescan) {
        if (forceRescan || !this.securiyUpdatesInSASHomeCheckedFor) {
            File securityUpdatesDir = this.getSecurityUpdatesDir();
            this.securityUpdatePackagesInSASHome = securityUpdatesDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File securityUpdatesDir, String name) {
                    return name.toLowerCase().endsWith(".zip");
                }
            });
            this.securiyUpdatesInSASHomeCheckedFor = true;
        }
        return this.securityUpdatePackagesInSASHome;
    }

    private String getSecurityUpdatePrefix(String securityUpdateID) {
        if (securityUpdateID == null || securityUpdateID.length() < 6) {
            return "";
        }
        return securityUpdateID.substring(0, 3);
    }

    private File getSecurityUpdatesDir() {
        File securityUpdatesDir = new File(this.sasHome, this.relSecurityUpdatesDir);
        return securityUpdatesDir;
    }

    private boolean hasRequiredMaintenanceFor(String hotFixVersion, String hotFixMinMaintVer, String hotFixMaxMaintVer, String productMaintVer, String productVersion) {
        Integer productMaint = -1;
        Integer hotFixMinMaint = -1;
        Integer hotFixMaxMaint = -1;
        if (productMaintVer != null && productMaintVer.length() > 0) {
            productMaint = Integer.valueOf(productMaintVer);
        }
        if (hotFixMinMaintVer != null && hotFixMinMaintVer.length() > 0) {
            hotFixMinMaint = Integer.valueOf(hotFixMinMaintVer);
        }
        if (hotFixMaxMaintVer != null && hotFixMaxMaintVer.length() > 0) {
            hotFixMaxMaint = Integer.valueOf(hotFixMaxMaintVer);
        }
        if (!hotFixVersion.equalsIgnoreCase(productVersion)) {
            return false;
        }
        if (hotFixMinMaint > -1 && hotFixMinMaint < productMaint) {
            return false;
        }
        return hotFixMaxMaint <= -1 || productMaint <= hotFixMaxMaint;
    }

    private void setNewestSecurityUpdateID(String newestSecurityUpdateID) {
        this.newestSecurityUpdateID = newestSecurityUpdateID;
    }

    private void replaceHotFixChainWithNewerSecurityUpdate(List<HotFix> hotFixesToInstall, Integer index, HotFix newerSecurityUpdate) {
        String securityHotFixName = hotFixesToInstall.get(index).getHotFixName();
        String candidateName = newerSecurityUpdate.getHotFixName();
        if (candidateName.compareTo(securityHotFixName) > 0) {
            String msg = String.format("Replacing %s with %s", securityHotFixName, candidateName);
            Logging.log.info(msg);
            int i = (int)Integer.toUnsignedLong(index);
            hotFixesToInstall.remove(i);
            hotFixesToInstall.add(newerSecurityUpdate);
        }
    }

    public boolean updateSecurityUpdatesInHotFixInstallChain(List<HotFix> hotFixesToInstall) {
        boolean newerSecurityUpdatesFound = false;
        String[] securityUpdateCandidates = this.getSecurityUpdatePackagesFromSASHome(true);
        if (securityUpdateCandidates.length == 0) {
            String msg = String.format("There were no security update packages found at %s", this.getSecurityUpdatesDir().getAbsolutePath());
            Logging.log.info(msg);
            return newerSecurityUpdatesFound;
        }
        List<Integer> indexes = this.findIndexesForSecurityUpdatesInHotFixChain(hotFixesToInstall);
        return this.applyNewestToHotFixChain(hotFixesToInstall, indexes);
    }

    public List<HotFix> removeOldSecurityHotFixes(List<HotFix> hotFixesToInstall) {
        if (hotFixesToInstall.size() == 1) {
            return hotFixesToInstall;
        }
        int newestIndex = -1;
        String newest = "";
        int maxIndex = hotFixesToInstall.size() - 1;
        ArrayList<HotFix> tempHotFixes = new ArrayList<HotFix>(hotFixesToInstall.size());
        for (int i = 0; i <= maxIndex; ++i) {
            if (!hotFixesToInstall.get(i).isSecurityFix()) {
                tempHotFixes.add(hotFixesToInstall.get(i));
                continue;
            }
            if (i == 0) {
                newest = hotFixesToInstall.get(i).getHotFixName();
                newestIndex = 0;
                continue;
            }
            String next = hotFixesToInstall.get(i).getHotFixName();
            if (next.compareToIgnoreCase(newest) <= 0) continue;
            newest = next;
            newestIndex = i;
        }
        if (newestIndex > -1) {
            tempHotFixes.add(hotFixesToInstall.get(newestIndex));
        }
        return tempHotFixes;
    }
}

