/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class SSNResource {
    protected static Hashtable m_bundleCache;
    protected static Hashtable<String, ResourceBundle> m_enBundleCache;
    protected boolean m_bResourceFileMissing = false;
    protected String m_strResourceFileName;
    protected ResourceBundle m_bundle;
    protected ClassLoader m_classLoader;

    public SSNResource(String strResourceFileName) {
        this.m_bundle = this._getBundle(strResourceFileName);
    }

    public SSNResource(Class source) {
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_bundle = this._getBundle(strPackageName + ".PropertyBundle");
    }

    public static SSNResource EnglishResource(Class source) {
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        return SSNResource.EnglishResource(strPackageName + ".PropertyBundle");
    }

    public static SSNResource EnglishResource(String strResourceFileName) {
        SSNResource res = new SSNResource(strResourceFileName);
        res.m_bundle = res._getEnglishBundle(strResourceFileName);
        return res;
    }

    protected ResourceBundle getCachedBundle(String key) {
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        }
        return (ResourceBundle)m_bundleCache.get(key);
    }

    protected ResourceBundle getCachedEnBundle(String key) {
        if (m_enBundleCache == null) {
            m_enBundleCache = new Hashtable();
        }
        return m_enBundleCache.get(key);
    }

    protected void cacheBundle(String key, ResourceBundle bundle) {
        m_bundleCache.put(key, bundle);
    }

    protected void cacheEnBundle(String key, ResourceBundle bundle) {
        m_enBundleCache.put(key, bundle);
    }

    protected ResourceBundle _getBundle(String strBundlePath) {
        ResourceBundle returnValue = this.getCachedBundle(strBundlePath);
        if (returnValue != null) {
            return returnValue;
        }
        Locale locale = Language.gs_SelectedLanguage == "" ? new Locale(Utils.localeTwoLangCode(Locale.getDefault())) : new Locale(Language.gs_SelectedLanguage);
        try {
            returnValue = ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            try {
                returnValue = PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                this.m_bResourceFileMissing = true;
                Logging.log.severe(e2.getMessage());
                return null;
            }
        }
        this.cacheBundle(strBundlePath, returnValue);
        this.m_strResourceFileName = strBundlePath;
        return returnValue;
    }

    protected ResourceBundle _getEnglishBundle(String strBundlePath) {
        return this._getEnglishBundle(strBundlePath, null);
    }

    protected ResourceBundle _getEnglishBundle(String strBundlePath, ClassLoader classLoader) {
        ResourceBundle returnValue = this.getCachedEnBundle(strBundlePath);
        if (returnValue != null) {
            return returnValue;
        }
        Locale locale = Locale.US;
        try {
            returnValue = classLoader != null ? ResourceBundle.getBundle(strBundlePath, locale, classLoader) : ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            try {
                returnValue = classLoader != null ? PropertyResourceBundle.getBundle(strBundlePath, locale, classLoader) : PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                this.m_bResourceFileMissing = true;
                return null;
            }
        }
        if (classLoader == null) {
            this.cacheEnBundle(strBundlePath, returnValue);
        } else {
            this.cacheEnBundle(strBundlePath + classLoader.hashCode(), returnValue);
        }
        this.m_strResourceFileName = strBundlePath;
        return returnValue;
    }

    public void clearBundleCache() {
        m_bundleCache.clear();
    }

    public void clearEnBundleCache() {
        m_enBundleCache.clear();
    }

    public String getString(String key) {
        String retValue;
        block6: {
            retValue = "";
            if (this.m_bundle == null) {
                try {
                    throw new Throwable();
                }
                catch (Throwable t) {
                    Logging.log.warning("Missing resource #" + key);
                    break block6;
                }
            }
            if (!this.m_bResourceFileMissing) {
                try {
                    retValue = this.m_bundle.getString(key);
                }
                catch (Throwable t) {
                    retValue = "Missing resource " + key;
                    System.err.println(retValue + ". Have you copied your resources?");
                    System.err.println("Missing resource is called from the following:");
                    Logging.log.warning(retValue);
                    t.printStackTrace();
                }
            }
        }
        return retValue;
    }

    public String getRawStringNoWarning(String key) {
        String retValue = null;
        if (this.m_bundle != null && !this.m_bResourceFileMissing) {
            try {
                retValue = this.m_bundle.getString(key);
                retValue = retValue.trim();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return retValue;
    }

    public String getRawString(String key) {
        String retValue = null;
        if (this.m_bundle != null && !this.m_bResourceFileMissing) {
            try {
                retValue = this.m_bundle.getString(key);
                retValue = retValue.trim();
            }
            catch (Throwable t) {
                Logging.log.warning("Missing resource #" + key);
            }
        }
        return retValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        try {
            String strValue = this.m_bundle.getString(key);
            return new Integer(strValue);
        }
        catch (Throwable t) {
            Logging.log.warning("Missing resource #" + key);
            return notFoundReturnValue;
        }
    }

    public ImageIcon getImageIcon(String sResourceName) {
        if (sResourceName == null) {
            return null;
        }
        ImageIcon image = null;
        String sImagePath = this.getString("ImageLocation.notrans") + this.getString(sResourceName);
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        } else {
            image = (ImageIcon)m_bundleCache.get(sImagePath);
            if (image != null) {
                return image;
            }
        }
        try {
            URL url = ClassLoader.getSystemResource(sImagePath);
            image = new ImageIcon(url);
        }
        catch (Exception e) {
            Logging.log.warning(e.getMessage());
            e.printStackTrace();
            String sDefaultPath = this.getString("ImageLocation.notrans") + this.getString("Common.Default.Image");
            try {
                URL urlDefault = this.m_classLoader.getResource(sDefaultPath);
                image = new ImageIcon(urlDefault);
            }
            catch (Exception e2) {
                Logging.log.warning(e2.getMessage());
                e2.printStackTrace();
            }
        }
        if (image != null) {
            m_bundleCache.put(sImagePath, image);
        }
        return image;
    }

    public String messageString(String key) {
        String pattern = this.getString(key);
        return pattern;
    }

    public String messageString(String key, Object parm1) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5, Object parm6) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString(), parm6.toString()};
        return MessageFormat.format(pattern, args);
    }

    public Enumeration getKeys() {
        return this.m_bundle.getKeys();
    }
}

