/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;

class RuntimeExecutor {
    private long timeout = Long.MAX_VALUE;

    public RuntimeExecutor() {
    }

    public RuntimeExecutor(long timeout) {
        this.timeout = timeout;
    }

    public String[] execute(String[] command) throws IOException, TimeoutException {
        Process p = Runtime.getRuntime().exec(command);
        final ArrayList Lines = new ArrayList();
        Timer timer = new Timer();
        timer.schedule((TimerTask)new InterruptScheduler(Thread.currentThread()), this.timeout);
        final BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        new Thread(){

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Lines.add(line);
                    }
                }
                catch (IOException e) {
                    Logging.logStackTrace(e);
                }
            }
        }.start();
        final BufferedReader ereader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        new Thread(){

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = ereader.readLine()) != null) {
                        Logging.log.warning("STDERR: " + line);
                    }
                }
                catch (IOException e) {
                    Logging.logStackTrace(e);
                }
            }
        }.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            p.destroy();
            throw new TimeoutException(command + "did not return after " + this.timeout + " milliseconds");
        }
        finally {
            timer.cancel();
        }
        String[] res = Lines.toArray(new String[0]);
        return res;
    }

    private class InterruptScheduler
    extends TimerTask {
        Thread target = null;

        public InterruptScheduler(Thread target) {
            this.target = target;
        }

        @Override
        public void run() {
            this.target.interrupt();
        }
    }
}

