/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.JREData;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.SASManifest;
import com.sas.ssn.Utils;
import com.sas.ssn.WizardPromptedIface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class RegistryData {
    public static final String DEPLOY_REGISTRY_JAR = "sas.tools.deploymntreg.jar";
    private static File deployRegPath;
    public static File deployRegJar;
    public static File sashomedeployRegJar;

    public static String getDeployRegJar() {
        String location = null;
        if (deployRegJar != null) {
            location = deployRegJar.getAbsolutePath();
        }
        return location;
    }

    public static boolean setRegistry(String sasHomePath) {
        boolean valid = false;
        if (sasHomePath != null) {
            deployRegPath = new File(sasHomePath, "deploymntreg");
            deployRegJar = new File(deployRegPath, DEPLOY_REGISTRY_JAR);
            valid = true;
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installRegistry() {
        boolean valid = false;
        boolean copyFile = false;
        if (deployRegPath != null && deployRegJar != null) {
            valid = true;
            String sourceDeployRegJar = Utils.joinPath(Globals.g_setupLocation, "deploymntreg");
            sourceDeployRegJar = Utils.joinPath(sourceDeployRegJar, DEPLOY_REGISTRY_JAR);
            if (!deployRegPath.isDirectory() && !deployRegPath.mkdirs()) {
                valid = false;
                Logging.log.info("Error initializing the deployment registry - could not create: " + deployRegPath);
            }
            if (valid) {
                if (deployRegJar.isDirectory()) {
                    valid = false;
                } else if (deployRegJar.isFile()) {
                    JarFile sourceJarFile = null;
                    ZipFile targetJarFile = null;
                    SASManifest sourceManifest = null;
                    SASManifest targetManifest = null;
                    try {
                        sourceJarFile = new JarFile(sourceDeployRegJar);
                        targetJarFile = new JarFile(deployRegJar);
                        sourceManifest = new SASManifest(sourceJarFile.getManifest());
                        targetManifest = new SASManifest(((JarFile)targetJarFile).getManifest());
                    }
                    catch (Exception e) {
                    }
                    finally {
                        if (targetJarFile != null) {
                            try {
                                targetJarFile.close();
                            }
                            catch (IOException e) {
                                valid = false;
                            }
                        }
                        if (sourceJarFile != null) {
                            try {
                                sourceJarFile.close();
                            }
                            catch (IOException e) {
                                valid = false;
                            }
                        }
                    }
                    if (valid && sourceManifest != null && targetManifest != null) {
                        if (targetManifest.hasSASVersion() && sourceManifest.hasSASVersion()) {
                            if (sourceManifest.compareTo(targetManifest) > 0) {
                                copyFile = true;
                            }
                        } else {
                            try {
                                URLClassLoader ucl = URLClassLoader.newInstance(new URL[]{new File(sourceDeployRegJar).toURI().toURL()});
                                Method[] sourceMethods = Class.forName("com.sas.deploymntreg.DeployAPI", true, ucl).getMethods();
                                ucl = URLClassLoader.newInstance(new URL[]{deployRegJar.toURI().toURL()});
                                Class<?> targetAPI = Class.forName("com.sas.deploymntreg.DeployAPI", true, ucl);
                                try {
                                    for (int i = 0; i < sourceMethods.length; ++i) {
                                        targetAPI.getMethod(sourceMethods[i].getName(), sourceMethods[i].getParameterTypes());
                                    }
                                }
                                catch (Exception e) {
                                    copyFile = true;
                                }
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        valid = false;
                        Logging.log.info("Error initializing the deployment registry - Unable to get manifest version data");
                    }
                } else {
                    copyFile = true;
                }
            }
            if (valid && copyFile) {
                if (Utils.copyFile(sourceDeployRegJar, deployRegJar.getAbsolutePath()) == 0) {
                    Logging.log.info("Successfully updated the deployment registry: " + deployRegJar.getAbsolutePath());
                } else {
                    valid = false;
                    Logging.log.info("Error initializing the deployment registry - could not copy: " + sourceDeployRegJar);
                }
            }
            if (valid) {
                RegistryAccess regAccess = null;
                try {
                    regAccess = new RegistryAccess(deployRegJar);
                    if (regAccess.getProperty("default.host") == null) {
                        regAccess.setProperty("default.host", Utils.getOS_Suffix());
                    }
                }
                catch (Exception e) {
                    Logging.log.warning("Unable to read host value from the deployment registry while saving the host value to the registry.properties file.");
                }
            }
            RegistryData.copyViewRegFile();
        } else {
            valid = false;
            Logging.log.info("Error initializing the deployment registry - SAS Home has not been set");
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyViewRegFile() {
        boolean valid = true;
        boolean copyFile = false;
        String copyJar = "sas.tools.viewregistry.jar";
        File targetJar = new File(deployRegPath, "sas.tools.viewregistry.jar");
        String sourceJar = Utils.joinPath(Globals.g_setupLocation, "deploymntreg");
        if (!new File(sourceJar = Utils.joinPath(sourceJar, "sas.tools.viewregistry.jar")).isFile()) {
            Logging.log.info("Source file does not exist " + sourceJar);
            return true;
        }
        if (targetJar.isDirectory()) {
            valid = false;
        } else if (targetJar.isFile()) {
            JarFile sourceJarFile = null;
            ZipFile targetJarFile = null;
            SASManifest sourceManifest = null;
            SASManifest targetManifest = null;
            try {
                sourceJarFile = new JarFile(sourceJar);
                targetJarFile = new JarFile(targetJar);
                sourceManifest = new SASManifest(sourceJarFile.getManifest());
                targetManifest = new SASManifest(((JarFile)targetJarFile).getManifest());
            }
            catch (Exception e) {
            }
            finally {
                if (targetJarFile != null) {
                    try {
                        targetJarFile.close();
                    }
                    catch (IOException e) {
                        valid = false;
                    }
                }
                if (sourceJarFile != null) {
                    try {
                        sourceJarFile.close();
                    }
                    catch (IOException e) {
                        valid = false;
                    }
                }
            }
            if (valid && sourceManifest != null && targetManifest != null) {
                if (targetManifest.hasSASVersion() && sourceManifest.hasSASVersion() && sourceManifest.compareTo(targetManifest) > 0) {
                    copyFile = true;
                }
            } else {
                valid = false;
                Logging.log.info("Error - Unable to get manifest version data: sas.tools.viewregistry.jar");
            }
        } else {
            copyFile = true;
        }
        if (valid && copyFile) {
            if (Utils.copyFile(sourceJar, targetJar.getAbsolutePath()) == 0) {
                Logging.log.info("Successfully updated the deployment registry files: " + targetJar.getAbsolutePath());
            } else {
                valid = false;
                Logging.log.info("Error initializing the deployment registry - could not copy: " + sourceJar);
            }
        }
        return valid;
    }

    private static void removeOldVersionsInSameProductHome(RegistryAccess registryAccess) {
        String[] hosts = registryAccess.getInstallHosts();
        if (hosts == null) {
            return;
        }
        for (String host : hosts) {
            String[] productCodes = registryAccess.getInstallCodes();
            if (productCodes == null) continue;
            for (String productCode : productCodes) {
                String[] versions = registryAccess.getInstallVersions(productCode, host);
                if (versions == null || versions.length < 2) continue;
                HashMap<String, ArrayList<String>> locations = new HashMap<String, ArrayList<String>>(5);
                for (String version : versions) {
                    String installLocation = registryAccess.getInstallLoc(productCode, version, host);
                    ArrayList<String> versionsForLocation = (ArrayList<String>)locations.get(installLocation = Utils.getCanonicalPath(installLocation));
                    if (versionsForLocation == null) {
                        versionsForLocation = new ArrayList<String>();
                        locations.put(installLocation, versionsForLocation);
                    }
                    versionsForLocation.add(version);
                }
                for (String location : locations.keySet()) {
                    ArrayList versionsForLocation = (ArrayList)locations.get(location);
                    if (versionsForLocation.size() <= 1) continue;
                    String newestVersion = (String)versionsForLocation.get(0);
                    String newestLastPortDate = registryAccess.getInstallLastPortDate(productCode, newestVersion, host);
                    for (int i = 1; i < versionsForLocation.size(); ++i) {
                        String nextVersion = (String)versionsForLocation.get(i);
                        String nextLastPortDate = registryAccess.getInstallLastPortDate(productCode, nextVersion, host);
                        String versionToRemove = nextVersion;
                        if (Utils.isNewerVersion(nextVersion, nextLastPortDate, newestVersion, newestLastPortDate)) {
                            versionToRemove = newestVersion;
                            newestVersion = nextVersion;
                            newestLastPortDate = nextLastPortDate;
                        }
                        String msgFormat = "Removing deployment registry record for product %s version %s for host %s.";
                        String msg = String.format(msgFormat, productCode, versionToRemove, host);
                        Logging.log.info(msg);
                        registryAccess.removeInstall(productCode, versionToRemove, host);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveRegistryData() {
        boolean valid = true;
        RegistryData.installRegistry();
        RegistryAccess regAccess = null;
        try {
            regAccess = new RegistryAccess(deployRegJar);
            if (!regAccess.open()) {
                valid = false;
                Logging.log.info("Error opening the deployment registry: " + deployRegJar);
            } else {
                String configDir;
                String prodCode;
                OrderData orderData;
                if (regAccess.getSASHome() == null) {
                    regAccess.setSASHome(Globals.g_wizardData.getPreference("SASHome", null));
                }
                if ((orderData = Globals.g_deploymentData.getOrder(Globals.g_order)) != null && !Globals.g_DocUpdate) {
                    if (orderData.isWeb() || orderData.isStandAlone()) {
                        if (regAccess.getLastOrder() == null || regAccess.getLastOrder().equals("") || regAccess.getLastOrder().equalsIgnoreCase("standalone")) {
                            regAccess.setLastOrder(Globals.g_order);
                        }
                    } else {
                        regAccess.setLastOrder(Globals.g_order);
                    }
                }
                RegistryData.removeOldVersionsInSameProductHome(regAccess);
                if (JREData.jreNeeded) {
                    String[] jreVersions = regAccess.getInstallVersions("javaruntime");
                    for (int j = 0; j < jreVersions.length; ++j) {
                        regAccess.removeInstall("javaruntime", jreVersions[j]);
                    }
                    WizardPromptedIface jrePanel = (WizardPromptedIface)Globals.g_wizard.getPanel("jre");
                    if (jrePanel != null && jrePanel.getLocation() != null) {
                        prodCode = jrePanel.getProductCode();
                        String version = Globals.g_majorReleaseVersion;
                        regAccess.setInstallOrderNum(prodCode, version, Globals.g_order);
                        regAccess.setInstallDisplayName(prodCode, version, jrePanel.getProductName());
                        regAccess.setInstallLoc(prodCode, version, jrePanel.getLocation());
                    } else if (Utils.getOS_Suffix() != "mvs") {
                        // empty if block
                    }
                }
                if (Globals.g_promptedInstalls != null) {
                    WizardPromptedIface promptedPanel = null;
                    for (int i = 0; i < Globals.g_promptedInstalls.length; ++i) {
                        promptedPanel = (WizardPromptedIface)Globals.g_wizard.getPanel(Globals.g_promptedInstalls[i]);
                        prodCode = promptedPanel.getProductCode();
                        String[] thirdPartyVersions = regAccess.getInstallVersions(prodCode);
                        for (int j = 0; j < thirdPartyVersions.length; ++j) {
                            regAccess.removeInstall(prodCode, thirdPartyVersions[j]);
                        }
                        String version = Globals.g_majorReleaseVersion;
                        regAccess.setInstallOrderNum(prodCode, version, Globals.g_order);
                        regAccess.setInstallDisplayName(prodCode, version, promptedPanel.getProductName());
                        regAccess.setInstallLoc(prodCode, version, promptedPanel.getLocation());
                    }
                }
                if ((configDir = Globals.g_configData.getProperty("config.home.dir", null)) != null) {
                    regAccess.setConfigLoc(configDir, configDir);
                }
            }
        }
        catch (FileNotFoundException e) {
            Logging.log.info("Error initializing the deployment registry - could not find: " + deployRegJar);
        }
        catch (IOException e) {
            Logging.log.info("Error initializing the deployment registry - could not read: " + deployRegJar);
        }
        catch (ClassNotFoundException e) {
            Logging.log.info("Error initializing the deployment registry - could not load class: " + deployRegJar);
        }
        finally {
            if (regAccess != null && !regAccess.close()) {
                valid = false;
                Logging.log.info("Error closing the deployment registry: " + deployRegJar);
            }
        }
        return valid;
    }

    public static boolean registerConfigDir() {
        boolean valid = true;
        RegistryAccess regAccess = null;
        try {
            regAccess = new RegistryAccess(deployRegJar);
            if (!regAccess.open()) {
                valid = false;
                Logging.log.info("Error opening the deployment registry: " + deployRegJar);
            } else {
                String configDir = Globals.g_configData.getProperty("config.home.dir", null);
                if (configDir != null) {
                    regAccess.setConfigLoc(configDir, configDir);
                }
            }
        }
        catch (FileNotFoundException e) {
            Logging.log.info("Error initializing the deployment registry - could not find: " + deployRegJar);
        }
        catch (IOException e) {
            Logging.log.info("Error initializing the deployment registry - could not read: " + deployRegJar);
        }
        catch (ClassNotFoundException e) {
            Logging.log.info("Error initializing the deployment registry - could not load class: " + deployRegJar);
        }
        finally {
            if (regAccess != null && !regAccess.close()) {
                valid = false;
                Logging.log.info("Error closing the deployment registry: " + deployRegJar);
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setInstallLoc(String code, String version, String host, String path) {
        boolean valid = false;
        if (deployRegJar != null) {
            try (RegistryAccess regAccess = null;){
                regAccess = new RegistryAccess(deployRegJar);
                if (regAccess.open()) {
                    valid = regAccess.setInstallLoc(code, version, host, path);
                }
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setInstallLoc(String code, String version, String path) {
        boolean valid = false;
        if (deployRegJar != null) {
            try (RegistryAccess regAccess = null;){
                regAccess = new RegistryAccess(deployRegJar);
                if (regAccess.open()) {
                    valid = regAccess.setInstallLoc(code, version, path);
                }
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInstallLoc(String code, String version, String host) {
        String location = null;
        if (deployRegJar != null) {
            try (RegistryAccess regAccess = null;){
                regAccess = new RegistryAccess(deployRegJar);
                if (regAccess.open()) {
                    location = regAccess.getInstallLoc(code, version, host);
                }
            }
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInstallLoc(String code, String version) {
        String location = null;
        if (deployRegJar != null) {
            try (RegistryAccess regAccess = null;){
                regAccess = new RegistryAccess(deployRegJar);
                if (regAccess.open()) {
                    location = regAccess.getInstallLoc(code, version);
                }
            }
        }
        return location;
    }

    public static boolean isProductInstalled(String code, String version) {
        boolean installed = false;
        String location = RegistryData.getInstallLoc(code, version);
        if (location != null && new File(location).isDirectory()) {
            installed = true;
        }
        return installed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMediaRegistryJarMoreRecent(File sourceDeployRegJar, File sashomedeployRegJar) {
        boolean valid = true;
        boolean bCurrent = false;
        JarFile testJarFile1 = null;
        ZipFile testJarFile2 = null;
        SASManifest testManifest1 = null;
        SASManifest testManifest2 = null;
        try {
            testJarFile1 = new JarFile(sourceDeployRegJar);
            testJarFile2 = new JarFile(sashomedeployRegJar);
            testManifest1 = new SASManifest(testJarFile1.getManifest());
            testManifest2 = new SASManifest(((JarFile)testJarFile2).getManifest());
        }
        catch (Exception e) {
        }
        finally {
            if (testJarFile1 != null) {
                try {
                    testJarFile1.close();
                }
                catch (IOException e) {
                    valid = false;
                }
            }
            if (testJarFile2 != null) {
                try {
                    testJarFile2.close();
                }
                catch (IOException e) {
                    valid = false;
                }
            }
        }
        if (valid && testManifest1 != null && testManifest2 != null && testManifest2.hasSASVersion() && testManifest1.hasSASVersion() && testManifest1.compareTo(testManifest2) > 0) {
            Logging.log.info("The deployment registry jar " + sourceDeployRegJar + " is more recent than " + sashomedeployRegJar);
            return true;
        }
        return bCurrent;
    }
}

