/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.DepotSubsetListData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.RecipeData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.VolserData;
import com.sas.ssn.schema.recipes.gen.Recipe;
import com.sas.ssn.schema.recipes.gen.SASRecipes;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;

public class Recipes {
    private SSNResource bundle = new SSNResource(Recipes.class);
    private List<RecipeData> recipeList = new LinkedList<RecipeData>();
    private Set<String> allAltSkus = new HashSet<String>();
    private HashMap<String, RecipeData> recipesById = new HashMap();
    private String selectedRecipeId = null;

    public void initDefaultRecipes() {
        this.readRecipes();
        if (this.recipeList.isEmpty()) {
            return;
        }
        this.loadOrderInformation();
        this.expandRulesToAltSkus();
        this.selectedRecipeId = this.recipeList.get(0).getId();
    }

    public void initCustomRecipes(String customRecipeFileName) {
        this.readRecipeFile(new File(customRecipeFileName));
        if (this.recipeList.isEmpty()) {
            return;
        }
        this.loadOrderInformation();
        this.expandRulesToAltSkus();
        this.selectedRecipeId = this.recipeList.get(0).getId();
    }

    public boolean status() {
        if (this.recipeList.isEmpty()) {
            return false;
        }
        return this.hasUseableRecipes();
    }

    private List<String> setRecipeDefaultSearchPath() {
        ArrayList<String> recipeSearchPaths = new ArrayList<String>();
        recipeSearchPaths.add(new File(Globals.g_deploymentData.getMediaRoot() + File.separator + "product_data" + File.separator + Globals.g_deploymentData.getNewestSpsSku("deploywiz", null, false).getSpsSku() + File.separator + "recipes").getAbsolutePath());
        return recipeSearchPaths;
    }

    public void readRecipeFile(File recipeFile) {
        JAXBElement<SASRecipes> element;
        if (recipeFile.exists() && (element = this.parseRecipeXML(recipeFile)) != null) {
            this.saveRecipeXML(element);
            Logging.log.info("Found and read a recipe file at: " + recipeFile.getAbsolutePath());
        }
    }

    public void readRecipes(List<String> recipeSearchPaths) {
        for (String recipePath : recipeSearchPaths) {
            File recipeFilePath = new File(recipePath);
            if (recipeFilePath == null || !recipeFilePath.isDirectory()) continue;
            for (File recipeFile : recipeFilePath.listFiles()) {
                if (!recipeFile.isFile() || !recipeFile.getAbsolutePath().endsWith(".xml")) continue;
                this.readRecipeFile(recipeFile);
            }
        }
    }

    public void readRecipes() {
        List<String> recipeDefaultSearchPaths = this.setRecipeDefaultSearchPath();
        this.readRecipes(recipeDefaultSearchPaths);
    }

    public void clearRecipes() {
        this.recipeList.clear();
    }

    private void loadOrderInformation() {
        this.allAltSkus.clear();
        OrderData orderData = Globals.g_deploymentData.getOrder(Globals.g_order);
        String[] volsers = orderData.getVolsers(orderData.getMediaType());
        for (int i = 0; i < volsers.length; ++i) {
            VolserData volserData = Globals.g_deploymentData.getVolser(volsers[i]);
            String[] spsSkus = volserData.getSpsSkus();
            for (int j = 0; j < spsSkus.length; ++j) {
                if (!volserData.isPayloadIncluded(spsSkus[j])) continue;
                this.allAltSkus.add(spsSkus[j]);
            }
        }
    }

    private JAXBElement<SASRecipes> parseRecipeXML(File recipeFile) throws RecipeDataException {
        try {
            JAXBContext jc = JAXBContext.newInstance("com.sas.ssn.schema.recipes.gen", Recipes.class.getClassLoader());
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement<SASRecipes> element = u.unmarshal(new StreamSource(recipeFile), SASRecipes.class);
            Logging.log.info("Recipe data: " + recipeFile.getName() + " Ver. " + element.getValue().getVersion().toString() + " Generated: " + element.getValue().getUpdated() + " [" + element.getValue().getTstamp().toString() + "]");
            return element;
        }
        catch (JAXBException e) {
            Logging.log.warning("Could not parse Hot Fix XML data");
            Logging.logStackTrace(e);
            throw new RecipeDataException(this.bundle.messageString("Recipes.JAXBFailed.txt"));
        }
        catch (Exception e) {
            Logging.log.warning("Could not parse Hot Fix XML data");
            Logging.logStackTrace(e);
            return null;
        }
    }

    private void saveRecipeXML(JAXBElement<SASRecipes> element) {
        for (Recipe recipe : element.getValue().getRecipe()) {
            RecipeData existingElement;
            RecipeData recipeData = new RecipeData();
            recipeData.setId(recipe.getId());
            recipeData.setDescription(recipe.getDescription());
            recipeData.setVersion(recipe.getVersion().intValue());
            recipeData.setStatus(recipe.getStatus());
            recipeData.setReq(recipe.getRequirements().getReq());
            recipeData.setNreq(recipe.getRequirements().getNreq());
            if (!"ACTIVE".equalsIgnoreCase(recipeData.getStatus()) || (existingElement = this.recipesById.get(recipeData.getId())) != null && existingElement.getVersion() > recipeData.getVersion()) continue;
            this.recipesById.put(recipeData.getId(), recipeData);
        }
        this.recipeList.clear();
        this.recipeList.addAll(this.recipesById.values());
    }

    private void expandRulesToAltSkus() {
        for (RecipeData recipe : this.recipeList) {
            LinkedList<String> altskuMatches = new LinkedList<String>();
            recipe.setHasAllReq(true);
            for (String reqPtrns : recipe.getReq()) {
                List<String> matches = this.findMatches(reqPtrns);
                if (matches.isEmpty()) {
                    recipe.setHasAllReq(false);
                    Logging.log.fine("Missing match for: " + reqPtrns);
                    continue;
                }
                altskuMatches.addAll(matches);
            }
            recipe.setRequiredAltSkus(altskuMatches);
            LinkedList<String> altskuMatches2 = new LinkedList<String>();
            for (String nreqPtrns : recipe.getNreq()) {
                altskuMatches2.addAll(this.findMatches(nreqPtrns));
            }
            recipe.setNonRequiredAltSkus(altskuMatches2);
        }
    }

    private List<String> findMatches(String ptrns) {
        LinkedList<String> matches = new LinkedList<String>();
        Pattern reqPtrn = Pattern.compile(ptrns);
        for (String orderAltSku : this.allAltSkus) {
            Matcher matcher_orderAltSku = reqPtrn.matcher(orderAltSku);
            if (!matcher_orderAltSku.matches()) continue;
            matches.add(orderAltSku);
        }
        return matches;
    }

    private boolean hasUseableRecipes() {
        for (RecipeData recipe : this.recipeList) {
            if (!recipe.useable()) continue;
            return true;
        }
        return false;
    }

    public List<String> recipeIDs() {
        LinkedList<String> listOfRecipeIds = new LinkedList<String>();
        for (RecipeData recipe : this.recipeList) {
            if (!recipe.useable()) continue;
            listOfRecipeIds.add(recipe.getId());
        }
        return listOfRecipeIds;
    }

    public String recipeDescription(String recipeId) {
        List<String> desc;
        RecipeData recipe = this.recipesById.get(recipeId);
        if (recipe != null && (desc = recipe.getDescription()) != null && !desc.isEmpty()) {
            return desc.get(0);
        }
        return null;
    }

    public List<String> getRecipeAltSkus(String recipeId) {
        LinkedList<String> listOfRecipeAltSkus = new LinkedList<String>();
        RecipeData recipe = this.recipesById.get(recipeId);
        if (recipe == null || !recipe.isHasAllReq()) {
            return null;
        }
        listOfRecipeAltSkus.addAll(recipe.getRequiredAltSkus());
        listOfRecipeAltSkus.addAll(recipe.getNonRequiredAltSkus());
        return listOfRecipeAltSkus;
    }

    public String getSelectedRecipeId() {
        return this.selectedRecipeId;
    }

    public void setSelectedRecipeId(String selectedRecipeId) {
        this.selectedRecipeId = selectedRecipeId;
    }

    public boolean isAltSkuInRecipe(String altSkuToTest) {
        List<String> altskus = this.getRecipeAltSkus(this.getSelectedRecipeId());
        return altskus != null && altskus.contains(altSkuToTest);
    }

    public void loadRecipeData(ArrayList<DepotSubsetListData> listData) {
        block0: for (DepotSubsetListData item : listData) {
            item.setSelectedByUser(false);
            HashSet<String> orderAltSkus = item.getAltSkus();
            for (String recipeAltSku : this.getRecipeAltSkus(this.getSelectedRecipeId())) {
                if (!orderAltSkus.contains(recipeAltSku)) continue;
                item.setSelectedByUser(true);
                continue block0;
            }
        }
    }

    protected class RecipeDataException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public RecipeDataException(String translatedMsg) {
            super(translatedMsg);
        }
    }
}

