/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigureData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.Plan;
import com.sas.ssn.ProductData;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PropertyRules {
    private static final String CONSTANT_SELECTED_ALL = "@plan.selected.list@";
    private static final String CONSTANT_SELECTED_DEPLOY = "@plan.selected.deploy.list@";
    private static final String CONSTANT_SELECTED_CONFIG = "@plan.selected.config.list@";
    private static final String CONSTANT_MACHINE_ALL = "@plan.machine.list@";
    private static final String CONSTANT_MACHINE_DEPLOY = "@plan.machine.deploy.list@";
    private static final String CONSTANT_MACHINE_CONFIG = "@plan.machine.config.list@";
    private static final String CONSTANT_PLAN_ALL = "@plan.all.list@";
    private static final String CONSTANT_PLAN_DEPLOY = "@plan.all.deploy.list@";
    private static final String CONSTANT_PLAN_CONFIG = "@plan.all.config.list@";
    private static final String CONSTANT_ORDER_LIST = "@order.list@";
    private static final String CONSTANT_MACHINE_INSTALLED_LIST = "@machine.installed.list@";
    private static final String CONSTANT_MACHINE_CONFIGURED_LIST = "@machine.configured.list@";
    private static final String CONSTANT_UPDATE_MODE_LIST = "@update.mode.list@";
    private static final String REQUIRE_METADATASRV_CONNECTION_LIST = "@require.metadatasrv.connection.list@";
    private static final String CONSTANT_TRUE = "true";
    private static final String CONSTANT_FALSE = "false";
    private static final String RULE_STRING = "string";
    private static final String RULE_CLAUSE = "clause";
    private static final String RULE_OPERATOR = "operator";
    private static final int MATH_INITIAL = 0;
    private static final int MATH_ADD = 1;
    private static final int MATH_SUBTRACT = 2;
    private static final int MATH_MULTIPLY = 3;
    private static final int MATH_DIVIDE = 4;
    private static final int MATH_MODULO = 5;
    private static HashMap<String, String> m_selectedAll = null;
    private static HashMap<String, String> m_selectedDeploy = null;
    private static HashMap<String, String> m_selectedConfig = null;
    private static HashMap<String, String> m_machineAll = null;
    private static HashMap<String, String> m_machineDeploy = null;
    private static HashMap<String, String> m_machineConfig = null;
    private static HashMap<String, String> m_planAll = null;
    private static HashMap<String, String> m_planDeploy = null;
    private static HashMap<String, String> m_planConfig = null;
    private static HashMap<String, String> m_orderList = null;
    private static HashMap<String, String> m_machineDeployed = null;
    private static HashMap<String, String> m_machineConfigured = null;
    private static HashMap<String, String> m_updateModeList = null;
    private static ArrayList<String> currentRulesToResolve = new ArrayList();

    public static boolean resolveBooleanRule(String rule, boolean initial, int type) {
        boolean valid = false;
        if (rule.length() > 0) {
            LinkedList clauses = PropertyRules.parseRuleClause(rule);
            valid = PropertyRules.resolveClauses(clauses, initial, type);
        }
        return valid;
    }

    public static void resetPlanData() {
        m_selectedAll = null;
        m_selectedDeploy = null;
        m_selectedConfig = null;
        m_machineAll = null;
        m_machineDeploy = null;
        m_machineConfig = null;
        m_planAll = null;
        m_planDeploy = null;
        m_planConfig = null;
    }

    public static void resetOrderData() {
        m_orderList = null;
    }

    public static void printConstants(PrintWriter debugFile) {
        Iterator<String> keys;
        String prodCodes = "";
        debugFile.println("Constants");
        debugFile.println("---------");
        if (m_selectedAll != null) {
            keys = m_selectedAll.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@plan.selected.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_selectedDeploy != null) {
            prodCodes = "";
            keys = m_selectedDeploy.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@plan.selected.deploy.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_selectedConfig != null) {
            prodCodes = "";
            keys = m_selectedConfig.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@plan.selected.config.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
            String requresMetadatasrvConn = Globals.g_configDefaults.getDefault(ConfigureData.REQUIRE_METADATASRV_CONNECTION_LIST, " ");
            debugFile.println("@require.metadatasrv.connection.list@ = " + requresMetadatasrvConn.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_machineAll != null) {
            keys = m_machineAll.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@plan.machine.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_machineDeploy != null) {
            prodCodes = "";
            keys = m_machineDeploy.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@plan.machine.deploy.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_machineConfig != null) {
            prodCodes = "";
            keys = m_machineConfig.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@plan.machine.config.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_planAll != null) {
            prodCodes = "";
            keys = m_planAll.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@plan.all.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_planDeploy != null) {
            prodCodes = "";
            keys = m_planDeploy.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@plan.all.deploy.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_planConfig != null) {
            prodCodes = "";
            keys = m_planConfig.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@plan.all.config.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_orderList != null) {
            prodCodes = "";
            keys = m_orderList.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@order.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_machineDeployed != null) {
            prodCodes = "";
            keys = m_machineDeployed.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@machine.installed.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
        if (m_machineConfigured != null) {
            prodCodes = "";
            keys = m_machineConfigured.keySet().iterator();
            while (keys.hasNext()) {
                prodCodes = prodCodes + " " + keys.next();
            }
            debugFile.println("@machine.configured.list@ = " + prodCodes.trim().toUpperCase(Locale.ENGLISH));
            debugFile.println("");
        }
    }

    public static boolean containsProperty(String text) {
        boolean contains = text.indexOf("@") > -1;
        return contains;
    }

    public static String resolveProperties(String text, int type) {
        return PropertyRules.resolveProperties(text, type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolveProperties(String text, int type, boolean forceDefault) {
        String ret = null;
        if (text != null) {
            String key = text.trim().toLowerCase();
            if (currentRulesToResolve.contains(key)) {
                currentRulesToResolve.add(key);
                Logging.log.severe("Circular reference detected when resolving the following sequence: " + currentRulesToResolve.toString());
                currentRulesToResolve.clear();
            }
            currentRulesToResolve.add(key);
            try {
                ret = PropertyRules.resolvePropertiesImpl(text, type, forceDefault);
            }
            finally {
                currentRulesToResolve.remove(key);
            }
        }
        return ret;
    }

    private static boolean isValidProvider(String provider) {
        boolean isValid = false;
        Pattern PROVIDER_PATTERN = Pattern.compile("^[a-zA-Z]+$");
        Matcher provider_matcher = PROVIDER_PATTERN.matcher(provider);
        if (provider_matcher.find()) {
            isValid = true;
        }
        return isValid;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String resolvePackagedDependency(Matcher matcher, boolean forceDefault) {
        TreeSet<String> options = new TreeSet<String>();
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(StringUtils.split(matcher.group(1), ".")));
        String provider = "|";
        if (params.isEmpty()) {
            Logging.log.severe("No dependent product_code was detected.");
            return provider;
        }
        if (params.size() == 1) {
            if (!PropertyRules.isValidProvider(params.get(0))) {
                Logging.log.severe("Invalid product_code [" + params.get(0) + "] detected.");
                return provider;
            }
            Logging.log.info("Using [" + params.get(params.size() - 1) + "] as the dependent 12byte.");
            provider = params.get(0);
        } else {
            if (!PropertyRules.isValidProvider(params.get(params.size() - 1))) {
                Logging.log.severe("Invalid product_code [" + params.get(0) + "] detected.");
                return provider;
            }
            Logging.log.info("Using [" + params.get(params.size() - 1) + "] as the dependent 12byte.");
            provider = params.remove(params.size() - 1);
        }
        if (Globals.g_configDefaults.getDefault("wizard.type", null).equalsIgnoreCase("sdw")) {
            Logging.log.info("Processing OOTB scenario");
            String being_configured = "@" + provider + ".configobj.name@=@" + provider + ".configobj.fqid@";
            if (provider.equalsIgnoreCase("levconfig")) {
                if (PropertyRules.resolveProperties("@oma.appserver.create_context@", 0, forceDefault).equalsIgnoreCase("TRUE")) {
                    Logging.log.info("adding LEVCONFIG as an option.");
                    options.add(PropertyRules.resolveProperties(being_configured, 0, forceDefault));
                }
            } else if (PropertyRules.resolveProperties(CONSTANT_SELECTED_CONFIG, 0, forceDefault).contains(provider.toUpperCase())) {
                Logging.log.info("adding " + provider + " as an option.");
                options.add(PropertyRules.resolveProperties(being_configured, 0, forceDefault));
            }
        }
        Logging.log.info("Processing MIGRATION scenario");
        String migrationList = PropertyRules.resolveProperties("@" + provider + ".migration.list@", 0, forceDefault);
        String[] migrationValues = StringUtils.split(migrationList, "|");
        if (migrationValues.length > 0 && !migrationValues[0].equals(migrationList)) {
            Logging.log.info("adding the following migration sting as options: " + migrationList);
            options.addAll(Arrays.asList(migrationValues));
        } else {
            Logging.log.info("NO @" + provider + ".migration.list@ property was detected.");
        }
        Logging.log.info("Adding additional metadata objects ");
        String XML_SELECT = "<XMLSelect search=\"@" + provider + ".configobj.type@[@ClassIdentifier='@" + provider + ".configobj.classid@']\"/>";
        if (params.size() >= 1) {
            Logging.log.info(matcher.group(0) + " indicates the use of a custom XMLSelect statement.");
            String xml_select_stmt = matcher.group(0).replace("@", "").trim();
            String userDefinedXmlSelectValue = Globals.g_configDefaults.getDefault(xml_select_stmt, null);
            if (userDefinedXmlSelectValue != null) {
                Logging.log.info("Custom XMLSelect detected. [" + xml_select_stmt + "] Will be used to search for related metadata objects.");
                XML_SELECT = userDefinedXmlSelectValue;
            } else {
                Logging.log.severe("Custom XMLSelect not found. Default XMLSELECT will be used:");
            }
        }
        StringBuffer query = new StringBuffer("@metaquery[]@");
        int offset = query.indexOf("]");
        query.insert(offset, XML_SELECT);
        XML_SELECT = query.toString();
        String[] metaquery = StringUtils.split(PropertyRules.resolveProperties(XML_SELECT, 32, forceDefault), "|");
        options.addAll(Arrays.asList(metaquery));
        return StringUtils.join(options.toArray(), "|");
    }

    private static String resolvePropertiesImpl(String text, int type, boolean forceDefault) {
        Pattern PACKAGED_DEPENDENCY_PATTERN = Pattern.compile("@(.+)\\.dependency@$");
        Matcher matcher = PACKAGED_DEPENDENCY_PATTERN.matcher(text);
        if (matcher.find()) {
            Logging.log.info("Packaged Dependency detected.");
            return PropertyRules.resolvePackagedDependency(matcher, forceDefault);
        }
        boolean performMath = false;
        int firstAt = text.indexOf("@");
        int nextAt = 0;
        String property = null;
        String value = null;
        String newText = text;
        String before = "";
        String after = "";
        String macro = null;
        while (firstAt > -1) {
            if (newText.indexOf("gendefault[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 12);
                if (nextAt > -1) {
                    macro = newText.substring(firstAt + 12, nextAt);
                    value = PropertyRules.resolveStringRule(macro, type, forceDefault);
                    if (value != null) {
                        before = newText.substring(0, firstAt);
                        after = newText.substring(nextAt + 2);
                        newText = before + value + after;
                        firstAt = newText.indexOf("@", firstAt + value.length());
                        continue;
                    }
                    firstAt = nextAt;
                    continue;
                }
                firstAt = -1;
                continue;
            }
            if (newText.indexOf("metaquery[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 11);
                if (nextAt > -1) {
                    macro = newText.substring(firstAt + 11, nextAt);
                    String search = "search=\"@levconfig.configobj.type@[";
                    String insert = "@Name NE '@iomsrv.metadatasrv.servercontext.name@' AND ";
                    StringBuffer query = new StringBuffer(macro);
                    int found = query.indexOf(search);
                    if (found > -1) {
                        int offset = found + search.length();
                        query.insert(offset, insert);
                        macro = query.toString();
                    }
                    if (PropertyRules.containsProperty(macro)) {
                        macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                    }
                    String host = null;
                    String port = null;
                    String repository = null;
                    String user = null;
                    String password = null;
                    if (Globals.g_mode == 2 || Globals.g_mode == 5) {
                        host = Globals.g_cmtConnectHost;
                        port = Globals.g_cmtConnectPort;
                        repository = Globals.g_cmtConnectRepos;
                        user = Globals.g_cmtConnectUser;
                        password = Globals.g_cmtConnectPassword;
                    } else {
                        host = Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null);
                        port = Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null);
                        repository = Globals.g_configData.getProperty("oma.repository.foundation.name", null);
                        user = Globals.g_configData.getProperty("oma.person.admin.login.userid", null);
                        password = Globals.g_configData.getProperty("oma.person.admin.login.passwd", null);
                    }
                    value = host != null && port != null && repository != null && user != null && password != null ? MetadataAccess.metaQuery(host, port, repository, user, password, macro) : null;
                    if (value != null) {
                        before = newText.substring(0, firstAt);
                        after = newText.substring(nextAt + 2);
                        newText = before + value + after;
                        firstAt = newText.indexOf("@", firstAt + value.length());
                        continue;
                    }
                    firstAt = nextAt;
                    continue;
                }
                firstAt = -1;
                continue;
            }
            if (newText.indexOf("fqidquery[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 11);
                if (nextAt > -1) {
                    macro = newText.substring(firstAt + 11, nextAt);
                    if (PropertyRules.containsProperty(macro)) {
                        macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                    }
                    String host = null;
                    String port = null;
                    String repository = null;
                    String user = null;
                    String password = null;
                    if (Globals.g_mode == 2 || Globals.g_mode == 5) {
                        host = Globals.g_cmtConnectHost;
                        port = Globals.g_cmtConnectPort;
                        repository = Globals.g_cmtConnectRepos;
                        user = Globals.g_cmtConnectUser;
                        password = Globals.g_cmtConnectPassword;
                    } else {
                        host = Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null);
                        port = Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null);
                        repository = Globals.g_configData.getProperty("oma.repository.foundation.name", null);
                        user = Globals.g_configData.getProperty("oma.person.admin.login.userid", null);
                        password = Globals.g_configData.getProperty("oma.person.admin.login.passwd", null);
                    }
                    value = host != null && port != null && repository != null && user != null && password != null ? MetadataAccess.fqidQuery(host, port, repository, user, password, macro) : null;
                    if (value != null) {
                        before = newText.substring(0, firstAt);
                        after = newText.substring(nextAt + 2);
                        newText = before + value + after;
                        firstAt = newText.indexOf("@", firstAt + value.length());
                        continue;
                    }
                    firstAt = nextAt;
                    continue;
                }
                firstAt = -1;
                continue;
            }
            if (newText.indexOf("propsubstring[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 15);
                if (nextAt > -1) {
                    String[] parameters;
                    macro = newText.substring(firstAt + 15, nextAt);
                    if (PropertyRules.containsProperty(macro)) {
                        macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                    }
                    if ((parameters = macro.split(",")).length < 2 || parameters.length > 3) {
                        value = null;
                        Logging.log.severe("Invalid propsubstring[] syntax: " + newText);
                    } else {
                        value = parameters[0].trim();
                        int subStart = -1;
                        int subEnd = -1;
                        try {
                            int end;
                            subStart = new Integer(parameters[1].trim());
                            subEnd = value.length();
                            if (parameters.length == 3 && (end = new Integer(parameters[2].trim()).intValue()) <= value.length()) {
                                subEnd = end;
                            }
                            value = value.substring(subStart, subEnd);
                        }
                        catch (NumberFormatException nfe) {
                            value = null;
                            Logging.log.severe("Invalid propsubstring[] syntax: " + newText + ". Start and end indicies must be integers.");
                        }
                    }
                    if (value != null) {
                        before = newText.substring(0, firstAt);
                        after = newText.substring(nextAt + 2);
                        newText = before + value + after;
                        firstAt = newText.indexOf("@", firstAt + value.length());
                        continue;
                    }
                    firstAt = nextAt;
                    continue;
                }
                firstAt = -1;
                continue;
            }
            if (newText.indexOf("propquery[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 11);
                if (nextAt > -1) {
                    String[] parameters;
                    macro = newText.substring(firstAt + 11, nextAt);
                    if (PropertyRules.containsProperty(macro)) {
                        macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                    }
                    if ((parameters = macro.split(",")).length < 2) {
                        value = null;
                        Logging.log.severe("Invalid propquery[] syntax: " + macro);
                    } else {
                        String fqid = "";
                        String prop = "";
                        String defval = "";
                        String parameter = null;
                        String nextParm = "fqid";
                        boolean xmlselect = false;
                        for (int i = 0; i < parameters.length; ++i) {
                            parameter = parameters[i];
                            if (nextParm == "fqid") {
                                if (parameter.toLowerCase(Locale.ENGLISH).startsWith("<xmlselect")) {
                                    xmlselect = true;
                                }
                                if (fqid.length() > 0) {
                                    fqid = fqid + ",";
                                }
                                fqid = fqid + parameter;
                                if (xmlselect && parameter.endsWith(">")) {
                                    nextParm = "prop";
                                    continue;
                                }
                                if (xmlselect) continue;
                                nextParm = "prop";
                                continue;
                            }
                            if (nextParm == "prop") {
                                prop = parameter;
                                nextParm = "default";
                                continue;
                            }
                            if (nextParm != "default") continue;
                            if (defval.length() > 0) {
                                defval = defval + ",";
                            }
                            defval = defval + parameter;
                        }
                        fqid = fqid.trim();
                        prop = prop.trim();
                        defval = defval.trim();
                        String host = null;
                        String port = null;
                        String repository = null;
                        String user = null;
                        String password = null;
                        if (Globals.g_mode == 2 || Globals.g_mode == 5) {
                            host = Globals.g_cmtConnectHost;
                            port = Globals.g_cmtConnectPort;
                            repository = Globals.g_cmtConnectRepos;
                            user = Globals.g_cmtConnectUser;
                            password = Globals.g_cmtConnectPassword;
                        } else {
                            host = Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null);
                            port = Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null);
                            repository = Globals.g_configData.getProperty("oma.repository.foundation.name", null);
                            user = Globals.g_configData.getProperty("oma.person.admin.login.userid", null);
                            password = Globals.g_configData.getProperty("oma.person.admin.login.passwd", null);
                        }
                        String defaultValue = null;
                        if (defval.length() > 0) {
                            defaultValue = defval;
                        }
                        value = host != null && port != null && repository != null && user != null && password != null ? MetadataAccess.propQuery(host, port, repository, user, password, fqid, prop, defaultValue) : null;
                    }
                    if (value != null) {
                        before = newText.substring(0, firstAt);
                        after = newText.substring(nextAt + 2);
                        newText = before + value + after;
                        firstAt = newText.indexOf("@", firstAt + value.length());
                        continue;
                    }
                    firstAt = nextAt;
                    continue;
                }
                firstAt = -1;
                continue;
            }
            if (newText.indexOf("instcount[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 11);
                if (nextAt > -1) {
                    macro = newText.substring(firstAt + 11, nextAt);
                    if (PropertyRules.containsProperty(macro)) {
                        macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                    }
                    String host = null;
                    String port = null;
                    String repository = null;
                    String user = null;
                    String password = null;
                    if (Globals.g_mode == 2 || Globals.g_mode == 5) {
                        host = Globals.g_cmtConnectHost;
                        port = Globals.g_cmtConnectPort;
                        repository = Globals.g_cmtConnectRepos;
                        user = Globals.g_cmtConnectUser;
                        password = Globals.g_cmtConnectPassword;
                    } else {
                        host = Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null);
                        port = Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null);
                        repository = Globals.g_configData.getProperty("oma.repository.foundation.name", null);
                        user = Globals.g_configData.getProperty("oma.person.admin.login.userid", null);
                        password = Globals.g_configData.getProperty("oma.person.admin.login.passwd", null);
                    }
                    value = host != null && port != null && repository != null && user != null && password != null ? MetadataAccess.instCount(host, port, repository, user, password, macro) : null;
                    if (value != null) {
                        before = newText.substring(0, firstAt);
                        after = newText.substring(nextAt + 2);
                        newText = before + value + after;
                        firstAt = newText.indexOf("@", firstAt + value.length());
                        continue;
                    }
                    firstAt = nextAt;
                    continue;
                }
                firstAt = -1;
                continue;
            }
            if (newText.indexOf("normalize[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 11);
                if (nextAt <= -1) continue;
                macro = newText.substring(firstAt + 11, nextAt);
                if (PropertyRules.containsProperty(macro)) {
                    macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                }
                macro = Utils.stringReplaceAll(macro, "`", "");
                macro = Utils.stringReplaceAll(macro, "!", "");
                macro = Utils.stringReplaceAll(macro, "@", "");
                macro = Utils.stringReplaceAll(macro, "#", "");
                macro = Utils.stringReplaceAll(macro, "$", "");
                macro = Utils.stringReplaceAll(macro, "%", "");
                macro = Utils.stringReplaceAll(macro, "^", "");
                macro = Utils.stringReplaceAll(macro, "&", "");
                macro = Utils.stringReplaceAll(macro, "*", "");
                macro = Utils.stringReplaceAll(macro, "(", "");
                macro = Utils.stringReplaceAll(macro, ")", "");
                macro = Utils.stringReplaceAll(macro, "-", "");
                macro = Utils.stringReplaceAll(macro, "_", "");
                macro = Utils.stringReplaceAll(macro, "=", "");
                macro = Utils.stringReplaceAll(macro, "+", "");
                macro = Utils.stringReplaceAll(macro, "\\", "");
                macro = Utils.stringReplaceAll(macro, "|", "");
                macro = Utils.stringReplaceAll(macro, "'", "");
                macro = Utils.stringReplaceAll(macro, "\"", "");
                macro = Utils.stringReplaceAll(macro, ";", "");
                macro = Utils.stringReplaceAll(macro, ":", "");
                macro = Utils.stringReplaceAll(macro, "/", "");
                macro = Utils.stringReplaceAll(macro, "?", "");
                macro = Utils.stringReplaceAll(macro, ".", "");
                macro = Utils.stringReplaceAll(macro, ",", "");
                macro = Utils.stringReplaceAll(macro, ">", "");
                macro = Utils.stringReplaceAll(macro, "<", "");
                value = macro = Utils.stringReplaceAll(macro, " ", "");
                if (value != null) {
                    before = newText.substring(0, firstAt);
                    after = newText.substring(nextAt + 2);
                    newText = before + value + after;
                    firstAt = newText.indexOf("@", firstAt + value.length());
                    continue;
                }
                firstAt = nextAt;
                continue;
            }
            if (newText.indexOf("compress[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 10);
                if (nextAt <= -1) continue;
                macro = newText.substring(firstAt + 10, nextAt);
                if (PropertyRules.containsProperty(macro)) {
                    macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                }
                if ((value = Utils.stringReplaceAll(macro, " ", "")) != null) {
                    before = newText.substring(0, firstAt);
                    after = newText.substring(nextAt + 2);
                    newText = before + value + after;
                    firstAt = newText.indexOf("@", firstAt + value.length());
                    continue;
                }
                firstAt = nextAt;
                continue;
            }
            if (newText.indexOf("isdefined[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 11);
                if (nextAt <= -1) continue;
                macro = newText.substring(firstAt + 11, nextAt);
                value = type == 1 ? Globals.g_installData.getProperty(macro, null) : Globals.g_configData.getProperty(macro, null);
                value = value != null ? CONSTANT_TRUE : CONSTANT_FALSE;
                before = newText.substring(0, firstAt);
                after = newText.substring(nextAt + 2);
                newText = before + value + after;
                firstAt = newText.indexOf("@", firstAt + value.length());
                continue;
            }
            if (newText.indexOf("getldrprop[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 12);
                if (nextAt > -1) {
                    String[] parameters;
                    macro = newText.substring(firstAt + 12, nextAt);
                    if (PropertyRules.containsProperty(macro)) {
                        macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                    }
                    if ((parameters = macro.split(",")).length < 2) {
                        value = null;
                        Logging.log.severe("Invalid getldrprop[] syntax: " + macro);
                    } else {
                        String ldrHost = "";
                        String prop = "";
                        int count = 0;
                        String parameter = null;
                        for (int i = 0; i < parameters.length; ++i) {
                            parameter = parameters[i];
                            if (++count == parameters.length) {
                                prop = parameter.trim();
                                continue;
                            }
                            if (ldrHost.length() > 0) {
                                ldrHost = ldrHost + ",";
                            }
                            ldrHost = ldrHost + parameter;
                        }
                        String host = null;
                        String port = null;
                        String repository = null;
                        String user = null;
                        String password = null;
                        if (Globals.g_mode == 2 || Globals.g_mode == 5) {
                            host = Globals.g_cmtConnectHost;
                            port = Globals.g_cmtConnectPort;
                            repository = Globals.g_cmtConnectRepos;
                            user = Globals.g_cmtConnectUser;
                            password = Globals.g_cmtConnectPassword;
                        } else {
                            host = Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null);
                            port = Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null);
                            repository = Globals.g_configData.getProperty("oma.repository.foundation.name", null);
                            user = Globals.g_configData.getProperty("oma.person.admin.login.userid", null);
                            password = Globals.g_configData.getProperty("oma.person.admin.login.passwd", null);
                        }
                        value = host != null && port != null && repository != null && user != null && password != null ? MetadataAccess.getLDRProp(host, port, repository, user, password, ldrHost, prop) : null;
                    }
                    if (value != null) {
                        before = newText.substring(0, firstAt);
                        after = newText.substring(nextAt + 2);
                        newText = before + value + after;
                        firstAt = newText.indexOf("@", firstAt + value.length());
                        continue;
                    }
                    firstAt = nextAt;
                    continue;
                }
                firstAt = -1;
                continue;
            }
            if (newText.indexOf("getslash[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 10);
                if (nextAt <= -1) continue;
                macro = newText.substring(firstAt + 10, nextAt);
                if (PropertyRules.containsProperty(macro)) {
                    macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                }
                value = macro.startsWith("/") ? "/" : "\\";
                before = newText.substring(0, firstAt);
                after = newText.substring(nextAt + 2);
                newText = before + value + after;
                firstAt = newText.indexOf("@", firstAt + value.length());
                continue;
            }
            if (newText.indexOf("resolve[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 9);
                if (nextAt > -1) {
                    macro = newText.substring(firstAt + 9, nextAt);
                    if (PropertyRules.containsProperty(macro)) {
                        macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                    }
                    before = newText.substring(0, firstAt);
                    after = newText.substring(nextAt + 2);
                    newText = before + macro + after;
                    firstAt = newText.indexOf("@", firstAt + macro.length());
                    continue;
                }
                firstAt = -1;
                continue;
            }
            if (newText.indexOf("firstunusedport[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 17);
                if (nextAt > -1) {
                    String[] parameters;
                    macro = newText.substring(firstAt + 17, nextAt);
                    if (PropertyRules.containsProperty(macro)) {
                        macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                    }
                    if ((parameters = macro.split(",")).length < 2) {
                        value = null;
                        Logging.log.severe("Invalid firstunusedport[] syntax: " + macro);
                    } else {
                        int lowPort = -1;
                        int highPort = -1;
                        int initial = -1;
                        int increment = 1;
                        String protocol = "tcp";
                        String hostName = null;
                        int count = 0;
                        block35: for (int i = 0; i < parameters.length; ++i) {
                            String parameter = parameters[i];
                            switch (++count) {
                                case 1: {
                                    try {
                                        lowPort = Integer.parseInt(parameter.trim());
                                    }
                                    catch (Exception e) {
                                        Logging.log.severe("Invalid firstunusedport[] low port value: " + macro);
                                    }
                                    continue block35;
                                }
                                case 2: {
                                    try {
                                        highPort = Integer.parseInt(parameter.trim());
                                    }
                                    catch (Exception e) {
                                        Logging.log.severe("Invalid firstunusedport[] high port value: " + macro);
                                    }
                                    continue block35;
                                }
                                case 3: {
                                    try {
                                        initial = Integer.parseInt(parameter.trim());
                                    }
                                    catch (Exception e) {
                                        Logging.log.severe("Invalid firstunusedport[] initial value: " + macro);
                                    }
                                    continue block35;
                                }
                                case 4: {
                                    try {
                                        increment = Integer.parseInt(parameter.trim());
                                    }
                                    catch (Exception e) {
                                        Logging.log.severe("Invalid firstunusedport[] increment value: " + macro);
                                    }
                                    continue block35;
                                }
                                case 5: {
                                    protocol = parameter.trim().toLowerCase(Locale.ENGLISH);
                                    if ("udp".equals(protocol) || "tcp".equals(protocol)) continue block35;
                                    Logging.log.severe("Invalid firstunusedport[] protocol value: " + macro);
                                    continue block35;
                                }
                                case 6: {
                                    hostName = parameter.trim();
                                    if (!"".equals(hostName)) continue block35;
                                    hostName = null;
                                    continue block35;
                                }
                                default: {
                                    Logging.log.severe("Invalid firstunusedport[] syntax: " + macro);
                                }
                            }
                        }
                        if (initial == -1) {
                            initial = lowPort;
                        }
                        if (lowPort <= initial && initial <= highPort && increment != 0 && Utils.isValidPortNumber(Integer.toString(lowPort)) && Utils.isValidPortNumber(Integer.toString(highPort))) {
                            InetAddress addr = null;
                            if (hostName != null) {
                                try {
                                    addr = InetAddress.getByName(hostName);
                                }
                                catch (Exception e) {
                                    Logging.log.severe("firstunusedport[] unable to resolve hostname: " + macro);
                                }
                            }
                            int foundPort = -1;
                            int rangeSpan = highPort - lowPort + 1;
                            int checkPort = initial;
                            for (count = rangeSpan / Math.abs(increment %= rangeSpan) + 1; count > 0 && foundPort < 0; --count) {
                                if (!Utils.isServerPortAvailable(checkPort, protocol, addr)) continue;
                                foundPort = checkPort;
                            }
                            if (foundPort < 0) {
                                foundPort = initial;
                            }
                            value = Integer.toString(foundPort);
                        } else {
                            value = null;
                        }
                    }
                    if (value != null) {
                        before = newText.substring(0, firstAt);
                        after = newText.substring(nextAt + 2);
                        newText = before + value + after;
                        firstAt = newText.indexOf("@", firstAt + value.length());
                        continue;
                    }
                    firstAt = nextAt;
                    continue;
                }
                firstAt = -1;
                continue;
            }
            if (newText.indexOf("winregquery[", firstAt + 1) == firstAt + 1) {
                nextAt = PropertyRules.getMacroEnd(newText, firstAt + 13);
                if (nextAt > -1) {
                    macro = newText.substring(firstAt + 13, nextAt);
                    if (PropertyRules.containsProperty(macro)) {
                        macro = PropertyRules.resolveProperties(macro, type, forceDefault);
                    }
                    String[] parameters = macro.split(",");
                    if (Utils.getOS() != 1) {
                        value = null;
                        Logging.log.severe("winregquery[] not valid for OS: " + Utils.getOS_Suffix());
                    } else if (parameters.length != 4) {
                        value = null;
                        Logging.log.severe("Invalid winregquery[] syntax: " + macro);
                    } else {
                        String hkey = parameters[0].trim();
                        String key = parameters[1].trim();
                        String name = parameters[2].trim();
                        String defVal = parameters[3].trim();
                        if (hkey != null && key != null && name != null && defVal != null) {
                            int hkeyCode = 0;
                            if (hkey.equalsIgnoreCase("HKEY_CLASSES_ROOT")) {
                                hkeyCode = 1;
                            } else if (hkey.equalsIgnoreCase("HKEY_CURRENT_CONFIG")) {
                                hkeyCode = 2;
                            } else if (hkey.equalsIgnoreCase("HKEY_CURRENT_USER")) {
                                hkeyCode = 4;
                            } else if (hkey.equalsIgnoreCase("HKEY_LOCAL_MACHINE")) {
                                hkeyCode = 8;
                            }
                            if (hkeyCode == 0) {
                                value = null;
                                Logging.log.severe("Invalid winregquery[] HKEY value: " + macro);
                            } else {
                                value = WinRegAPI.getWindowsRegistryValue(hkeyCode, key, name);
                                if (value == null) {
                                    value = defVal;
                                }
                            }
                        } else {
                            value = null;
                        }
                    }
                    if (value != null) {
                        before = newText.substring(0, firstAt);
                        after = newText.substring(nextAt + 2);
                        newText = before + value + after;
                        firstAt = newText.indexOf("@", firstAt + value.length());
                        continue;
                    }
                    firstAt = nextAt;
                    continue;
                }
                firstAt = -1;
                continue;
            }
            nextAt = newText.indexOf("@", firstAt + 1);
            if (nextAt > -1) {
                property = newText.substring(firstAt + 1, nextAt);
                if (property.equals("/")) {
                    value = File.separator;
                } else if ((property.equals("+") || property.equals("ADD") || property.equals("-") || property.equals("SUB") || property.equals("*") || property.equals("MULT") || property.equals("%") || property.equals("MOD") || property.equals("DIV")) && firstAt > 0 && newText.substring(firstAt - 1, firstAt).equals(" ") && nextAt + 2 <= newText.length() && newText.substring(nextAt + 1, nextAt + 2).equals(" ")) {
                    performMath = true;
                    value = property;
                } else {
                    value = type == 1 ? Globals.g_installData.getProperty(property, null) : Globals.g_configData.getProperty(property, null);
                    if (value == null && type == 0 && Globals.g_mode == 2 && Globals.g_cmtTask == 5 && Globals.g_instances != null) {
                        boolean finished = false;
                        Properties instanceProps = null;
                        for (int i = 0; i < Globals.g_instances.length && !finished; ++i) {
                            instanceProps = Globals.g_instances[i].getInstanceData().getProperties();
                            if (instanceProps == null) continue;
                            if (value != null && instanceProps.containsKey(property)) {
                                value = null;
                                finished = true;
                                continue;
                            }
                            value = instanceProps.getProperty(property, null);
                        }
                    }
                    if (value == null) {
                        if (type == 1) {
                            value = Globals.g_installDefaults.getDefault(property, null);
                        } else if (Globals.g_configKnownProps == null || !Globals.g_configKnownProps.containsKey(property) || forceDefault) {
                            value = Globals.g_configDefaults.getDefault(property, null);
                        }
                    }
                    if (value != null && PropertyRules.containsProperty(value)) {
                        value = PropertyRules.resolveProperties(value, type, forceDefault);
                    }
                }
                if (value != null) {
                    before = newText.substring(0, firstAt);
                    after = newText.substring(nextAt + 1);
                    newText = before + value + after;
                    firstAt = newText.indexOf("@", firstAt + value.length());
                    continue;
                }
                firstAt = nextAt;
                continue;
            }
            firstAt = -1;
        }
        if (performMath) {
            boolean error = false;
            int total = 0;
            int action = 0;
            String part = null;
            StringTokenizer equationParts = new StringTokenizer(newText);
            while (equationParts.hasMoreTokens() && !error) {
                part = equationParts.nextToken();
                if (part.equals("+") || part.equals("ADD")) {
                    action = 1;
                    continue;
                }
                if (part.equals("-") || part.equals("SUB")) {
                    action = 2;
                    continue;
                }
                if (part.equals("*") || part.equals("MULT")) {
                    action = 3;
                    continue;
                }
                if (part.equals("DIV")) {
                    action = 4;
                    continue;
                }
                if (part.equals("%") || part.equals("MOD")) {
                    action = 5;
                    continue;
                }
                if (action == 0) {
                    try {
                        total = Integer.parseInt(part);
                    }
                    catch (Exception e) {
                        error = true;
                        total = 0;
                        Logging.log.severe("Invalid property syntax: " + text);
                        Logging.logStackTrace(e);
                    }
                    continue;
                }
                if (action == 1) {
                    try {
                        total += Integer.parseInt(part);
                    }
                    catch (Exception e) {
                        error = true;
                        total = 0;
                        Logging.log.severe("Invalid property syntax: " + text);
                        Logging.logStackTrace(e);
                    }
                    continue;
                }
                if (action == 2) {
                    try {
                        total -= Integer.parseInt(part);
                    }
                    catch (Exception e) {
                        error = true;
                        total = 0;
                        Logging.log.severe("Invalid property syntax: " + text);
                        Logging.logStackTrace(e);
                    }
                    continue;
                }
                if (action == 3) {
                    try {
                        total *= Integer.parseInt(part);
                    }
                    catch (Exception e) {
                        error = true;
                        total = 0;
                        Logging.log.severe("Invalid property syntax: " + text);
                        Logging.logStackTrace(e);
                    }
                    continue;
                }
                if (action == 4) {
                    try {
                        total /= Integer.parseInt(part);
                    }
                    catch (Exception e) {
                        error = true;
                        total = 0;
                        Logging.log.severe("Invalid property syntax: " + text);
                        Logging.logStackTrace(e);
                    }
                    continue;
                }
                if (action != 5) continue;
                try {
                    total %= Integer.parseInt(part);
                }
                catch (Exception e) {
                    error = true;
                    total = 0;
                    Logging.log.severe("Invalid property syntax: " + text);
                    Logging.logStackTrace(e);
                }
            }
            newText = Integer.toString(total);
        }
        if (!newText.equals(text) && PropertyRules.containsProperty(newText)) {
            newText = PropertyRules.resolveProperties(newText, type, forceDefault);
        }
        newText = newText.trim();
        return newText;
    }

    private static int getMacroEnd(String text, int start) {
        int count = 0;
        int end = -1;
        for (int i = start; i < text.length() && end == -1; ++i) {
            if (text.indexOf("@gendefault[", i) == i || text.indexOf("@metaquery[", i) == i || text.indexOf("@fqidquery[", i) == i || text.indexOf("@propsubstring[", i) == i || text.indexOf("@propquery[", i) == i || text.indexOf("@instcount[", i) == i || text.indexOf("@normalize[", i) == i || text.indexOf("@compress[", i) == i || text.indexOf("@isdefined[", i) == i || text.indexOf("@getldrprop[", i) == i || text.indexOf("@getslash[", i) == i || text.indexOf("@resolve[", i) == i || text.indexOf("@firstunusedport[", i) == i || text.indexOf("@winregquery[", i) == i) {
                ++count;
                continue;
            }
            if (text.indexOf("]@", i) != i) continue;
            if (count == 0) {
                end = i;
                continue;
            }
            --count;
        }
        return end;
    }

    public static String resolveStringRule(String expression, int type) {
        return PropertyRules.resolveStringRule(expression, type, false);
    }

    public static String resolveStringRule(String expression, int type, boolean forceDefault) {
        boolean valid = true;
        boolean found = false;
        boolean validElse = true;
        int closingPos = 0;
        String defaultValue = null;
        String workExpression = expression.trim();
        String lcWorkExpression = workExpression.toLowerCase(Locale.ENGLISH);
        String rule = null;
        try {
            while (!found && (lcWorkExpression.startsWith("if") || lcWorkExpression.startsWith("else if"))) {
                if ((workExpression = workExpression.substring(lcWorkExpression.indexOf("if") + 2).trim()).startsWith("(")) {
                    closingPos = PropertyRules.findMatchingParenthesis(workExpression);
                    if (closingPos > 0) {
                        rule = workExpression.substring(0, closingPos + 1);
                        found = PropertyRules.resolveBooleanRule(rule, false, type);
                        workExpression = workExpression.substring(closingPos + 1).trim();
                        if (found) {
                            if (workExpression.startsWith("{")) {
                                defaultValue = workExpression.substring(1, PropertyRules.findMatchingBrace(workExpression));
                            } else {
                                valid = false;
                            }
                        } else {
                            workExpression = workExpression.substring(PropertyRules.findMatchingBrace(workExpression) + 1).trim();
                        }
                    } else {
                        valid = false;
                    }
                } else {
                    valid = false;
                }
                lcWorkExpression = workExpression.toLowerCase(Locale.ENGLISH);
            }
            if (valid && !found) {
                lcWorkExpression = workExpression.toLowerCase(Locale.ENGLISH);
                if (lcWorkExpression.startsWith("else")) {
                    if ((workExpression = workExpression.substring(lcWorkExpression.indexOf("else") + 4).trim()).startsWith("{")) {
                        defaultValue = workExpression.substring(1, PropertyRules.findMatchingBrace(workExpression));
                    } else {
                        valid = false;
                    }
                } else {
                    valid = false;
                    validElse = false;
                }
            }
        }
        catch (Exception e) {
            valid = false;
        }
        if (valid) {
            if (PropertyRules.containsProperty(defaultValue)) {
                defaultValue = PropertyRules.resolveProperties(defaultValue, type, forceDefault);
            }
        } else {
            defaultValue = "";
            if (validElse) {
                Logging.log.severe("Invalid generate default expression: " + expression);
            }
        }
        return defaultValue;
    }

    private static int findMatchingParenthesis(String expression) {
        int pos = 0;
        int matchCount = 1;
        String expChar = null;
        for (int i = 1; i < expression.length() && pos == 0; ++i) {
            expChar = expression.substring(i, i + 1);
            if (expChar.equals("(")) {
                ++matchCount;
            } else if (expChar.equals(")")) {
                --matchCount;
            }
            if (matchCount != 0) continue;
            pos = i;
        }
        return pos;
    }

    private static int findMatchingBrace(String expression) {
        int pos = 0;
        int matchCount = 1;
        String expChar = null;
        for (int i = 1; i < expression.length() && pos == 0; ++i) {
            expChar = expression.substring(i, i + 1);
            if (expChar.equals("{")) {
                ++matchCount;
            } else if (expChar.equals("}")) {
                --matchCount;
            }
            if (matchCount != 0) continue;
            pos = i;
        }
        return pos;
    }

    private static LinkedList parseRuleClause(String clause) {
        LinkedList<RuleClauses> clauses = new LinkedList<RuleClauses>();
        int stringCount = 0;
        int clauseCount = 0;
        int operatorCount = 0;
        int openParenPos = clause.indexOf("(");
        if (openParenPos > -1) {
            String subClause = null;
            boolean moreClauses = true;
            int startParenPos = 0;
            int openParenCount = 0;
            int closeParenPos = clause.indexOf(")");
            int closeParenCount = 0;
            while (moreClauses) {
                if (openParenPos < closeParenPos && openParenPos > -1) {
                    if (++openParenCount == 1) {
                        startParenPos = openParenPos;
                    }
                    openParenPos = clause.indexOf("(", openParenPos + 1);
                    continue;
                }
                if (closeParenPos > -1) {
                    if (++closeParenCount == openParenCount) {
                        subClause = clause.substring(startParenPos + 1, closeParenPos);
                        int ignoreClausePos = subClause.indexOf(" contains ");
                        while (ignoreClausePos > -1) {
                            --openParenCount;
                            --closeParenCount;
                            ignoreClausePos = subClause.indexOf(" contains ", ignoreClausePos + 1);
                        }
                        ignoreClausePos = subClause.indexOf(" containsall ");
                        while (ignoreClausePos > -1) {
                            --openParenCount;
                            --closeParenCount;
                            ignoreClausePos = subClause.indexOf(" containsall ", ignoreClausePos + 1);
                        }
                        if (openParenCount > 1) {
                            clauses.add(new RuleClauses(RULE_CLAUSE + ++clauseCount, PropertyRules.parseRuleClause(subClause)));
                        } else {
                            clauses.add(new RuleClauses(RULE_STRING + ++stringCount, subClause));
                        }
                        openParenCount = 0;
                        closeParenCount = 0;
                        if (closeParenPos < openParenPos) {
                            subClause = clause.substring(closeParenPos + 1, openParenPos).trim();
                            clauses.add(new RuleClauses(RULE_OPERATOR + ++operatorCount, subClause));
                        }
                    }
                    closeParenPos = clause.indexOf(")", closeParenPos + 1);
                    continue;
                }
                if (openParenPos != -1) continue;
                moreClauses = false;
            }
        } else {
            clauses.add(new RuleClauses(RULE_STRING + ++stringCount, clause));
        }
        return clauses;
    }

    private static boolean resolveClauses(LinkedList clauses, boolean initial, int type) {
        String OPERATOR_OR = "or";
        String OPERATOR_AND = "and";
        String OPERATOR_CONTAINS = " contains ";
        String OPERATOR_NOT_CONTAINS = " not contains ";
        String OPERATOR_CONTAINSALL = " containsall ";
        String OPERATOR_NOT_CONTAINSALL = " not containsall ";
        String OPERATOR_EQUAL = " ==";
        String OPERATOR_NOT_EQUAL = " !=";
        String OPERATOR_GREATER_EQUAL = " >=";
        String OPERATOR_GREATER = " >";
        String OPERATOR_LESS_EQUAL = " <=";
        String OPERATOR_LESS = " <";
        boolean valid = false;
        boolean clauseValid = false;
        boolean orOperator = false;
        boolean andOperator = false;
        RuleClauses clausesData = null;
        String clause = null;
        String leftSide = null;
        String rightSide = null;
        int operatorPos = 0;
        for (int i = 0; i < clauses.size(); ++i) {
            clausesData = (RuleClauses)clauses.get(i);
            if (clausesData.getType().indexOf(RULE_OPERATOR) > -1) {
                clause = (String)clausesData.getData();
                if (clause.equalsIgnoreCase("or")) {
                    orOperator = true;
                    andOperator = false;
                    continue;
                }
                if (!clause.equalsIgnoreCase("and")) continue;
                orOperator = false;
                andOperator = true;
                continue;
            }
            if (clausesData.getType().indexOf(RULE_STRING) > -1) {
                block74: {
                    Float rs;
                    Float ls;
                    block73: {
                        block72: {
                            block71: {
                                int j;
                                String[] prodCodes;
                                HashMap<String, String> hashMap;
                                if ((andOperator || orOperator) && !andOperator && (!orOperator || valid)) continue;
                                clauseValid = false;
                                clause = ((String)clausesData.getData()).toLowerCase(Locale.ENGLISH);
                                operatorPos = clause.indexOf(" not containsall ");
                                if (operatorPos > -1) {
                                    leftSide = PropertyRules.getLeftSide(clause, operatorPos);
                                    rightSide = PropertyRules.getRightSide(clause, operatorPos + " not containsall ".length());
                                    rightSide = rightSide.substring(1, rightSide.length() - 1);
                                    if (initial && PropertyRules.containsProperty(rightSide)) {
                                        clauseValid = true;
                                    } else {
                                        hashMap = PropertyRules.getCorrectHashMap(leftSide);
                                        if (hashMap != null) {
                                            if (PropertyRules.containsProperty(rightSide)) {
                                                rightSide = PropertyRules.resolveProperties(rightSide, type);
                                            }
                                            prodCodes = rightSide.split(" ");
                                            for (j = 0; j < prodCodes.length && !clauseValid; ++j) {
                                                clauseValid = !hashMap.containsKey(prodCodes[j].toLowerCase(Locale.ENGLISH));
                                            }
                                        }
                                    }
                                }
                                if (operatorPos == -1 && (operatorPos = clause.indexOf(" containsall ")) > -1) {
                                    leftSide = PropertyRules.getLeftSide(clause, operatorPos);
                                    rightSide = PropertyRules.getRightSide(clause, operatorPos + " containsall ".length());
                                    rightSide = rightSide.substring(1, rightSide.length() - 1);
                                    if (initial && PropertyRules.containsProperty(rightSide)) {
                                        clauseValid = true;
                                    } else {
                                        hashMap = PropertyRules.getCorrectHashMap(leftSide);
                                        if (hashMap != null) {
                                            if (PropertyRules.containsProperty(rightSide)) {
                                                rightSide = PropertyRules.resolveProperties(rightSide, type);
                                            }
                                            prodCodes = rightSide.split(" ");
                                            clauseValid = true;
                                            for (j = 0; j < prodCodes.length && clauseValid; ++j) {
                                                if (hashMap.containsKey(prodCodes[j].toLowerCase(Locale.ENGLISH))) continue;
                                                clauseValid = false;
                                            }
                                        }
                                    }
                                }
                                if (operatorPos == -1 && (operatorPos = clause.indexOf(" not contains ")) > -1) {
                                    leftSide = PropertyRules.getLeftSide(clause, operatorPos);
                                    rightSide = PropertyRules.getRightSide(clause, operatorPos + " not contains ".length());
                                    rightSide = rightSide.substring(1, rightSide.length() - 1);
                                    if (initial && PropertyRules.containsProperty(rightSide)) {
                                        clauseValid = true;
                                    } else {
                                        hashMap = PropertyRules.getCorrectHashMap(leftSide);
                                        if (hashMap != null) {
                                            if (PropertyRules.containsProperty(rightSide)) {
                                                rightSide = PropertyRules.resolveProperties(rightSide, type);
                                            }
                                            prodCodes = rightSide.split(" ");
                                            clauseValid = true;
                                            for (j = 0; j < prodCodes.length && clauseValid; ++j) {
                                                if (!hashMap.containsKey(prodCodes[j].toLowerCase(Locale.ENGLISH))) continue;
                                                clauseValid = false;
                                            }
                                        }
                                    }
                                }
                                if (operatorPos == -1 && (operatorPos = clause.indexOf(" contains ")) > -1) {
                                    leftSide = PropertyRules.getLeftSide(clause, operatorPos);
                                    rightSide = PropertyRules.getRightSide(clause, operatorPos + " contains ".length());
                                    rightSide = rightSide.substring(1, rightSide.length() - 1);
                                    if (initial && PropertyRules.containsProperty(rightSide)) {
                                        clauseValid = true;
                                    } else {
                                        hashMap = PropertyRules.getCorrectHashMap(leftSide);
                                        if (hashMap != null) {
                                            if (PropertyRules.containsProperty(rightSide)) {
                                                rightSide = PropertyRules.resolveProperties(rightSide, type);
                                            }
                                            prodCodes = rightSide.split(" ");
                                            for (j = 0; j < prodCodes.length && !clauseValid; ++j) {
                                                clauseValid = hashMap.containsKey(prodCodes[j].toLowerCase(Locale.ENGLISH));
                                            }
                                        }
                                    }
                                }
                                if (operatorPos == -1 && (operatorPos = clause.indexOf(" ==")) > -1) {
                                    leftSide = PropertyRules.getLeftSide(clause, operatorPos);
                                    rightSide = PropertyRules.getRightSide(clause, operatorPos + " ==".length());
                                    if (initial && (PropertyRules.containsProperty(leftSide) || PropertyRules.containsProperty(rightSide))) {
                                        clauseValid = true;
                                    } else {
                                        if (PropertyRules.containsProperty(leftSide)) {
                                            leftSide = PropertyRules.resolveProperties(leftSide, type);
                                        }
                                        if (PropertyRules.containsProperty(rightSide)) {
                                            rightSide = PropertyRules.resolveProperties(rightSide, type);
                                        }
                                        clauseValid = leftSide.equalsIgnoreCase(rightSide);
                                    }
                                }
                                if (operatorPos == -1 && (operatorPos = clause.indexOf(" !=")) > -1) {
                                    leftSide = PropertyRules.getLeftSide(clause, operatorPos);
                                    rightSide = PropertyRules.getRightSide(clause, operatorPos + " !=".length());
                                    if (initial && (PropertyRules.containsProperty(leftSide) || PropertyRules.containsProperty(rightSide))) {
                                        clauseValid = true;
                                    } else {
                                        if (PropertyRules.containsProperty(leftSide)) {
                                            leftSide = PropertyRules.resolveProperties(leftSide, type);
                                        }
                                        if (PropertyRules.containsProperty(rightSide)) {
                                            rightSide = PropertyRules.resolveProperties(rightSide, type);
                                        }
                                        boolean bl = clauseValid = !leftSide.equalsIgnoreCase(rightSide);
                                    }
                                }
                                if (operatorPos == -1 && (operatorPos = clause.indexOf(" >=")) > -1) {
                                    leftSide = PropertyRules.getLeftSide(clause, operatorPos);
                                    rightSide = PropertyRules.getRightSide(clause, operatorPos + " >=".length());
                                    if (initial && (PropertyRules.containsProperty(leftSide) || PropertyRules.containsProperty(rightSide))) {
                                        clauseValid = true;
                                    } else {
                                        if (PropertyRules.containsProperty(leftSide)) {
                                            leftSide = PropertyRules.resolveProperties(leftSide, type);
                                        }
                                        if (PropertyRules.containsProperty(rightSide)) {
                                            rightSide = PropertyRules.resolveProperties(rightSide, type);
                                        }
                                        try {
                                            ls = Float.valueOf(Float.parseFloat(leftSide));
                                            rs = Float.valueOf(Float.parseFloat(rightSide));
                                            clauseValid = ls.floatValue() >= rs.floatValue();
                                        }
                                        catch (Exception e) {
                                            if (leftSide.compareTo(rightSide) < 0) break block71;
                                            clauseValid = true;
                                        }
                                    }
                                }
                            }
                            if (operatorPos == -1 && (operatorPos = clause.indexOf(" >")) > -1) {
                                leftSide = PropertyRules.getLeftSide(clause, operatorPos);
                                rightSide = PropertyRules.getRightSide(clause, operatorPos + " >".length());
                                if (initial && (PropertyRules.containsProperty(leftSide) || PropertyRules.containsProperty(rightSide))) {
                                    clauseValid = true;
                                } else {
                                    if (PropertyRules.containsProperty(leftSide)) {
                                        leftSide = PropertyRules.resolveProperties(leftSide, type);
                                    }
                                    if (PropertyRules.containsProperty(rightSide)) {
                                        rightSide = PropertyRules.resolveProperties(rightSide, type);
                                    }
                                    try {
                                        ls = Float.valueOf(Float.parseFloat(leftSide));
                                        rs = Float.valueOf(Float.parseFloat(rightSide));
                                        clauseValid = ls.floatValue() > rs.floatValue();
                                    }
                                    catch (Exception e) {
                                        if (leftSide.compareTo(rightSide) <= 0) break block72;
                                        clauseValid = true;
                                    }
                                }
                            }
                        }
                        if (operatorPos == -1 && (operatorPos = clause.indexOf(" <=")) > -1) {
                            leftSide = PropertyRules.getLeftSide(clause, operatorPos);
                            rightSide = PropertyRules.getRightSide(clause, operatorPos + " <=".length());
                            if (initial && (PropertyRules.containsProperty(leftSide) || PropertyRules.containsProperty(rightSide))) {
                                clauseValid = true;
                            } else {
                                if (PropertyRules.containsProperty(leftSide)) {
                                    leftSide = PropertyRules.resolveProperties(leftSide, type);
                                }
                                if (PropertyRules.containsProperty(rightSide)) {
                                    rightSide = PropertyRules.resolveProperties(rightSide, type);
                                }
                                try {
                                    ls = Float.valueOf(Float.parseFloat(leftSide));
                                    rs = Float.valueOf(Float.parseFloat(rightSide));
                                    clauseValid = ls.floatValue() <= rs.floatValue();
                                }
                                catch (Exception e) {
                                    if (leftSide.compareTo(rightSide) > 0) break block73;
                                    clauseValid = true;
                                }
                            }
                        }
                    }
                    if (operatorPos == -1 && (operatorPos = clause.indexOf(" <")) > -1) {
                        leftSide = PropertyRules.getLeftSide(clause, operatorPos);
                        rightSide = PropertyRules.getRightSide(clause, operatorPos + " <".length());
                        if (initial && (PropertyRules.containsProperty(leftSide) || PropertyRules.containsProperty(rightSide))) {
                            clauseValid = true;
                        } else {
                            if (PropertyRules.containsProperty(leftSide)) {
                                leftSide = PropertyRules.resolveProperties(leftSide, type);
                            }
                            if (PropertyRules.containsProperty(rightSide)) {
                                rightSide = PropertyRules.resolveProperties(rightSide, type);
                            }
                            try {
                                ls = Float.valueOf(Float.parseFloat(leftSide));
                                rs = Float.valueOf(Float.parseFloat(rightSide));
                                clauseValid = ls.floatValue() < rs.floatValue();
                            }
                            catch (Exception e) {
                                if (leftSide.compareTo(rightSide) >= 0) break block74;
                                clauseValid = true;
                            }
                        }
                    }
                }
                if (operatorPos == -1 && PropertyRules.containsProperty(clause)) {
                    clause = PropertyRules.resolveProperties(clause, type);
                }
                if (operatorPos == -1 && clause.equals(CONSTANT_TRUE)) {
                    clauseValid = true;
                }
                if (operatorPos == -1 && clause.equals(CONSTANT_FALSE)) {
                    clauseValid = false;
                }
                if (orOperator) {
                    valid = valid || clauseValid;
                    continue;
                }
                if (andOperator) {
                    valid = valid && clauseValid;
                    continue;
                }
                valid = clauseValid;
                continue;
            }
            if (clausesData.getType().indexOf(RULE_CLAUSE) <= -1) continue;
            clauseValid = PropertyRules.resolveClauses((LinkedList)clausesData.getData(), initial, type);
            valid = orOperator ? valid || clauseValid : (andOperator ? valid && clauseValid : clauseValid);
        }
        return valid;
    }

    private static String getLeftSide(String clause, int operatorPos) {
        String leftSide = clause.substring(0, operatorPos).trim();
        return leftSide;
    }

    private static String getRightSide(String clause, int operatorPos) {
        String rightSide = clause.substring(operatorPos).trim();
        return rightSide;
    }

    private static HashMap<String, String> getCorrectHashMap(String leftSide) {
        HashMap<String, String> correctHash = null;
        if (leftSide.equals(CONSTANT_SELECTED_ALL)) {
            correctHash = PropertyRules.getSelectedAll();
        } else if (leftSide.equals(CONSTANT_SELECTED_DEPLOY)) {
            correctHash = PropertyRules.getSelectedDeploy();
        } else if (leftSide.equals(CONSTANT_SELECTED_CONFIG)) {
            correctHash = PropertyRules.getSelectedConfig();
        } else if (leftSide.equals(CONSTANT_MACHINE_ALL)) {
            correctHash = PropertyRules.getMachineAll();
        } else if (leftSide.equals(CONSTANT_MACHINE_DEPLOY)) {
            correctHash = PropertyRules.getMachineDeploy();
        } else if (leftSide.equals(CONSTANT_MACHINE_CONFIG)) {
            correctHash = PropertyRules.getMachineConfig();
        } else if (leftSide.equals(CONSTANT_PLAN_ALL)) {
            correctHash = PropertyRules.getPlanAll();
        } else if (leftSide.equals(CONSTANT_PLAN_DEPLOY)) {
            correctHash = PropertyRules.getPlanDeploy();
        } else if (leftSide.equals(CONSTANT_PLAN_CONFIG)) {
            correctHash = PropertyRules.getPlanConfig();
        } else if (leftSide.equals(CONSTANT_ORDER_LIST)) {
            correctHash = PropertyRules.getOrderList();
        } else if (leftSide.equals(CONSTANT_MACHINE_INSTALLED_LIST)) {
            correctHash = PropertyRules.getMachineInstalled();
        } else if (leftSide.equals(CONSTANT_MACHINE_CONFIGURED_LIST)) {
            correctHash = PropertyRules.getMachineConfigured();
        } else if (leftSide.equals(CONSTANT_UPDATE_MODE_LIST)) {
            correctHash = PropertyRules.getUpdateModeDeploy();
        }
        return correctHash;
    }

    private static HashMap<String, String> getMachineInstalled() {
        if (m_machineDeployed == null) {
            m_machineDeployed = new HashMap();
            String machineInstalledList = Globals.g_installData.loadMachineInstalledList();
            StringTokenizer st = new StringTokenizer(machineInstalledList, " ");
            while (st.hasMoreTokens()) {
                String prodCode = st.nextToken();
                m_machineDeployed.put(prodCode.toLowerCase(Locale.ENGLISH), null);
            }
        }
        return m_machineDeployed;
    }

    private static HashMap<String, String> getMachineConfigured() {
        if (m_machineConfigured == null) {
            m_machineConfigured = new HashMap();
            String machineConfiguredList = Globals.g_configData.loadMachineConfiguredList();
            StringTokenizer st = new StringTokenizer(machineConfiguredList, " ");
            while (st.hasMoreTokens()) {
                String prodCode = st.nextToken();
                m_machineConfigured.put(prodCode.toLowerCase(Locale.ENGLISH), null);
            }
        }
        return m_machineConfigured;
    }

    private static HashMap<String, String> getUpdateModeDeploy() {
        if (m_updateModeList == null) {
            m_updateModeList = new HashMap();
        }
        ProductData[] maintenance = Globals.g_sasHomeStatus.getRequiredInstallSteps();
        for (int i = 0; i < maintenance.length; ++i) {
            String prodcode = maintenance[i].getProdCode();
            m_updateModeList.put(prodcode.toLowerCase(Locale.ENGLISH), null);
        }
        return m_updateModeList;
    }

    private static HashMap<String, String> getSelectedAll() {
        if (m_selectedAll == null) {
            m_selectedAll = new HashMap();
            PropertyRules.addSelectedInstalls(m_selectedAll);
            if (Globals.g_planConfigs != null) {
                for (int i = 0; i < Globals.g_planConfigs.length; ++i) {
                    m_selectedAll.put(Globals.g_planConfigs[i].toLowerCase(Locale.ENGLISH), null);
                }
            }
        }
        return m_selectedAll;
    }

    private static HashMap<String, String> getSelectedDeploy() {
        if (m_selectedDeploy == null) {
            m_selectedDeploy = new HashMap();
            PropertyRules.addSelectedInstalls(m_selectedDeploy);
        }
        return m_selectedDeploy;
    }

    private static void addSelectedInstalls(HashMap<String, String> selectedHash) {
        int i;
        if (Globals.g_fullInstalls != null) {
            for (i = 0; i < Globals.g_fullInstalls.length; ++i) {
                selectedHash.put(Globals.g_fullInstalls[i].getProdCode().toLowerCase(Locale.ENGLISH), null);
            }
        }
        if (Globals.g_deploymentData != null) {
            if (Globals.g_fullMVAAltSkus != null) {
                SpsSkuData spsSkuData = null;
                for (int i2 = 0; i2 < Globals.g_fullMVAAltSkus.length; ++i2) {
                    spsSkuData = Globals.g_deploymentData.getSpsSku(Globals.g_fullMVAAltSkus[i2]);
                    if (spsSkuData == null) continue;
                    selectedHash.put(spsSkuData.getProdCode().toLowerCase(Locale.ENGLISH), null);
                }
            } else if (selectedHash.containsKey("sasinstall") && Globals.g_order != null) {
                String basePlatform = null;
                basePlatform = Globals.g_sasinstallPlat == null ? Utils.getOS_Suffix() : Globals.g_sasinstallPlat;
                String[] mvaAltSkus = Globals.g_deploymentData.getOrder(Globals.g_order).getMVAAltSkus(basePlatform);
                if (mvaAltSkus != null) {
                    SpsSkuData spsSkuData = null;
                    for (int i3 = 0; i3 < mvaAltSkus.length; ++i3) {
                        spsSkuData = Globals.g_deploymentData.getSpsSku(mvaAltSkus[i3]);
                        if (spsSkuData == null) continue;
                        selectedHash.put(spsSkuData.getProdCode().toLowerCase(Locale.ENGLISH), null);
                    }
                }
            }
        }
        if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired() && Globals.g_dependencyInstalls != null) {
            for (i = 0; i < Globals.g_dependencyInstalls.length; ++i) {
                selectedHash.put(Globals.g_dependencyInstalls[i].toLowerCase(Locale.ENGLISH), null);
            }
        }
    }

    private static HashMap<String, String> getSelectedConfig() {
        if (m_selectedConfig == null) {
            m_selectedConfig = new HashMap();
            if (Globals.g_planConfigs != null) {
                for (int i = 0; i < Globals.g_planConfigs.length; ++i) {
                    m_selectedConfig.put(Globals.g_planConfigs[i].toLowerCase(Locale.ENGLISH), null);
                }
            }
        }
        return m_selectedConfig;
    }

    private static HashMap<String, String> getMachineAll() {
        block4: {
            block6: {
                block5: {
                    int i;
                    if (m_machineAll != null) break block4;
                    m_machineAll = new HashMap();
                    if (Globals.g_machine == null) break block5;
                    String[] components = Globals.g_machine.getDeployedComponentIds();
                    for (i = 0; i < components.length; ++i) {
                        m_machineAll.put(components[i].toLowerCase(Locale.ENGLISH), null);
                    }
                    components = Globals.g_machine.getConfiguredComponentIds();
                    for (i = 0; i < components.length; ++i) {
                        m_machineAll.put(components[i].toLowerCase(Locale.ENGLISH), null);
                    }
                    break block4;
                }
                if (Globals.g_cmtMachineList == null) break block6;
                for (int i = 0; i < Globals.g_cmtMachineList.size(); ++i) {
                    m_machineAll.put(Globals.g_cmtMachineList.get(i).toLowerCase(Locale.ENGLISH), null);
                }
                break block4;
            }
            if (Globals.g_planConfigs == null) break block4;
            for (int i = 0; i < Globals.g_planConfigs.length; ++i) {
                m_machineAll.put(Globals.g_planConfigs[i].toLowerCase(Locale.ENGLISH), null);
            }
        }
        return m_machineAll;
    }

    private static HashMap<String, String> getMachineDeploy() {
        if (m_machineDeploy == null) {
            m_machineDeploy = new HashMap();
            if (Globals.g_machine != null) {
                String[] components = Globals.g_machine.getDeployedComponentIds();
                for (int i = 0; i < components.length; ++i) {
                    m_machineDeploy.put(components[i].toLowerCase(Locale.ENGLISH), null);
                }
            }
        }
        return m_machineDeploy;
    }

    private static HashMap<String, String> getMachineConfig() {
        block3: {
            block5: {
                block4: {
                    if (m_machineConfig != null) break block3;
                    m_machineConfig = new HashMap();
                    if (Globals.g_machine == null) break block4;
                    String[] components = Globals.g_machine.getConfiguredComponentIds();
                    for (int i = 0; i < components.length; ++i) {
                        m_machineConfig.put(components[i].toLowerCase(Locale.ENGLISH), null);
                    }
                    break block3;
                }
                if (Globals.g_cmtMachineList == null) break block5;
                for (int i = 0; i < Globals.g_cmtMachineList.size(); ++i) {
                    m_machineConfig.put(Globals.g_cmtMachineList.get(i).toLowerCase(Locale.ENGLISH), null);
                }
                break block3;
            }
            if (Globals.g_planConfigs == null) break block3;
            for (int i = 0; i < Globals.g_planConfigs.length; ++i) {
                m_machineConfig.put(Globals.g_planConfigs[i].toLowerCase(Locale.ENGLISH), null);
            }
        }
        return m_machineConfig;
    }

    private static HashMap<String, String> getPlanAll() {
        if (m_planAll == null) {
            m_planAll = new HashMap();
            if (Globals.g_plan != null) {
                Plan.Machine[] machines = Globals.g_plan.getMachines();
                String[] components = null;
                for (int i = 0; i < machines.length; ++i) {
                    int j;
                    components = machines[i].getDeployedComponentIds();
                    for (j = 0; j < components.length; ++j) {
                        m_planAll.put(components[j].toLowerCase(Locale.ENGLISH), null);
                    }
                    components = machines[i].getConfiguredComponentIds();
                    for (j = 0; j < components.length; ++j) {
                        m_planAll.put(components[j].toLowerCase(Locale.ENGLISH), null);
                    }
                }
            } else if (Globals.g_cmtMachineList != null) {
                boolean addMetadataServer = true;
                for (int i = 0; i < Globals.g_cmtMachineList.size(); ++i) {
                    m_planAll.put(Globals.g_cmtMachineList.get(i).toLowerCase(Locale.ENGLISH), null);
                    if (!Globals.g_cmtMachineList.get(i).equalsIgnoreCase("metadatasrv")) continue;
                    addMetadataServer = false;
                }
                if (addMetadataServer) {
                    m_planAll.put("metadatasrv".toLowerCase(Locale.ENGLISH), null);
                }
            }
        }
        return m_planAll;
    }

    private static HashMap<String, String> getPlanDeploy() {
        if (m_planDeploy == null) {
            m_planDeploy = new HashMap();
            if (Globals.g_plan != null) {
                Plan.Machine[] machines = Globals.g_plan.getMachines();
                String[] components = null;
                for (int i = 0; i < machines.length; ++i) {
                    components = machines[i].getDeployedComponentIds();
                    for (int j = 0; j < components.length; ++j) {
                        m_planDeploy.put(components[j].toLowerCase(Locale.ENGLISH), null);
                    }
                }
            }
        }
        return m_planDeploy;
    }

    private static HashMap<String, String> getPlanConfig() {
        if (m_planConfig == null) {
            m_planConfig = new HashMap();
            if (Globals.g_plan != null) {
                Plan.Machine[] machines = Globals.g_plan.getMachines();
                String[] components = null;
                for (int i = 0; i < machines.length; ++i) {
                    components = machines[i].getConfiguredComponentIds();
                    for (int j = 0; j < components.length; ++j) {
                        m_planConfig.put(components[j].toLowerCase(Locale.ENGLISH), null);
                    }
                }
            } else if (Globals.g_cmtMachineList != null) {
                boolean addMetadataServer = true;
                for (int i = 0; i < Globals.g_cmtMachineList.size(); ++i) {
                    m_planConfig.put(Globals.g_cmtMachineList.get(i).toLowerCase(Locale.ENGLISH), null);
                    if (!Globals.g_cmtMachineList.get(i).equalsIgnoreCase("metadatasrv")) continue;
                    addMetadataServer = false;
                }
                if (addMetadataServer) {
                    m_planConfig.put("metadatasrv".toLowerCase(Locale.ENGLISH), null);
                }
            }
        }
        return m_planConfig;
    }

    private static HashMap<String, String> getOrderList() {
        if (m_orderList == null) {
            m_orderList = new HashMap();
            if (Globals.g_deploymentData != null && Globals.g_order != null) {
                ProductData[] allProducts = Globals.g_deploymentData.getAllProducts(Globals.g_order, true);
                for (int i = 0; i < allProducts.length; ++i) {
                    m_orderList.put(allProducts[i].getProdCode().toLowerCase(Locale.ENGLISH), null);
                }
            }
        }
        return m_orderList;
    }

    private static class RuleClauses {
        private String m_type = null;
        private Object m_data = null;

        public RuleClauses(String type, Object data) {
            this.m_type = type;
            this.m_data = data;
        }

        public String getType() {
            return this.m_type;
        }

        public Object getData() {
            return this.m_data;
        }
    }
}

