/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.UnicodeInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ParseRequirementsXML {
    private static HashMap<String, HashSet<String>> requirementsData = null;

    public static HashMap<String, HashSet<String>> loadRequirementsData(File fileToParse, String depReq) {
        if (fileToParse == null) {
            return null;
        }
        requirementsData = new HashMap();
        try {
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(fileToParse)).getDocumentElement();
            NodeList data = root.getChildNodes();
            if (data != null) {
                for (int i = 0; i < data.getLength(); ++i) {
                    Element element;
                    if (data.item(i).getNodeType() != 1 || !depReq.equals((element = (Element)data.item(i)).getTagName())) continue;
                    ParseRequirementsXML.loadRequirements(element);
                }
            }
        }
        catch (FileNotFoundException root) {
        }
        catch (IOException e) {
            Logging.log.info("Error Reading Select XML File: " + fileToParse.toString());
            Logging.log.info(e.getMessage());
        }
        catch (Exception e) {
            Logging.log.info("Error Parsing Select XML File: " + fileToParse.toString());
            Logging.log.info(e.getMessage());
        }
        return requirementsData;
    }

    private static void loadRequirements(Element root) {
        NodeList reqs;
        String currentId = root.getAttribute("id");
        if (currentId != null && (reqs = root.getChildNodes()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < reqs.getLength(); ++i) {
                String relatedId;
                Element element;
                if (reqs.item(i).getNodeType() != 1 || !"req".equals((element = (Element)reqs.item(i)).getTagName()) || (relatedId = element.getAttribute("id")) == null) continue;
                hashSet.add(relatedId);
            }
            requirementsData.put(currentId, hashSet);
        }
    }
}

