/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.KitAction;
import com.sas.ssn.Logging;
import com.sas.ssn.PrintableEditorPane;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PanelZOSPostInstallSummary
implements WizardPanelIface,
HyperlinkListener,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelZOSPostInstallSummary.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JScrollPane m_scrollPane = null;
    private PrintableEditorPane m_summaryText = null;
    private JButton m_printButton = null;
    private PageFormat m_pageFormat = null;
    private String m_consoleText = null;

    public PanelZOSPostInstallSummary() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        if (Globals.g_zosJobSubmit) {
            return this.bundle.getString("PanelZOSPostInstallSummary.JobSubmit.Header.txt");
        }
        return this.bundle.getString("PanelZOSPostInstallSummary.NoJobSubmit.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        if (Globals.g_zosJobSubmit) {
            return this.bundle.getString("PanelZOSPostInstallSummary.JobSubmit.HeaderDesc.txt");
        }
        return this.bundle.getString("PanelZOSPostInstallSummary.NoJobSubmit.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired() ? "configmaint" : "finish";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.updateTextArea();
        this.m_printButton.setMinimumSize(wizardFramework.getHelpButton().getPreferredSize());
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid;
        boolean bl = valid = Globals.g_resumeChain || !Globals.g_partialPrompt;
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        if (Globals.g_recordMode && Globals.g_recordOnly) {
            ConsoleMode.println("Recording a responsefile, no changes have been made to your system.");
        }
        if (this.m_consoleText != null) {
            ConsoleMode.printInfoText(this.m_consoleText);
        }
        return ConsoleMode.promptPause(false, false);
    }

    private void initialize() {
        this.m_summaryText = new PrintableEditorPane();
        this.m_summaryText.setOpaque(false);
        this.m_summaryText.setEditable(false);
        this.m_summaryText.setContentType("text/html");
        this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_scrollPane = new JScrollPane(this.m_summaryText);
        this.m_summaryText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelZOSPostInstallSummary.this.m_summaryText.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_summaryText.addHyperlinkListener(this);
        String mtxt = this.bundle.getString("Common.Print.txt");
        this.m_printButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_printButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_printButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_printButton.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_printButton, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_printButton) {
            this.onPrint();
        }
    }

    private void updateTextArea() {
        String listText = "<html>";
        if (Globals.g_recordMode && Globals.g_recordOnly) {
            listText = listText + "Recording a responsefile, no changes have been made to your system.";
        } else {
            List<String> jobNames = InstallToolConnector.getMvsFinalJobNames();
            if (jobNames != null && !jobNames.isEmpty()) {
                String userParamCNTLDSN = InstallToolConnector.getMvsUserParam("CNTLDSN");
                if (Globals.g_zosJobSubmit) {
                    if (InstallToolConnector.postProcessingCalled()) {
                        listText = InstallToolConnector.postProcessingSuccessful() ? listText + this.bundle.messageString("PanelZOSPostInstallSummary.JobSubmit.Completed.txt", userParamCNTLDSN) : listText + this.bundle.messageString("PanelZOSPostInstallSummary.JobSubmit.Failed.txt", userParamCNTLDSN);
                        listText = listText + " ";
                        listText = listText + this.bundle.messageString("PanelZOSPostInstallSummary.JobIndex.txt");
                        listText = listText + " ";
                        listText = listText + this.bundle.messageString("PanelZOSPostInstallSummary.JobSubmit.Status.txt");
                    }
                } else {
                    listText = listText + this.bundle.messageString("PanelZOSPostInstallSummary.NoJobSubmit.Members.txt", userParamCNTLDSN);
                }
                listText = listText + "<hr>";
                listText = listText + "<table valign=top cellspacing=1 cellpadding=0>";
                if (Globals.g_zosJobSubmit) {
                    Map<String, String> jobStatus = InstallToolConnector.getMvsJobStatus();
                    for (String job : jobNames) {
                        listText = listText + String.format("<tr><td nowrap>%s %s</td></tr>", job, jobStatus.get(job));
                    }
                } else {
                    for (String job : jobNames) {
                        listText = listText + String.format("<tr><td nowrap>%s</td></tr>", job);
                    }
                }
                listText = listText + "</table>";
                listText = listText + "<hr>";
                String firstJob = jobNames.get(0);
                if (!Globals.g_zosJobSubmit) {
                    int end = firstJob.indexOf("0");
                    String jobnn = firstJob.substring(0, end).concat("nn");
                    listText = Globals.g_zosJobChain ? listText + this.bundle.messageString("PanelZOSPostInstallSummary.NoJobSubmit.Instructions.txt", firstJob, jobnn) : listText + this.bundle.messageString("PanelZOSPostInstallSummary.NoJobSubmitNoChain.Instructions.txt", jobnn, firstJob);
                    listText = listText + " ";
                    listText = listText + this.bundle.messageString("PanelZOSPostInstallSummary.JobIndex.txt");
                    listText = listText + "<br><br>";
                }
                if (InstallToolConnector.isMvsStagedInstall()) {
                    listText = listText + this.bundle.messageString("PanelZOSPostInstallSummary.PromoteJobInstructions.txt");
                    listText = listText + "<br><br>";
                }
                if (InstallToolConnector.isMvsHelpJobPresent()) {
                    String helpJob = firstJob.substring(0, 4).concat("HELP");
                    listText = listText + this.bundle.messageString("PanelZOSPostInstallSummary.HelpJobInstructions.txt", helpJob, helpJob);
                }
            }
        }
        listText = listText + "</html>";
        if (Globals.g_consoleMode) {
            this.m_consoleText = listText.replaceAll("<hr>", "\n");
        } else {
            this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.m_summaryText.setText(listText);
            this.m_summaryText.setCaretPosition(0);
            this.m_summaryText.revalidate();
        }
    }

    private void onPrint() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.m_pageFormat == null) {
            this.m_pageFormat = printerJob.defaultPage();
        }
        PrinterDialogThread printerThread = new PrinterDialogThread(printerJob);
        printerThread.start();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
        }
    }

    @Override
    public String getHelpTopic() {
        return null;
    }

    class PrinterDialogThread
    extends Thread {
        PrinterJob m_printerJob;

        public PrinterDialogThread(PrinterJob printerJob) {
            this.m_printerJob = printerJob;
            this.setPriority(1);
        }

        @Override
        public void run() {
            this.m_printerJob.setPrintable(PanelZOSPostInstallSummary.this.m_summaryText, PanelZOSPostInstallSummary.this.m_pageFormat);
            this.m_printerJob.validatePage(PanelZOSPostInstallSummary.this.m_pageFormat);
            if (this.m_printerJob.printDialog()) {
                try {
                    this.m_printerJob.setPrintable(PanelZOSPostInstallSummary.this.m_summaryText, PanelZOSPostInstallSummary.this.m_pageFormat);
                    this.m_printerJob.validatePage(PanelZOSPostInstallSummary.this.m_pageFormat);
                    this.m_printerJob.print();
                }
                catch (Exception e) {
                    Logging.log.info(e.getMessage());
                    System.err.println(e);
                }
            }
        }
    }
}

