/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PrintableEditorPane;
import com.sas.ssn.ProductData;
import com.sas.ssn.SASHomeStatus;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PanelUpdateSummary
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelUpdateSummary.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JEditorPane m_instructions = null;
    private JScrollPane m_scrollPane = null;
    private PrintableEditorPane m_summaryText = null;
    private JButton m_printButton = null;
    private PageFormat m_pageFormat = null;

    public PanelUpdateSummary() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelUpdateSummary.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelUpdateSummary.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String sServiceName = "";
        String listServiceName = "";
        String listServiceNameInMsg = "";
        boolean bServiceFound = false;
        if (!(!valid || Globals.g_skipLockCheck || Utils.getOS() != 1 || Globals.g_recordMode && Globals.g_recordOnly)) {
            Vector<ProductData> products = new Vector<ProductData>();
            ProductData prodData = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", false);
            if (prodData != null) {
                products.add(prodData);
            }
            if (Utils.getOS_Suffix().equals("wx6") && (prodData = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "win", false)) != null) {
                products.add(prodData);
            }
            Enumeration e = products.elements();
            while (valid && e.hasMoreElements()) {
                prodData = (ProductData)e.nextElement();
                if (!Utils.isRunning(prodData.getProdCode(), prodData.getProdVersion(), prodData.getPlatform(), "sashost.dll") && !Utils.isRunning(prodData.getProdCode(), prodData.getProdVersion(), prodData.getPlatform(), "dbcs\\sashost.dll") && !Utils.isRunning(prodData.getProdCode(), prodData.getProdVersion(), prodData.getPlatform(), "sas.exe")) continue;
                if (Globals.g_quietMode) {
                    valid = false;
                    Logging.log.severe("The following products are currently running: " + prodData.getProdName() + Globals.g_eol + "      You must exit these products before updating them.");
                    continue;
                }
                valid = false;
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelUpdateSummary.LockCheckWarning.txt", prodData.getProdName()), this.bundle.getString("Common.Warning.txt"), 2);
            }
            String sUpdateProdCode = null;
            SASHomeStatus.UpdateEntity[] installs = Globals.g_sasHomeStatus.getRequiredInstalls();
            for (int i = 0; i < installs.length; ++i) {
                sUpdateProdCode = installs[i].getBaseProductData().getProdCode();
                if (sUpdateProdCode.equals("deployagent") && Utils.isWindowServiceRunning(sServiceName = "SAS Deployment Agent")) {
                    bServiceFound = true;
                    if (!listServiceNameInMsg.equals(" ") && listServiceNameInMsg.indexOf(sServiceName) < 0) {
                        listServiceNameInMsg = listServiceNameInMsg + "\n" + sServiceName;
                    }
                    if (!listServiceName.equals(" ") && listServiceName.indexOf(sServiceName) < 0) {
                        listServiceName = listServiceName + sServiceName + ",";
                    }
                }
                if (sUpdateProdCode.equals("txtandocconv") && Utils.isWindowServiceRunning(sServiceName = "SAS Document Conversion Server")) {
                    bServiceFound = true;
                    if (!listServiceNameInMsg.equals(" ") && listServiceNameInMsg.indexOf(sServiceName) < 0) {
                        listServiceNameInMsg = listServiceNameInMsg + "\n" + sServiceName;
                    }
                    if (!listServiceName.equals(" ") && listServiceName.indexOf(sServiceName) < 0) {
                        listServiceName = listServiceName + sServiceName + ",";
                    }
                }
                if (!sUpdateProdCode.equals("pcfilesrv") || !Utils.isWindowServiceRunning(sServiceName = "SAS PC Files Server")) continue;
                bServiceFound = true;
                if (!listServiceNameInMsg.equals(" ") && listServiceNameInMsg.indexOf(sServiceName) < 0) {
                    listServiceNameInMsg = listServiceNameInMsg + "\n" + sServiceName;
                }
                if (listServiceName.equals(" ") || listServiceName.indexOf(sServiceName) >= 0) continue;
                listServiceName = listServiceName + sServiceName + ",";
            }
            if (bServiceFound) {
                if (Globals.g_quietMode) {
                    valid = true;
                } else {
                    String msgTxt = this.bundle.messageString("PanelSelectServicesToEnd.Update.Information.txt", listServiceNameInMsg);
                    valid = this.confirmPrompt(msgTxt);
                }
            }
            if (!(!valid || Globals.g_recordMode && Globals.g_recordOnly)) {
                StringTokenizer tokens = new StringTokenizer(listServiceName, ",");
                while (tokens.hasMoreTokens()) {
                    sServiceName = tokens.nextToken();
                    Utils.stopWindowActiveService(sServiceName);
                }
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_sasHomeStatus.isSASSIDRequired() ? "selectsid" : (Globals.g_sasHomeStatus.isSPDSSIDRequired() ? "selectspdssid" : (Globals.g_sasHomeStatus.isJMPSIDRequired() ? "selectjmpsid" : (Globals.g_sasHomeStatus.isSimStudioSIDRequired() ? "selectsimstudiosid" : (Globals.g_sasHomeStatus.isMomInstallSIDRequired() ? "selectmominstallsid" : "jre"))));
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.updateTextArea();
        this.m_printButton.setMinimumSize(wizardFramework.getHelpButton().getPreferredSize());
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid;
        boolean bl = valid = Globals.g_resumeChain || !Globals.g_partialPrompt;
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.printInfoText(this.m_instructions.getText());
        if (!Globals.g_sasHomeStatus.visibleRequiredInstalls() && !Globals.g_sasHomeStatus.visibleRequiredMaintenance()) {
            ConsoleMode.printInfoText(this.bundle.getString("PanelUpdateSummary.SupportInstallsOnly.txt"));
        } else {
            int i;
            ArrayList<String> text;
            if (Globals.g_sasHomeStatus.visibleRequiredInstalls()) {
                ConsoleMode.printInfoText(this.bundle.getString("PanelUpdateSummary.InstallHeader.txt"));
                text = new ArrayList<String>();
                text.add("~" + Utils.removeHTMLTags(this.bundle.getString("PanelUpdateSummary.Column.Installed.txt")) + "~" + Utils.removeHTMLTags(this.bundle.getString("PanelUpdateSummary.Column.Updated.txt")));
                SASHomeStatus.UpdateEntity[] installs = Globals.g_sasHomeStatus.getRequiredInstalls();
                for (i = 0; i < installs.length; ++i) {
                    if (installs[i].isUpdateHidden()) continue;
                    text.add(installs[i].getExistingProductName() + "~" + installs[i].getExistingCustomerVersion() + "~" + installs[i].getUpdatedCustomerVersion());
                }
                ConsoleMode.printTable(text.toArray(new String[0]));
            }
            if (Globals.g_sasHomeStatus.visibleRequiredMaintenance()) {
                ConsoleMode.printInfoText(this.bundle.getString("PanelUpdateSummary.MaintHeader.txt"));
                text = new ArrayList();
                text.add("~" + Utils.removeHTMLTags(this.bundle.getString("PanelUpdateSummary.Column.Installed.txt")) + "~" + Utils.removeHTMLTags(this.bundle.getString("PanelUpdateSummary.Column.Updated.txt")));
                SASHomeStatus.UpdateEntity[] maint = Globals.g_sasHomeStatus.getRequiredMaintenance();
                for (i = 0; i < maint.length; ++i) {
                    if (maint[i].isUpdateHidden()) continue;
                    text.add(maint[i].getExistingProductName() + "~" + maint[i].getExistingCustomerVersion() + "~" + maint[i].getUpdatedCustomerVersion());
                }
                ConsoleMode.printTable(text.toArray(new String[0]));
            }
        }
        return ConsoleMode.promptPause();
    }

    private void initialize() {
        this.m_instructions = new JEditorPane();
        String instruction = this.bundle.getString("PanelUpdateSummary.Instructions.txt");
        this.m_instructions.setContentType("text/html");
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setText(instruction);
        this.m_instructions.setOpaque(false);
        this.m_instructions.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_summaryText = new PrintableEditorPane();
        this.m_summaryText.setOpaque(false);
        this.m_summaryText.setEditable(false);
        this.m_summaryText.setContentType("text/html");
        this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_scrollPane = new JScrollPane(this.m_summaryText);
        this.m_summaryText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelUpdateSummary.this.m_summaryText.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        String mtxt = this.bundle.getString("Common.Print.txt");
        this.m_printButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_printButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_printButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_printButton.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 10, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_printButton, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_printButton) {
            this.onPrint();
        }
    }

    private void updateTextArea() {
        String listText = "<html>";
        if (!Globals.g_sasHomeStatus.visibleRequiredInstalls() && !Globals.g_sasHomeStatus.visibleRequiredMaintenance()) {
            listText = Globals.g_resumeChain ? listText + this.bundle.getString("PanelUpdateSummary.Reentry.txt") : listText + this.bundle.getString("PanelUpdateSummary.SupportInstallsOnly.txt");
        } else {
            int i;
            listText = listText + "<table valign=top cellspacing=1 cellpadding=0>";
            if (Globals.g_sasHomeStatus.visibleRequiredInstalls()) {
                listText = listText + "<tr>";
                listText = listText + "<td nowrap>" + this.bundle.getString("PanelUpdateSummary.InstallHeader.txt") + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td>";
                listText = listText + "</tr>";
                listText = listText + "<tr>";
                listText = listText + "<td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + this.bundle.getString("PanelUpdateSummary.Column.Installed.txt") + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + this.bundle.getString("PanelUpdateSummary.Column.Updated.txt") + "</td>";
                listText = listText + "</tr>";
                SASHomeStatus.UpdateEntity[] installs = Globals.g_sasHomeStatus.getRequiredInstalls();
                for (i = 0; i < installs.length; ++i) {
                    if (installs[i].isUpdateHidden()) continue;
                    listText = listText + "<tr>";
                    listText = listText + "<td nowrap>&nbsp;&nbsp;&nbsp;" + installs[i].getExistingProductName() + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap align=center>" + installs[i].getExistingCustomerVersion() + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap align=center>" + installs[i].getUpdatedCustomerVersion() + "</td>";
                    listText = listText + "</tr>";
                }
                if (Globals.g_sasHomeStatus.visibleRequiredMaintenance()) {
                    listText = listText + "<tr>";
                    listText = listText + "<td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td>";
                    listText = listText + "</tr>";
                    listText = listText + "<tr>";
                    listText = listText + "<td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td>";
                    listText = listText + "</tr>";
                }
            }
            if (Globals.g_sasHomeStatus.visibleRequiredMaintenance()) {
                listText = listText + "<tr>";
                listText = listText + "<td nowrap>" + this.bundle.getString("PanelUpdateSummary.MaintHeader.txt") + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td>";
                listText = listText + "</tr>";
                listText = listText + "<tr>";
                listText = listText + "<td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + this.bundle.getString("PanelUpdateSummary.Column.Installed.txt") + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap>" + this.bundle.getString("PanelUpdateSummary.Column.Updated.txt") + "</td>";
                listText = listText + "</tr>";
                SASHomeStatus.UpdateEntity[] maint = Globals.g_sasHomeStatus.getRequiredMaintenance();
                for (i = 0; i < maint.length; ++i) {
                    if (maint[i].isUpdateHidden()) continue;
                    listText = listText + "<tr>";
                    listText = listText + "<td nowrap>&nbsp;&nbsp;&nbsp;" + maint[i].getExistingProductName() + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap align=center>" + maint[i].getExistingCustomerVersion() + "</td><td nowrap>&nbsp;</td><td nowrap>&nbsp;</td><td nowrap align=center>" + maint[i].getUpdatedCustomerVersion() + "</td>";
                    listText = listText + "</tr>";
                }
            }
            listText = listText + "</table>";
        }
        listText = listText + "</html>";
        this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_summaryText.setText(listText);
        this.m_summaryText.setCaretPosition(0);
        this.m_summaryText.revalidate();
    }

    private void onPrint() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.m_pageFormat == null) {
            this.m_pageFormat = printerJob.defaultPage();
        }
        PrinterDialogThread printerThread = new PrinterDialogThread(printerJob);
        printerThread.start();
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private boolean confirmPrompt(String message) {
        boolean valid = true;
        if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), message, Globals.g_wizard.getWizardTitle(), 0, 3, 0) == 1) {
            valid = false;
        }
        return valid;
    }

    class PrinterDialogThread
    extends Thread {
        PrinterJob m_printerJob;

        public PrinterDialogThread(PrinterJob printerJob) {
            this.m_printerJob = printerJob;
            this.setPriority(1);
        }

        @Override
        public void run() {
            this.m_printerJob.setPrintable(PanelUpdateSummary.this.m_summaryText, PanelUpdateSummary.this.m_pageFormat);
            this.m_printerJob.validatePage(PanelUpdateSummary.this.m_pageFormat);
            if (this.m_printerJob.printDialog()) {
                try {
                    this.m_printerJob.setPrintable(PanelUpdateSummary.this.m_summaryText, PanelUpdateSummary.this.m_pageFormat);
                    this.m_printerJob.validatePage(PanelUpdateSummary.this.m_pageFormat);
                    this.m_printerJob.print();
                }
                catch (Exception e) {
                    Logging.log.info(e.getMessage());
                    System.err.println(e);
                }
            }
        }
    }
}

