/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.HyperlinkField;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.PropsParser;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class PanelTPSummary
implements WizardPanelIface {
    private final String JDK6_LEVCHECK_FILE = "levcheck1.6.xml";
    private final String JDK5OR6_LEVCHECK_FILE = "levcheck5or6.xml";
    private SSNResource bundle = new SSNResource(PanelTPSummary.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_headerText = null;
    private HyperlinkField m_supportLink = null;
    private JCheckBox m_remoteWebApp = null;
    private JTable m_tpList = null;
    private JScrollPane m_tpScrollPane = null;
    private TPTableModel m_tpTableModel = null;
    private boolean m_panelLoaded = false;
    private boolean m_jdkPlusWebLogic = false;
    private boolean m_jdkPlusJBoss = false;
    private String[] m_promptedInstalls = null;
    private ProductData[] m_promptedData = null;

    public PanelTPSummary() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelTPSummary.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelTPSummary.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        Globals.g_showRemoteWebApps = this.m_remoteWebApp.isVisible();
        boolean bl = Globals.g_remoteWebApps = this.m_remoteWebApp.isVisible() && this.m_remoteWebApp.isSelected();
        if (Globals.g_remoteWebApps) {
            int i;
            boolean containsWebAppSrv;
            if (Globals.g_promptedData != null) {
                containsWebAppSrv = false;
                for (i = 0; i < Globals.g_promptedData.length && !containsWebAppSrv; ++i) {
                    String prodCode = Globals.g_promptedData[i].getProdCode();
                    if (!Utils.isWebAppServerCode(prodCode)) continue;
                    containsWebAppSrv = true;
                }
                if (containsWebAppSrv) {
                    ArrayList<ProductData> newPromptedData = new ArrayList<ProductData>();
                    for (int i2 = 0; i2 < Globals.g_promptedData.length; ++i2) {
                        String prodCode = Globals.g_promptedData[i2].getProdCode();
                        if (prodCode.equalsIgnoreCase("jboss") || prodCode.equalsIgnoreCase("vfabrictcsvr") || prodCode.equalsIgnoreCase("weblogic") || prodCode.equalsIgnoreCase("websphereba") || prodCode.equalsIgnoreCase("webspherend") || prodCode.equalsIgnoreCase("jdk")) {
                            if (Globals.g_configData == null) continue;
                            Globals.g_configData.removeProperty(prodCode + ".install.dir");
                            Globals.g_configData.removeProperty(prodCode + ".selected.version");
                            if (!prodCode.equalsIgnoreCase("jdk")) continue;
                            Globals.g_configData.removeProperty("jdk.java.vm.name");
                            continue;
                        }
                        newPromptedData.add(Globals.g_promptedData[i2]);
                    }
                    Globals.g_promptedData = newPromptedData.toArray(new ProductData[0]);
                }
            }
            if (Globals.g_promptedInstalls != null) {
                containsWebAppSrv = false;
                for (i = 0; i < Globals.g_promptedInstalls.length && !containsWebAppSrv; ++i) {
                    if (!Globals.g_promptedInstalls[i].equalsIgnoreCase("promptforjboss") && !Globals.g_promptedInstalls[i].equalsIgnoreCase("promptforvfabrictcsvr") && !Globals.g_promptedInstalls[i].equalsIgnoreCase("promptforweblogic") && !Globals.g_promptedInstalls[i].equalsIgnoreCase("promptforwebsphereba") && !Globals.g_promptedInstalls[i].equalsIgnoreCase("promptforwebspherend")) continue;
                    containsWebAppSrv = true;
                }
                if (containsWebAppSrv) {
                    ArrayList<String> newPromptedInstalls = new ArrayList<String>();
                    for (int i3 = 0; i3 < Globals.g_promptedInstalls.length; ++i3) {
                        if (Globals.g_promptedInstalls[i3].equalsIgnoreCase("promptforjboss") || Globals.g_promptedInstalls[i3].equalsIgnoreCase("promptforvfabrictcsvr") || Globals.g_promptedInstalls[i3].equalsIgnoreCase("promptforweblogic") || Globals.g_promptedInstalls[i3].equalsIgnoreCase("promptforwebsphereba") || Globals.g_promptedInstalls[i3].equalsIgnoreCase("promptforwebspherend") || Globals.g_promptedInstalls[i3].equalsIgnoreCase("promptforjdk")) continue;
                        newPromptedInstalls.add(Globals.g_promptedInstalls[i3]);
                    }
                    Globals.g_promptedInstalls = newPromptedInstalls.toArray(new String[0]);
                }
            }
        } else {
            if (this.m_promptedData != null) {
                Globals.g_promptedData = this.m_promptedData;
            }
            if (this.m_promptedInstalls != null) {
                Globals.g_promptedInstalls = this.m_promptedInstalls;
            }
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        return this.m_promptedInstalls != null && this.m_promptedInstalls.length > 0;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_promptedInstalls != null && Globals.g_promptedInstalls.length > 0 ? Globals.g_promptedInstalls[0] : (Globals.g_planConfigs != null && Globals.g_planConfigs.length > 0 ? "accounttype" : "execute");
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.initializeRemoteOption();
        String jdkDataDir = Globals.g_deploymentData.getProductDataDir(Globals.g_order, "jdk", true, false);
        File levCheckFile = new File(jdkDataDir, "levcheck1.6.xml");
        if (levCheckFile.isFile()) {
            boolean jdkPrompted = false;
            boolean webLogicPrompted = false;
            for (int i = 0; i < this.m_promptedData.length; ++i) {
                if (this.m_promptedData[i].getProdCode().equalsIgnoreCase("jdk")) {
                    jdkPrompted = true;
                    continue;
                }
                if (!this.m_promptedData[i].getProdCode().equalsIgnoreCase("weblogic")) continue;
                webLogicPrompted = true;
            }
            this.m_jdkPlusWebLogic = jdkPrompted && webLogicPrompted;
        } else {
            this.m_jdkPlusWebLogic = false;
        }
        File levCheck5or6File = new File(jdkDataDir, "levcheck5or6.xml");
        if (levCheck5or6File.isFile()) {
            boolean jdkPrompted = false;
            boolean jbossPrompted = false;
            for (int i = 0; i < this.m_promptedData.length; ++i) {
                if (this.m_promptedData[i].getProdCode().equalsIgnoreCase("jdk")) {
                    jdkPrompted = true;
                    continue;
                }
                if (!this.m_promptedData[i].getProdCode().equalsIgnoreCase("jboss")) continue;
                jbossPrompted = true;
            }
            this.m_jdkPlusJBoss = jdkPrompted && jbossPrompted;
        } else {
            this.m_jdkPlusJBoss = false;
        }
        TableCellRenderer headerRenderer = this.m_tpList.getTableHeader().getDefaultRenderer();
        TableColumn column = this.m_tpList.getColumnModel().getColumn(1);
        Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
        int headerWidth = comp.getPreferredSize().width;
        int margin = this.m_tpList.getColumnModel().getColumnMargin();
        int maxWidth = headerWidth;
        for (int i = 0; i < this.m_tpTableModel.getRowCount(); ++i) {
            comp = this.m_tpList.getDefaultRenderer(this.m_tpTableModel.getColumnClass(1)).getTableCellRendererComponent(this.m_tpList, this.getVersion(i), false, false, 0, 1);
            maxWidth = Math.max(maxWidth, comp.getPreferredSize().width);
        }
        column.setMinWidth(headerWidth + margin * 2);
        column.setPreferredWidth(maxWidth + margin * 2);
        column.setMaxWidth(maxWidth * 2);
        int rowHeight = Utils.getPreferredRowHeight(this.m_tpList);
        if (rowHeight > 0) {
            this.m_tpList.setRowHeight(rowHeight);
        }
        this.m_panelLoaded = true;
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_tpScrollPane;
    }

    @Override
    public boolean silentEvent() {
        this.initializeRemoteOption();
        boolean valid = this.validateData();
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = null;
        if (this.m_panelLoaded && this.m_remoteWebApp.isVisible() && this.m_remoteWebApp.isEnabled()) {
            data = new String[]{"#REMOTE_WEB_APPS=yes/no", " REMOTE_WEB_APPS="};
            data[1] = this.m_remoteWebApp.isSelected() ? " REMOTE_WEB_APPS=yes" : " REMOTE_WEB_APPS=no";
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_showRemoteWebApps = false;
        Globals.g_remoteWebApps = false;
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        ConsoleMode.printInfoText(this.m_headerText.getText());
        ConsoleMode.println();
        ConsoleMode.println(this.getSupportLink());
        ArrayList<String> text = new ArrayList<String>();
        String line = null;
        for (int i = 0; i < this.m_promptedData.length; ++i) {
            line = this.m_promptedData[i].getProdName() + "~" + this.getVersion(i);
            text.add(line);
        }
        ConsoleMode.printTable(text.toArray(new String[0]));
        returnCode = this.m_remoteWebApp.isVisible() && this.m_remoteWebApp.isEnabled() ? ConsoleMode.promptBoolean(this.m_remoteWebApp) : ConsoleMode.promptPause();
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        if (this.m_remoteWebApp.isVisible() && this.m_remoteWebApp.isEnabled()) {
            String response = Wizard.getResponse("REMOTE_WEB_APPS", null);
            if (response != null) {
                if (response.equalsIgnoreCase("yes")) {
                    this.m_remoteWebApp.setSelected(true);
                } else if (response.equalsIgnoreCase("no")) {
                    this.m_remoteWebApp.setSelected(false);
                } else if (Globals.g_quietMode) {
                    valid = false;
                    Wizard.logResponseInvalid(this.getHeader(), "REMOTE_WEB_APPS", response, null);
                }
            } else if (Globals.g_quietMode) {
                this.m_remoteWebApp.setSelected(false);
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_headerText = new JTextArea(this.bundle.getString("PanelTPSummary.Info.txt"));
        this.m_headerText.setEditable(false);
        this.m_headerText.setFocusable(false);
        this.m_headerText.setLineWrap(true);
        this.m_headerText.setWrapStyleWord(true);
        this.m_headerText.setOpaque(false);
        this.m_supportLink = new HyperlinkField();
        this.m_supportLink.setOpaque(false);
        this.m_supportLink.setEditable(false);
        this.m_supportLink.setContentType("text/html");
        this.m_supportLink.setText(this.bundle.getString("PanelTPSummary.SupportLink.txt"), this.getSupportLink());
        this.m_supportLink.setCaretPosition(0);
        String mtxt = this.bundle.getString("PanelTPSummary.RemoteWebApp.txt");
        this.m_remoteWebApp = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_remoteWebApp.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_remoteWebApp.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_remoteWebApp.setVisible(false);
        this.m_tpTableModel = new TPTableModel();
        this.m_tpList = new JTable(this.m_tpTableModel);
        this.m_tpList.setRowSelectionAllowed(false);
        this.m_tpList.setColumnSelectionAllowed(false);
        this.m_tpList.getTableHeader().setResizingAllowed(true);
        this.m_tpList.getTableHeader().setReorderingAllowed(false);
        this.m_tpList.getColumnModel().getColumn(0).setCellRenderer(new StringCellRenderer());
        this.m_tpList.getColumnModel().getColumn(1).setCellRenderer(new StringCellRenderer());
        this.m_tpList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelTPSummary.this.m_tpList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_tpScrollPane = new JScrollPane(this.m_tpList);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 18;
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_headerText, c);
        c.gridy = 1;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_supportLink, c);
        c.gridy = 2;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_remoteWebApp, c);
        c.gridy = 3;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_tpScrollPane, c);
    }

    private void initializeRemoteOption() {
        boolean webAppSrvPrompted = false;
        for (int i = 0; i < this.m_promptedData.length && !webAppSrvPrompted; ++i) {
            String prodCode = this.m_promptedData[i].getProdCode();
            if (!Utils.isWebAppServerCode(prodCode)) continue;
            webAppSrvPrompted = true;
        }
        this.m_remoteWebApp.setEnabled(true);
        this.m_remoteWebApp.setVisible(webAppSrvPrompted);
        if (webAppSrvPrompted) {
            String sasHome = Globals.g_wizardData.getPreference("SASHome", "");
            File sasswFile = new File(sasHome, "sassw.config");
            if (sasswFile.isFile()) {
                PropsParser sasswINIFile = new PropsParser(true);
                try {
                    sasswINIFile.load(sasswFile, null);
                    String remoteValue = sasswINIFile.getINIValue("properties", "REMOTE_WEB_APPS", null);
                    if (remoteValue != null) {
                        this.m_remoteWebApp.setEnabled(false);
                        if (remoteValue.equalsIgnoreCase("true")) {
                            this.m_remoteWebApp.setSelected(true);
                        } else {
                            this.m_remoteWebApp.setSelected(false);
                        }
                    } else if (!this.m_panelLoaded) {
                        this.loadResponseData();
                    }
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            } else if (!this.m_panelLoaded) {
                this.loadResponseData();
            }
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    public void updatePromptedInfo() {
        this.m_promptedInstalls = (String[])Globals.g_promptedInstalls.clone();
        this.m_promptedData = (ProductData[])Globals.g_promptedData.clone();
    }

    private String getSupportLink() {
        String link = "https://support.sas.com/resources/thirdpartysupport/index.html";
        return link;
    }

    private String getVersion(int row) {
        String version = null;
        version = this.m_jdkPlusWebLogic && this.m_promptedData[row].getProdCode().equalsIgnoreCase("jdk") ? this.bundle.getString("PanelTPSummary.DependsWebLogic.txt") : (this.m_jdkPlusWebLogic && this.m_promptedData[row].getProdCode().equalsIgnoreCase("weblogic") ? this.bundle.getString("Common.WebLogicVersion.txt") : (this.m_jdkPlusJBoss && this.m_promptedData[row].getProdCode().equalsIgnoreCase("jdk") ? this.bundle.getString("PanelTPSummary.DependsJBoss.txt") : (this.m_jdkPlusJBoss && this.m_promptedData[row].getProdCode().equalsIgnoreCase("jboss") ? this.bundle.getString("Common.JBossVersion.txt") : this.m_promptedData[row].getProdVersion())));
        return version;
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else if (column == 0) {
                this.setText(PanelTPSummary.this.m_promptedData[row].getProdName());
            } else if (column == 1) {
                this.setText(PanelTPSummary.this.getVersion(row));
            }
            return this;
        }
    }

    private class TPTableModel
    extends AbstractTableModel {
        public static final int TABLE_COLUMN_NAME = 0;
        public static final int TABLE_COLUMN_VERSION = 1;
        private String[] m_columnNames;

        public TPTableModel() {
            this.m_columnNames = new String[]{PanelTPSummary.this.bundle.getString("PanelTPSummary.Column.Name.txt"), PanelTPSummary.this.bundle.getString("PanelTPSummary.Column.Version.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            int count = 0;
            if (PanelTPSummary.this.m_promptedData != null) {
                count = PanelTPSummary.this.m_promptedData.length;
            }
            return count;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }

        public void clear() {
            this.fireTableDataChanged();
        }
    }
}

