/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.InstanceData;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.PanelPassword;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class PanelSelectUsers
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelSelectUsers.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_warningImage = null;
    private JTextArea m_warningMessage = null;
    private JTable m_usersTable = null;
    private UserTableModel m_usersTableModel = null;
    private ActionListener m_allColumnListener = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private boolean m_panelLoaded = false;
    private String m_previousConfigDir = "";
    private String m_previousHost = "";
    private String m_previousPort = "";
    private String m_previousUser = "";
    private HashMap m_responseUsers = null;
    private ProductData m_cfgwizardData = null;

    public PanelSelectUsers() {
        this.initialize();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectUsers.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectUsers.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = false;
        boolean cfgwizardNeeded = true;
        ArrayList userIds = this.m_usersTableModel.getUserIds();
        HashMap users = this.m_usersTableModel.getUsers();
        ArrayList<String> dialogs = new ArrayList<String>();
        HashMap instanceData = null;
        ArrayList<String> instanceIDs = null;
        ArrayList<ProductData> globalInstances = new ArrayList<ProductData>();
        Globals.g_cmtExcludePasswds = new HashMap();
        String id = null;
        UserData data = null;
        int count = 0;
        String panelID = null;
        for (int i = 0; i < userIds.size(); ++i) {
            id = (String)userIds.get(i);
            data = (UserData)users.get(id);
            if (data.getSelected()) {
                if (count == 0 && Globals.g_cmtPasswordDialogs != null) {
                    for (int j = 0; j < Globals.g_cmtPasswordDialogs.length; ++j) {
                        Globals.g_wizard.removePanel(Globals.g_cmtPasswordDialogs[j]);
                    }
                    Globals.g_cmtPasswordDialogs = null;
                }
                instanceIDs = new ArrayList<String>();
                instanceData = data.getInstanceData();
                boolean exists = false;
                String fqid2 = null;
                ProductData prodData = null;
                for (String fqid2 : instanceData.keySet()) {
                    instanceIDs.add(fqid2);
                    exists = false;
                    Iterator itinner = globalInstances.iterator();
                    while (!exists && itinner.hasNext()) {
                        prodData = (ProductData)itinner.next();
                        if (!fqid2.equals(prodData.getInstanceData().getFQID())) continue;
                        exists = true;
                    }
                    if (exists) continue;
                    prodData = (ProductData)instanceData.get(fqid2);
                    globalInstances.add(prodData);
                    if (!prodData.getProdCode().equalsIgnoreCase("cfgwizard")) continue;
                    cfgwizardNeeded = false;
                }
                valid = true;
                panelID = "password".concat(data.getName());
                Globals.g_wizard.addPanel(panelID, new PanelPassword(count, data.getName(), instanceIDs.toArray(new String[0]), data.getInstanceProp()));
                dialogs.add(panelID);
                ++count;
                continue;
            }
            Globals.g_cmtExcludePasswds.put(data.getPasswdProp(), null);
        }
        if (valid) {
            Globals.g_cmtPasswordDialogs = dialogs.toArray(new String[0]);
            if (cfgwizardNeeded && this.m_cfgwizardData != null) {
                globalInstances.add(this.m_cfgwizardData);
            }
            Globals.g_instances = globalInstances.toArray(new ProductData[0]);
            DynamicDialogs.loadDialogDefaults(null, 0);
        } else if (Globals.g_quietMode) {
            Logging.log.severe("At least one user ID must be selected.\n   Panel: " + this.getHeader() + "\n   Field: " + "USER_SELECTION" + "#");
        } else {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectUsers.NoUsersError.txt"), this.bundle.getString("Common.Warning.txt"), 2);
            this.m_usersTable.requestFocus();
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_cmtPasswordDialogs != null && Globals.g_cmtPasswordDialogs.length > 0 ? Globals.g_cmtPasswordDialogs[0] : "execute";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        if (!(this.m_previousConfigDir.equals(Globals.g_cmtConfigDir) && this.m_previousHost.equals(Globals.g_cmtConnectHost) && this.m_previousPort.equals(Globals.g_cmtConnectPort) && this.m_previousUser.equals(Globals.g_cmtConnectUser))) {
            this.populate();
            this.m_previousConfigDir = Globals.g_cmtConfigDir;
            this.m_previousHost = Globals.g_cmtConnectHost;
            this.m_previousPort = Globals.g_cmtConnectPort;
            this.m_previousUser = Globals.g_cmtConnectUser;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_usersTable;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.populate();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        if (this.m_panelLoaded) {
            ArrayList userIds = this.m_usersTableModel.getUserIds();
            HashMap users = this.m_usersTableModel.getUsers();
            UserData userData = null;
            int count = 0;
            for (int i = 0; i < userIds.size(); ++i) {
                userData = (UserData)users.get(userIds.get(i));
                if (!userData.getSelected()) continue;
                data.add(" USER_SELECTION" + Integer.toString(++count) + "=" + userData.getID());
            }
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ArrayList userIds = this.m_usersTableModel.getUserIds();
        HashMap users = this.m_usersTableModel.getUsers();
        UserData userData = null;
        String text = null;
        String domain = null;
        String header = null;
        ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[userIds.size()];
        for (int i = 0; i < options.length; ++i) {
            userData = (UserData)users.get(userIds.get(i));
            domain = userData.getDomain();
            if (domain == null) {
                domain = this.bundle.getString("PanelSelectUsers.NotApplicable.txt");
            }
            text = Globals.g_debug ? userData.getName() + "~" + domain + "~" + userData.getType() : userData.getName() + "~" + domain;
            options[i] = new ConsoleMode.SelectionItem(text, userData.getSelected());
        }
        header = Globals.g_debug ? this.bundle.getString("PanelSelectUsers.UsersTable.UserColumn.Title.txt") + "~" + this.bundle.getString("PanelSelectUsers.UsersTable.DomainColumn.Title.txt") + "~" + this.bundle.getString("PanelSelectUsers.UsersTable.TypeColumn.Title.txt") : this.bundle.getString("PanelSelectUsers.UsersTable.UserColumn.Title.txt") + "~" + this.bundle.getString("PanelSelectUsers.UsersTable.DomainColumn.Title.txt");
        int returnCode = ConsoleMode.promptMultiChoice(options, header);
        if (returnCode > -1) {
            for (int i = 0; i < options.length; ++i) {
                userData = (UserData)users.get(userIds.get(i));
                userData.setSelected(options[i].getSelected());
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        this.m_responseUsers = null;
        boolean found = true;
        int productCount = 1;
        String responseProduct = null;
        while (found) {
            responseProduct = Wizard.getResponse("USER_SELECTION" + Integer.toString(productCount), null);
            if (responseProduct == null) {
                found = false;
            } else {
                if (this.m_responseUsers == null) {
                    this.m_responseUsers = new HashMap();
                }
                this.m_responseUsers.put(responseProduct.toLowerCase(Locale.ENGLISH), null);
            }
            ++productCount;
        }
        return valid;
    }

    private void initialize() {
        this.m_warningImage = new JLabel();
        this.m_warningImage.setIcon(this.bundle.getImageIcon("Common.warning_small.image"));
        this.m_warningMessage = new JTextArea(this.bundle.getString("PanelSelectUsers.WarningMessage.txt"));
        this.m_warningMessage.setEditable(false);
        this.m_warningMessage.setFocusable(false);
        this.m_warningMessage.setLineWrap(true);
        this.m_warningMessage.setWrapStyleWord(true);
        this.m_warningMessage.setOpaque(false);
        this.m_usersTableModel = new UserTableModel();
        this.m_usersTable = new JTable(this.m_usersTableModel);
        this.m_usersTable.setCellSelectionEnabled(true);
        this.m_usersTable.setSelectionMode(0);
        this.m_usersTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelSelectUsers.this.m_usersTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane tablePane = new JScrollPane(this.m_usersTable);
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        this.m_selectAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_selectAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_selectAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        this.m_clearAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clearAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clearAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_allColumnListener = new AllColumnActionListener();
        this.m_selectAllButton.addActionListener(this.m_allColumnListener);
        this.m_clearAllButton.addActionListener(this.m_allColumnListener);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_warningImage, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_warningMessage, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)tablePane, c);
        this.initButtonPanel();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void installRenderers() {
        this.m_usersTable.getColumnModel().getColumn(0).setCellRenderer(new UserDataCellRenderer());
        this.m_usersTable.getColumnModel().getColumn(0).setCellEditor(new UserDataCellEditor(new JCheckBox()));
        this.m_usersTable.getColumnModel().getColumn(1).setCellRenderer(new StringCellRenderer());
        if (Globals.g_debug) {
            this.m_usersTable.getColumnModel().getColumn(2).setCellRenderer(new StringCellRenderer());
        }
        this.m_usersTable.getTableHeader().setResizingAllowed(true);
        this.m_usersTable.getTableHeader().setReorderingAllowed(false);
        TableColumn column = this.m_usersTable.getColumnModel().getColumn(1);
        int minWidth = Utils.getMinColumnWidth(this.m_usersTable, 1);
        int width = Utils.getPreferredColumnWidth(this.m_usersTable, 1);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(width);
        column.setMaxWidth(width * 2);
        if (Globals.g_debug) {
            column = this.m_usersTable.getColumnModel().getColumn(2);
            minWidth = Utils.getMinColumnWidth(this.m_usersTable, 2);
            width = Utils.getPreferredColumnWidth(this.m_usersTable, 2);
            column.setMinWidth(minWidth);
            column.setPreferredWidth(width);
            column.setMaxWidth(width * 2);
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private void populate() {
        this.m_usersTableModel.load();
        int rowHeight = Utils.getPreferredRowHeight(this.m_usersTable);
        if (rowHeight > 0) {
            this.m_usersTable.setRowHeight(rowHeight);
        }
        if (this.m_usersTableModel.getUserIds().size() < 1) {
            this.m_warningImage.setVisible(true);
            this.m_warningMessage.setVisible(true);
        } else {
            this.m_warningImage.setVisible(false);
            this.m_warningMessage.setVisible(false);
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3547229212748176989L;

        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    class AllColumnActionListener
    implements ActionListener {
        AllColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelSelectUsers.this.m_selectAllButton) {
                PanelSelectUsers.this.m_usersTableModel.selectAll(true);
            } else if (e.getSource() == PanelSelectUsers.this.m_clearAllButton) {
                PanelSelectUsers.this.m_usersTableModel.selectAll(false);
            }
        }
    }

    private class UserDataCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 4328663578982533393L;
        private JCheckBox m_checkBox;

        public UserDataCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = null;
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSelectUsers.this.m_usersTableModel.getUserIds().get(row);
                    UserData data = (UserData)PanelSelectUsers.this.m_usersTableModel.getUsers().get(id);
                    this.m_checkBox.setText(data.getName());
                    this.m_checkBox.setSelected(data.getSelected());
                }
            }
            return this.m_checkBox;
        }
    }

    private class UserDataCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -8165708165563209708L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSelectUsers.this.m_usersTableModel.getUserIds().get(row);
                    UserData data = (UserData)PanelSelectUsers.this.m_usersTableModel.getUsers().get(id);
                    this.setText(data.getName());
                    this.setSelected(data.getSelected());
                }
            }
            return this;
        }
    }

    class UserData {
        private String m_id = null;
        private String m_name = null;
        private String m_passwdProp = null;
        private String m_domain = null;
        private String m_type = null;
        private boolean m_selected = false;
        private HashMap m_instanceData = new HashMap();
        private HashMap m_instanceProp = new HashMap();

        public UserData(String id, String name, String domain, String type, String passwdProp, ProductData data) {
            this.m_id = id;
            this.m_name = name;
            this.m_passwdProp = passwdProp;
            this.m_domain = domain;
            this.m_type = type;
            this.m_instanceData.put(data.getInstanceData().getFQID(), data);
            this.m_instanceProp.put(data.getInstanceData().getFQID(), passwdProp);
        }

        public String getID() {
            return this.m_id;
        }

        public String getName() {
            return this.m_name;
        }

        public String getPasswdProp() {
            return this.m_passwdProp;
        }

        public String getDomain() {
            return this.m_domain;
        }

        public String getType() {
            return this.m_type;
        }

        public boolean getSelected() {
            return this.m_selected;
        }

        public HashMap getInstanceData() {
            return this.m_instanceData;
        }

        public HashMap getInstanceProp() {
            return this.m_instanceProp;
        }

        public void setSelected(boolean selected) {
            this.m_selected = selected;
        }

        public void addInstanceData(ProductData data) {
            this.m_instanceData.put(data.getInstanceData().getFQID(), data);
        }

        public void addInstanceProp(String fqid, String prop) {
            this.m_instanceProp.put(fqid, prop);
        }
    }

    class UserTableModel
    extends AbstractTableModel {
        public static final int COLUMN_USER = 0;
        public static final int COLUMN_DOMAIN = 1;
        public static final int COLUMN_TYPE = 2;
        private String[] m_columnNames = null;
        private HashMap m_users = new HashMap();
        private ArrayList m_userIds = new ArrayList();

        public UserTableModel() {
            this.m_columnNames = Globals.g_debug ? new String[]{PanelSelectUsers.this.bundle.getString("PanelSelectUsers.UsersTable.UserColumn.Title.txt"), PanelSelectUsers.this.bundle.getString("PanelSelectUsers.UsersTable.DomainColumn.Title.txt"), PanelSelectUsers.this.bundle.getString("PanelSelectUsers.UsersTable.TypeColumn.Title.txt")} : new String[]{PanelSelectUsers.this.bundle.getString("PanelSelectUsers.UsersTable.UserColumn.Title.txt"), PanelSelectUsers.this.bundle.getString("PanelSelectUsers.UsersTable.DomainColumn.Title.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            if (index == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_users.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            Object value = null;
            String id = (String)this.m_userIds.get(rowIndex);
            if (id != null) {
                UserData userData = (UserData)this.m_users.get(id);
                if (colIndex == 0) {
                    value = userData.getSelected();
                } else if (colIndex == 1) {
                    value = userData.getDomain();
                    if (value == null) {
                        value = PanelSelectUsers.this.bundle.getString("PanelSelectUsers.NotApplicable.txt");
                    }
                } else if (colIndex == 2) {
                    value = userData.getType();
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            boolean editable = false;
            String id = (String)this.m_userIds.get(rowIndex);
            if (id != null) {
                editable = colIndex == 0;
            }
            return editable;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            String id = (String)this.m_userIds.get(rowIndex);
            if (id != null && value instanceof Boolean && colIndex == 0) {
                UserData userData = (UserData)this.m_users.get(id);
                userData.setSelected((Boolean)value);
                this.fireTableCellUpdated(rowIndex, colIndex);
            }
        }

        public void load() {
            int i;
            this.m_users.clear();
            this.m_userIds.clear();
            Globals.g_levdirrootFQID = null;
            File statusFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "ConfigData", "status.xml"));
            InstanceData[] instanceData = MetadataAccess.getInstanceData(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, statusFile);
            String code = null;
            String order = null;
            String ucCode = null;
            Properties globalRootProps = null;
            Properties levDirRootProps = null;
            ArrayList<String> prodList = new ArrayList<String>();
            for (i = 0; i < instanceData.length; ++i) {
                code = instanceData[i].getCode();
                if (code.equalsIgnoreCase("globalroot")) {
                    globalRootProps = instanceData[i].getProperties();
                } else if (code.equalsIgnoreCase("levdirroot")) {
                    levDirRootProps = instanceData[i].getProperties();
                    Globals.g_levdirrootFQID = instanceData[i].getFQID();
                }
                ucCode = code.toUpperCase(Locale.ENGLISH);
                if (prodList.contains(ucCode)) continue;
                prodList.add(ucCode);
            }
            Globals.g_cmtMachineAll = "";
            for (i = 0; i < prodList.size(); ++i) {
                if (i > 0) {
                    Globals.g_cmtMachineAll = Globals.g_cmtMachineAll + " ";
                }
                Globals.g_cmtMachineAll = Globals.g_cmtMachineAll + prodList.get(i);
            }
            UserData data = null;
            Properties props = null;
            ProductData[] prodData = null;
            String[] codeList = new String[1];
            String persistedCredentials = null;
            String credential = null;
            String nameProp = null;
            String domainProp = null;
            String passwdProp = null;
            String name = null;
            String domain = null;
            String userID = null;
            for (int i2 = 0; i2 < instanceData.length; ++i2) {
                code = instanceData[i2].getCode();
                if (code.equalsIgnoreCase("globalroot")) {
                    codeList[0] = code = "cfgwizard";
                    prodData = Globals.g_deploymentData.getConfigured(Globals.g_order, codeList, true);
                    if (prodData != null && prodData.length == 1) {
                        prodData[0].setInstanceData(instanceData[i2]);
                        PanelSelectUsers.this.m_cfgwizardData = prodData[0];
                    }
                }
                DynamicDialogs.loadProductDefaults(code, null, Language.gs_SelectedLanguage, 0);
                persistedCredentials = Globals.g_configDefaults.getDefault(code + ".credentials.persisted.list", "");
                if (persistedCredentials.length() <= 0) continue;
                props = instanceData[i2].getProperties();
                StringTokenizer credentials = new StringTokenizer(persistedCredentials);
                while (credentials.hasMoreTokens()) {
                    credential = credentials.nextToken();
                    nameProp = credential + ".userid";
                    name = props.getProperty(nameProp, "");
                    if (name.length() == 0) {
                        name = globalRootProps.getProperty(nameProp, "");
                    }
                    if (name.length() == 0) {
                        name = levDirRootProps.getProperty(nameProp, "");
                    }
                    if (name.length() <= 0) continue;
                    domainProp = credential + ".authdomain";
                    domain = props.getProperty(domainProp, "");
                    if (domain.length() == 0) {
                        domain = globalRootProps.getProperty(domainProp, "");
                    }
                    if (domain.length() == 0) {
                        domain = levDirRootProps.getProperty(domainProp, PanelSelectUsers.this.bundle.getString("PanelSelectUsers.NotApplicable.txt"));
                    }
                    passwdProp = credential + ".passwd";
                    order = instanceData[i2].getOrder();
                    codeList[0] = code;
                    prodData = Globals.g_deploymentData.getConfigured(order, codeList, true);
                    if (prodData == null || prodData.length != 1) continue;
                    prodData[0].setInstanceData(instanceData[i2]);
                    userID = domain + name;
                    data = (UserData)this.m_users.get(userID);
                    if (data != null) {
                        data.addInstanceData(prodData[0]);
                        data.addInstanceProp(prodData[0].getInstanceData().getFQID(), passwdProp);
                        continue;
                    }
                    data = new UserData(userID, name, domain, "", passwdProp, prodData[0]);
                    if (PanelSelectUsers.this.m_responseUsers != null && PanelSelectUsers.this.m_responseUsers.containsKey(userID.toLowerCase(Locale.ENGLISH))) {
                        data.setSelected(true);
                    }
                    this.m_userIds.add(userID);
                    this.m_users.put(userID, data);
                }
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectUsers.this.installRenderers();
            PanelSelectUsers.this.m_selectAllButton.setEnabled(this.m_users.size() > 0);
            PanelSelectUsers.this.m_clearAllButton.setEnabled(this.m_users.size() > 0);
        }

        public void selectAll(boolean value) {
            String id = null;
            UserData data = null;
            for (int i = 0; i < this.m_userIds.size(); ++i) {
                id = (String)this.m_userIds.get(i);
                data = (UserData)this.m_users.get(id);
                if (data == null) continue;
                data.setSelected(value);
            }
            this.fireTableDataChanged();
        }

        public ArrayList getUserIds() {
            return this.m_userIds;
        }

        public HashMap getUsers() {
            return this.m_users;
        }
    }
}

