/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.SID;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardCallbackIface;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PanelSelectSID
implements WizardPanelIface,
WizardCallbackIface {
    public static final int IDTYPE_SAS = 0;
    public static final int IDTYPE_JMP = 1;
    public static final int IDTYPE_SPDS = 2;
    public static final int IDTYPE_SIMSTUDIO = 3;
    public static final int IDTYPE_MOMINSTALL = 4;
    private SSNResource bundle = new SSNResource(PanelSelectSID.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private KitTextField m_sidFileText = null;
    private KitBrowseButton m_browseText = null;
    private JComboBox m_sidFileCombo = null;
    private KitBrowseButton m_browseCombo = null;
    private JTextArea m_sidPreviewLabel = null;
    private JTextArea m_sidExampleLabel = null;
    private JScrollPane m_scrollPane = null;
    private JEditorPane m_sidInfo = null;
    private boolean m_panelLoaded = false;
    private boolean m_multiDefaultSID = false;
    private boolean m_lastZOS = false;
    private boolean m_lastInstallSAS = false;
    private boolean m_lastInstallJMP = false;
    private boolean m_lastInstallSPDS = false;
    private boolean m_lastInstallSIMSTUDIO = false;
    private boolean m_lastInstallMOMINSTALL = false;
    private int m_idType = 0;
    private String m_responseValueName = null;
    private String m_lastOrder = "";
    private String m_loadedSID = "";
    private String m_lastSASInstallPlat = null;
    private String m_lastJMPInstallPlat = null;
    private String m_defaultSIDPath = null;
    private HashMap m_orderSetnumids = null;
    private ArrayList m_jmpSoftware = new ArrayList<String>(Arrays.asList("jmp", "jmp64", "jmpgenom", "jmp64genom", "jmpclin", "jmp64clin", "jmppro", "jmplifesci", "jmpwithsas"));
    private ArrayList m_spdsSoftware = new ArrayList<String>(Arrays.asList("spds"));
    private ArrayList m_simstudioSoftware = new ArrayList<String>(Arrays.asList("simstudio"));
    private ArrayList m_momInstallSoftware = new ArrayList<String>(Arrays.asList("mominstall"));

    public PanelSelectSID(int idType) {
        this.m_idType = idType;
        if (this.m_idType == 0) {
            this.m_responseValueName = "SAS_INSTALLATION_DATA";
        } else if (this.m_idType == 1) {
            this.m_responseValueName = "SAS_INSTALLATION_DATA_JMP";
        } else if (this.m_idType == 2) {
            this.m_responseValueName = "SAS_INSTALLATION_DATA_SPDS";
        } else if (this.m_idType == 3) {
            this.m_responseValueName = "SAS_INSTALLATION_DATA_SIMSTUDIO";
        } else if (this.m_idType == 4) {
            this.m_responseValueName = "MOMINSTALL.PRODUCTS.SIDLOCATION";
        }
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        String header = null;
        if (this.m_idType == 0) {
            header = this.bundle.getString("PanelSelectSID.Header.txt");
        } else if (this.m_idType == 1) {
            header = this.bundle.getString("PanelSelectSID.JMPHeader.txt");
        } else if (this.m_idType == 2) {
            header = this.bundle.getString("PanelSelectSID.SPDSHeader.txt");
        } else if (this.m_idType == 3) {
            header = this.bundle.getString("PanelSelectSID.SIMSTUDIOHeader.txt");
        } else if (this.m_idType == 4) {
            header = this.bundle.getString("PanelSelectSID.MOMINSTALLHeader.txt");
        }
        return header;
    }

    @Override
    public String getHeaderDesc() {
        String header = null;
        if (this.m_idType == 0) {
            header = this.bundle.getString("PanelSelectSID.HeaderDesc.txt");
        } else if (this.m_idType == 1) {
            header = this.bundle.getString("PanelSelectSID.JMPHeaderDesc.txt");
        } else if (this.m_idType == 2) {
            header = this.bundle.getString("PanelSelectSID.SPDSHeaderDesc.txt");
        } else if (this.m_idType == 3) {
            header = this.bundle.getString("PanelSelectSID.SIMSTUDIOHeaderDesc.txt");
        } else if (this.m_idType == 4) {
            header = this.bundle.getString("PanelSelectSID.MOMINSTALLHeaderDesc.txt");
        }
        return header;
    }

    @Override
    public boolean validateData() {
        String query = "<XMLSelect search=\"Textstore[@Name='Setinit text'][Objects/Document[@Name='SAS Setinit Location' and @TextRole='setinit']]\" />";
        Hashtable<String, ArrayList<String>> textstores = null;
        boolean valid = true;
        String quietMsg = null;
        String errorMsg = null;
        String sidFile = this.getSelectedSID().trim();
        SID sid = null;
        Logging.log.info("Validating sid file: " + sidFile);
        if (!this.m_multiDefaultSID) {
            Logging.log.info("Updating the m_sidFileText object with text from: " + sidFile);
            this.m_sidFileText.setText(sidFile);
        }
        if (!Utils.pathContainsValidChars(sidFile)) {
            Logging.log.warning("SID file path contains illegal characters:" + sidFile);
            valid = false;
            if (Globals.g_quietMode) {
                quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
            } else {
                errorMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelSelectSID.FieldName.txt")) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelSelectSID.FieldName.txt")) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelSelectSID.FieldName.txt")));
            }
        }
        if (valid) {
            try {
                sid = new SID(sidFile);
            }
            catch (Exception e) {
                sid = null;
            }
            if (sid == null || this.m_idType == 0 && sid.getSetinit() == null || this.m_idType == 1 && sid.getJMPPer() == null || this.m_idType == 2 && sid.getSPDSLic() == null || this.m_idType == 3 && sid.getSetinit() == null || this.m_idType == 4 && sid.getSetinit() == null) {
                valid = false;
                Logging.log.warning("The specified SID is invalid: " + sidFile);
                if (Globals.g_quietMode) {
                    quietMsg = "The specified SAS installation data file is invalid.";
                } else {
                    errorMsg = this.bundle.getString("PanelSelectSID.InvalidSIDMsg.txt");
                }
            }
        }
        if (Globals.g_validateSID) {
            if (valid) {
                String sidVersion;
                if (this.m_idType == 0 && (this.isInstallingSAS() || this.isRenewingSAS()) || this.m_idType == 1 && this.isInstallingJMPSoftware() || this.m_idType == 2 && this.isInstallingSPDSSoftware() || Globals.g_createSSD) {
                    String sasPlatform;
                    String sidPlatform;
                    if (Globals.g_zos) {
                        if (!sid.isValidPlatform("mvs")) {
                            valid = false;
                            if (Globals.g_quietMode) {
                                quietMsg = "The specified SAS installation data file is not valid for the z/OS platform.";
                            } else {
                                errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatformMVS.txt");
                            }
                        }
                    } else if (this.m_idType == 0) {
                        if (Globals.g_sasinstallPlat != null) {
                            if (!sid.isValidPlatform(Globals.g_sasinstallPlat)) {
                                valid = false;
                                sidPlatform = sid.getPlatformShort();
                                if (Globals.g_quietMode) {
                                    quietMsg = "wx6".equalsIgnoreCase(Utils.getOS_Suffix()) && "wx6".equalsIgnoreCase(sidPlatform) || "lax".equalsIgnoreCase(Utils.getOS_Suffix()) && "lax".equalsIgnoreCase(sidPlatform) || "mvs".equalsIgnoreCase(Utils.getOS_Suffix()) && !Globals.g_z64 && "z64".equalsIgnoreCase(sidPlatform) ? "The specified SAS installation data file is only valid for the 64-bit mode of SAS Foundation. A SAS installation data file for the 32-bit mode of SAS Foundation must be specified." : ("mvs".equalsIgnoreCase(Utils.getOS_Suffix()) && Globals.g_z64 && "mvs".equalsIgnoreCase(sidPlatform) ? "The specified SAS installation data file is only valid for the 32-bit mode of SAS Foundation. A SAS installation data file for the 64-bit mode of SAS Foundation must be specified." : "The specified SAS installation data file is not valid for the platform of this machine.");
                                } else {
                                    Logging.log.info("Platform mismatch with the sid file.");
                                    errorMsg = "wx6".equalsIgnoreCase(Utils.getOS_Suffix()) && "wx6".equalsIgnoreCase(sidPlatform) || "lax".equalsIgnoreCase(Utils.getOS_Suffix()) && "lax".equalsIgnoreCase(sidPlatform) || "mvs".equalsIgnoreCase(Utils.getOS_Suffix()) && !Globals.g_z64 && "z64".equalsIgnoreCase(sidPlatform) ? this.bundle.getString("PanelSelectSID.InvalidPlatformAlt64.txt") : ("mvs".equalsIgnoreCase(Utils.getOS_Suffix()) && Globals.g_z64 && "mvs".equalsIgnoreCase(sidPlatform) ? this.bundle.getString("PanelSelectSID.InvalidPlatformAlt32.txt") : this.bundle.getString("PanelSelectSID.InvalidPlatform.txt"));
                                }
                            } else if (!this.isRenewingSAS()) {
                                if (Globals.g_sasHomeStatus.isSimStudioInAnUpdateChain() && !Globals.g_sasHomeStatus.isSimStudioSIDRequired()) {
                                    if (!sid.isValidPlatform(Utils.getOS_Suffix()) && !sid.isValidPlatform("win")) {
                                        valid = false;
                                        Logging.log.info("SIMSTUDIO license information in the SAS SID is a mismatch with the platform.");
                                        if (Globals.g_quietMode) {
                                            quietMsg = "The specified SAS installation data file is not valid for the platform of this machine.";
                                        } else {
                                            errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatform.txt");
                                        }
                                    }
                                } else if (Globals.g_sasHomeStatus.isMomInstallInAnUpdateChain() && !Globals.g_sasHomeStatus.isMomInstallSIDRequired() && !sid.isValidPlatform(Utils.getOS_Suffix())) {
                                    valid = false;
                                    Logging.log.info("MOMINSTALL license information in the SAS SID is a mismatch with the platform.");
                                    if (Globals.g_quietMode) {
                                        quietMsg = "The specified SAS installation data file is not valid for the platform of this machine.";
                                    } else {
                                        errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatform.txt");
                                    }
                                }
                            }
                        } else if (!sid.isValidPlatform(Utils.getOS_Suffix())) {
                            sidPlatform = sid.getPlatformShort();
                            sasPlatform = Utils.getOS_Suffix();
                            valid = false;
                            if (this.m_idType == 0 && ("wx6".equalsIgnoreCase(sasPlatform) && "win".equalsIgnoreCase(sidPlatform) || "lax".equalsIgnoreCase(sasPlatform) && "lnx".equalsIgnoreCase(sidPlatform) || "mvs".equalsIgnoreCase(sasPlatform) && Globals.g_z64 && "mvs".equalsIgnoreCase(sidPlatform))) {
                                if (Globals.g_quietMode) {
                                    quietMsg = "The specified SAS installation data file is only valid for the 32-bit mode of SAS Foundation. A SAS installation data file for the 64-bit mode of SAS Foundation must be specified. ";
                                } else {
                                    errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatformAlt32.txt");
                                }
                            } else if ("mvs".equalsIgnoreCase(sasPlatform) && !Globals.g_z64 && "z64".equalsIgnoreCase(sidPlatform)) {
                                if (Globals.g_quietMode) {
                                    quietMsg = "The specified SAS installation data file is only valid for the 64-bit mode of SAS Foundation. A SAS installation data file for the 32-bit mode of SAS Foundation must be specified. ";
                                } else {
                                    errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatformAlt64.txt");
                                }
                            } else if (Globals.g_quietMode) {
                                quietMsg = "The specified SAS installation data file is not valid for the platform of this machine.";
                            } else {
                                errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatform.txt");
                            }
                        }
                    } else if (this.m_idType == 1) {
                        if (!sid.isValidPlatform(Utils.getOS_Suffix()) && !sid.isValidPlatform("win")) {
                            valid = false;
                            Logging.log.info("JMP license information in the SAS SID is a mismatch with the platform.");
                            if (Globals.g_quietMode) {
                                quietMsg = "The specified SAS installation data file is not valid for the platform of this machine.";
                            } else {
                                errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatform.txt");
                            }
                        }
                    } else if (this.m_idType == 2 && ("wx6".equals(Utils.getOS_Suffix()) || "w64".equals(Utils.getOS_Suffix()))) {
                        if (!sid.isValidPlatform(Utils.getOS_Suffix()) && !sid.isValidPlatform("win")) {
                            valid = false;
                            Logging.log.info("SPDS license information in the SAS SID is a mismatch with the platform.");
                            if (Globals.g_quietMode) {
                                quietMsg = "The specified SAS installation data file is not valid for the platform of this machine.";
                            } else {
                                errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatform.txt");
                            }
                        }
                    } else if (!sid.isValidPlatform(Utils.getOS_Suffix())) {
                        sidPlatform = sid.getPlatformShort();
                        sasPlatform = Utils.getOS_Suffix();
                        valid = false;
                        if (this.m_idType == 0 && ("wx6".equalsIgnoreCase(sasPlatform) && "win".equalsIgnoreCase(sidPlatform) || "lax".equalsIgnoreCase(sasPlatform) && "lnx".equalsIgnoreCase(sidPlatform) || "mvs".equalsIgnoreCase(sasPlatform) && Globals.g_z64 && "mvs".equalsIgnoreCase(sidPlatform))) {
                            if (Globals.g_quietMode) {
                                quietMsg = "The specified SAS installation data file is only valid for the 32-bit mode of SAS Foundation. A SAS installation data file for the 64-bit mode of SAS Foundation must be specified. ";
                            } else {
                                errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatformAlt32.txt");
                            }
                        } else if ("mvs".equalsIgnoreCase(sasPlatform) && !Globals.g_z64 && "z64".equalsIgnoreCase(sidPlatform)) {
                            if (Globals.g_quietMode) {
                                quietMsg = "The specified SAS installation data file is only valid for the 64-bit mode of SAS Foundation. A SAS installation data file for the 32-bit mode of SAS Foundation must be specified. ";
                            } else {
                                errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatformAlt64.txt");
                            }
                        } else {
                            Logging.log.info("SPDS license information in the SAS SID is a mismatch with the platform.");
                            if (Globals.g_quietMode) {
                                quietMsg = "The specified SAS installation data file is not valid for the platform of this machine.";
                            } else {
                                errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatform.txt");
                            }
                        }
                    }
                    if (!Globals.g_zos && valid) {
                        if (this.m_idType == 0) {
                            String tempPlat = Globals.g_sasinstallPlat;
                            if (tempPlat == null && !this.isRenewingSAS() && Globals.g_sasHomeStatus.isSimStudioInAnUpdateChain() && !Globals.g_sasHomeStatus.isSimStudioSIDRequired() && sid.isValidPlatform("win")) {
                                tempPlat = "win";
                            }
                            String sasWinVersion = SASWinAPI.GetSasWinVersion();
                            SID.SetinitFile setinit = sid.getSetinit();
                            valid = setinit.isValidOSNAME(sasWinVersion, tempPlat);
                        }
                        if (!valid) {
                            if (Globals.g_quietMode) {
                                quietMsg = "The specified SAS installation data file is not valid for the platform of this machine.";
                            } else {
                                errorMsg = this.bundle.getString("PanelSelectSID.InvalidPlatform.txt");
                            }
                        }
                    }
                }
                if (valid && !sid.isValidVersion(sidVersion = this.getSidVersion(sid.getSetnumid()))) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        quietMsg = "The specified SAS installation data file is intended for release " + sid.getVersion() + ".  This SAS software requires a SAS installation data file with a release of " + sidVersion + " to proceed.";
                    } else {
                        errorMsg = this.bundle.messageString("PanelSelectSID.InvalidSIDVerMsg.txt", sid.getVersion(), sidVersion);
                    }
                }
                if (valid && !sid.isValidRevision(Globals.g_deploymentData.getOrder(Globals.g_order).getSidRevision(sid.getSetnumid()))) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        quietMsg = "The specified SAS installation data file is intended for release value " + sid.getRevision() + ".  This SAS software requires a SAS installation data file with a release value of " + Globals.g_deploymentData.getOrder(Globals.g_order).getSidRevision(sid.getSetnumid()) + " to proceed.";
                    } else {
                        errorMsg = this.bundle.messageString("PanelSelectSID.InvalidSIDRevMsg.txt", sid.getRevision(), Globals.g_deploymentData.getOrder(Globals.g_order).getSidRevision(sid.getSetnumid()));
                    }
                }
                if (!this.isUpdatingSID() && !this.isRenewingSAS() && valid && this.m_orderSetnumids.size() > 0 && !this.m_orderSetnumids.containsKey(sid.getSetnumid())) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        quietMsg = "The SID file you selected is not intended for the order you are deploying because the Tech Support Site Number values do not match. Select a SID file with a matching Tech Support Site Number.";
                    } else {
                        errorMsg = this.bundle.getString("PanelSelectSID.InvalidSetnumidMsg.txt");
                    }
                }
                if (valid && (this.m_idType == 0 && sid.getSetinit().getDaysToDeath() <= 0 || this.m_idType == 1 && sid.getJMPPer().getDaysToDeath() <= 0 || this.m_idType == 2 && sid.getSPDSLic().getDaysToDeath() <= 0 || this.m_idType == 3 && sid.getSetinit().getDaysToDeath() <= 0 || this.m_idType == 4 && sid.getSetinit().getDaysToDeath() <= 0)) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        quietMsg = "The specified SAS installation data file is expired.";
                    } else {
                        errorMsg = this.bundle.getString("PanelSelectSID.InvalidSIDDeadMsg.txt");
                    }
                }
            }
            if (valid) {
                String info = "";
                if (this.isUpdatingSID()) {
                    textstores = MetadataAccess.textstoreQuery(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, query);
                    MetadataAccess.closeConnection();
                    if (!textstores.get("textRole").contains(sid.getSetnumid())) {
                        for (int i = 0; i < textstores.get("textRole").size(); ++i) {
                            info = info + textstores.get("textRole").get(i) + " - " + textstores.get("siteInfo").get(i) + "\n";
                        }
                        valid = false;
                        if (textstores.get("textRole").size() == 0) {
                            if (Globals.g_quietMode) {
                                quietMsg = "There are no SID files stored in metadata.";
                            } else {
                                errorMsg = this.bundle.getString("PanelSelectSID.InvalidNoneSitenumMsg.txt");
                            }
                        } else if (textstores.get("textRole").size() == 1) {
                            if (Globals.g_quietMode) {
                                quietMsg = "The SAS site number associated with the specified SAS installation data file (SID file) does not match a SAS site number currently in metadata. Locate the SID file with the following SAS site number:\n\n" + info;
                            } else {
                                errorMsg = this.bundle.messageString("PanelSelectSID.InvalidOneSitenumMsg.txt", info);
                            }
                        } else if (Globals.g_quietMode) {
                            quietMsg = "The SAS site number associated with the specified SAS installation data file (SID file) does not match a SAS site number currently in metadata. Locate the SID file with one of the following SAS site numbers:\n\n" + info;
                        } else {
                            errorMsg = this.bundle.messageString("PanelSelectSID.InvalidMultipleSitenumMsg.txt", info);
                        }
                    }
                }
            }
        }
        if (valid) {
            if (this.isUpdatingSID() || this.isRenewingSAS()) {
                String inSASHome = "in" + Globals.g_wizardData.getPreference("SASHome", "");
                Globals.g_wizardData.setPreference("LastSidDir" + inSASHome, Utils.joinPath(new File(this.m_sidFileText.getText()).getParent(), "."));
                Globals.g_sid = sid;
            } else {
                if (this.m_idType == 0) {
                    Globals.g_sid = sid;
                } else if (this.m_idType == 1) {
                    Globals.g_jmpSID = sid;
                } else if (this.m_idType == 2) {
                    Globals.g_spdsSID = sid;
                } else if (this.m_idType == 3) {
                    Globals.g_simstudioSID = sid;
                } else if (this.m_idType == 4) {
                    Globals.g_mominstallSID = sid;
                }
                if (!Globals.g_quietMode && !sidFile.equals(this.getOrderSIDFile(Globals.g_order).getAbsolutePath())) {
                    if (this.m_idType == 0) {
                        Globals.g_wizardData.setPreference("LastSidFile", sidFile);
                    } else if (this.m_idType == 1) {
                        Globals.g_wizardData.setPreference("LastJMPSidFile", sidFile);
                    } else if (this.m_idType == 2) {
                        Globals.g_wizardData.setPreference("LastSPDSSidFile", sidFile);
                    } else if (this.m_idType == 3) {
                        Globals.g_wizardData.setPreference("LastSIMSTUDIOSidFile", sidFile);
                    } else if (this.m_idType == 4) {
                        Globals.g_wizardData.setPreference("LastMOMINSTALLSidFile", sidFile);
                    }
                }
            }
            if (Globals.g_sid != null) {
                Globals.g_installData.setProperty("sid.site.num", Globals.g_sid.getSetnumid());
                Globals.g_installData.setProperty("sid.site.name", Globals.g_sid.getSiteName());
            }
        } else if (Globals.g_quietMode) {
            if (quietMsg != null) {
                Wizard.logResponseInvalid(this.getHeader(), this.m_responseValueName, sidFile, quietMsg);
            }
        } else {
            if (errorMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errorMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            if (this.m_multiDefaultSID) {
                this.m_sidFileCombo.requestFocus();
            } else {
                this.m_sidFileText.requestFocus();
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        if (this.isUpdatingSID() || this.isRenewingSAS()) {
            display = true;
        } else {
            if (Globals.g_srwOnly) {
                return display;
            }
            if (Globals.g_install || Globals.g_createSSD) {
                String sidType;
                if (this.m_idType == 0) {
                    boolean requiresNAPPrompt = false;
                    boolean requiresNAPPromptForMOM = false;
                    this.m_simstudioSoftware.remove("simstudio");
                    this.m_momInstallSoftware.remove("mominstall");
                    String[] setnumids = Globals.g_deploymentData.getOrder(Globals.g_order).getSetnumids();
                    for (int i = 0; !requiresNAPPrompt && i < setnumids.length; ++i) {
                        sidType = Globals.g_deploymentData.getOrder(Globals.g_order).getSidType(setnumids[i]);
                        if ("NAP".equals(sidType) && Globals.g_deploymentData.getOrder(Globals.g_order).getSidProducts(setnumids[i]).contains("simstudio")) {
                            requiresNAPPrompt = true;
                        }
                        if ((!"NAP".equals(sidType) || !Globals.g_deploymentData.getOrder(Globals.g_order).getSidProducts(setnumids[i]).contains("momfdnbndl")) && !Globals.g_deploymentData.getOrder(Globals.g_order).getSidProducts(setnumids[i]).contains("momsdmbndl")) continue;
                        requiresNAPPromptForMOM = true;
                    }
                    if (requiresNAPPrompt) {
                        this.m_simstudioSoftware.add("simstudio");
                    }
                    if (requiresNAPPromptForMOM) {
                        this.m_momInstallSoftware.add("mominstall");
                    }
                }
                boolean installingSASSoftware = this.isInstallingSASSoftware();
                boolean installingJMPSoftware = this.isInstallingJMPSoftware();
                boolean installingSPDSSoftware = this.isInstallingSPDSSoftware();
                boolean installingSIMSTUDIOSoftware = this.isInstallingSIMSTUDIOSoftware();
                boolean installingMOMINSTALLSoftware = this.isInstallingMOMINSTALLSoftware();
                String[] setnumids = Globals.g_deploymentData.getOrder(Globals.g_order).getSetnumids();
                for (int i = 0; !display && i < setnumids.length; ++i) {
                    sidType = Globals.g_deploymentData.getOrder(Globals.g_order).getSidType(setnumids[i]);
                    if (installingSASSoftware && this.m_idType == 0) {
                        if (!"".equals(sidType) && !"SAS".equals(sidType)) continue;
                        display = true;
                        continue;
                    }
                    if (installingJMPSoftware && this.m_idType == 1) {
                        if (!"JMP".equals(sidType)) continue;
                        display = true;
                        continue;
                    }
                    if (installingSPDSSoftware && this.m_idType == 2) {
                        if (!"SPDS".equals(sidType)) continue;
                        display = true;
                        continue;
                    }
                    if (installingSIMSTUDIOSoftware && this.m_idType == 3) {
                        if (!"NAP".equals(sidType) || !Globals.g_deploymentData.getOrder(Globals.g_order).getSidProducts(setnumids[i]).contains("simstudio")) continue;
                        display = true;
                        continue;
                    }
                    if (!installingMOMINSTALLSoftware || this.m_idType != 4) continue;
                    if ("NAP".equals(sidType) && Globals.g_deploymentData.getOrder(Globals.g_order).getSidProducts(setnumids[i]).contains("momfdnbndl")) {
                        display = true;
                    }
                    if (!"NAP".equals(sidType) || !Globals.g_deploymentData.getOrder(Globals.g_order).getSidProducts(setnumids[i]).contains("momsdmbndl")) continue;
                    display = true;
                }
            }
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_createSSD ? "destination" : (this.isUpdatingSID() || this.isRenewingSAS() ? "execute" : (this.m_idType == 0 ? "selectjmpsid" : (this.m_idType == 1 ? "selectspdssid" : (this.m_idType == 2 ? "selectsimstudiosid" : (this.m_idType == 3 ? "selectmominstallsid" : "selectlang")))));
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_lastOrder.equals(Globals.g_order)) {
            this.m_panelLoaded = false;
            this.loadOrderSetnumids();
        }
        this.m_lastOrder = Globals.g_order;
        if (this.m_idType == 0) {
            boolean installingSAS = this.isInstallingSAS();
            if (this.m_panelLoaded && this.m_lastInstallSAS != installingSAS) {
                this.m_panelLoaded = false;
            }
            this.m_lastInstallSAS = installingSAS;
            if (this.m_panelLoaded && this.m_lastZOS != Globals.g_zos) {
                this.m_panelLoaded = false;
            }
            this.m_lastZOS = Globals.g_zos;
            if (this.m_panelLoaded && (this.m_lastSASInstallPlat == null && Globals.g_sasinstallPlat != null || this.m_lastSASInstallPlat != null && Globals.g_sasinstallPlat == null || this.m_lastSASInstallPlat != null && Globals.g_sasinstallPlat != null && !this.m_lastSASInstallPlat.equalsIgnoreCase(Globals.g_sasinstallPlat))) {
                this.m_panelLoaded = false;
            }
            this.m_lastSASInstallPlat = Globals.g_sasinstallPlat;
        } else if (this.m_idType == 1) {
            boolean installingJMPSoftware = this.isInstallingJMPSoftware();
            if (this.m_panelLoaded && this.m_lastInstallJMP != installingJMPSoftware) {
                this.m_panelLoaded = false;
            }
            this.m_lastInstallJMP = installingJMPSoftware;
            if (this.m_panelLoaded && (this.m_lastJMPInstallPlat == null && Globals.g_jmpPlat != null || this.m_lastJMPInstallPlat != null && Globals.g_jmpPlat == null || this.m_lastJMPInstallPlat != null && Globals.g_jmpPlat != null && !this.m_lastJMPInstallPlat.equalsIgnoreCase(Globals.g_jmpPlat))) {
                this.m_panelLoaded = false;
            }
            this.m_lastJMPInstallPlat = Globals.g_jmpPlat;
        } else if (this.m_idType == 2) {
            boolean installingSPDSSoftware = this.isInstallingSPDSSoftware();
            if (this.m_panelLoaded && this.m_lastInstallSPDS != installingSPDSSoftware) {
                this.m_panelLoaded = false;
            }
            this.m_lastInstallSPDS = installingSPDSSoftware;
        } else if (this.m_idType == 3) {
            boolean installingSIMSTUDIOSoftware = this.isInstallingSIMSTUDIOSoftware();
            if (this.m_panelLoaded && this.m_lastInstallSIMSTUDIO != installingSIMSTUDIOSoftware) {
                this.m_panelLoaded = false;
            }
            this.m_lastInstallSIMSTUDIO = installingSIMSTUDIOSoftware;
        } else if (this.m_idType == 4) {
            boolean installingMOMINSTALLSoftware = this.isInstallingMOMINSTALLSoftware();
            if (this.m_panelLoaded && this.m_lastInstallMOMINSTALL != installingMOMINSTALLSoftware) {
                this.m_panelLoaded = false;
            }
            this.m_lastInstallMOMINSTALL = installingMOMINSTALLSoftware;
        }
        if (!this.m_panelLoaded) {
            this.updateAvailableSIDFiles();
            this.loadResponseData();
        }
        this.updateTextArea();
        this.m_panelLoaded = true;
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JComponent focus = null;
        focus = this.m_multiDefaultSID ? this.m_sidFileCombo : this.m_sidFileText;
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.loadOrderSetnumids();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#" + this.m_responseValueName + "=<full path to file>", " " + this.m_responseValueName + "="};
        if (this.m_panelLoaded) {
            data[1] = " " + this.m_responseValueName + "=" + this.getSelectedSID();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        if (this.m_idType == 0) {
            Globals.g_sid = null;
        } else if (this.m_idType == 1) {
            Globals.g_jmpSID = null;
        } else if (this.m_idType == 2) {
            Globals.g_spdsSID = null;
        } else if (this.m_idType == 3) {
            Globals.g_simstudioSID = null;
        } else if (this.m_idType == 4) {
            Globals.g_mominstallSID = null;
        }
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        returnCode = this.m_multiDefaultSID ? ConsoleMode.promptComboBox(this.m_sidFileCombo) : ConsoleMode.promptText(this.bundle.getString("PanelSelectSID.SIDLabel.txt"), this.m_sidFileText);
        if (returnCode > -1) {
            ConsoleMode.println();
            ConsoleMode.println(this.m_sidPreviewLabel.getText());
            String sidPath = this.getSelectedSID().trim();
            if (!Utils.pathContainsValidChars(sidPath)) {
                if (Utils.getOS() == 1) {
                    ConsoleMode.println(this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelSelectSID.FieldName.txt")));
                } else if (Utils.getOS() == 9) {
                    ConsoleMode.println(this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelSelectSID.FieldName.txt")));
                } else {
                    ConsoleMode.println(this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelSelectSID.FieldName.txt")));
                }
            } else {
                SID sid = null;
                try {
                    sid = new SID(sidPath);
                }
                catch (Exception e) {
                    sid = null;
                }
                if (sid != null) {
                    ArrayList<String> text = new ArrayList<String>();
                    text.add(this.bundle.getString("PanelSelectSID.Product.txt") + "~" + sid.getSIDHeader());
                    text.add(this.bundle.getString("PanelSelectSID.Platform.txt") + "~" + sid.getPlatformLong());
                    text.add(this.bundle.getString("PanelSelectSID.Order.txt") + "~" + sid.getOrder());
                    ConsoleMode.printTable(text.toArray(new String[0]));
                    text = new ArrayList();
                    text.add(this.bundle.messageString("PanelSelectSID.LicensedSoftware.txt", "SAS Foundation") + "~" + this.bundle.getString("PanelSelectSID.ExpirationDate.txt"));
                    Vector tletter = null;
                    if (sid.getTLetter() != null) {
                        tletter = sid.getTLetter().getList();
                    }
                    if (tletter != null && tletter.size() > 0) {
                        ListIterator iter = tletter.listIterator();
                        while (iter.hasNext()) {
                            SID.TletterData tletterData = (SID.TletterData)iter.next();
                            text.add(tletterData.getProduct() + "~" + tletterData.getExpiration());
                        }
                        ConsoleMode.printTable(text.toArray(new String[0]));
                    } else {
                        ConsoleMode.printTable(text.toArray(new String[0]));
                        ConsoleMode.println(this.bundle.getString("PanelSelectSID.NoTLetter.txt"));
                    }
                } else if (!(sidPath == null || sidPath.length() <= 0 || this.m_defaultSIDPath != null && this.m_defaultSIDPath.equals(sidPath))) {
                    ConsoleMode.println(this.bundle.getString("PanelSelectSID.InvalidSIDMsg.txt"));
                } else {
                    ConsoleMode.println();
                }
            }
            returnCode = ConsoleMode.promptPause();
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse(this.m_responseValueName, null);
        if (response != null) {
            valid = true;
            if (this.m_multiDefaultSID) {
                ((JTextField)this.m_sidFileCombo.getEditor().getEditorComponent()).setText(response);
            } else {
                this.m_sidFileText.setText(response);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), this.m_responseValueName);
        }
        return valid;
    }

    private void initialize() {
        this.m_sidFileText = new KitTextField();
        this.m_sidFileText.getDocument().addDocumentListener(new TextChangeListener());
        this.m_sidFileCombo = new JComboBox();
        this.m_sidFileCombo.setEditable(true);
        ((JTextField)this.m_sidFileCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new TextChangeListener());
        this.m_sidExampleLabel = Utils.getOS() == 1 ? new JTextArea(this.bundle.getString("PanelSelectSID.SIDExampleWinLabel.txt")) : new JTextArea(this.bundle.getString("PanelSelectSID.SIDExampleUnixLabel.txt"));
        this.m_sidExampleLabel.setEditable(false);
        this.m_sidExampleLabel.setFocusable(false);
        this.m_sidExampleLabel.setLineWrap(false);
        this.m_sidExampleLabel.setOpaque(false);
        String mtxt = this.bundle.getString("Common.Browse2.txt");
        String defaultDir = Utils.joinPath(Globals.g_startupLocation, "sid_files");
        this.m_browseText = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), defaultDir, 0, this.m_sidFileText);
        this.m_browseText.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseText.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseText.setCallbackPanel(this);
        this.m_browseCombo = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), defaultDir, 0, this.m_sidFileCombo);
        this.m_browseCombo.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseCombo.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseCombo.setCallbackPanel(this);
        this.m_sidPreviewLabel = new JTextArea(this.bundle.getString("PanelSelectSID.SIDPreviewLabel.txt"));
        this.m_sidPreviewLabel.setEditable(false);
        this.m_sidPreviewLabel.setFocusable(false);
        this.m_sidPreviewLabel.setLineWrap(false);
        this.m_sidPreviewLabel.setOpaque(false);
        this.m_sidInfo = new JEditorPane();
        this.m_sidInfo.setOpaque(false);
        this.m_sidInfo.setEditable(false);
        this.m_sidInfo.setContentType("text/html");
        this.m_sidInfo.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelSelectSID.this.m_sidInfo.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_scrollPane = new JScrollPane(this.m_sidInfo);
    }

    private String getSidVersion(String setnumid) {
        String sidVersion = null;
        sidVersion = !this.isRenewingSAS() && !this.isUpdatingSID() ? Globals.g_deploymentData.getOrder(Globals.g_order).getSidVersion(setnumid) : Globals.g_majorReleaseVersion;
        return sidVersion;
    }

    private boolean isInstallingSAS() {
        boolean isUpdate;
        boolean installingSAS = false;
        boolean bl = isUpdate = Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired();
        if (Globals.g_createSSD) {
            installingSAS = true;
        } else if (this.isUpdatingSID() || this.isRenewingSAS()) {
            installingSAS = false;
        } else if (isUpdate) {
            if (Globals.g_sasHomeStatus.isSASSIDRequired() || Globals.g_sasHomeStatus.isSASSIDRequiredForVAE()) {
                installingSAS = true;
            }
        } else if (Globals.g_install && Globals.g_selectedInstalls != null) {
            for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                if (!Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("sasinstall") && !Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("zosinstwiz")) continue;
                installingSAS = true;
            }
        }
        return installingSAS;
    }

    private boolean isRenewingSAS() {
        boolean renewingSAS = false;
        if (Globals.g_cmtTask == 41) {
            renewingSAS = true;
        }
        return renewingSAS;
    }

    private boolean isUpdatingSID() {
        boolean updatingSAS = false;
        if (Globals.g_cmtTask == 3) {
            updatingSAS = true;
        }
        return updatingSAS;
    }

    private boolean isInstallingJMPSoftware() {
        boolean installingJMPSoftware = false;
        if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.isJMPSIDRequired()) {
            installingJMPSoftware = true;
        } else if (Globals.g_install && Globals.g_selectedInstalls != null) {
            for (int i = 0; !installingJMPSoftware && i < Globals.g_selectedInstalls.length; ++i) {
                if (!this.m_jmpSoftware.contains(Globals.g_selectedInstalls[i].getProdCode().toLowerCase(Locale.ENGLISH))) continue;
                installingJMPSoftware = true;
            }
        }
        return installingJMPSoftware;
    }

    private boolean isInstallingSPDSSoftware() {
        boolean installingSPDSSoftware = false;
        if (Globals.g_createSSD) {
            installingSPDSSoftware = false;
        } else if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.isSPDSSIDRequired()) {
            installingSPDSSoftware = true;
        } else if (Globals.g_install && Globals.g_selectedInstalls != null) {
            for (int i = 0; !installingSPDSSoftware && i < Globals.g_selectedInstalls.length; ++i) {
                if (!this.m_spdsSoftware.contains(Globals.g_selectedInstalls[i].getProdCode().toLowerCase(Locale.ENGLISH))) continue;
                installingSPDSSoftware = true;
            }
        }
        return installingSPDSSoftware;
    }

    private boolean isInstallingSIMSTUDIOSoftware() {
        boolean installingSIMSTUDIOSoftware = false;
        if (Globals.g_createSSD) {
            installingSIMSTUDIOSoftware = false;
        } else if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.isSimStudioSIDRequired()) {
            installingSIMSTUDIOSoftware = true;
        } else if (Globals.g_install && Globals.g_selectedInstalls != null) {
            for (int i = 0; !installingSIMSTUDIOSoftware && i < Globals.g_selectedInstalls.length; ++i) {
                if (!this.m_simstudioSoftware.contains(Globals.g_selectedInstalls[i].getProdCode().toLowerCase(Locale.ENGLISH))) continue;
                installingSIMSTUDIOSoftware = true;
            }
        }
        return installingSIMSTUDIOSoftware;
    }

    private boolean isInstallingMOMINSTALLSoftware() {
        boolean installingMOMINSTALLSoftware = false;
        if (Globals.g_createSSD) {
            installingMOMINSTALLSoftware = false;
        } else if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.isMomInstallSIDRequired()) {
            installingMOMINSTALLSoftware = true;
        } else if (Globals.g_install && Globals.g_selectedInstalls != null) {
            for (int i = 0; !installingMOMINSTALLSoftware && i < Globals.g_selectedInstalls.length; ++i) {
                if (!this.m_momInstallSoftware.contains(Globals.g_selectedInstalls[i].getProdCode().toLowerCase(Locale.ENGLISH))) continue;
                installingMOMINSTALLSoftware = true;
            }
        }
        return installingMOMINSTALLSoftware;
    }

    private boolean isInstallingSASSoftware() {
        boolean installingSASSoftware = false;
        if (Globals.g_createSSD) {
            installingSASSoftware = true;
        } else if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.isSASSIDRequired()) {
            installingSASSoftware = true;
        } else if (Globals.g_install && Globals.g_selectedInstalls != null) {
            for (int i = 0; !installingSASSoftware && i < Globals.g_selectedInstalls.length; ++i) {
                if (this.m_jmpSoftware.contains(Globals.g_selectedInstalls[i].getProdCode().toLowerCase(Locale.ENGLISH)) || this.m_spdsSoftware.contains(Globals.g_selectedInstalls[i].getProdCode().toLowerCase(Locale.ENGLISH)) || this.m_momInstallSoftware.contains(Globals.g_selectedInstalls[i].getProdCode().toLowerCase(Locale.ENGLISH)) || this.m_simstudioSoftware.contains(Globals.g_selectedInstalls[i].getProdCode().toLowerCase(Locale.ENGLISH))) continue;
                installingSASSoftware = true;
            }
        }
        return installingSASSoftware;
    }

    private void loadOrderSetnumids() {
        if (this.m_orderSetnumids == null) {
            this.m_orderSetnumids = new HashMap();
        } else {
            this.m_orderSetnumids.clear();
        }
        String[] setnumids = Globals.g_deploymentData.getOrder(Globals.g_order).getSetnumids();
        for (int i = 0; i < setnumids.length; ++i) {
            String sidType = Globals.g_deploymentData.getOrder(Globals.g_order).getSidType(setnumids[i]);
            if (this.m_idType == 0) {
                if (!"".equals(sidType) && !"SAS".equals(sidType)) continue;
                this.m_orderSetnumids.put(setnumids[i], null);
                continue;
            }
            if (this.m_idType == 1) {
                if (!"JMP".equals(sidType)) continue;
                this.m_orderSetnumids.put(setnumids[i], null);
                continue;
            }
            if (this.m_idType == 2) {
                if (!"SPDS".equals(sidType)) continue;
                this.m_orderSetnumids.put(setnumids[i], null);
                continue;
            }
            if (this.m_idType == 3) {
                if (!"NAP".equals(sidType) || !Globals.g_deploymentData.getOrder(Globals.g_order).getSidProducts(setnumids[i]).contains("simstudio")) continue;
                this.m_orderSetnumids.put(setnumids[i], null);
                continue;
            }
            if (this.m_idType != 4 || !"NAP".equals(sidType) || !Globals.g_deploymentData.getOrder(Globals.g_order).getSidProducts(setnumids[i]).contains("mominstall")) continue;
            this.m_orderSetnumids.put(setnumids[i], null);
        }
    }

    private String[] getValidSIDFiles() {
        ArrayList<String> sidFilesList = new ArrayList<String>();
        File sidFilesDir = new File(Globals.g_startupLocation, "sid_files");
        if (sidFilesDir.isDirectory()) {
            String platform = null;
            platform = Globals.g_zos ? "mvs" : (this.m_idType == 0 && Globals.g_sasinstallPlat != null ? Globals.g_sasinstallPlat : (this.m_idType == 1 && Globals.g_jmpPlat != null ? Globals.g_jmpPlat : Utils.getOS_Suffix()));
            Logging.log.info("PanelSelectSID.getValidSidFiles platform=" + platform);
            File[] sidFiles = sidFilesDir.listFiles();
            SID sid = null;
            boolean validSID = true;
            for (int i = 0; i < sidFiles.length; ++i) {
                if (!sidFiles[i].isFile()) continue;
                try {
                    sid = new SID(sidFiles[i]);
                    validSID = true;
                    if (this.m_idType == 0 && sid.getSetinit() == null || this.m_idType == 1 && sid.getJMPPer() == null || this.m_idType == 2 && sid.getSPDSLic() == null || this.m_idType == 3 && sid.getSetinit() == null || this.m_idType == 4 && sid.getSetinit() == null) {
                        validSID = false;
                    }
                    if (validSID && (this.m_idType == 0 && this.isInstallingSAS() || this.m_idType == 1 && this.isInstallingJMPSoftware() || this.m_idType == 2 && this.isInstallingSPDSSoftware() || this.m_idType == 3 && this.isInstallingSIMSTUDIOSoftware() || this.m_idType == 4 && this.isInstallingMOMINSTALLSoftware() || Globals.g_createSSD)) {
                        if (Globals.g_zos) {
                            validSID = sid.isValidPlatform(platform);
                        } else if (this.m_idType == 1) {
                            validSID = sid.isValidPlatform(Utils.getOS_Suffix()) || sid.isValidPlatform("win");
                        } else if (this.m_idType == 2 && ("wx6".equals(platform) || "w64".equals(platform))) {
                            validSID = sid.isValidPlatform(platform) || sid.isValidPlatform("win");
                        } else if (sid.isValidPlatform(platform)) {
                            if (this.m_idType == 0) {
                                validSID = sid.getSetinit().isValidOSNAME(SASWinAPI.GetSasWinVersion(), Globals.g_sasinstallPlat);
                            }
                        } else {
                            validSID = false;
                        }
                    }
                    if (validSID && this.m_orderSetnumids.size() > 0) {
                        validSID = this.m_orderSetnumids.containsKey(sid.getSetnumid());
                    }
                    if (validSID) {
                        validSID = sid.isValidVersion(this.getSidVersion(sid.getSetnumid()));
                    }
                    if (validSID) {
                        validSID = sid.isValidRevision(Globals.g_deploymentData.getOrder(Globals.g_order).getSidRevision(sid.getSetnumid()));
                    }
                    if (validSID) {
                        boolean bl = validSID = this.m_idType == 0 && sid.getSetinit().getDaysToDeath() > 0 || this.m_idType == 1 && sid.getJMPPer().getDaysToDeath() > 0 || this.m_idType == 2 && sid.getSPDSLic().getDaysToDeath() > 0 || this.m_idType == 3 && sid.getSetinit().getDaysToDeath() > 0 || this.m_idType == 4 && sid.getSetinit().getDaysToDeath() > 0;
                    }
                    if (validSID && Globals.g_depotManager != null && (Globals.g_depotManager.isInstallDepot() || Globals.g_depotManager.isPreSPSDepot())) {
                        validSID = sid.getOrder().equalsIgnoreCase(Globals.g_order);
                    }
                    if (!validSID) continue;
                    sidFilesList.add(sid.getSIDFile().getAbsolutePath());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (sidFilesList.size() == 0) {
            sidFilesList.add(this.getDefaultSIDPath());
        }
        return sidFilesList.toArray(new String[0]);
    }

    private void updateAvailableSIDFiles() {
        String[] defaultSIDFiles = this.getValidSIDFiles();
        if (defaultSIDFiles == null || defaultSIDFiles.length == 0) {
            this.m_multiDefaultSID = false;
            this.m_sidFileText.setText("");
        } else if (defaultSIDFiles.length == 1) {
            this.m_multiDefaultSID = false;
            this.m_sidFileText.setText(defaultSIDFiles[0]);
        } else {
            this.m_multiDefaultSID = true;
            this.loadSIDComboBox(defaultSIDFiles);
        }
        this.m_sidFileText.setVisible(!this.m_multiDefaultSID);
        this.m_browseText.setVisible(!this.m_multiDefaultSID);
        this.m_sidFileCombo.setVisible(this.m_multiDefaultSID);
        this.m_browseCombo.setVisible(this.m_multiDefaultSID);
    }

    private void loadSIDComboBox(String[] sidFiles) {
        this.m_sidFileCombo.removeAllItems();
        for (int i = 0; i < sidFiles.length; ++i) {
            this.m_sidFileCombo.addItem(sidFiles[i]);
        }
    }

    private String getDefaultSIDPath() {
        File file;
        File sidFile;
        String defaultSIDPath = null;
        if (this.isUpdatingSID() || this.isRenewingSAS()) {
            return defaultSIDPath;
        }
        if (Globals.g_personalSID != null) {
            String personalSID;
            String relPath = Globals.g_personalSID;
            if (Utils.getOS() == 1) {
                relPath = relPath.replaceAll("/", "\\\\");
            }
            if (new File(personalSID = Utils.joinPath(Globals.g_startupLocation, relPath)).isFile()) {
                defaultSIDPath = personalSID;
            }
        }
        if (defaultSIDPath == null && (sidFile = this.getOrderSIDFile(Globals.g_order)).isFile()) {
            defaultSIDPath = sidFile.getAbsolutePath();
        }
        if (defaultSIDPath == null) {
            if (this.m_idType == 0) {
                defaultSIDPath = Globals.g_wizardData.getPreference("LastSidFile", null);
            } else if (this.m_idType == 1) {
                defaultSIDPath = Globals.g_wizardData.getPreference("LastJMPSidFile", null);
            } else if (this.m_idType == 2) {
                defaultSIDPath = Globals.g_wizardData.getPreference("LastSPDSSidFile", null);
            } else if (this.m_idType == 3) {
                defaultSIDPath = Globals.g_wizardData.getPreference("LastSIMSTUDIOSidFile", null);
            } else if (this.m_idType == 4) {
                defaultSIDPath = Globals.g_wizardData.getPreference("LastMOMINSTALLSidFile", null);
            }
        }
        if (defaultSIDPath == null && (file = new File(Globals.g_startupLocation)).getParent() != null && !new File(defaultSIDPath = Utils.joinPath(file.getParent(), "SID", "sid.txt")).isFile()) {
            defaultSIDPath = null;
        }
        if (defaultSIDPath == null) {
            this.m_defaultSIDPath = defaultSIDPath = Utils.joinPath(Globals.g_startupLocation, "sid_files");
        }
        return defaultSIDPath;
    }

    private File getOrderSIDFile(String order) {
        return new File(Utils.joinPath(Globals.g_deploymentData.getOrderDir(), order, "sid.txt"));
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.anchor = 16;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_sidExampleLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_sidFileText, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.anchor = 18;
        c.fill = 0;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseText, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_sidFileCombo, c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.anchor = 18;
        c.fill = 0;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseCombo, c);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.anchor = 16;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_sidPreviewLabel, c);
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
    }

    @Override
    public void updateTextArea() {
        String sidPath = this.getSelectedSID().trim();
        if (Utils.getOS() == 6) {
            sidPath = Utils.VMSToUnixPath(sidPath);
        }
        if (!sidPath.equals(this.m_loadedSID)) {
            this.m_loadedSID = sidPath;
            if (Globals.g_wizard != null && Globals.g_wizard.getFrame() != null) {
                Globals.g_wizard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            }
            SID sid = null;
            try {
                sid = new SID(sidPath);
            }
            catch (Exception e) {
                sid = null;
            }
            String listText = null;
            if (!Utils.pathContainsValidChars(sidPath)) {
                listText = "<html>";
                listText = Utils.getOS() == 1 ? listText + this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelSelectSID.FieldName.txt")) : (Utils.getOS() == 9 ? listText + this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelSelectSID.FieldName.txt")) : listText + this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelSelectSID.FieldName.txt")));
                listText = listText + "</html>";
            } else if (sid != null) {
                listText = "<html><table valign=top cellspacing=1 cellpadding=0><tr><td nowrap>" + this.bundle.getString("PanelSelectSID.Product.txt") + "</td><td>&nbsp;</td><td>" + sid.getSIDHeader() + "</td></tr><tr><td nowrap>" + this.bundle.getString("PanelSelectSID.Platform.txt") + "</td><td>&nbsp;</td><td>" + sid.getPlatformLong() + "</td></tr><tr><td nowrap>" + this.bundle.getString("PanelSelectSID.Order.txt") + "</td><td>&nbsp;</td><td>" + sid.getOrder() + "</td></tr></table>";
                String sasText = "SAS Foundation";
                String softwareMessage = this.bundle.messageString("PanelSelectSID.LicensedSoftware.txt", sasText);
                if (sasText.length() == 0) {
                    softwareMessage = this.bundle.getString("PanelSelectSID.LicensedSoftware_null.txt");
                }
                listText = listText + "<table valign=top cellspacing=1 cellpadding=0><tr><td><b><u>" + softwareMessage + "</u></b></td><td>&nbsp;&nbsp;&nbsp;</td><td><b><u>" + this.bundle.getString("PanelSelectSID.ExpirationDate.txt") + "</u></b></td></tr>";
                Vector tletter = null;
                if (sid.getTLetter() != null) {
                    tletter = sid.getTLetter().getList();
                }
                if (tletter != null && tletter.size() > 0) {
                    ListIterator iter = tletter.listIterator();
                    while (iter.hasNext()) {
                        SID.TletterData tletterData = (SID.TletterData)iter.next();
                        listText = listText + "<tr><td>" + tletterData.getProduct() + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + tletterData.getExpiration() + "</td></tr>";
                    }
                } else {
                    listText = listText + "<tr><td>" + this.bundle.getString("PanelSelectSID.NoTLetter.txt") + "</td></tr>";
                }
                listText = listText + "</table></html>";
            } else {
                listText = sidPath != null && sidPath.length() > 0 && (this.m_defaultSIDPath == null || !this.m_defaultSIDPath.equals(sidPath)) ? "<html>" + this.bundle.getString("PanelSelectSID.InvalidSIDMsg.txt") + "</html>" : "";
            }
            this.m_sidInfo.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.m_sidInfo.setText(listText);
            this.m_sidInfo.setCaretPosition(0);
            this.m_sidInfo.revalidate();
            if (Globals.g_wizard != null && Globals.g_wizard.getFrame() != null) {
                Globals.g_wizard.getFrame().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private String getSelectedSID() {
        String sidFile = null;
        sidFile = this.m_multiDefaultSID ? this.getSIDComboText() : this.m_sidFileText.getText();
        return sidFile;
    }

    private String getSIDComboText() {
        return ((JTextField)this.m_sidFileCombo.getEditor().getEditorComponent()).getText();
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    class TextChangeListener
    implements DocumentListener {
        TextChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PanelSelectSID.this.updateTextArea();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PanelSelectSID.this.updateTextArea();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PanelSelectSID.this.updateTextArea();
        }
    }
}

