/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DeploymentData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.PanelSDMStart;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SASSharedComponents;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SkuFilterIface;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.DeploymentXMLReader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class PanelSelectProductsToUninstall
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelSelectProductsToUninstall.class);
    private RegistryAccess registryAccess = null;
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_subsetsLabel = null;
    private JComboBox m_subsetsComboBox = null;
    private JTextArea m_info = null;
    private JTable m_prodList = null;
    private JScrollPane m_listScrollPane = null;
    private ProductTableModel m_prodListModel = null;
    private ActionListener m_prodActionListener = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private JLabel m_warningImage = null;
    private JTextArea m_warningMessage = null;
    private boolean m_panelLoaded = false;
    private boolean m_sharedConsumersExist = false;
    private boolean m_multipleViews = false;
    private ArrayList<String> m_productIds = new ArrayList();
    private ArrayList<String> m_MVAProductIds = new ArrayList();
    private HashMap<String, ProductUninstallData> m_products = new HashMap();
    private HashMap<String, ProductUninstallData> m_MVAProducts = new HashMap();
    private ArrayList<String> m_includeProducts = new ArrayList();
    private ArrayList<String> m_excludeProducts = new ArrayList();
    private final int SUBSET_OLDER = 1;
    private SkuFilterIface uninstallSkuFilter = null;
    private static int REQUIRED_BY_IMMEDIATE = 0;
    private static int REQUIRED_BY_FULL = 1;

    public PanelSelectProductsToUninstall() {
        try {
            RegistryData.setRegistry(Globals.g_cmtSASHome);
            this.registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
        }
        catch (FileNotFoundException e) {
            Logging.logStackTrace(e);
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public void backEvent(String backPanelID) {
        JButton jbutton;
        Globals.g_selectedProductsToUninstall.clear();
        if (Globals.g_wizard != null && (jbutton = Globals.g_wizard.getNextButton()) != null) {
            jbutton.setEnabled(true);
        }
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectProductsToUninstall.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectProductsToUninstall.HeaderDesc.txt");
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public String getNextPanelID() {
        return "systemcheck";
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_subsetsComboBox) {
            this.loadProdInfo();
        }
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.m_warningImage.setVisible(false);
        this.m_warningMessage.setVisible(false);
        this.m_info.setVisible(false);
        if (!this.m_panelLoaded) {
            this.loadProdInfo();
            if (!this.loadResponseData()) {
                String id = null;
                ProductUninstallData prodUninstData = null;
                for (int i = 0; i < this.m_productIds.size(); ++i) {
                    id = this.m_productIds.get(i);
                    prodUninstData = this.m_products.get(id);
                    if (prodUninstData == null) continue;
                    prodUninstData.setInstall(true);
                }
            }
        }
        if (!this.m_panelLoaded) {
            this.m_panelLoaded = true;
        }
        if (this.m_productIds.isEmpty()) {
            if (Globals.g_wizard != null) {
                Globals.g_wizard.getNextButton().setEnabled(false);
            }
            this.m_warningImage.setVisible(true);
            this.m_warningMessage.setVisible(true);
            this.m_info.setVisible(false);
        }
    }

    @Override
    public int consoleEvent() {
        String id = null;
        ProductUninstallData data = null;
        ConsoleMode.promptComboBox(this.m_subsetsComboBox);
        ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[this.m_productIds.size()];
        if (this.m_warningMessage.isVisible()) {
            ConsoleMode.printInfoText(this.m_warningMessage.getText());
        }
        for (int i = 0; i < options.length; ++i) {
            id = this.m_productIds.get(i);
            data = this.m_products.get(id);
            options[i] = new ConsoleMode.SelectionItem(data.getName(), data.getInstall(), !data.getSelectable());
        }
        int returnCode = ConsoleMode.promptMultiChoice(options, null);
        if (returnCode > -1) {
            for (int i = 0; i < options.length; ++i) {
                id = this.m_productIds.get(i);
                data = this.m_products.get(id);
                data.setInstall(options[i].getSelected());
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("UNINSTALL_SUBSET", null);
        if (response != null) {
            int index = Integer.parseInt(response);
            this.m_subsetsComboBox.setSelectedIndex(index);
        }
        if (Globals.g_uninstallAll) {
            return true;
        }
        String id = null;
        response = Wizard.getResponse("UNINSTALL_SELECTION", null);
        if (response != null) {
            Vector<String> prodCodes = new Vector<String>(Arrays.asList(response.split(",")));
            ProductUninstallData prodData = null;
            for (int i = 0; i < this.m_productIds.size() && (prodData = this.m_products.get(id = this.m_productIds.get(i))) != null; ++i) {
                if (prodCodes.contains(id)) {
                    valid = true;
                    prodData.setInstall(true);
                    continue;
                }
                prodData.setInstall(false);
            }
        }
        if (Globals.g_quietMode && !valid) {
            Wizard.logResponseMissing(this.getHeader(), "UNINSTALL_SELECTION");
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        data.add("#UNINSTALL_SUBSET=0,1");
        data.add(" UNINSTALL_SUBSET=" + this.m_subsetsComboBox.getSelectedIndex());
        data.add("#UNINSTALL_SELECTION=<comma delimited product codes to uninstall>");
        String selection = " UNINSTALL_SELECTION=";
        if (this.m_panelLoaded) {
            String response = "";
            String id = null;
            ProductUninstallData prodData = null;
            for (int i = 0; i < this.m_productIds.size(); ++i) {
                id = this.m_productIds.get(i);
                prodData = this.m_products.get(id);
                if (prodData == null || !prodData.getInstall()) continue;
                if (response.length() > 0) {
                    response = response + ",";
                }
                response = response + id;
            }
            selection = selection + response;
        }
        data.add(selection);
        return data.toArray(new String[0]);
    }

    @Override
    public boolean silentEvent() {
        if (Globals.g_uninstallAll) {
            Logging.log.info("Command line -quiet -uninstallall was passed");
            this.loadProdInfo();
            String response = "";
            String id = null;
            ProductUninstallData prodUninstData = null;
            for (int i = 0; i < this.m_productIds.size(); ++i) {
                id = this.m_productIds.get(i);
                prodUninstData = this.m_products.get(id);
                if (prodUninstData != null && response.length() > 0) {
                    response = response + ",";
                }
                if (response.indexOf(id) >= 0) continue;
                response = response + id;
            }
            Logging.log.info("response: " + response);
            if (response != null) {
                Vector<String> prodCodes = new Vector<String>(Arrays.asList(response.split(",")));
                for (int i = 0; i < this.m_productIds.size(); ++i) {
                    id = this.m_productIds.get(i);
                    prodUninstData = this.m_products.get(id);
                    if (!prodCodes.contains(id) || (prodUninstData = this.m_products.get(id)) == null) continue;
                    prodUninstData.setInstall(true);
                }
            }
            boolean valid = this.validateData();
            return valid;
        }
        this.loadProdInfo();
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void addSelectedProduct(ProductUninstallData productUninstallData) {
        uninstallLoc = "";
        baseProduct = productUninstallData.getProductData();
        tmpArray = this.registryAccess.getMaintVersions(baseProduct.getProdCode(), baseProduct.getProdCustVersion(), baseProduct.getPlatform());
        maintVersions = new String[tmpArray.length];
        for (i = 0; i < tmpArray.length; ++i) {
            maintVersions[i] = tmpArray[tmpArray.length - 1 - i];
        }
        for (String maintVersion : maintVersions) {
            block30: {
                block31: {
                    block32: {
                        doMaint = false;
                        isInt = true;
                        reader = null;
                        try {
                            doMaint = Integer.parseInt(maintVersion) > 0;
                        }
                        catch (NumberFormatException e) {
                            isInt = false;
                            Logging.log.info("NumberFormatException caught for maintVersion = " + maintVersion);
                        }
                        languages = this.registryAccess.getMaintLanguages(baseProduct.getProdCode(), baseProduct.getProdCustVersion(), maintVersion, baseProduct.getPlatform());
                        if (languages.length != 0) break block30;
                        prodData = new ProductData(baseProduct);
                        uninstallLoc = this.registryAccess.getMaintUninstallLoc(prodData.getProdCode(), prodData.getProdCustVersion(), prodData.getPlatform(), maintVersion);
                        if (uninstallLoc == null && Globals.g_deploymentData.getSpsSku(prodData.getSpsSku()).getIndb()) {
                            uninstallLoc = this.registryAccess.getMaintUninstallLoc(prodData.getProdCode(), prodData.getProdVersion(), prodData.getPlatform(), maintVersion);
                        }
                        if (uninstallLoc == null || uninstallLoc.equals("")) break block31;
                        uninstallFile = new File(uninstallLoc);
                        if (!uninstallFile.exists()) break block32;
                        prodData.setInteractiveRef(uninstallLoc);
                        prodData.setSilentRef(uninstallLoc);
                        try {
                            block35: {
                                block33: {
                                    block34: {
                                        deployXMLFile = new File(new File(uninstallLoc).getParent(), "deployment.xml");
                                        if (!isInt) {
                                            reader = new DeploymentXMLReader(deployXMLFile);
                                        }
                                        if (isInt || !reader.isHotFix()) break block33;
                                        Logging.log.info("Processing Hot Fix " + maintVersion);
                                        maint = Globals.g_deploymentData.getMaintenance(prodData.getOrder(), prodData.getProdCode(), prodData.getPlatform(), "xx", true);
                                        productXML = new File(new File(uninstallLoc).getParent(), "product.xml");
                                        if (productXML == null || !productXML.exists()) break block34;
                                        skuData = new SpsSkuData(productXML, Globals.g_deploymentData);
                                        spsSku = skuData.getSpsSku();
                                        prodData.setSpsSku(spsSku);
                                        prodData.setProdMaint(skuData.getMaintLevel());
                                        prodData.setProdName(prodData.getProdName() + " (HF" + maintVersion + ")");
                                        prodData.setLastPortDate(maint.getLastPortDate());
                                        break block35;
                                    }
                                    Logging.log.warning("Hotfix data not found for product= " + prodData.getProdCode() + " language= xx  platform=" + prodData.getPlatform() + " version=" + prodData.getProdCustVersion() + " maintenance version=" + maintVersion);
                                    continue;
                                }
                                if (!doMaint) ** GOTO lbl73
                                maint = Globals.g_deploymentData.getMaintenance(prodData.getOrder(), prodData.getProdCode(), prodData.getPlatform(), "xx", true);
                                if (maint == null && Globals.g_deploymentData.getSpsSku(prodData.getSpsSku()).getIndb()) {
                                    maintDataList = Globals.g_deploymentData.getIndbMaintenance(prodData.getOrder(), prodData.getProdCode(), Utils.getOS_Suffix(), prodData.getPlatform(), true);
                                    for (i = 0; i < maintDataList.length; ++i) {
                                        if (!maintDataList[i].getProdMaint().equals(maintVersion)) continue;
                                        maint = maintDataList[i];
                                        break;
                                    }
                                }
                                try {
                                    Logging.log.info("DeploymentData ProductData getMaintenance maint.getLastPortDate(): " + maint.getLastPortDate());
                                }
                                catch (NullPointerException ex) {
                                    Logging.log.warning("DeploymentData ProductData getMaintenance maint.getLastPortDate() not found");
                                }
                                productXML = new File(new File(uninstallLoc).getParent(), "product.xml");
                                skuData = new SpsSkuData(productXML, Globals.g_deploymentData);
                                spsSku = skuData.getSpsSku();
                                if (maint != null) {
                                    prodData.setSpsSku(spsSku);
                                    prodData.setProdMaint(maintVersion);
                                    prodData.setProdName(prodData.getProdName() + " (M" + maintVersion + ")");
                                    prodData.setLastPortDate(maint.getLastPortDate());
                                } else {
                                    Logging.log.warning("Maintenance data not found for product= " + prodData.getProdCode() + " language=xx platform=" + prodData.getPlatform() + " version=" + prodData.getProdCustVersion() + " maintenance version=" + maintVersion);
                                    continue;
lbl73:
                                    // 1 sources

                                    full = Globals.g_deploymentData.getProduct(prodData.getOrder(), prodData.getProdCode(), prodData.getPlatform(), true);
                                    if (full == null && Globals.g_deploymentData.getSpsSku(prodData.getSpsSku()).getIndb()) {
                                        full = Globals.g_deploymentData.getIndbProduct(prodData.getOrder(), prodData.getProdCode(), Utils.getOS_Suffix(), prodData.getPlatform(), true);
                                    }
                                    if (!(productXML = new File(new File(uninstallLoc).getParent(), "product.xml")).exists()) {
                                        SkuProductDataDir = Utils.joinPath(Utils.joinPath(Globals.g_cmtSASHome, Globals.CMT_INSTALL_DIR), "product_data", full.getSpsSku());
                                        productXML = new File(SkuProductDataDir, "product.xml");
                                    }
                                    Logging.log.info("Full productXML " + productXML);
                                    skuData = new SpsSkuData(productXML, Globals.g_deploymentData);
                                    spsSku = skuData.getSpsSku();
                                    if (full != null) {
                                        prodData.setSpsSku(spsSku);
                                        prodData.setProdMaint(maintVersion);
                                        prodData.setProdName(prodData.getProdName());
                                        prodData.setLastPortDate(full.getLastPortDate());
                                    } else {
                                        Logging.log.warning("Maintenance data not found for product= " + prodData.getProdCode() + " language=xx platform=" + prodData.getPlatform() + " version=" + prodData.getProdCustVersion() + " maintenance version=" + maintVersion);
                                        continue;
                                    }
                                }
                            }
                            Globals.g_selectedProductsToUninstall.add(prodData);
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                        continue;
                    }
                    Logging.log.warning("Uninstall metadata not found for product= " + prodData.getProdCode() + " platform=" + prodData.getPlatform() + " version=" + prodData.getProdCustVersion() + " maintenance version=" + maintVersion);
                    Logging.log.warning("Uninstall package will not be added to the uninstall chain: " + uninstallLoc);
                    continue;
                }
                Logging.log.warning("Uninstall metadata not defined for product= " + prodData.getProdCode() + " platform=" + prodData.getPlatform() + " version=" + prodData.getProdCustVersion() + " maintenance version=" + maintVersion);
                Logging.log.warning("Uninstall package will not be added to the uninstall chain: " + uninstallLoc);
                continue;
            }
            for (String language : languages) {
                block36: {
                    block37: {
                        block38: {
                            if (productUninstallData.getProductData(language) == null) break block36;
                            prodData = new ProductData(productUninstallData.getProductData(language));
                            uninstallLoc = this.registryAccess.getMaintUninstallLoc(prodData.getProdCode(), prodData.getProdVersion(), prodData.getPlatform(), maintVersion, language);
                            if (uninstallLoc == null || uninstallLoc.equals("")) break block37;
                            uninstallFile = new File(uninstallLoc);
                            if (!uninstallFile.exists()) break block38;
                            prodData.setInteractiveRef(uninstallLoc);
                            prodData.setSilentRef(uninstallLoc);
                            try {
                                block41: {
                                    block39: {
                                        block40: {
                                            deployXMLFile = new File(new File(uninstallLoc).getParent(), "deployment.xml");
                                            if (!isInt) {
                                                reader = new DeploymentXMLReader(deployXMLFile);
                                            }
                                            if (isInt || !reader.isHotFix()) break block39;
                                            Logging.log.info("Processing Hot Fix " + maintVersion);
                                            productXML = new File(new File(uninstallLoc).getParent(), "product.xml");
                                            if (productXML == null || !productXML.exists()) break block40;
                                            skuData = new SpsSkuData(productXML, Globals.g_deploymentData);
                                            spsSku = skuData.getSpsSku();
                                            prodData.setSpsSku(spsSku);
                                            prodData.setProdMaint(skuData.getMaintLevel());
                                            prodData.setProdName(prodData.getProdName() + " (HF" + maintVersion + ")");
                                            break block41;
                                        }
                                        Logging.log.warning("Hotfix data not found for product= " + prodData.getProdCode() + " language= xx  platform=" + prodData.getPlatform() + " version=" + prodData.getProdVersion() + " maintenance version=" + maintVersion);
                                        continue;
                                    }
                                    if (!doMaint) ** GOTO lbl151
                                    maint = Globals.g_deploymentData.getMaintenance(prodData.getOrder(), prodData.getProdCode(), prodData.getPlatform(), language, true);
                                    if (maint == null && Globals.g_deploymentData.getSpsSku(prodData.getSpsSku()).getIndb()) {
                                        maintDataList = Globals.g_deploymentData.getIndbMaintenance(prodData.getOrder(), prodData.getProdCode(), Utils.getOS_Suffix(), prodData.getPlatform(), true);
                                        for (i = 0; i < maintDataList.length; ++i) {
                                            if (!maintDataList[i].getProdMaint().equals(maintVersion)) continue;
                                            maint = maintDataList[i];
                                            break;
                                        }
                                    }
                                    productXML = new File(new File(uninstallLoc).getParent(), "product.xml");
                                    skuData = new SpsSkuData(productXML, Globals.g_deploymentData);
                                    spsSku = skuData.getSpsSku();
                                    if (maint != null) {
                                        prodData.setSpsSku(spsSku);
                                        prodData.setProdMaint(maintVersion);
                                        prodData.setProdName(prodData.getProdName() + " (M" + maintVersion + ")");
                                    } else {
                                        Logging.log.warning("Maintenance data not found for product= " + prodData.getProdCode() + " language=" + language + " platform=" + prodData.getPlatform() + " version=" + prodData.getProdVersion() + " maintenance version=" + maintVersion);
                                        continue;
lbl151:
                                        // 1 sources

                                        full = Globals.g_deploymentData.getProduct(prodData.getOrder(), prodData.getProdCode(), prodData.getPlatform(), true);
                                        if (full == null && Globals.g_deploymentData.getSpsSku(prodData.getSpsSku()).getIndb()) {
                                            full = Globals.g_deploymentData.getIndbProduct(prodData.getOrder(), prodData.getProdCode(), Utils.getOS_Suffix(), prodData.getPlatform(), true);
                                        }
                                        if (!(productXML = new File(new File(uninstallLoc).getParent(), "product.xml")).exists()) {
                                            SkuProductDataDir = Utils.joinPath(Utils.joinPath(Globals.g_cmtSASHome, Globals.CMT_INSTALL_DIR), "product_data", full.getSpsSku());
                                            productXML = new File(SkuProductDataDir, "product.xml");
                                        }
                                        Logging.log.info("Full productXML " + productXML);
                                        skuData = new SpsSkuData(productXML, Globals.g_deploymentData);
                                        spsSku = skuData.getSpsSku();
                                        if (full != null) {
                                            prodData.setSpsSku(spsSku);
                                            prodData.setProdMaint(maintVersion);
                                            prodData.setProdName(prodData.getProdName());
                                            prodData.setLastPortDate(full.getLastPortDate());
                                        } else {
                                            Logging.log.warning("Maintenance data not found for product= " + prodData.getProdCode() + " language=xx platform=" + prodData.getPlatform() + " version=" + prodData.getProdCustVersion() + " maintenance version=" + maintVersion);
                                            continue;
                                        }
                                    }
                                }
                                Globals.g_selectedProductsToUninstall.add(prodData);
                            }
                            catch (Exception e) {
                                Logging.logStackTrace(e);
                            }
                            continue;
                        }
                        Logging.log.warning("Uninstall metadata not found for product= " + prodData.getProdCode() + " language=" + language + " platform=" + prodData.getPlatform() + " version=" + prodData.getProdCustVersion() + " maintenance version=" + maintVersion);
                        Logging.log.warning("Uninstall package will not be added to the uninstall chain: " + uninstallLoc);
                        continue;
                    }
                    Logging.log.warning("Uninstall metadata not defined for product= " + prodData.getProdCode() + " language=" + language + " platform=" + prodData.getPlatform() + " version=" + prodData.getProdCustVersion() + " maintenance version=" + maintVersion);
                    Logging.log.warning("Uninstall package will not be added to the uninstall chain: " + uninstallLoc);
                    continue;
                }
                Logging.log.warning("Uninstall: Could not load language data: " + language + " for product=" + baseProduct.getProdCode() + " platform=" + baseProduct.getPlatform() + " version=" + baseProduct.getProdCustVersion() + " maintenance version=" + maintVersion);
            }
        }
    }

    protected boolean processDependencies(String productToChk, String platform, String spsSku, boolean mvaSku) {
        boolean depExists = false;
        boolean sasinstallAdded = false;
        String dependencyList = "";
        String mvaDependencyPlatform = "";
        String dependencyDisplayName = null;
        HashSet<Object> dependencies = new HashSet();
        dependencies = this.getFullProductIdRequiredBys(platform, spsSku);
        for (String string : dependencies) {
            dependencyDisplayName = null;
            if ((!mvaSku || this.m_products.get(string) == null || this.isProductSelected(string)) && (mvaSku || this.isProductSelected(string))) continue;
            depExists = true;
            if (this.m_MVAProducts.get(string) != null) {
                mvaDependencyPlatform = this.m_MVAProducts.get(string).getProductData().getPlatform();
            }
            if (mvaSku || this.m_products.get(string) != null) {
                dependencyDisplayName = this.m_products.get(string).getProductData().getProdName();
            } else if (!mvaSku && !sasinstallAdded && this.m_products.get(mvaDependencyPlatform + "_sasinstall") != null) {
                sasinstallAdded = true;
                dependencyDisplayName = this.m_products.get(mvaDependencyPlatform + "_sasinstall").getProductData().getProdName();
            }
            if (dependencyDisplayName == null) continue;
            if (dependencyList.length() > 0) {
                dependencyList = Globals.g_quietMode ? dependencyList + ", " : dependencyList + "\n";
            }
            dependencyList = dependencyList + dependencyDisplayName;
        }
        if (depExists) {
            if (Globals.g_quietMode) {
                Logging.log.severe("The product " + this.m_products.get(productToChk).getProductData().getProdName() + " cannot be removed until the following products are removed or selected for removal: " + dependencyList);
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelSelectProductsToUninstall.DependencyError.txt", this.m_products.get(productToChk).getProductData().getProdName(), dependencyList), this.bundle.getString("Common.Warning.txt"), 2);
            }
        }
        return depExists;
    }

    protected boolean dependencyExists() {
        ProductUninstallData productUninstallData = null;
        for (String id : this.m_productIds) {
            productUninstallData = this.m_products.get(id);
            if (!productUninstallData.getInstall()) continue;
            if (productUninstallData.getProductData().getProdCode().equalsIgnoreCase("sasinstall")) {
                for (String mvaId : this.m_MVAProductIds) {
                    productUninstallData = this.m_MVAProducts.get(mvaId);
                    String platform = productUninstallData.getProductData().getPlatform();
                    if (this.getImmediateProductIdRequiredBys(platform, mvaId).isEmpty() || !this.processDependencies(id, platform, mvaId, true)) continue;
                    return true;
                }
                continue;
            }
            String platform = productUninstallData.getProductData().getPlatform();
            if (this.getImmediateProductIdRequiredBys(platform, id).isEmpty() || !this.processDependencies(id, platform, id, false)) continue;
            return true;
        }
        return false;
    }

    protected boolean isProductSelected(String spsSku) {
        ProductUninstallData productUninstallData = null;
        boolean mvaSelected = false;
        for (String id : this.m_productIds) {
            productUninstallData = this.m_products.get(id);
            if (productUninstallData.getProductData().getProdCode().equalsIgnoreCase("sasinstall") && productUninstallData.getInstall()) {
                mvaSelected = true;
                continue;
            }
            if (!productUninstallData.getInstall() || !id.equalsIgnoreCase(spsSku)) continue;
            return true;
        }
        if (mvaSelected) {
            for (String id : this.m_MVAProductIds) {
                productUninstallData = this.m_MVAProducts.get(id);
                if (!id.equalsIgnoreCase(spsSku)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean allProductsSelected() {
        ProductUninstallData productUninstallData = null;
        if (this.m_subsetsComboBox.getSelectedIndex() == 1) {
            return false;
        }
        for (String id : this.m_productIds) {
            productUninstallData = this.m_products.get(id);
            if (productUninstallData.getInstall()) continue;
            return false;
        }
        return !this.m_multipleViews;
    }

    @Override
    public boolean validateData() {
        PanelSDMStart sdmStartPanel;
        boolean valid = false;
        Globals.g_removeSasHomeFolder = false;
        boolean depExists = this.dependencyExists();
        if (this.allProductsSelected()) {
            if (Utils.getOS() == 1) {
                Globals.g_removeConsumers = true;
                Logging.log.info("All installed products is selected to uninstall so set the global boolean removeConsumers true.");
            }
            boolean bSASHomeShared = false;
            if (Utils.getSharedSASHomeDir() != null && Globals.g_cmtSASHome.equals(Utils.getSharedSASHomeDir())) {
                bSASHomeShared = true;
            }
            if (bSASHomeShared) {
                Logging.log.info("All installed products are selected to uninstall, but the SASHome folder is shared with other SAS releases so the SASHome folder will remain.");
            }
            if (!depExists && !bSASHomeShared) {
                if (Utils.getOS() == 1) {
                    if (!this.m_sharedConsumersExist) {
                        Globals.g_removeSasHomeFolder = true;
                        Logging.log.info("All installed products are selected to uninstall and no dependencies are found. The SASHome folder will be removed when the Finish button is clicked.");
                    }
                } else {
                    Globals.g_removeSasHomeFolder = true;
                    Logging.log.info("All installed products are selected to uninstall and no dependencies are found. The SASHome folder will be removed when the Finish button is clicked.");
                }
            }
        }
        if (this.allProductsSelected() || !depExists) {
            ProductUninstallData productUninstallData = null;
            ProductUninstallData mvaProductUninstallData = null;
            String sasinstallKey = "sasinstall";
            Globals.g_selectedProductsToUninstall.clear();
            this.registryAccess.open();
            for (String id : this.m_productIds) {
                productUninstallData = this.m_products.get(id);
                if (!productUninstallData.getInstall()) continue;
                valid = true;
                if (sasinstallKey.equalsIgnoreCase(productUninstallData.getProductData().getProdCode())) {
                    for (String mvaId : this.m_MVAProductIds) {
                        mvaProductUninstallData = this.m_MVAProducts.get(mvaId);
                        if (!mvaProductUninstallData.getProductData().getPlatform().equals(productUninstallData.getProductData().getPlatform())) continue;
                        this.addSelectedProduct(mvaProductUninstallData);
                    }
                    continue;
                }
                productUninstallData = this.m_products.get(id);
                this.addSelectedProduct(productUninstallData);
            }
            this.registryAccess.close();
            Collections.sort(Globals.g_selectedProductsToUninstall, new Comparator<ProductData>(){

                @Override
                public int compare(ProductData prodData1, ProductData prodData2) {
                    if (prodData1.getSequenceNum() < prodData2.getSequenceNum()) {
                        return 1;
                    }
                    if (prodData1.getSequenceNum() == prodData2.getSequenceNum()) {
                        if (prodData1.getProdCode().equalsIgnoreCase(prodData2.getProdCode())) {
                            Logging.log.info("Last_Port_Date of Product 1 " + prodData1.getProdName() + ": " + prodData1.getLastPortDate());
                            Logging.log.info("Last_Port_Date of Product 2 " + prodData2.getProdName() + ": " + prodData2.getLastPortDate());
                            if (prodData1.getLastPortDate().length() != 9 || prodData2.getLastPortDate().length() != 9) {
                                if (prodData1.getLastPortDate().length() == 9) {
                                    Logging.log.info("Last_Port_Date of Product 1 is not in ddMMMyyyy format");
                                }
                                if (prodData2.getLastPortDate().length() == 9) {
                                    Logging.log.info("Last_Port_Date of Product 2 is not in ddMMMyyyy format");
                                }
                                return 1;
                            }
                            return Utils.compareDates(prodData1.getLastPortDate(), prodData2.getLastPortDate());
                        }
                        return 0;
                    }
                    return -1;
                }
            });
        }
        for (int i = 0; i < Globals.g_selectedProductsToUninstall.size() - 1; ++i) {
            if (Globals.g_selectedProductsToUninstall.get(i).getSequenceNum() != Globals.g_selectedProductsToUninstall.get(i + 1).getSequenceNum() || !Globals.g_selectedProductsToUninstall.get(i).getProdCode().equalsIgnoreCase(Globals.g_selectedProductsToUninstall.get(i + 1).getProdCode())) continue;
            if (!Globals.g_selectedProductsToUninstall.get(i).getProdName().contains(Globals.g_selectedProductsToUninstall.get(i).getProdVersion())) {
                Globals.g_selectedProductsToUninstall.get(i).setProdName(Globals.g_selectedProductsToUninstall.get(i).getProdName().concat(" (" + Globals.g_selectedProductsToUninstall.get(i).getProdVersion() + ")"));
            }
            if (Globals.g_selectedProductsToUninstall.get(i + 1).getProdName().contains(Globals.g_selectedProductsToUninstall.get(i + 1).getProdVersion())) continue;
            Globals.g_selectedProductsToUninstall.get(i + 1).setProdName(Globals.g_selectedProductsToUninstall.get(i + 1).getProdName().concat(" (" + Globals.g_selectedProductsToUninstall.get(i + 1).getProdVersion() + ")"));
        }
        String sServiceName = "";
        String listServiceName = "";
        String listServiceNameInMsg = "";
        boolean bServiceFound = false;
        if (Utils.getOS() == 1) {
            for (int i = 0; i < Globals.g_selectedProductsToUninstall.size(); ++i) {
                if (Globals.g_selectedProductsToUninstall.get(i).getProdCode().equals("deployagent") && Utils.isWindowServiceRunning(sServiceName = "SAS Deployment Agent")) {
                    bServiceFound = true;
                    if (!listServiceNameInMsg.equals(" ") && listServiceNameInMsg.indexOf(sServiceName) < 0) {
                        listServiceNameInMsg = listServiceNameInMsg + "\n" + sServiceName;
                    }
                    if (!listServiceName.equals(" ") && listServiceName.indexOf(sServiceName) < 0) {
                        listServiceName = listServiceName + sServiceName + ",";
                    }
                }
                if (Globals.g_selectedProductsToUninstall.get(i).getProdCode().equals("txtandocconv") && Utils.isWindowServiceRunning(sServiceName = "SAS Document Conversion Server")) {
                    bServiceFound = true;
                    if (!listServiceNameInMsg.equals(" ") && listServiceNameInMsg.indexOf(sServiceName) < 0) {
                        listServiceNameInMsg = listServiceNameInMsg + "\n" + sServiceName;
                    }
                    if (!listServiceName.equals(" ") && listServiceName.indexOf(sServiceName) < 0) {
                        listServiceName = listServiceName + sServiceName + ",";
                    }
                }
                if (!Globals.g_selectedProductsToUninstall.get(i).getProdCode().equals("pcfilesrv") || !Utils.isWindowServiceRunning(sServiceName = "SAS PC Files Server")) continue;
                bServiceFound = true;
                if (!listServiceNameInMsg.equals(" ") && listServiceNameInMsg.indexOf(sServiceName) < 0) {
                    listServiceNameInMsg = listServiceNameInMsg + "\n" + sServiceName;
                }
                if (listServiceName.equals(" ") || listServiceName.indexOf(sServiceName) >= 0) continue;
                listServiceName = listServiceName + sServiceName + ",";
            }
            if (bServiceFound) {
                if (Globals.g_uninstallAll || Globals.g_quietMode) {
                    valid = true;
                } else {
                    String msgTxt = this.bundle.messageString("PanelSelectServicesToEnd.Information.txt", listServiceNameInMsg);
                    boolean stopServices = this.confirmPrompt(msgTxt);
                    if (!stopServices) {
                        return stopServices;
                    }
                    if (stopServices) {
                        if (!Globals.g_recordMode || !Globals.g_recordOnly) {
                            StringTokenizer tokens = new StringTokenizer(listServiceName, ",");
                            while (tokens.hasMoreTokens()) {
                                sServiceName = tokens.nextToken();
                                Utils.stopWindowActiveService(sServiceName);
                            }
                        }
                    } else {
                        return stopServices;
                    }
                }
            }
        }
        if (Globals.g_selectedProductsToUninstall.isEmpty()) {
            valid = false;
        }
        if (!(depExists || Globals.g_quietMode || valid)) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectProductsToUninstall.RequiredField.txt"), this.bundle.getString("Common.Warning.txt"), 2);
            this.m_prodList.requestFocus();
        }
        if (valid && Globals.g_uninstallMode && (sdmStartPanel = (PanelSDMStart)Globals.g_wizard.getPanel("sdmstart")) != null) {
            sdmStartPanel.loadDynamicDialogs(null, "uninstall");
        }
        return valid;
    }

    protected void checkSASSharedComponentDependencies() {
        int i;
        SASSharedComponents sc = new SASSharedComponents();
        String sharedComponentRootKey = "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files";
        String sharedComponentRootKey32bit = "SOFTWARE\\Wow6432Node\\SAS Institute Inc.\\Common Data\\Shared Files";
        String[] allConsumers = null;
        Globals.g_removeConsumersRegKeys = "";
        Globals.g_removeConsumersRegKeys32bit = "";
        if (Utils.getOS_Suffix().equals("wx6")) {
            Globals.g_sharedFilesLocation = WinRegAPI.getWinRegValueWow64(8, "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files", "");
            Logging.log.info("Globals.g_sharedFilesLocation is " + Globals.g_sharedFilesLocation);
        } else {
            Globals.g_sharedFilesLocation = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\Wow6432Node\\SAS Institute Inc.\\Common Data\\Shared Files", "");
            Logging.log.info("Globals.g_sharedFilesLocation_32bit is " + Globals.g_sharedFilesLocation);
        }
        ArrayList<String> productIdsToRemove = new ArrayList<String>();
        for (i = 0; i < this.m_productIds.size(); ++i) {
            boolean compatibilityMode = false;
            ProductUninstallData prodData = this.m_products.get(this.m_productIds.get(i));
            if (!sc.isSharedComponent(prodData.getProductData().getProdCode())) continue;
            String sharedComponentKey = "SOFTWARE\\SAS Institute Inc.\\Common Data\\Shared Files\\" + sc.getWinRegistryKey(prodData.getProductData().getProdCode()) + "\\Consumers";
            String sharedComponentKey32bit = "SOFTWARE\\Wow6432Node\\SAS Institute Inc.\\Common Data\\Shared Files\\" + sc.getWinRegistryKey(prodData.getProductData().getProdCode()) + "\\Consumers";
            if (Utils.getOS_Suffix().equals("wx6") && prodData.getProductData().getPlatform().equalsIgnoreCase("win")) {
                compatibilityMode = true;
                if (WinRegAPI.isWindowsRegistryKey32(8, sharedComponentKey)) {
                    allConsumers = WinRegAPI.childrenForKey32(8, sharedComponentKey);
                }
            } else if (WinRegAPI.isWindowsRegistryKey64(8, sharedComponentKey)) {
                allConsumers = WinRegAPI.childrenForKey64(8, sharedComponentKey);
            }
            if (allConsumers == null || allConsumers.length == 0) continue;
            HashSet<String> consumers = new HashSet<String>(Arrays.asList(allConsumers));
            consumers.remove(Globals.SHARED_COMP_CONSUMER_KEY);
            String sRemoveConsumersKey = sharedComponentKey + "\\" + Globals.SHARED_COMP_CONSUMER_KEY;
            String sRemoveConsumersKey32bit = sharedComponentKey32bit + "\\" + Globals.SHARED_COMP_CONSUMER_KEY;
            Globals.g_removeConsumersRegKeys = !Globals.g_removeConsumersRegKeys.equals("") ? Globals.g_removeConsumersRegKeys + "," + sRemoveConsumersKey : sRemoveConsumersKey;
            Globals.g_removeConsumersRegKeys32bit = !Globals.g_removeConsumersRegKeys32bit.equals("") ? Globals.g_removeConsumersRegKeys32bit + "," + sRemoveConsumersKey32bit : sRemoveConsumersKey32bit;
            if (!consumers.isEmpty()) {
                Logging.log.info("The following consumers were found for the SAS shared component " + prodData.getProductData().getProdName() + " therefore this product will not be available for uninstall.");
                for (String temp : consumers) {
                    Logging.log.info(temp);
                }
                productIdsToRemove.add(this.m_productIds.get(i));
                HashSet<Object> dependencies = new HashSet();
                dependencies = this.getFullProductIdRequirements(this.m_products.get(this.m_productIds.get(i)).getProductData().getPlatform(), this.m_productIds.get(i));
                if (dependencies == null || dependencies.isEmpty()) continue;
                Logging.log.info("The following shared component dependencies will also not be available for uninstall.");
                this.m_sharedConsumersExist = true;
                for (String string : dependencies) {
                    Logging.log.info(this.m_products.get(string).getProductData().getProdName());
                    productIdsToRemove.add(string);
                }
                continue;
            }
            Logging.log.info("The SAS shared component " + prodData.getProductData().getProdName() + " does not have any consumers and is available to uninstall.");
        }
        for (i = 0; i < productIdsToRemove.size(); ++i) {
            this.m_products.remove(productIdsToRemove.get(i));
            this.m_productIds.remove(productIdsToRemove.get(i));
        }
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_subsetsLabel, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_subsetsComboBox, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_warningImage, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_warningMessage, c);
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 18;
        c.gridy = 1;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_info, c);
        c.gridy = 2;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.fill = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
        this.initButtonPanel();
        c.gridy = 3;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void loadProdInfo() {
        this.m_prodListModel.load();
        int rowHeight = Utils.getPreferredRowHeight(this.m_prodList);
        if (rowHeight > 0) {
            this.m_prodList.setRowHeight(rowHeight);
        }
    }

    private void initialize() {
        this.m_subsetsComboBox = new JComboBox();
        this.m_subsetsComboBox.addItem(this.bundle.getString("PanelSelectProductsToUninstall.SubsetAllProducts.txt"));
        this.m_subsetsComboBox.addItem(this.bundle.getString("PanelSelectProductsToUninstall.SubsetOldProducts.txt"));
        this.m_subsetsComboBox.addActionListener(this);
        String subset = this.bundle.getString("PanelSelectProductsToUninstall.Subsets.Label.txt");
        this.m_subsetsLabel = new JLabel(Util.getLabelWithoutMnemonic(subset));
        this.m_subsetsLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(subset));
        this.m_subsetsLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(subset));
        this.m_subsetsLabel.setLabelFor(this.m_subsetsComboBox);
        this.m_warningImage = new JLabel();
        this.m_warningImage.setIcon(this.bundle.getImageIcon("Common.warning_small.image"));
        this.m_warningMessage = new JTextArea();
        this.m_warningMessage.setEditable(false);
        this.m_warningMessage.setFocusable(false);
        this.m_warningMessage.setLineWrap(true);
        this.m_warningMessage.setWrapStyleWord(true);
        this.m_warningMessage.setOpaque(false);
        this.m_warningMessage.setText(this.bundle.getString("PanelSelectProductsToUninstall.NoProducts.txt"));
        this.m_info = new JTextArea(this.bundle.getString("PanelSelectProductsToUninstall.Info.txt"));
        this.m_info.setEditable(false);
        this.m_info.setFocusable(false);
        this.m_info.setLineWrap(true);
        this.m_info.setWrapStyleWord(true);
        this.m_info.setOpaque(false);
        this.m_prodListModel = new ProductTableModel();
        this.m_prodList = new JTable(this.m_prodListModel);
        this.m_prodList.setCellSelectionEnabled(true);
        this.m_prodList.setSelectionMode(0);
        this.m_prodList.setTableHeader(null);
        this.m_prodList.setShowGrid(false);
        this.m_prodList.setOpaque(true);
        this.m_prodList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelSelectProductsToUninstall.this.m_prodList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_prodList);
        this.m_listScrollPane.getViewport().setBackground(this.m_prodList.getBackground());
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        String txt = Util.getLabelWithoutMnemonic(mtxt);
        int mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_selectAllButton = new JButton(txt);
        this.m_selectAllButton.setMnemonic(mkey);
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        txt = Util.getLabelWithoutMnemonic(mtxt);
        mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_clearAllButton = new JButton(txt);
        this.m_clearAllButton.setMnemonic(mkey);
        this.m_prodActionListener = new SelectClearActionListener();
        this.m_selectAllButton.addActionListener(this.m_prodActionListener);
        this.m_clearAllButton.addActionListener(this.m_prodActionListener);
        this.installRenderers();
    }

    private HashSet<String> getImmediateProductIdRequiredBys(String platform, String spsSku) {
        return this.getProductIdRequiredByDriver(platform, spsSku, REQUIRED_BY_IMMEDIATE);
    }

    private HashSet<String> getFullProductIdRequiredBys(String platform, String spsSku) {
        return this.getProductIdRequiredByDriver(platform, spsSku, REQUIRED_BY_FULL);
    }

    private HashSet<String> getProductIdRequiredByDriver(String platform, String spsSku, int fullOrImmediate) {
        HashSet<String> productIdSet = new HashSet<String>();
        if (spsSku != null) {
            DeploymentData depData = Globals.g_deploymentData;
            SkuFilterIface skuFilter = this.getUninstallSkuFilter();
            String reqType = "blocks_uninstall";
            HashSet<String> skuHashSet = fullOrImmediate == REQUIRED_BY_IMMEDIATE ? depData.getImmediateSkuRequiredBys(platform, spsSku, skuFilter, reqType) : depData.getFullSkuRequiredBys(platform, spsSku, skuFilter, reqType);
            for (String requiredBySku : skuHashSet) {
                String immediateProductId = this.getProductIdFromSpsSku(requiredBySku);
                if (immediateProductId == null) continue;
                productIdSet.add(immediateProductId);
            }
        }
        return productIdSet;
    }

    private HashSet<String> getImmediateProductIdRequirements(String platform, String spsSku) {
        return this.getProductIDRequirementsDriver(platform, spsSku, REQUIRED_BY_IMMEDIATE);
    }

    private HashSet<String> getFullProductIdRequirements(String platform, String spsSku) {
        return this.getProductIDRequirementsDriver(platform, spsSku, REQUIRED_BY_FULL);
    }

    private HashSet<String> getProductIDRequirementsDriver(String platform, String spsSku, int fullOrImmediate) {
        HashSet<String> productIdSet = new HashSet<String>();
        if (spsSku != null) {
            DeploymentData depData = Globals.g_deploymentData;
            SkuFilterIface skuFilter = this.getUninstallSkuFilter();
            String reqType = "blocks_uninstall";
            HashSet<String> skuHashSet = fullOrImmediate == REQUIRED_BY_IMMEDIATE ? depData.getImmediateSkuRequirements(platform, spsSku, skuFilter, reqType) : depData.getFullSkuRequirements(platform, spsSku, skuFilter, reqType);
            for (String requiredSku : skuHashSet) {
                String immediateProductId = this.getProductIdFromSpsSku(requiredSku);
                if (immediateProductId == null) continue;
                productIdSet.add(immediateProductId);
            }
        }
        return productIdSet;
    }

    private SkuFilterIface getUninstallSkuFilter() {
        if (this.uninstallSkuFilter == null) {
            this.uninstallSkuFilter = new SkuFilterIface(){
                private SkuFilterIface stdLangSkuFilter = OrderData.getStandardLanguagesSkuFilter();
                private HashMap<String, String> cache = new HashMap();

                @Override
                public String getFilteredSku(String sku, OrderData order, String platform) {
                    return this.getFilteredSku(Globals.g_deploymentData.getSpsSku(sku), order, platform);
                }

                @Override
                public String getFilteredSku(SpsSkuData spsSkuData, OrderData order, String platform) {
                    String filteredSku = null;
                    if (spsSkuData != null) {
                        String key = spsSkuData.getSpsSku() + "::" + platform;
                        if (this.cache.containsKey(key)) {
                            filteredSku = this.cache.get(key);
                        } else {
                            filteredSku = this.stdLangSkuFilter.getFilteredSku(spsSkuData, order, platform);
                            if (filteredSku != null && PanelSelectProductsToUninstall.this.getProductIdFromSpsSku(filteredSku) == null) {
                                filteredSku = PanelSelectProductsToUninstall.this.getInstalledUpgrade(filteredSku, this.stdLangSkuFilter, platform);
                            }
                            this.cache.put(key, filteredSku);
                        }
                    }
                    return filteredSku;
                }
            };
        }
        return this.uninstallSkuFilter;
    }

    private String getProductIdFromSpsSku(String spsSku) {
        String productId = null;
        if (spsSku != null) {
            for (int i = 0; i < 2 && productId == null; ++i) {
                HashMap<String, ProductUninstallData> lookupHash = i == 0 ? this.m_products : this.m_MVAProducts;
                Iterator<String> prodIdIt = lookupHash.keySet().iterator();
                while (prodIdIt.hasNext() && productId == null) {
                    productId = prodIdIt.next();
                    if (spsSku.equals(lookupHash.get(productId).getProductData().getSpsSku())) continue;
                    productId = null;
                }
            }
        }
        return productId;
    }

    private String getInstalledUpgrade(String spsSku, SkuFilterIface filter, String platform) {
        SpsSkuData bestUpgradeSku = null;
        long bestPortDate = 0L;
        DeploymentData depData = Globals.g_deploymentData;
        OrderData[] orders = depData.getOrders();
        SpsSkuData spsSkuData = depData.getSpsSku(spsSku);
        if (spsSkuData != null) {
            SpsSkuData[] possibleUpgradeSpsSkuDatas;
            long origPortDate = spsSkuData.getLastPortDateAsLong();
            for (SpsSkuData possibleUpgradeSpsSkuData : possibleUpgradeSpsSkuDatas = depData.getSpsSkusByProdCode(spsSkuData.getProdCode(), platform, true)) {
                if (spsSku.equals(possibleUpgradeSpsSkuData.getSpsSku())) continue;
                long possPortDate = possibleUpgradeSpsSkuData.getLastPortDateAsLong();
                int scenario = 0;
                if (bestUpgradeSku == null) {
                    scenario = 1;
                } else if (bestPortDate < possPortDate && possPortDate <= origPortDate) {
                    scenario = 2;
                } else if (origPortDate <= possPortDate && (bestPortDate < origPortDate || possPortDate < bestPortDate)) {
                    scenario = 3;
                }
                if (scenario <= 0) continue;
                OrderData order = null;
                for (int i = 0; i < orders.length && order == null; ++i) {
                    if (orders[i].getSpsSku(possibleUpgradeSpsSkuData.getSpsSku()) == null) continue;
                    order = orders[i];
                }
                if (order == null || filter.getFilteredSku(possibleUpgradeSpsSkuData, order, platform) == null) continue;
                bestUpgradeSku = possibleUpgradeSpsSkuData;
                bestPortDate = possPortDate;
            }
        }
        String returnSku = null;
        if (bestUpgradeSku != null) {
            returnSku = bestUpgradeSku.getSpsSku();
        }
        return returnSku;
    }

    private void installRenderers() {
        this.m_prodList.getColumnModel().getColumn(0).setCellRenderer(new ProductCellRenderer());
        this.m_prodList.getColumnModel().getColumn(0).setCellEditor(new ProductCellEditor(new JCheckBox()));
    }

    private boolean confirmPrompt(String message) {
        boolean valid = true;
        if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), message, Globals.g_wizard.getWizardTitle(), 0, 3, 0) == 1) {
            valid = false;
        }
        return valid;
    }

    class ProductTableModel
    extends AbstractTableModel {
        public static final int PRODUCT_COLUMN = 0;

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int index) {
            return null;
        }

        public Class getColumnClass(int index) {
            return Boolean.class;
        }

        @Override
        public int getRowCount() {
            return PanelSelectProductsToUninstall.this.m_products.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String id = (String)PanelSelectProductsToUninstall.this.m_productIds.get(rowIndex);
            boolean selected = false;
            if (id != null) {
                ProductUninstallData prodData = (ProductUninstallData)PanelSelectProductsToUninstall.this.m_products.get(id);
                selected = prodData.getInstall();
            }
            return selected;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            String id = (String)PanelSelectProductsToUninstall.this.m_productIds.get(rowIndex);
            if (id != null && value instanceof Boolean) {
                ProductUninstallData prodData = (ProductUninstallData)PanelSelectProductsToUninstall.this.m_products.get(id);
                prodData.setInstall((Boolean)value);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        private String getBitSuffix(String host) {
            if (Utils.getOS_Suffix().equals("wx6") || Utils.getOS_Suffix().equals("lax")) {
                if (Utils.getOS_Suffix().equals(host)) {
                    return "(64-bit)";
                }
                return "(32-bit)";
            }
            return "";
        }

        private void loadByPlatform(String platform) {
            boolean bMVAFound = false;
            PanelSelectProductsToUninstall.this.registryAccess.open();
            String includeFilePath = Utils.joinPath(new File(Globals.g_deploymentData.getProductDataDir(Globals.g_order, "deploywiz", true, false)).getAbsolutePath(), "uninstall", "include.txt");
            String excludeFilePath = Utils.joinPath(new File(Globals.g_deploymentData.getProductDataDir(Globals.g_order, "deploywiz", true, false)).getAbsolutePath(), "uninstall", "exclude.txt");
            String[] installedProductCodes = PanelSelectProductsToUninstall.this.registryAccess.getInstallCodes(platform);
            String order = "";
            String displayName = "";
            String sasinstallKey = "";
            String spsSku = "";
            String installSequence = "0";
            ProductUninstallData prodUninstData = null;
            ProductData prodData = null;
            this.loadExternalList(includeFilePath, PanelSelectProductsToUninstall.this.m_includeProducts);
            this.loadExternalList(excludeFilePath, PanelSelectProductsToUninstall.this.m_excludeProducts);
            for (String productCode : installedProductCodes) {
                String[] productVersions;
                if ("javaruntime".equalsIgnoreCase(productCode)) continue;
                for (String productVersion : productVersions = PanelSelectProductsToUninstall.this.registryAccess.getInstallVersions(productCode, platform)) {
                    SpsSkuData skuData;
                    ProductData deploymentData;
                    ProductData[] products;
                    block21: {
                        block19: {
                            block22: {
                                block20: {
                                    String newestVersion;
                                    if (PanelSelectProductsToUninstall.this.m_subsetsComboBox.getSelectedIndex() == 1 && ((newestVersion = this.newestVersion(productCode, platform, productVersions)).equals(productVersion) && !PanelSelectProductsToUninstall.this.m_includeProducts.contains(productCode) || PanelSelectProductsToUninstall.this.m_excludeProducts.contains(productCode))) continue;
                                    displayName = PanelSelectProductsToUninstall.this.registryAccess.getInstallDisplayName(productCode, productVersion, platform);
                                    if (displayName == null || displayName.equals("")) {
                                        displayName = productCode;
                                    }
                                    displayName = displayName + " " + productVersion;
                                    order = PanelSelectProductsToUninstall.this.registryAccess.getInstallOrderNum(productCode, productVersion, platform);
                                    if (order == null || order.equals("")) {
                                        Logging.log.warning("Order data is " + order + " for product=" + productCode + " version=" + productVersion + " platform=" + platform + ", This product will not be available to select for uninstall");
                                        continue;
                                    }
                                    if (PanelSelectProductsToUninstall.this.registryAccess.getInstallViews(productCode, productVersion, platform).length > 1) {
                                        Logging.log.warning("Product=" + productCode + " version=" + productVersion + " platform=" + platform + " is shared by another SAS install. This product will not be available to select for uninstall.");
                                        PanelSelectProductsToUninstall.this.m_multipleViews = true;
                                        continue;
                                    }
                                    String uninstallLoc = null;
                                    boolean uninstallLocFound = false;
                                    String[] maintVersions = PanelSelectProductsToUninstall.this.registryAccess.getMaintVersions(productCode, productVersion, platform);
                                    if (maintVersions.length > 0) {
                                        for (String maintVersion : maintVersions) {
                                            String[] languages = PanelSelectProductsToUninstall.this.registryAccess.getMaintLanguages(productCode, productVersion, maintVersion, platform);
                                            if (languages.length == 0) {
                                                File uninstallFile;
                                                uninstallLoc = PanelSelectProductsToUninstall.this.registryAccess.getMaintUninstallLoc(productCode, productVersion, platform, maintVersion);
                                                if (uninstallLoc != null && !uninstallLoc.equals("") && (uninstallFile = new File(uninstallLoc)).exists()) {
                                                    uninstallLocFound = true;
                                                    break;
                                                }
                                            } else {
                                                for (String language : languages) {
                                                    File uninstallFile;
                                                    uninstallLoc = PanelSelectProductsToUninstall.this.registryAccess.getMaintUninstallLoc(productCode, productVersion, platform, maintVersion, language);
                                                    if (uninstallLoc == null || uninstallLoc.equals("") || !(uninstallFile = new File(uninstallLoc)).exists()) continue;
                                                    uninstallLocFound = true;
                                                    break;
                                                }
                                            }
                                            if (uninstallLocFound) break;
                                        }
                                    }
                                    if (!uninstallLocFound) {
                                        Logging.log.warning("Uninstall: Uninstall metadata not found for product=" + productCode + " version=" + productVersion + " platform=" + platform + ", This product will not be available to select for uninstall");
                                        continue;
                                    }
                                    products = Globals.g_deploymentData.getProductArrayByRegPlat(order, productCode, platform, true);
                                    deploymentData = null;
                                    skuData = null;
                                    for (ProductData product : products) {
                                        skuData = Globals.g_deploymentData.getSpsSku(product.getSpsSku());
                                        if (skuData != null) {
                                            if (!skuData.isStandardLanguage()) continue;
                                            deploymentData = product;
                                            break;
                                        }
                                        Logging.log.warning("Uninstall: Cannot obtain sku data to determine sequence, sequence is set to 0 for product=" + productCode + " version=" + productVersion + " platform=" + platform);
                                    }
                                    if (deploymentData == null) {
                                        Logging.log.warning("Uninstall: Could not load deployment data for order=" + order + " product=" + productCode + " platform=" + platform);
                                        continue;
                                    }
                                    spsSku = deploymentData.getSpsSku();
                                    if ("prt".equals(skuData.getPlatform())) break block19;
                                    if (!skuData.getIndb()) break block20;
                                    displayName = displayName + " (" + PanelSelectProductsToUninstall.this.bundle.getString("Common.Platform" + platform.toUpperCase() + ".txt") + ")";
                                    break block21;
                                }
                                if (!Utils.getOS_Suffix().equals("wx6") && !Utils.getOS_Suffix().equals("lax")) break block21;
                                if (platform == null || !platform.equals("wx6") && !platform.equals("lax")) break block22;
                                displayName = displayName + " (" + PanelSelectProductsToUninstall.this.bundle.getString("PanelExecute.64BitTag.txt") + ")";
                                break block21;
                            }
                            if (platform == null || !platform.equals("win") && !platform.equals("lnx")) break block21;
                            displayName = displayName + " (" + PanelSelectProductsToUninstall.this.bundle.getString("PanelExecute.32BitTag.txt") + ")";
                            break block21;
                        }
                        if (!PanelSelectProductsToUninstall.this.m_productIds.contains(spsSku)) {
                            displayName = displayName + " " + this.getBitSuffix(platform);
                        } else {
                            Logging.log.info("Not adding duplicate sku " + spsSku.toString() + " to uninstall chain.");
                            continue;
                        }
                    }
                    installSequence = skuData.getSequenceNum().trim();
                    prodData = new ProductData(productCode, spsSku, platform, "", productVersion, "0", "", "", displayName, 3, 0, 0, false, "", "", "", "", "", false, false, false, false, false, "", "", Long.valueOf(installSequence));
                    prodData.setOrder(order);
                    prodUninstData = new ProductUninstallData(prodData, true);
                    for (ProductData product : products) {
                        product.setOrder(order);
                        prodUninstData.putProductData(this.getLanguage(product), product);
                    }
                    if (deploymentData.isFoundation() && PanelSelectProductsToUninstall.this.m_subsetsComboBox.getSelectedIndex() != 1) {
                        PanelSelectProductsToUninstall.this.m_MVAProducts.put(spsSku, prodUninstData);
                        PanelSelectProductsToUninstall.this.m_MVAProductIds.add(spsSku);
                        if (bMVAFound || !"base".equalsIgnoreCase(productCode)) continue;
                        bMVAFound = true;
                        displayName = "SAS Foundation " + productVersion + " " + this.getBitSuffix(platform);
                        prodData = new ProductData("sasinstall", "", platform, "", productVersion, "", "", "", displayName, 3, 0, 0, false, "", "", "", "", "", false, false, false, false, false, "", "", Long.valueOf("0"));
                        prodData.setOrder(order);
                        sasinstallKey = platform + "_sasinstall";
                        prodUninstData = new ProductUninstallData(prodData, true);
                        PanelSelectProductsToUninstall.this.m_products.put(sasinstallKey, prodUninstData);
                        PanelSelectProductsToUninstall.this.m_productIds.add(sasinstallKey);
                        continue;
                    }
                    PanelSelectProductsToUninstall.this.m_products.put(spsSku, prodUninstData);
                    PanelSelectProductsToUninstall.this.m_productIds.add(spsSku);
                }
            }
            PanelSelectProductsToUninstall.this.registryAccess.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadExternalList(String path, ArrayList<String> productMap) {
            BufferedReader br = null;
            try {
                String line;
                File file = new File(path);
                if (!file.isFile()) {
                    Logging.log.info(path + " file not found.");
                    return;
                }
                br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                    productMap.add(line.trim());
                }
            }
            catch (IOException e) {
                Logging.log.severe("Unable to read file " + path + ": " + e.getMessage());
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        Logging.log.warning("Unable to close file " + path + ": " + e.getMessage());
                    }
                }
            }
        }

        private String newestVersion(String code, String host, String[] versions) {
            String newestVersion = versions[0];
            String newestLastPortDate = PanelSelectProductsToUninstall.this.registryAccess.getInstallLastPortDate(code, newestVersion, host);
            for (int i = 1; i < versions.length; ++i) {
                String nextVersion = versions[i];
                String nextLastPortDate = PanelSelectProductsToUninstall.this.registryAccess.getInstallLastPortDate(code, nextVersion, host);
                if (!Utils.isNewerVersion(nextVersion, nextLastPortDate, newestVersion, newestLastPortDate)) continue;
                newestVersion = nextVersion;
                newestLastPortDate = nextLastPortDate;
            }
            return newestVersion;
        }

        private String getLanguage(ProductData product) {
            SpsSkuData sku = Globals.g_deploymentData.getSpsSku(product.getSpsSku());
            return sku.getLanguage();
        }

        public void load() {
            JButton jbutton;
            int i;
            PanelSelectProductsToUninstall.this.m_products.clear();
            PanelSelectProductsToUninstall.this.m_productIds.clear();
            PanelSelectProductsToUninstall.this.m_MVAProductIds.clear();
            PanelSelectProductsToUninstall.this.m_MVAProducts.clear();
            PanelSelectProductsToUninstall.this.m_includeProducts.clear();
            PanelSelectProductsToUninstall.this.m_excludeProducts.clear();
            PanelSelectProductsToUninstall.this.m_multipleViews = false;
            PanelSelectProductsToUninstall.this.registryAccess.open();
            String[] hosts = PanelSelectProductsToUninstall.this.registryAccess.getInstallHosts();
            PanelSelectProductsToUninstall.this.registryAccess.close();
            if (hosts == null || hosts.length == 0) {
                Logging.log.severe("Hosts cannot be loaded from deployment registry.");
                return;
            }
            for (int h = 0; h < hosts.length; ++h) {
                Logging.log.info("Loading uninstall data for host " + hosts[h]);
                this.loadByPlatform(hosts[h]);
            }
            if (Utils.getOS() == 1) {
                PanelSelectProductsToUninstall.this.checkSASSharedComponentDependencies();
            }
            String tempProdId = null;
            for (i = PanelSelectProductsToUninstall.this.m_productIds.size() - 1; i > 0; --i) {
                for (int j = 0; j < i; ++j) {
                    if (((ProductUninstallData)PanelSelectProductsToUninstall.this.m_products.get(PanelSelectProductsToUninstall.this.m_productIds.get(j))).getName().compareTo(((ProductUninstallData)PanelSelectProductsToUninstall.this.m_products.get(PanelSelectProductsToUninstall.this.m_productIds.get(j + 1))).getName()) <= 0) continue;
                    tempProdId = (String)PanelSelectProductsToUninstall.this.m_productIds.get(j);
                    PanelSelectProductsToUninstall.this.m_productIds.set(j, (String)PanelSelectProductsToUninstall.this.m_productIds.get(j + 1));
                    PanelSelectProductsToUninstall.this.m_productIds.set(j + 1, tempProdId);
                }
            }
            for (i = 0; i < PanelSelectProductsToUninstall.this.m_productIds.size(); ++i) {
                String id = (String)PanelSelectProductsToUninstall.this.m_productIds.get(i);
                ProductUninstallData prodUninstData = (ProductUninstallData)PanelSelectProductsToUninstall.this.m_products.get(id);
                if (prodUninstData == null) continue;
                prodUninstData.setInstall(true);
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectProductsToUninstall.this.installRenderers();
            PanelSelectProductsToUninstall.this.m_selectAllButton.setEnabled(PanelSelectProductsToUninstall.this.m_products.size() > 0);
            PanelSelectProductsToUninstall.this.m_clearAllButton.setEnabled(PanelSelectProductsToUninstall.this.m_products.size() > 0);
            PanelSelectProductsToUninstall.this.m_warningImage.setVisible(PanelSelectProductsToUninstall.this.m_products.size() == 0);
            PanelSelectProductsToUninstall.this.m_warningMessage.setVisible(PanelSelectProductsToUninstall.this.m_products.size() == 0);
            if (Globals.g_wizard != null && (jbutton = Globals.g_wizard.getNextButton()) != null) {
                if (PanelSelectProductsToUninstall.this.m_productIds.isEmpty()) {
                    jbutton.setEnabled(false);
                } else {
                    jbutton.setEnabled(true);
                }
            }
        }

        public void selectAll(boolean value) {
            String id = null;
            ProductUninstallData prodData = null;
            for (int i = 0; i < PanelSelectProductsToUninstall.this.m_productIds.size(); ++i) {
                id = (String)PanelSelectProductsToUninstall.this.m_productIds.get(i);
                prodData = (ProductUninstallData)PanelSelectProductsToUninstall.this.m_products.get(id);
                if (prodData == null || !prodData.getSelectable()) continue;
                prodData.setInstall(value);
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectProductsToUninstall.this.installRenderers();
        }

        public void clear() {
            PanelSelectProductsToUninstall.this.m_products.clear();
            PanelSelectProductsToUninstall.this.m_productIds.clear();
            this.fireTableDataChanged();
        }
    }

    class ProductUninstallData {
        private final ProductData baseProduct;
        private final Map<String, ProductData> langProducts;
        private boolean m_install = false;
        private boolean m_selectable = false;

        public ProductUninstallData(ProductData prodData, boolean selectable) {
            this.baseProduct = prodData;
            this.langProducts = new HashMap<String, ProductData>();
            this.m_selectable = selectable;
            if (!this.m_selectable) {
                this.m_install = true;
            }
        }

        public boolean getInstall() {
            return this.m_install;
        }

        public boolean getSelectable() {
            return this.m_selectable;
        }

        public ProductData getProductData() {
            return this.baseProduct;
        }

        public ProductData getProductData(String lang) {
            return this.langProducts.get(lang);
        }

        public void putProductData(String lang, ProductData productData) {
            ProductData copy = new ProductData(productData);
            copy.setType(3);
            this.langProducts.put(lang, copy);
        }

        public String getName() {
            return this.baseProduct.getProdName();
        }

        public void setInstall(boolean install) {
            if (this.m_selectable) {
                this.m_install = install;
            }
        }

        public void setSelectable(boolean selectable) {
            this.m_selectable = selectable;
            if (!this.m_selectable) {
                this.m_install = true;
            }
        }
    }

    private class ProductCellEditor
    extends DefaultCellEditor {
        private JCheckBox m_checkBox;

        public ProductCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSelectProductsToUninstall.this.m_productIds.get(row);
                    ProductUninstallData prodData = (ProductUninstallData)PanelSelectProductsToUninstall.this.m_products.get(id);
                    this.m_checkBox.setText(prodData.getName());
                    this.m_checkBox.setSelected(prodData.getInstall());
                    this.m_checkBox.setEnabled(prodData.getSelectable());
                }
            }
            return this.m_checkBox;
        }
    }

    private class ProductCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSelectProductsToUninstall.this.m_productIds.get(row);
                    ProductUninstallData prodData = (ProductUninstallData)PanelSelectProductsToUninstall.this.m_products.get(id);
                    this.setText(prodData.getName());
                    this.setSelected(prodData.getInstall());
                    this.setEnabled(prodData.getSelectable());
                }
            }
            return this;
        }
    }

    class SelectClearActionListener
    implements ActionListener {
        SelectClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelSelectProductsToUninstall.this.m_selectAllButton) {
                PanelSelectProductsToUninstall.this.m_prodListModel.selectAll(true);
            } else if (e.getSource() == PanelSelectProductsToUninstall.this.m_clearAllButton) {
                PanelSelectProductsToUninstall.this.m_prodListModel.selectAll(false);
            }
        }
    }
}

