/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DepotManager;
import com.sas.ssn.DlgBusyMsg;
import com.sas.ssn.DlgCreateMedia;
import com.sas.ssn.DlgOrderDetails;
import com.sas.ssn.Globals;
import com.sas.ssn.KitAction;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Language;
import com.sas.ssn.OrderData;
import com.sas.ssn.OsLevelConfirm;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class PanelSelectOrder
implements WizardPanelIface,
ActionListener,
HyperlinkListener {
    public static final int IDTYPE_INSTALL = 0;
    public static final int IDTYPE_MANAGE = 1;
    private SSNResource bundle = new SSNResource(PanelSelectOrder.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_orderListLabel = null;
    private JTable m_orderList = null;
    private JScrollPane m_listScrollPane = null;
    private JLabel m_orderSummaryLabel = null;
    private JEditorPane m_orderSummary = null;
    private JScrollPane m_summaryScrollPane = null;
    private JLabel m_adminTasksLabel = null;
    private JButton m_detailsButton = null;
    private JButton m_deleteButton = null;
    private JButton m_createMediaButton = null;
    private OrderTableModel m_orderTableModel = null;
    private OrderData[] m_orderData = null;
    private Hashtable m_summaryData = null;
    private boolean m_panelLoaded = false;
    private int m_idType = 0;
    private int m_originalMode = 0;
    private String m_order = "";

    public PanelSelectOrder(int idType) {
        this.m_idType = idType;
        this.m_orderData = Globals.g_deploymentData.getOrders();
        this.m_summaryData = new Hashtable();
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        String header = null;
        header = this.m_idType == 1 ? this.bundle.getString("PanelSelectOrder.ManageSSDHeader.txt") : this.bundle.getString("PanelSelectOrder.Header.txt");
        return header;
    }

    @Override
    public String getHeaderDesc() {
        String headerDesc = null;
        headerDesc = this.m_idType == 1 ? this.bundle.getString("PanelSelectOrder.ManageSSDHeaderDesc.txt") : this.bundle.getString("PanelSelectOrder.HeaderDesc.txt");
        return headerDesc;
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        this.m_order = "";
        if (this.m_idType == 0) {
            int selectedRow = this.m_orderList.getSelectedRow();
            if (selectedRow > -1) {
                Globals.g_order = this.m_order = this.m_orderData[selectedRow].getOrder();
                if (!Globals.g_resumeChain) {
                    Globals.g_wizardData.setPreference("ResumedOrder", Globals.g_order);
                    Globals.g_wizardData.save();
                }
                if (!Globals.g_createSSD && !OsLevelConfirm.checkOsVersion()) {
                    if (!Globals.g_quietMode) {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), OsLevelConfirm.getErrorMessage(), this.bundle.getString("Common.Warning.txt"), 2);
                    }
                    valid = false;
                } else {
                    Globals.g_mode = this.m_originalMode;
                    if (Globals.g_forcePlanning) {
                        Globals.g_sugiSam = false;
                    } else if (Globals.g_skipPlanning) {
                        Globals.g_sugiSam = true;
                    } else {
                        boolean bl = Globals.g_sugiSam = !this.m_orderData[selectedRow].isPlanning();
                    }
                    if (Globals.g_sugiSam) {
                        Globals.g_plannedInstall = false;
                        Globals.g_install = true;
                        Globals.g_configure = false;
                        Globals.g_plan = null;
                        Globals.g_machine = null;
                    } else {
                        Globals.g_plannedInstall = Globals.g_wizardData.getPreference("PlannedInstall", true);
                        Globals.g_install = Globals.g_wizardData.getPreference("Install", true);
                        Globals.g_configure = Globals.g_wizardData.getPreference("Configure", true);
                    }
                    if (!Globals.g_quietMode) {
                        Globals.g_wizardData.setPreference("SelectedOrder", Globals.g_order);
                    }
                }
            } else {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "SELECT_ORDER_NUMBER", Wizard.getResponse("SELECT_ORDER_NUMBER", ""), null);
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectOrder.OrderRequiredMsg.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                    this.m_orderList.requestFocus();
                }
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        if (!Globals.g_resumeChain && Globals.g_deploymentData.getOrderCount() == 1) {
            Globals.g_wizardData.setPreference("ResumedOrder", Globals.g_order);
            Globals.g_wizardData.save();
        }
        return Globals.g_deploymentData.getOrderCount() > 1 || this.m_idType == 1;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        if (Globals.g_checkForHotFix) {
            panelID = "checkforhotfixes";
        } else if (Globals.g_createSSD) {
            panelID = "addorder";
        } else if (this.m_idType == 0) {
            panelID = "zos";
        } else if (this.m_idType == 1) {
            panelID = null;
        }
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (this.m_idType == 1) {
            wizardFramework.getCancelButton().setEnabled(false);
        }
        this.m_orderData = Globals.g_deploymentData.getOrders();
        this.m_orderTableModel.fireTableDataChanged();
        if (this.m_panelLoaded || !this.loadResponseData()) {
            if (Globals.g_order != null) {
                boolean found = false;
                for (int i = 0; i < this.m_orderData.length && !found; ++i) {
                    if (!this.m_orderData[i].getOrder().equalsIgnoreCase(Globals.g_order)) continue;
                    found = true;
                    this.m_orderList.setRowSelectionInterval(i, i);
                    this.m_orderList.scrollRectToVisible(this.m_orderList.getCellRect(i, 0, true));
                }
            }
            if (this.m_orderList.getSelectedRow() < 0 && this.m_orderList.getRowCount() > 0) {
                this.m_orderList.setRowSelectionInterval(0, 0);
            }
        }
        this.m_originalMode = Globals.g_mode;
        this.m_panelLoaded = true;
        TableColumn column = this.m_orderList.getColumnModel().getColumn(0);
        int minWidth = Utils.getMinColumnWidth(this.m_orderList, 0);
        int width = Utils.getPreferredColumnWidth(this.m_orderList, 0);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(width);
        column.setMaxWidth(width * 2);
        int rowHeight = Utils.getPreferredRowHeight(this.m_orderList);
        if (rowHeight > 0) {
            this.m_orderList.setRowHeight(rowHeight);
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = null;
        if (this.m_idType == 0) {
            data = new String[]{"#SELECT_ORDER_NUMBER=<order number>", " SELECT_ORDER_NUMBER="};
            if (this.m_panelLoaded) {
                data[1] = " SELECT_ORDER_NUMBER=" + this.m_order;
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int selection = 0;
        String[] options = new String[this.m_orderData.length];
        for (int i = 0; i < this.m_orderData.length; ++i) {
            options[i] = this.m_orderData[i].getOrder() + "~" + this.m_orderData[i].getDescription(Language.gs_SelectedLanguage);
            if (!this.m_orderData[i].getOrder().equalsIgnoreCase(Globals.g_order)) continue;
            selection = i;
        }
        String header = this.bundle.getString("PanelSelectOrder.Column.Order.txt") + "~" + this.bundle.getString("PanelSelectOrder.Column.Desc.txt");
        selection = ConsoleMode.promptSingleChoice(options, null, header, selection);
        if (selection > -1) {
            this.m_orderList.setRowSelectionInterval(selection, selection);
            if (this.m_idType == 1) {
                OrderData orderData = this.m_orderData[selection];
                ConsoleMode.printInfoText(this.m_adminTasksLabel.getText());
                ArrayList<String> adminTasks = new ArrayList<String>();
                if (this.m_detailsButton != null && this.m_detailsButton.isVisible() && this.m_detailsButton.isEnabled()) {
                    adminTasks.add(ConsoleMode.stripEllipses(this.m_detailsButton.getText()));
                }
                if (this.m_deleteButton != null && this.m_deleteButton.isVisible() && this.m_deleteButton.isEnabled()) {
                    adminTasks.add(ConsoleMode.stripEllipses(this.m_deleteButton.getText()));
                }
                if (this.m_createMediaButton != null && this.m_createMediaButton.isVisible() && this.m_createMediaButton.isEnabled()) {
                    adminTasks.add(ConsoleMode.stripEllipses(this.m_createMediaButton.getText()));
                }
                if ((selection = ConsoleMode.promptSingleChoice(adminTasks.toArray(new String[0]), null, null, 0)) > -1) {
                    if (selection == 0) {
                        boolean editable = Globals.g_forceOrder == null && (Globals.g_depotManager == null || Globals.g_depotManager.isWritable());
                        ConsoleMode.printInfoText(this.bundle.getString("DlgOrderDetails.Title.txt"));
                        String dateAdded = null;
                        try {
                            dateAdded = DateFormat.getDateTimeInstance(2, 3).format(new SimpleDateFormat("yyyyMMddHHmmss").parse(orderData.getExtendedData().getTime(), new ParsePosition(0)));
                        }
                        catch (Exception e) {
                            dateAdded = this.bundle.getString("DlgOrderDetails.NotAvailable.txt");
                        }
                        KitTextField dateField = new KitTextField(dateAdded);
                        dateField.setEditable(false);
                        selection = ConsoleMode.promptText(Util.getLabelWithoutMnemonic(this.bundle.getString("DlgOrderDetails.DateAdded.txt")), dateField);
                        KitTextField descField = new KitTextField(orderData.getDescription(Language.gs_SelectedLanguage));
                        descField.setEditable(editable);
                        if (selection > -1) {
                            selection = ConsoleMode.promptText(Util.getLabelWithoutMnemonic(this.bundle.getString("DlgOrderDetails.OrderDesc.txt")), descField);
                        }
                        KitTextField notesField = new KitTextField(orderData.getExtendedData().getNote());
                        notesField.setEditable(editable);
                        if (selection > -1) {
                            selection = ConsoleMode.promptText(Util.getLabelWithoutMnemonic(this.bundle.getString("DlgOrderDetails.Notes.txt")), notesField);
                        }
                        if (selection > -1 && editable) {
                            Globals.g_depotManager.setDescription(orderData.getOrder(), descField.getText().trim());
                            Globals.g_depotManager.setNote(orderData.getOrder(), notesField.getText().trim());
                        }
                    } else if (selection == 1 && this.m_deleteButton != null && this.m_deleteButton.isVisible() && this.m_deleteButton.isEnabled()) {
                        this.deleteOrderEvent();
                    } else {
                        ConsoleMode.printInfoText(this.bundle.messageString("DlgCreateMedia.Title.txt", orderData.getOrder()));
                        ConsoleMode.println();
                        JComboBox<String> typeCombo = new JComboBox<String>();
                        String[] types = orderData.getExportMediaTypes();
                        MediaType[] mediaTypes = new MediaType[types.length];
                        for (int i = 0; i < types.length; ++i) {
                            if (types[i] == null) continue;
                            mediaTypes[i] = new MediaType(types[i]);
                        }
                        MediaType temp = null;
                        for (int i = mediaTypes.length - 1; i > 0; --i) {
                            for (int j = 0; j < i; ++j) {
                                if (mediaTypes[j].getName().compareTo(mediaTypes[j + 1].getName()) <= 0) continue;
                                temp = mediaTypes[j];
                                mediaTypes[j] = mediaTypes[j + 1];
                                mediaTypes[j + 1] = temp;
                            }
                        }
                        int currentRank = 0;
                        int currentDisks = 0;
                        for (int i = 0; i < mediaTypes.length; ++i) {
                            typeCombo.addItem(mediaTypes[i].getName());
                            int disks = orderData.getVolsers(mediaTypes[i].getType()).length;
                            int rank = mediaTypes[i].getRank();
                            if (disks < currentDisks || currentRank == 0) {
                                currentDisks = disks;
                                currentRank = rank;
                                typeCombo.setSelectedIndex(i);
                                continue;
                            }
                            if (disks != currentDisks || rank >= currentRank) continue;
                            currentDisks = disks;
                            currentRank = rank;
                            typeCombo.setSelectedIndex(i);
                        }
                        ConsoleMode.println(Util.getLabelWithoutMnemonic(this.bundle.getString("DlgCreateMedia.MediaType.txt")));
                        selection = ConsoleMode.promptComboBox(typeCombo);
                        if (selection > -1) {
                            Runnable job = null;
                            KitTextField mediaDest = new KitTextField();
                            boolean valid = false;
                            while (!valid) {
                                long freeSpace;
                                File targetFile;
                                valid = true;
                                selection = ConsoleMode.promptText(Util.getLabelWithoutMnemonic(this.bundle.getString("DlgCreateMedia.TargetDir.txt")), mediaDest);
                                if (selection <= -1) continue;
                                String errMsg = null;
                                String targetDir = Utils.trimTrailingSlashes(mediaDest.getText());
                                mediaDest.setText(targetDir);
                                if (targetDir.length() == 0) {
                                    valid = false;
                                    errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt"));
                                }
                                if (valid) {
                                    if (Utils.pathContainsValidChars(targetDir)) {
                                        valid = Utils.validatePath(targetDir);
                                        if (!valid) {
                                            errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt"));
                                        }
                                    } else {
                                        valid = false;
                                        errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt")) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt")) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt")));
                                    }
                                }
                                if (valid && !(valid = Utils.canWriteToPath(targetDir))) {
                                    errMsg = this.bundle.messageString("Common.Error.NoPermissions.txt", this.bundle.getString("DlgCreateMedia.FieldName.txt"));
                                }
                                if (valid) {
                                    targetFile = new File(targetDir);
                                    boolean bl = valid = !Utils.pathContainsFiles(targetFile);
                                    if (!valid) {
                                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("DlgCreateMedia.ExistingFilesMsg.txt"), "", 2);
                                    }
                                }
                                if (valid) {
                                    job = Globals.g_depotManager.createExportJob(mediaDest.getText(), orderData.getOrder(), mediaTypes[typeCombo.getSelectedIndex()].getType());
                                } else if (errMsg != null) {
                                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                                }
                                if (valid && !Globals.g_skipSpaceCheck && (freeSpace = Utils.getFreeSpace(targetDir)) < ((DepotManager.Job)job).getTotalSize()) {
                                    DecimalFormat gigFormat = new DecimalFormat("###,##0.000");
                                    String requiredSpace = gigFormat.format((double)((DepotManager.Job)job).getTotalSize() / 1.073741824E9);
                                    valid = ConsoleMode.confirmPrompt(this.bundle.messageString("DlgCreateMedia.InsufficientSpaceMsg.txt", requiredSpace));
                                }
                                if (!valid || (targetFile = new File(targetDir)).exists()) continue;
                                valid = targetFile.mkdirs();
                            }
                            if (selection > -1) {
                                ConsoleMode.busyMsgStart(this.bundle.getString("DlgCreateMedia.ConsoleCreateMediaMsg.txt"));
                                job.run();
                                ConsoleMode.busyMsgStop();
                            }
                        }
                    }
                }
                if (selection > -1) {
                    selection = ConsoleMode.promptPause(false, true);
                }
            }
        }
        return selection;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("SELECT_ORDER_NUMBER", null);
        if (response != null) {
            for (int i = 0; i < this.m_orderData.length && !valid; ++i) {
                if (!this.m_orderData[i].getOrder().equalsIgnoreCase(response)) continue;
                valid = true;
                this.m_orderList.setRowSelectionInterval(i, i);
                this.m_orderList.scrollRectToVisible(this.m_orderList.getCellRect(i, 0, true));
            }
            if (Globals.g_quietMode && !valid) {
                Wizard.logResponseInvalid(this.getHeader(), "SELECT_ORDER_NUMBER", response, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "SELECT_ORDER_NUMBER");
        }
        return valid;
    }

    private void initialize() {
        this.m_orderTableModel = new OrderTableModel();
        this.m_orderList = new JTable(this.m_orderTableModel);
        this.m_orderList.setRowSelectionAllowed(true);
        this.m_orderList.setColumnSelectionAllowed(false);
        this.m_orderList.setSelectionMode(0);
        this.m_orderList.getTableHeader().setResizingAllowed(true);
        this.m_orderList.getTableHeader().setReorderingAllowed(false);
        this.m_orderList.getColumnModel().getColumn(0).setCellRenderer(new StringCellRenderer());
        this.m_orderList.getColumnModel().getColumn(1).setCellRenderer(new StringCellRenderer());
        this.m_orderList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    PanelSelectOrder.this.updateSummaryText(lsm.getMinSelectionIndex());
                }
            }
        });
        this.m_orderList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelSelectOrder.this.m_orderList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_orderList);
        String mtxt = this.bundle.getString("PanelSelectOrder.OrderList.txt");
        this.m_orderListLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_orderListLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_orderListLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_orderListLabel.setLabelFor(this.m_orderList);
        this.m_adminTasksLabel = this.m_idType == 0 ? new JLabel(this.bundle.getString("PanelSelectOrder.AdditionalDetails.txt")) : new JLabel(this.bundle.getString("PanelSelectOrder.AdminTasks.txt"));
        mtxt = this.m_idType == 0 || Globals.g_forceOrder != null || Globals.g_depotManager != null && !Globals.g_depotManager.isWritable() ? this.bundle.getString("PanelSelectOrder.ViewDetailsButton.txt") : this.bundle.getString("PanelSelectOrder.ChangeDetailsButton.txt");
        this.m_detailsButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_detailsButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_detailsButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_detailsButton.addActionListener(this);
        if (this.m_idType == 1 && Globals.g_forceOrder == null && (Globals.g_depotManager == null || Globals.g_depotManager.isWritable() && Globals.g_depotManager.getDepotType() == 0)) {
            mtxt = this.bundle.getString("PanelSelectOrder.DeleteButton.txt");
            this.m_deleteButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
            this.m_deleteButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_deleteButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            this.m_deleteButton.addActionListener(this);
        }
        if (this.m_idType == 1 && (Globals.g_depotManager == null || Globals.g_depotManager.getDepotType() == 0)) {
            mtxt = this.bundle.getString("PanelSelectOrder.CreateMediaButton.txt");
            this.m_createMediaButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
            this.m_createMediaButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_createMediaButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            this.m_createMediaButton.addActionListener(this);
        }
        this.m_orderSummary = new JEditorPane();
        this.m_orderSummary.setOpaque(false);
        this.m_orderSummary.setEditable(false);
        this.m_orderSummary.setContentType("text/html");
        this.m_orderSummary.addHyperlinkListener(this);
        this.m_orderSummary.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelSelectOrder.this.m_orderSummary.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_summaryScrollPane = new JScrollPane(this.m_orderSummary);
        mtxt = this.bundle.getString("PanelSelectOrder.OrderSummary.txt");
        this.m_orderSummaryLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_orderSummaryLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_orderSummaryLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_orderSummaryLabel.setLabelFor(this.m_orderSummary);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_orderListLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_adminTasksLabel, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 5, 5);
        this.m_panel.add((Component)this.m_detailsButton, c);
        if (this.m_deleteButton != null) {
            c.gridx = 1;
            c.gridy = 3;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.insets = new Insets(5, 5, 5, 5);
            this.m_panel.add((Component)this.m_deleteButton, c);
        }
        if (this.m_createMediaButton != null) {
            c.gridx = 2;
            c.gridy = 3;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.insets = new Insets(5, 5, 5, 0);
            this.m_panel.add((Component)this.m_createMediaButton, c);
        }
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_orderSummaryLabel, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 2.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_summaryScrollPane, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_detailsButton) {
            this.detailsEvent();
        } else if (src == this.m_deleteButton) {
            this.deleteOrderEvent();
        } else if (src == this.m_createMediaButton) {
            this.createMediaEvent();
        }
    }

    private void detailsEvent() {
        int selectedRow = this.m_orderList.getSelectedRow();
        if (selectedRow > -1) {
            String order = this.m_orderData[selectedRow].getOrder();
            DlgOrderDetails dlgDetails = new DlgOrderDetails(Globals.g_wizard.getFrame(), order, this.m_idType == 1 && Globals.g_forceOrder == null && (Globals.g_depotManager == null || Globals.g_depotManager.isWritable()));
            dlgDetails.setVisible(true);
            if (dlgDetails.descChanged()) {
                this.refreshPanel();
            }
        }
    }

    private void deleteOrderEvent() {
        int selectedRow = this.m_orderList.getSelectedRow();
        if (selectedRow > -1) {
            String orderText = null;
            orderText = Globals.g_consoleMode ? "\n\n" + this.m_orderData[selectedRow].getOrder() + " - " + Utils.escapeHTMLString(this.m_orderData[selectedRow].getDescription(Language.gs_SelectedLanguage)) : "<table cellspacing=0 cellpadding=0><tr><td>" + this.bundle.getString("PanelSelectOrder.Column.Order.txt") + ":</td><td>&nbsp;</td><td>" + this.m_orderData[selectedRow].getOrder() + "</td></tr><tr><td>" + this.bundle.getString("PanelSelectOrder.Column.Desc.txt") + ":</td><td>&nbsp;</td><td>" + Utils.escapeHTMLString(this.m_orderData[selectedRow].getDescription(Language.gs_SelectedLanguage)) + "</td></tr></table>";
            if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelSelectOrder.DeleteOrderMsg.txt", orderText), this.bundle.getString("PanelSelectOrder.DeleteOrderTitle.txt"), 0, 3, 1) == 0) {
                String order = this.m_orderData[selectedRow].getOrder();
                Globals.g_job = Globals.g_depotManager.createDelJob(order);
                if (Globals.g_consoleMode) {
                    ConsoleMode.busyMsgStart(this.bundle.messageString("PanelSelectOrder.DeleteMsg.txt", this.m_orderData[selectedRow].getOrder()));
                    Globals.g_job.run();
                    ConsoleMode.busyMsgStop();
                } else {
                    DlgBusyMsg busyMsg = new DlgBusyMsg(Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectOrder.DeleteTitle.txt"), this.bundle.messageString("PanelSelectOrder.DeleteMsg.txt", this.m_orderData[selectedRow].getOrder()));
                    busyMsg.execute(Globals.g_job);
                    this.refreshPanel();
                }
                if (this.m_orderList.getSelectedRow() < 0 && this.m_orderList.getRowCount() > 0) {
                    this.m_orderList.setRowSelectionInterval(0, 0);
                }
                if (this.m_orderData.length > 0) {
                    Globals.g_order = this.m_orderData[0].getOrder();
                }
            }
        }
    }

    private void createMediaEvent() {
        int selectedRow = this.m_orderList.getSelectedRow();
        if (selectedRow > -1) {
            DlgCreateMedia dlgCreateMedia = new DlgCreateMedia(Globals.g_wizard.getFrame(), this.m_orderData[selectedRow]);
            dlgCreateMedia.show();
        }
    }

    private void refreshPanel() {
        int selectedRow = this.m_orderList.getSelectedRow();
        String selectedOrder = null;
        if (selectedRow > -1) {
            selectedOrder = this.m_orderData[selectedRow].getOrder();
        }
        this.m_orderData = Globals.g_deploymentData.getOrders();
        this.m_orderTableModel.fireTableDataChanged();
        if (this.m_orderList.getRowCount() == 0) {
            this.m_detailsButton.setEnabled(false);
            if (this.m_deleteButton != null) {
                this.m_deleteButton.setEnabled(false);
            }
            if (this.m_createMediaButton != null) {
                this.m_createMediaButton.setEnabled(false);
            }
            Globals.g_wizard.getBackButton().setEnabled(false);
            String listText = "<html>";
            listText = listText + this.bundle.getString("PanelSelectOrder.NoOrdersMsg.txt");
            listText = listText + "</html>";
            this.m_orderSummary.setText(listText);
            this.m_orderSummary.setCaretPosition(0);
            this.m_orderSummary.revalidate();
        } else {
            if (selectedOrder != null) {
                boolean found = false;
                for (int i = 0; i < this.m_orderData.length && !found; ++i) {
                    if (!this.m_orderData[i].getOrder().equalsIgnoreCase(selectedOrder)) continue;
                    found = true;
                    this.m_orderList.setRowSelectionInterval(i, i);
                }
            }
            if (this.m_orderList.getSelectedRow() < 0) {
                this.m_orderList.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void updateSummaryText(int selectedRow) {
        if (Globals.g_wizard != null && Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        }
        this.m_detailsButton.setEnabled(true);
        if (this.m_deleteButton != null) {
            this.m_deleteButton.setEnabled(true);
        }
        if (this.m_createMediaButton != null) {
            this.m_createMediaButton.setEnabled(this.m_orderData[selectedRow].getExportMediaTypes().length > 0 && (Globals.g_depotManager == null || !Globals.g_depotManager.isCompressed()));
        }
        String summaryText = "";
        if (this.m_summaryData.get(Integer.toString(selectedRow)) == null) {
            ProductData[] summaryData = Globals.g_deploymentData.getInstallableProducts(this.m_orderData[selectedRow].getOrder(), false);
            int swapPos = 0;
            ProductData swapData = null;
            for (int i = 0; i < summaryData.length; ++i) {
                if (summaryData[i] != null && summaryData[i].getSelectableType() == 2) {
                    summaryData[i] = null;
                }
                if (summaryData[i] == null) continue;
                swapPos = i;
                for (int j = i + 1; j < summaryData.length; ++j) {
                    if (summaryData[j] == null || summaryData[j].getSelectableType() == 2) continue;
                    int comp = summaryData[j].getProdName().compareTo(summaryData[swapPos].getProdName());
                    if (comp == 0) {
                        summaryData[j] = null;
                        continue;
                    }
                    if (comp >= 0) continue;
                    swapPos = j;
                }
                if (swapPos == i) continue;
                swapData = summaryData[i];
                summaryData[i] = summaryData[swapPos];
                summaryData[swapPos] = swapData;
            }
            boolean found = false;
            for (int i = 0; i < summaryData.length && !found; ++i) {
                if (summaryData[i] == null || !summaryData[i].getProdCode().equalsIgnoreCase("sasinstall")) continue;
                swapData = summaryData[i];
                for (int j = i; j > 0; --j) {
                    summaryData[j] = summaryData[j - 1];
                }
                summaryData[0] = swapData;
                found = true;
            }
            summaryText = "<html>";
            String soiLink = this.getSOILink();
            if (soiLink != null) {
                summaryText = summaryText + "<a href=\"" + soiLink + "\">" + this.bundle.getString("PanelSelectOrder.SOILink.txt") + "</a><br>";
            }
            summaryText = summaryText + "<ol>";
            for (int i = 0; i < summaryData.length; ++i) {
                if (summaryData[i] == null) continue;
                summaryText = summaryText.concat("<li>" + summaryData[i].getProdName());
            }
            summaryText = summaryText + "</ol></html>";
            this.m_summaryData.put(Integer.toString(selectedRow), summaryText);
        } else {
            summaryText = (String)this.m_summaryData.get(Integer.toString(selectedRow));
        }
        this.m_orderSummary.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_orderSummary.setText(summaryText);
        this.m_orderSummary.setCaretPosition(0);
        this.m_orderSummary.revalidate();
        if (Globals.g_wizard != null && Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
        }
    }

    @Override
    public String getHelpTopic() {
        String helpTopic = null;
        helpTopic = this.m_idType == 1 ? "PanelManageDepot" : this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
        return helpTopic;
    }

    private String getSOILink() {
        String link = null;
        File orderRoot = Globals.g_mode == 1 ? new File(Globals.g_tempLocation, "download") : new File(Globals.g_startupLocation);
        File soiFile = new File(orderRoot, "install_doc/" + this.m_orderData[this.m_orderList.getSelectedRow()].getOrder() + "/soi.html");
        if (soiFile.isFile()) {
            link = Utils.pathToURL(soiFile.getAbsolutePath());
        }
        return link;
    }

    private class MediaType {
        private int m_rank = 0;
        private String m_type = null;
        private String m_name = null;

        public MediaType(String mediaType) {
            if (mediaType == null) {
                throw new NullPointerException();
            }
            this.m_type = mediaType.toLowerCase(Locale.ENGLISH);
            if ("esdm".equals(this.m_type)) {
                this.m_name = PanelSelectOrder.this.bundle.getString("DlgCreateMedia.MediaNameESD.txt");
                this.m_rank = 1;
            } else if ("cdrm".equals(this.m_type)) {
                this.m_name = PanelSelectOrder.this.bundle.getString("DlgCreateMedia.MediaNameCD.txt");
                this.m_rank = 2;
            } else if ("dvdm".equals(this.m_type)) {
                this.m_name = PanelSelectOrder.this.bundle.getString("DlgCreateMedia.MediaNameDVD.txt");
                this.m_rank = 3;
            } else if ("dvd2".equals(this.m_type)) {
                this.m_name = PanelSelectOrder.this.bundle.getString("DlgCreateMedia.MediaNameDVD2.txt");
                this.m_rank = 4;
            } else {
                this.m_name = PanelSelectOrder.this.bundle.messageString("DlgCreateMedia.MediaNameUnknown.txt", this.m_type);
                this.m_rank = 5;
            }
        }

        public String getType() {
            return this.m_type;
        }

        public String getName() {
            return this.m_name;
        }

        public int getRank() {
            return this.m_rank;
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 977738641382602506L;

        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    private class OrderTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6061895390510109094L;
        public static final int TABLE_COLUMN_ORDER = 0;
        public static final int TABLE_COLUMN_DESC = 1;
        private String[] m_columnNames;

        public OrderTableModel() {
            this.m_columnNames = new String[]{PanelSelectOrder.this.bundle.getString("PanelSelectOrder.Column.Order.txt"), PanelSelectOrder.this.bundle.getString("PanelSelectOrder.Column.Desc.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return PanelSelectOrder.this.m_orderData.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String value = null;
            if (rowIndex < PanelSelectOrder.this.m_orderData.length) {
                if (columnIndex == 0) {
                    value = PanelSelectOrder.this.m_orderData[rowIndex].getOrder();
                } else if (columnIndex == 1) {
                    value = PanelSelectOrder.this.m_orderData[rowIndex].getDescription(Language.gs_SelectedLanguage);
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }
    }
}

