/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelSelectModeEG
implements WizardPanelIface {
    private final String RESPONSE_32BIT = "32-bit";
    private final String RESPONSE_64BIT = "64-bit";
    private SSNResource bundle = new SSNResource(PanelSelectModeEG.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JRadioButton m_platAlternate = null;
    private JTextArea m_descAlternate = null;
    private JRadioButton m_platPrimary = null;
    private JTextArea m_descPrimary = null;
    private boolean m_panelLoaded = false;
    private String m_altPlatCode = "win";

    public PanelSelectModeEG() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectModeEG.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectModeEG.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        Globals.g_eguidePlat = this.m_platAlternate.isSelected() ? this.m_altPlatCode : null;
        if (Globals.g_selectedInstalls != null) {
            ProductData productData = null;
            for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                if (!Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("eguide") && !Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("itrmeg") && !Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("itrmeggaltsk") || (productData = Globals.g_eguidePlat == null ? Globals.g_deploymentData.getProduct(Globals.g_order, Globals.g_selectedInstalls[i].getProdCode(), false) : Globals.g_deploymentData.getProduct(Globals.g_order, Globals.g_selectedInstalls[i].getProdCode(), Globals.g_eguidePlat, false)) == null) continue;
                Globals.g_selectedInstalls[i] = productData;
            }
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        if (Globals.g_srwOnly) {
            return display;
        }
        if (Utils.getOS_Suffix().equals("wx6")) {
            boolean installingEG = false;
            boolean installingITRMEG = false;
            if (Globals.g_selectedInstalls != null) {
                for (int i = 0; !installingEG && i < Globals.g_selectedInstalls.length; ++i) {
                    if (Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("eguide") || Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("dminerpm")) {
                        installingEG = true;
                        continue;
                    }
                    if (!Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("itrmeg") && !Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("itrmeggaltsk")) continue;
                    installingITRMEG = true;
                }
            }
            if (installingEG) {
                if (Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", "win", false) != null && Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", "wx6", false) != null) {
                    display = true;
                }
            } else if (installingITRMEG) {
                this.setEGPluginPlatform();
            }
        }
        return display;
    }

    public RegistryAccess getRegistryAccess() {
        File deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar");
        RegistryAccess regAccess = null;
        if (deploymntRegJar.exists()) {
            try {
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            }
            catch (FileNotFoundException e) {
                Logging.logStackTrace(e);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        return regAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEGPluginPlatform() {
        RegistryAccess registryAccess = this.getRegistryAccess();
        String[] platforms = new String[]{"win", "wx6"};
        String order = null;
        String eguidePlatform = null;
        String thirtyTwoBitLoc = null;
        String sixtyFourBitLoc = null;
        try {
            if (registryAccess != null && registryAccess.open()) {
                for (String platform : platforms) {
                    for (String version : registryAccess.getInstallVersions("eguide", platform)) {
                        order = registryAccess.getInstallOrderNum("eguide", version, platform);
                        ProductData prodData = Globals.g_deploymentData.getProduct(order, "eguide", platform, true);
                        String location = registryAccess.getInstallLoc("eguide", version, platform);
                        String platformFromSku = Globals.g_deploymentData.getSpsSku(prodData.getSpsSku()).getPlatform();
                        if (platformFromSku.equals("win")) {
                            thirtyTwoBitLoc = location;
                            continue;
                        }
                        if (!platformFromSku.equals("wx6")) continue;
                        sixtyFourBitLoc = location;
                    }
                }
                if (thirtyTwoBitLoc != null && !thirtyTwoBitLoc.isEmpty() && sixtyFourBitLoc != null && !sixtyFourBitLoc.isEmpty()) {
                    eguidePlatform = "wx6";
                } else if (thirtyTwoBitLoc != null && !thirtyTwoBitLoc.isEmpty()) {
                    eguidePlatform = "win";
                } else if (sixtyFourBitLoc != null && !sixtyFourBitLoc.isEmpty()) {
                    eguidePlatform = "wx6";
                }
                if (eguidePlatform != null && !eguidePlatform.isEmpty() && Globals.g_selectedInstalls != null) {
                    ProductData productData = null;
                    for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                        if (!Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("itrmeg") && !Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("itrmeggaltsk") || (productData = Globals.g_deploymentData.getProduct(Globals.g_order, Globals.g_selectedInstalls[i].getProdCode(), eguidePlatform, false)) == null) continue;
                        Globals.g_selectedInstalls[i] = productData;
                    }
                }
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        finally {
            if (registryAccess != null) {
                registryAccess.close();
            }
        }
    }

    @Override
    public String getNextPanelID() {
        return "selectmodeamo";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_platAlternate.setSelected(true);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        if (this.m_platAlternate.isSelected()) {
            return this.m_platAlternate;
        }
        return this.m_platPrimary;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        if (Utils.getOS_Suffix().equals("wx6")) {
            data.add("#SAS_EG_MODE=32-bit/64-bit");
            if (this.m_panelLoaded) {
                if (this.m_platAlternate.isSelected()) {
                    data.add(" SAS_EG_MODE=32-bit");
                } else {
                    data.add(" SAS_EG_MODE=64-bit");
                }
            } else {
                data.add(" SAS_EG_MODE=");
            }
            return data.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_platAlternate, this.m_platPrimary};
        JTextArea[] infos = new JTextArea[]{this.m_descAlternate, this.m_descPrimary};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        if (Utils.getOS_Suffix().equals("wx6")) {
            String response = Wizard.getResponse("SAS_EG_MODE", null);
            if (response != null) {
                if (response.equalsIgnoreCase("32-bit")) {
                    valid = true;
                    this.m_platAlternate.setSelected(true);
                } else if (response.equalsIgnoreCase("64-bit")) {
                    valid = true;
                    this.m_platPrimary.setSelected(true);
                }
                if (Globals.g_quietMode && !valid) {
                    Wizard.logResponseInvalid(this.getHeader(), "SAS_EG_MODE", response, null);
                }
            } else if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "SAS_EG_MODE");
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_instructions = new JTextArea(this.bundle.getString("PanelSelectModeEG.Instructions.txt"));
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        String mtxt = this.bundle.getString("PanelSelectModeEG.Name32Bit.txt");
        this.m_platAlternate = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_platAlternate.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_platAlternate.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_platAlternate.getFont();
        this.m_platAlternate.setFont(optionFont.deriveFont(1));
        this.m_descAlternate = new JTextArea(this.bundle.getString("PanelSelectModeEG.Desc32Bit.txt"));
        this.m_descAlternate.setEditable(false);
        this.m_descAlternate.setFocusable(false);
        this.m_descAlternate.setLineWrap(true);
        this.m_descAlternate.setWrapStyleWord(true);
        this.m_descAlternate.setOpaque(false);
        mtxt = this.bundle.getString("PanelSelectModeEG.Name64Bit.txt");
        this.m_platPrimary = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_platPrimary.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_platPrimary.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_platPrimary.getFont();
        this.m_platPrimary.setFont(optionFont.deriveFont(1));
        this.m_descPrimary = new JTextArea(this.bundle.getString("PanelSelectModeEG.Desc64Bit.txt"));
        this.m_descPrimary.setEditable(false);
        this.m_descPrimary.setFocusable(false);
        this.m_descPrimary.setLineWrap(true);
        this.m_descPrimary.setWrapStyleWord(true);
        this.m_descPrimary.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_platAlternate);
        group.add(this.m_platPrimary);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridy = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_platPrimary, c);
        c.gridy = 2;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_descPrimary, c);
        c.gridy = 3;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_platAlternate, c);
        c.gridy = 4;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_descAlternate, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

