/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.PanelSelectModeAMO;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelSelectModeAMOVA
implements WizardPanelIface {
    private final String RESPONSE_32BIT = "32-bit";
    private final String RESPONSE_64BIT = "64-bit";
    private SSNResource bundle = new SSNResource(PanelSelectModeAMO.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JRadioButton m_platAlternate = null;
    private JTextArea m_descAlternate = null;
    private JRadioButton m_platPrimary = null;
    private JTextArea m_descPrimary = null;
    private boolean m_panelLoaded = false;
    private String m_altPlatCode = "win";

    public PanelSelectModeAMOVA() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectModeAMOVA.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectModeAMOVA.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        Globals.g_msoffintvaPlat = this.m_platAlternate.isSelected() ? this.m_altPlatCode : null;
        if (Globals.g_selectedInstalls != null) {
            ProductData productData = null;
            for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                if (!Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("msoffintva")) continue;
                productData = Globals.g_msoffintvaPlat == null ? Globals.g_deploymentData.getProduct(Globals.g_order, "msoffintva", false) : Globals.g_deploymentData.getProduct(Globals.g_order, "msoffintva", Globals.g_msoffintvaPlat, false);
                if (productData != null) {
                    Globals.g_selectedInstalls[i] = productData;
                }
                i = Globals.g_selectedInstalls.length;
            }
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        if (Utils.getOS_Suffix().equals("wx6") && Globals.g_officeBitness == -1) {
            boolean installingAMO = false;
            if (Globals.g_selectedInstalls != null) {
                for (int i = 0; !installingAMO && i < Globals.g_selectedInstalls.length; ++i) {
                    if (!Globals.g_selectedInstalls[i].getProdCode().equalsIgnoreCase("msoffintva")) continue;
                    installingAMO = true;
                }
            }
            if (installingAMO && Globals.g_deploymentData.getProduct(Globals.g_order, "msoffintva", "win", false) != null && Globals.g_deploymentData.getProduct(Globals.g_order, "msoffintva", "wx6", false) != null) {
                display = true;
            }
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        return "selectmodepcfs";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_platAlternate.setSelected(true);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        if (this.m_platAlternate.isSelected()) {
            return this.m_platAlternate;
        }
        return this.m_platPrimary;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        if (Utils.getOS_Suffix().equals("wx6")) {
            data.add("#SAS_AMOVA_MODE=32-bit/64-bit");
            if (this.m_panelLoaded) {
                if (this.m_platAlternate.isSelected()) {
                    data.add(" SAS_AMOVA_MODE=32-bit");
                } else {
                    data.add(" SAS_AMOVA_MODE=64-bit");
                }
            } else {
                data.add(" SAS_AMOVA_MODE=");
            }
            return data.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_platAlternate, this.m_platPrimary};
        JTextArea[] infos = new JTextArea[]{this.m_descAlternate, this.m_descPrimary};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        if (Utils.getOS_Suffix().equals("wx6")) {
            String response = Wizard.getResponse("SAS_AMOVA_MODE", null);
            if (response != null) {
                if (response.equalsIgnoreCase("32-bit")) {
                    valid = true;
                    this.m_platAlternate.setSelected(true);
                } else if (response.equalsIgnoreCase("64-bit")) {
                    valid = true;
                    this.m_platPrimary.setSelected(true);
                }
                if (Globals.g_quietMode && !valid) {
                    Wizard.logResponseInvalid(this.getHeader(), "SAS_AMOVA_MODE", response, null);
                }
            } else if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "SAS_AMOVA_MODE");
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_instructions = new JTextArea(this.bundle.getString("PanelSelectModeAMOVA.Instructions.txt"));
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        String mtxt = this.bundle.getString("PanelSelectModeAMOVA.Name32Bit.txt");
        this.m_platAlternate = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_platAlternate.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_platAlternate.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_platAlternate.getFont();
        this.m_platAlternate.setFont(optionFont.deriveFont(1));
        this.m_descAlternate = new JTextArea(this.bundle.getString("PanelSelectModeAMOVA.Desc32Bit.txt"));
        this.m_descAlternate.setEditable(false);
        this.m_descAlternate.setFocusable(false);
        this.m_descAlternate.setLineWrap(true);
        this.m_descAlternate.setWrapStyleWord(true);
        this.m_descAlternate.setOpaque(false);
        mtxt = this.bundle.getString("PanelSelectModeAMOVA.Name64Bit.txt");
        this.m_platPrimary = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_platPrimary.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_platPrimary.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_platPrimary.getFont();
        this.m_platPrimary.setFont(optionFont.deriveFont(1));
        this.m_descPrimary = new JTextArea(this.bundle.getString("PanelSelectModeAMOVA.Desc64Bit.txt"));
        this.m_descPrimary.setEditable(false);
        this.m_descPrimary.setFocusable(false);
        this.m_descPrimary.setLineWrap(true);
        this.m_descPrimary.setWrapStyleWord(true);
        this.m_descPrimary.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_platAlternate);
        group.add(this.m_platPrimary);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridy = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_platAlternate, c);
        c.gridy = 2;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_descAlternate, c);
        c.gridy = 3;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_platPrimary, c);
        c.gridy = 4;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_descPrimary, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

