/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.FileTypeManagementData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.installs.extension.ExtensionRegistry;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelSelectDefaultProductForFileTypes
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelSelectDefaultProductForFileTypes.class);
    public static final String useExisting = "use_existing_option";
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JRadioButton m_firstButton = null;
    private JRadioButton m_secondButton = null;
    private JRadioButton m_thirdButton = null;
    private JRadioButton m_fourthButton = null;
    private boolean m_panelLoaded = false;
    List<String> productsToInstall = new ArrayList<String>();
    List<String> productsInstalled = new ArrayList<String>();
    Map<Integer, String> buttonMap = new HashMap<Integer, String>();
    Map<Integer, String> previousButtonMap = new HashMap<Integer, String>();
    ExtensionRegistry extRegistry = null;
    private static final List<String> selectableProducts = Arrays.asList("sasinstall", "eguide", "sasuniviewer");
    private static final int maxNumOfButtons = 4;

    public PanelSelectDefaultProductForFileTypes() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectDefaultProductForFileTypes.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectDefaultProductForFileTypes.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        Globals.g_defaultProductForFileTypes = null;
        String selectedProductCode = useExisting;
        if (this.m_firstButton.isSelected()) {
            selectedProductCode = this.buttonMap.get(0);
        } else if (this.m_secondButton.isSelected()) {
            selectedProductCode = this.buttonMap.get(1);
        } else if (this.m_thirdButton.isSelected()) {
            selectedProductCode = this.buttonMap.get(2);
        } else if (this.m_fourthButton.isSelected()) {
            selectedProductCode = this.buttonMap.get(3);
        }
        if (selectedProductCode.equals(useExisting)) {
            return true;
        }
        if (selectedProductCode.equals("sasinstall")) {
            selectedProductCode = "base";
        }
        Globals.g_defaultProductForFileTypes = selectedProductCode;
        return true;
    }

    @Override
    public boolean displayPanel() {
        if (Utils.getOS() != 1) {
            return false;
        }
        if (Globals.g_srwOnly) {
            return false;
        }
        if (Globals.g_resumeChain) {
            return false;
        }
        this.productsToInstall.clear();
        this.productsInstalled.clear();
        Globals.g_ProductsWithSharedFileTypesAlreadyInstalled = false;
        this.productsToInstall = this.getProdsToInstallWithSharedFileTypes();
        if (this.productsToInstall.isEmpty()) {
            return false;
        }
        this.productsInstalled = this.getProdsInstalledWithSharedFileTypes();
        if (this.productsInstalled.size() > 0) {
            Globals.g_ProductsWithSharedFileTypesAlreadyInstalled = true;
            Globals.g_activeSasLocation = FileTypeManagementData.getActiveSasLocation();
            boolean bl = Globals.g_updatingBase = this.productsToInstall.contains("sasinstall") && this.productsInstalled.contains("sasinstall") && !Globals.g_installingBasePlatform.equals(Globals.g_activeBasePlatform);
        }
        return this.productsToInstall.size() + this.productsInstalled.size() >= 2;
    }

    private List<String> getProdsToInstallWithSharedFileTypes() {
        ArrayList<String> products = new ArrayList<String>();
        if (Globals.g_selectedInstalls == null) {
            return products;
        }
        for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
            String productCode = Globals.g_selectedInstalls[i].getProdCode();
            if (!selectableProducts.contains(productCode)) continue;
            if (productCode == "sasinstall") {
                Globals.g_installingBasePlatform = Globals.g_selectedInstalls[i].getPlatform();
            }
            products.add(productCode.toLowerCase());
        }
        return products;
    }

    private List<String> getProdsInstalledWithSharedFileTypes() {
        ArrayList<String> products = new ArrayList<String>();
        File deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar");
        if (deploymntRegJar.exists()) {
            RegistryAccess registryAccess = null;
            try {
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                registryAccess.open();
                for (String product : selectableProducts) {
                    if (!this.isProductInstalled(registryAccess, product)) continue;
                    products.add(product);
                }
            }
            catch (FileNotFoundException e) {
                Logging.logStackTrace(e);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            registryAccess.close();
        }
        return products;
    }

    private boolean isProductInstalled(RegistryAccess registryAccess, String code) {
        String installLoc;
        int i;
        String[] versions;
        if (code.equalsIgnoreCase("sasinstall")) {
            code = "base";
        }
        if ((versions = registryAccess.getInstallVersions(code, Utils.getOS_Suffix())) != null && versions.length > 0) {
            for (i = 0; i < versions.length; ++i) {
                installLoc = registryAccess.getInstallLoc(code, versions[i]);
                File installDir = new File(installLoc);
                if (!installDir.exists()) continue;
                if (code == "base" && installLoc.equalsIgnoreCase(FileTypeManagementData.getActiveSasLocation())) {
                    Globals.g_activeBasePlatform = Utils.getOS_Suffix();
                    return true;
                }
                if (code == "base") continue;
                return true;
            }
        }
        if (Utils.getOS_Suffix() == "wx6" && (versions = registryAccess.getInstallVersions(code, "win")) != null && versions.length > 0) {
            for (i = 0; i < versions.length; ++i) {
                installLoc = registryAccess.getInstallLoc(code, versions[i], "win");
                if (installLoc == null || installLoc.equals("")) continue;
                if (code == "base" && installLoc.equalsIgnoreCase(FileTypeManagementData.getActiveSasLocation())) {
                    Globals.g_activeBasePlatform = "win";
                    return true;
                }
                if (code == "base") continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getNextPanelID() {
        return "jre";
    }

    private int findNextFreeButton() {
        for (int i = 0; i < 4; ++i) {
            if (this.buttonMap.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        int buttonIndex;
        this.m_firstButton.setEnabled(false);
        this.m_firstButton.setVisible(false);
        this.m_secondButton.setEnabled(false);
        this.m_secondButton.setVisible(false);
        this.m_thirdButton.setEnabled(false);
        this.m_thirdButton.setVisible(false);
        this.m_fourthButton.setEnabled(false);
        this.m_fourthButton.setVisible(false);
        this.buttonMap.clear();
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_firstButton.setSelected(true);
            }
            this.m_panelLoaded = true;
        }
        for (int i = 0; i < selectableProducts.size(); ++i) {
            int buttonIndex2;
            if (!this.productsToInstall.contains(selectableProducts.get(i)) || (buttonIndex2 = this.findNextFreeButton()) < 0) continue;
            this.buttonMap.put(buttonIndex2, selectableProducts.get(i));
        }
        if ((Globals.g_recordMode || !this.productsInstalled.isEmpty()) && (buttonIndex = this.findNextFreeButton()) >= 0) {
            this.buttonMap.put(buttonIndex, useExisting);
        }
        this.m_firstButton.setText(this.getDisplayName(this.buttonMap.get(0)));
        this.m_firstButton.setEnabled(true);
        this.m_firstButton.setVisible(true);
        this.m_secondButton.setText(this.getDisplayName(this.buttonMap.get(1)));
        this.m_secondButton.setEnabled(true);
        this.m_secondButton.setVisible(true);
        if (this.buttonMap.containsKey(2)) {
            this.m_thirdButton.setText(this.getDisplayName(this.buttonMap.get(2)));
            this.m_thirdButton.setEnabled(true);
            this.m_thirdButton.setVisible(true);
        }
        if (this.buttonMap.containsKey(3)) {
            this.m_fourthButton.setText(this.getDisplayName(this.buttonMap.get(3)));
            this.m_fourthButton.setEnabled(true);
            this.m_fourthButton.setVisible(true);
        }
        if (Globals.g_responseFile != null) {
            Set<Integer> buttonIndexes = this.buttonMap.keySet();
            String defaultProduct = Globals.g_defaultProductForFileTypes;
            if (defaultProduct == null) {
                defaultProduct = useExisting;
            }
            for (Integer index : buttonIndexes) {
                String productToCheck = defaultProduct;
                if (productToCheck.equalsIgnoreCase("base")) {
                    productToCheck = "sasinstall";
                }
                if (!this.buttonMap.get(index).equals(productToCheck)) continue;
                if (index == 1) {
                    this.m_secondButton.setSelected(true);
                    break;
                }
                if (index == 2) {
                    if (this.m_thirdButton.isEnabled()) {
                        this.m_thirdButton.setSelected(true);
                        break;
                    }
                    this.m_firstButton.setSelected(true);
                    break;
                }
                if (index == 3) {
                    if (this.m_fourthButton.isEnabled()) {
                        this.m_fourthButton.setSelected(true);
                        break;
                    }
                    this.m_firstButton.setSelected(true);
                    break;
                }
                this.m_firstButton.setSelected(true);
                break;
            }
            if (!this.isAnyButtonSelected()) {
                this.m_firstButton.setSelected(true);
            }
        } else if (!this.buttonMap.equals(this.previousButtonMap)) {
            this.m_firstButton.setSelected(true);
        }
        this.previousButtonMap.clear();
        this.previousButtonMap.putAll(this.buttonMap);
    }

    private boolean isAnyButtonSelected() {
        if (this.m_firstButton.isSelected()) {
            return true;
        }
        if (this.m_secondButton.isSelected()) {
            return true;
        }
        if (this.m_thirdButton.isEnabled() && this.m_thirdButton.isSelected()) {
            return true;
        }
        return this.m_fourthButton.isEnabled() && this.m_fourthButton.isSelected();
    }

    private String getDisplayName(String productCode) {
        String productName = productCode;
        if (productCode.equals(useExisting)) {
            productName = this.bundle.getString("PanelSelectDefaultProductForFileTypes.LeaveCurrentDefaultButton.txt");
        } else {
            ProductData prodData = this.getSelectedProductData(productCode);
            if (prodData != null) {
                StringBuffer displayNameExtended = new StringBuffer(prodData.getProdName());
                if (Utils.getOS_Suffix().equals("wx6")) {
                    String bitTag = this.bundle.getString("PanelExecute.64BitTag.txt");
                    if (prodData.getPlatform().equalsIgnoreCase("win")) {
                        bitTag = this.bundle.getString("PanelExecute.32BitTag.txt");
                    }
                    productName = displayNameExtended.append(" ").append(this.bundle.messageString("PanelExecute.InstallBitOrLangTag.txt", bitTag)).toString();
                } else {
                    productName = displayNameExtended.toString();
                }
            }
        }
        return productName;
    }

    private ProductData getSelectedProductData(String productCode) {
        ProductData selectedProductData = null;
        for (ProductData productData : Globals.g_selectedInstalls) {
            if (!productCode.equals(productData.getProdCode())) continue;
            selectedProductData = productData;
            break;
        }
        return selectedProductData;
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        if (this.m_firstButton.isSelected()) {
            return this.m_firstButton;
        }
        if (this.m_secondButton.isSelected()) {
            return this.m_secondButton;
        }
        if (this.m_thirdButton.isSelected()) {
            return this.m_thirdButton;
        }
        return this.m_fourthButton;
    }

    @Override
    public boolean silentEvent() {
        return this.loadResponseData();
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#DEFAULT_PRODUCT_FOR_SAS_FILE_TYPES=<default product to open SAS file types, possible choices are: base, eguide, sasuniviewer or use_existing_option>", " DEFAULT_PRODUCT_FOR_SAS_FILE_TYPES="};
        if (this.m_panelLoaded) {
            String response = Globals.g_defaultProductForFileTypes;
            if (response == null) {
                response = useExisting;
            }
            data[1] = " DEFAULT_PRODUCT_FOR_SAS_FILE_TYPES=" + response;
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_firstButton, this.m_secondButton, this.m_thirdButton, this.m_fourthButton};
        JTextArea noDescriptions = new JTextArea("");
        JTextArea[] infos = new JTextArea[]{noDescriptions, noDescriptions, noDescriptions};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        String response = Wizard.getResponse("DEFAULT_PRODUCT_FOR_SAS_FILE_TYPES", null);
        if (response == null) {
            Globals.g_defaultProductForFileTypes = this.productsToInstall.contains("sasinstall") || this.productsInstalled.contains("sasinstall") ? "sasinstall" : (this.productsToInstall.contains("eguide") || this.productsInstalled.contains("eguide") ? "eguide" : (this.productsToInstall.contains("sasuniviewer") || this.productsInstalled.contains("sasuniviewer") ? "sasuniviewer" : null));
            Logging.log.info("Default response set to " + Globals.g_defaultProductForFileTypes + " due to data missing from response file.");
            return true;
        }
        response.toLowerCase();
        Globals.g_defaultProductForFileTypes = response;
        if (response.equalsIgnoreCase(useExisting)) {
            Globals.g_defaultProductForFileTypes = null;
        }
        if (Globals.g_defaultProductForFileTypes != null) {
            String defaultProduct = Globals.g_defaultProductForFileTypes;
            if (defaultProduct.equals("base")) {
                defaultProduct = "sasinstall";
            }
            if (!selectableProducts.contains(defaultProduct)) {
                Logging.log.warning("The selected default product for file type actions " + defaultProduct + " is not valid. Please see further down in the log for the 'register extension' statements to see which product is registered as the default product for file type actions.");
                return true;
            }
            List<String> selectedProducts = this.getProdsToInstallWithSharedFileTypes();
            if (!selectedProducts.contains(defaultProduct)) {
                Logging.log.warning("The selected default product for file type actions " + defaultProduct + " is not selected for installation. Please see further down in the log for the 'register extension' statements to see which product is registered as the default product for file type actions.");
                return true;
            }
        }
        return true;
    }

    private void initialize() {
        this.m_instructions = new JTextArea(this.bundle.getString("PanelSelectDefaultProductForFileTypes.Instructions.txt"));
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        String mtxt = "";
        this.m_firstButton = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_firstButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_firstButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_firstButton.getFont();
        this.m_firstButton.setFont(optionFont.deriveFont(1));
        this.m_firstButton.setEnabled(false);
        this.m_firstButton.setVisible(false);
        mtxt = "";
        this.m_secondButton = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_secondButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_secondButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_secondButton.getFont();
        this.m_secondButton.setFont(optionFont.deriveFont(1));
        this.m_secondButton.setEnabled(false);
        this.m_secondButton.setVisible(false);
        mtxt = "";
        this.m_thirdButton = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_thirdButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_thirdButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_thirdButton.getFont();
        this.m_thirdButton.setFont(optionFont.deriveFont(1));
        this.m_thirdButton.setEnabled(false);
        this.m_thirdButton.setVisible(false);
        mtxt = "";
        this.m_fourthButton = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_fourthButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_fourthButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_fourthButton.getFont();
        this.m_fourthButton.setFont(optionFont.deriveFont(1));
        this.m_fourthButton.setEnabled(false);
        this.m_fourthButton.setVisible(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_firstButton);
        group.add(this.m_secondButton);
        group.add(this.m_thirdButton);
        group.add(this.m_fourthButton);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridy = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_firstButton, c);
        c.gridy = 3;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_secondButton, c);
        c.gridy = 5;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_thirdButton, c);
        c.gridy = 7;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_fourthButton, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

